/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.as2es;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.uml.internal.as2es.AS2UML;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.uml2.uml.MultiplicityElement;

public class AS2UMLReferenceVisitor
extends AbstractExtendingVisitor<EObject, AS2UML> {
    private static final Logger logger = Logger.getLogger(AS2UMLReferenceVisitor.class);

    public AS2UMLReferenceVisitor(@NonNull AS2UML context) {
        super((Object)context);
    }

    public <T extends org.eclipse.uml2.uml.Element> void safeVisitAll(List<T> eObjects, List<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            org.eclipse.uml2.uml.Element eObject = (org.eclipse.uml2.uml.Element)this.safeVisit((Visitable)element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    public EObject visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for AS2UML Reference pass");
    }

    public EObject visitClass(@NonNull Class pivotClass) {
        org.eclipse.uml2.uml.Class umlClass = ((AS2UML)((Object)this.context)).getCreated(org.eclipse.uml2.uml.Class.class, (Element)pivotClass);
        this.safeVisitAll((List)umlClass.getSuperClasses(), pivotClass.getSuperClasses());
        return umlClass;
    }

    public EObject visitDataType(@NonNull DataType pivotDataType) {
        org.eclipse.uml2.uml.DataType umlDataType = ((AS2UML)((Object)this.context)).getCreated(org.eclipse.uml2.uml.DataType.class, (Element)pivotDataType);
        return umlDataType;
    }

    public EObject visitOperation(@NonNull Operation pivotOperation) {
        org.eclipse.uml2.uml.Operation umlOperation = ((AS2UML)((Object)this.context)).getCreated(org.eclipse.uml2.uml.Operation.class, (Element)pivotOperation);
        this.safeVisitAll((List)umlOperation.getRaisedExceptions(), pivotOperation.getRaisedExceptions());
        Type pivotType = pivotOperation.getType();
        if (pivotType == null) {
            return null;
        }
        org.eclipse.uml2.uml.Type umlType = ((AS2UML)((Object)this.context)).getCreated(org.eclipse.uml2.uml.Type.class, (Element)pivotType);
        umlOperation.setType(umlType);
        return null;
    }

    public EObject visitPackage(@NonNull Package pivotPackage) {
        return null;
    }

    public EObject visitProperty(@NonNull Property pivotProperty) {
        org.eclipse.uml2.uml.Property umlOpposite;
        org.eclipse.uml2.uml.Property umlProperty = ((AS2UML)((Object)this.context)).getCreated(org.eclipse.uml2.uml.Property.class, (Element)pivotProperty);
        Property pivotOpposite = pivotProperty.getOpposite();
        if (pivotOpposite != null && (umlOpposite = ((AS2UML)((Object)this.context)).getCreated(org.eclipse.uml2.uml.Property.class, (Element)pivotOpposite)) != null) {
            umlProperty.setOpposite(umlOpposite);
        }
        return (EObject)super.visitProperty(pivotProperty);
    }

    public EObject visitTemplateParameter(@NonNull TemplateParameter pivotTemplateParameter) {
        return null;
    }

    public EObject visitTypedElement(@NonNull TypedElement pivotTypedElement) {
        org.eclipse.uml2.uml.TypedElement umlTypedElement = ((AS2UML)((Object)this.context)).getCreated(org.eclipse.uml2.uml.TypedElement.class, (Element)pivotTypedElement);
        Type pivotType = pivotTypedElement.getType();
        if (pivotType == null || pivotType instanceof VoidType) {
            if (umlTypedElement instanceof MultiplicityElement) {
                MultiplicityElement umlMultiplicityElement = (MultiplicityElement)umlTypedElement;
                umlMultiplicityElement.setLower(1);
                umlMultiplicityElement.setUpper(1);
                umlMultiplicityElement.setIsOrdered(true);
                umlMultiplicityElement.setIsUnique(true);
            }
            umlTypedElement.setType(null);
            return null;
        }
        if (pivotType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)pivotType;
            Type elementType = collectionType.getElementType();
            org.eclipse.uml2.uml.Type umlElementType = elementType != null ? ((AS2UML)((Object)this.context)).getCreated(org.eclipse.uml2.uml.Type.class, (Element)elementType) : null;
            umlTypedElement.setType(umlElementType);
            if (umlTypedElement instanceof MultiplicityElement) {
                MultiplicityElement umlMultiplicityElement = (MultiplicityElement)umlTypedElement;
                umlMultiplicityElement.setIsOrdered(collectionType.isOrdered());
                umlMultiplicityElement.setIsUnique(collectionType.isUnique());
                IntegerValue lower = collectionType.getLowerValue();
                UnlimitedNaturalValue upper = collectionType.getUpperValue();
                try {
                    umlMultiplicityElement.setLower(lower.intValue());
                }
                catch (InvalidValueException e) {
                    logger.error((Object)"Out of range lower bound", (Throwable)e);
                }
                try {
                    umlMultiplicityElement.setUpper(upper.isUnlimited() ? -1 : upper.intValue());
                }
                catch (InvalidValueException e) {
                    logger.error((Object)"Out of range upper bound", (Throwable)e);
                }
            }
            return null;
        }
        if (umlTypedElement instanceof MultiplicityElement) {
            MultiplicityElement umlMultiplicityElement = (MultiplicityElement)umlTypedElement;
            if (pivotTypedElement.isIsRequired()) {
                umlMultiplicityElement.setLower(1);
                umlMultiplicityElement.setUpper(1);
            } else {
                umlMultiplicityElement.setLower(0);
                umlMultiplicityElement.setUpper(1);
            }
            umlMultiplicityElement.setIsUnique(true);
            umlMultiplicityElement.setIsOrdered(false);
        }
        org.eclipse.uml2.uml.Type umlType = ((AS2UML)((Object)this.context)).getCreated(org.eclipse.uml2.uml.Type.class, (Element)pivotType);
        umlTypedElement.setType(umlType);
        return null;
    }
}

