/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.es2as;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Profile;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.StereotypeExtender;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;

public class ProfileAnalysis {
    @NonNull
    protected final UML2AS.Outer converter;
    @NonNull
    protected final EnvironmentFactoryInternal environmentFactory;
    @NonNull
    private final Set<Type> allExtendedMetatypes = new HashSet<Type>();
    @NonNull
    private final Set<Package> allExtendedMetapackages = new HashSet<Package>();
    @NonNull
    private final Set<Stereotype> allExtendingStereotypes = new HashSet<Stereotype>();
    @NonNull
    private final Set<Stereotype> allStereotypes = new HashSet<Stereotype>();
    @NonNull
    private final Map<Profile, Set<Stereotype>> profile2ownedStereotypes = new HashMap<Profile, Set<Stereotype>>();
    @NonNull
    private final Map<String, Type> metatypeName2metatype = new HashMap<String, Type>();
    @NonNull
    private final Map<Type, Set<Type>> metatype2superMetatypeClosure = new HashMap<Type, Set<Type>>();
    @NonNull
    private final Map<Type, Set<Type>> metatype2subMetatypeClosure = new HashMap<Type, Set<Type>>();
    @NonNull
    private final Map<Stereotype, Set<Stereotype>> stereotype2superStereotypeClosure = new HashMap<Stereotype, Set<Stereotype>>();
    @NonNull
    private final Map<Stereotype, Set<Stereotype>> stereotype2subStereotypeClosure = new HashMap<Stereotype, Set<Stereotype>>();

    public ProfileAnalysis(@NonNull UML2AS.Outer converter) {
        this.converter = converter;
        this.environmentFactory = converter.getEnvironmentFactory();
    }

    public void addStereotype(@NonNull Stereotype asStereotype) {
        this.allStereotypes.add(asStereotype);
        Package asPackage = asStereotype.getOwningPackage();
        if (asPackage instanceof Profile) {
            Profile asProfile = (Profile)asPackage;
            Set<Stereotype> ownedStereotypes = this.profile2ownedStereotypes.get(asProfile);
            if (ownedStereotypes == null) {
                ownedStereotypes = new HashSet<Stereotype>();
                this.profile2ownedStereotypes.put(asProfile, ownedStereotypes);
            }
            ownedStereotypes.add(asStereotype);
        }
    }

    public void addTypeExtension(@NonNull StereotypeExtender asTypeExtension) {
        Class extendedMetatype = asTypeExtension.getClass_();
        Stereotype extendingStereotype = asTypeExtension.getOwningStereotype();
        if (extendedMetatype != null && extendingStereotype != null) {
            this.allExtendedMetatypes.add((Type)extendedMetatype);
            this.allExtendingStereotypes.add(extendingStereotype);
            Package metaPackage = extendedMetatype.getOwningPackage();
            if (metaPackage != null) {
                this.allExtendedMetapackages.add(metaPackage);
            }
        }
    }

    public void analyze() {
        this.computeMetatypeName2metatype();
        this.computeMetatypeClosure();
        this.computeStereotypeClosure();
    }

    private void computeMetatypeName2metatype() {
        for (Package metapackage : this.allExtendedMetapackages) {
            for (Class metatype : metapackage.getOwnedClasses()) {
                if (metatype == null) continue;
                this.metatypeName2metatype.put(metatype.getName(), (Type)metatype);
            }
        }
    }

    private void computeMetatypeClosure() {
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        for (Package metapackage : this.allExtendedMetapackages) {
            for (Class subMetatype : metapackage.getOwnedClasses()) {
                if (subMetatype == null) continue;
                HashSet<Class> superMetatypeClosure = new HashSet<Class>();
                this.metatype2superMetatypeClosure.put((Type)subMetatype, superMetatypeClosure);
                for (CompleteClass superCompleteClass : metamodelManager.getAllSuperCompleteClasses((Type)subMetatype)) {
                    Class asSuperMetatype = superCompleteClass.getPrimaryClass();
                    superMetatypeClosure.add(asSuperMetatype);
                    Set<Type> subMetatypeClosure = this.metatype2subMetatypeClosure.get(asSuperMetatype);
                    if (subMetatypeClosure == null) {
                        subMetatypeClosure = new HashSet<Type>();
                        this.metatype2subMetatypeClosure.put((Type)asSuperMetatype, subMetatypeClosure);
                    }
                    subMetatypeClosure.add((Type)subMetatype);
                }
            }
        }
    }

    private void computeStereotypeClosure() {
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        for (Stereotype subStereotype : this.allStereotypes) {
            if (subStereotype == null) continue;
            HashSet<Stereotype> superStereotypeClosure = new HashSet<Stereotype>();
            this.stereotype2superStereotypeClosure.put(subStereotype, superStereotypeClosure);
            for (CompleteClass superCompleteClass : metamodelManager.getAllSuperCompleteClasses((Type)subStereotype)) {
                Class asSuperStereotype = superCompleteClass.getPrimaryClass();
                if (!(asSuperStereotype instanceof Stereotype)) continue;
                superStereotypeClosure.add((Stereotype)asSuperStereotype);
                Set<Stereotype> subStereotypeClosure = this.stereotype2subStereotypeClosure.get(asSuperStereotype);
                if (subStereotypeClosure == null) {
                    subStereotypeClosure = new HashSet<Stereotype>();
                    this.stereotype2subStereotypeClosure.put((Stereotype)asSuperStereotype, subStereotypeClosure);
                }
                subStereotypeClosure.add(subStereotype);
            }
        }
    }

    @NonNull
    public Map<Type, Set<StereotypeExtender>> computeMetatypes2typeExtensions() {
        Set<Stereotype> applicableStereotypes = this.allStereotypes;
        Map<Type, Set<StereotypeExtender>> extensibleMetatype2typeExtensions = this.getExtensibleMetatype2typeExtensions(applicableStereotypes);
        return extensibleMetatype2typeExtensions;
    }

    @NonNull
    public Map<Type, Set<StereotypeExtender>> computeMetatypes2typeExtensions(@NonNull Set<Profile> appliedProfileClosure) {
        Set<Stereotype> applicableStereotypes = this.getOwnedStereotypes(appliedProfileClosure);
        Map<Type, Set<StereotypeExtender>> extensibleMetatype2typeExtensions = this.getExtensibleMetatype2typeExtensions(applicableStereotypes);
        HashMap<Type, Set<StereotypeExtender>> metatype2typeExtensions = new HashMap<Type, Set<StereotypeExtender>>();
        for (Type metatype : extensibleMetatype2typeExtensions.keySet()) {
            Set<Type> metatypeSubClosure;
            Set someTypeExtensions = (Set)metatype2typeExtensions.get(metatype);
            if (someTypeExtensions == null || (metatypeSubClosure = this.getSubMetatypeClosure(metatype)) == null) continue;
            for (Type subMetatype : metatypeSubClosure) {
                HashSet allTypeExtensions = (HashSet)metatype2typeExtensions.get(subMetatype);
                if (allTypeExtensions == null) {
                    allTypeExtensions = new HashSet();
                    metatype2typeExtensions.put(subMetatype, allTypeExtensions);
                }
                allTypeExtensions.addAll(someTypeExtensions);
            }
        }
        return metatype2typeExtensions;
    }

    @NonNull
    private Map<Type, Set<StereotypeExtender>> getExtensibleMetatype2typeExtensions(@NonNull Iterable<Stereotype> applicableStereotypes) {
        HashMap<Type, Set<StereotypeExtender>> extensibleMetatype2typeExtensions = new HashMap<Type, Set<StereotypeExtender>>();
        for (Stereotype applicableStereotype : applicableStereotypes) {
            for (StereotypeExtender typeExtension : applicableStereotype.getOwnedExtenders()) {
                Class extensibleMetatype = typeExtension.getClass_();
                if (extensibleMetatype == null) continue;
                HashSet<StereotypeExtender> typeExtensions = (HashSet<StereotypeExtender>)extensibleMetatype2typeExtensions.get(extensibleMetatype);
                if (typeExtensions == null) {
                    typeExtensions = new HashSet<StereotypeExtender>();
                    extensibleMetatype2typeExtensions.put((Type)extensibleMetatype, typeExtensions);
                }
                typeExtensions.add(typeExtension);
            }
        }
        return extensibleMetatype2typeExtensions;
    }

    @Nullable
    public Type getMetatype(@NonNull String packageName, @NonNull String className) {
        return this.metatypeName2metatype.get(className);
    }

    @NonNull
    private Set<Stereotype> getOwnedStereotypes(@NonNull Iterable<Profile> asProfiles) {
        HashSet<Stereotype> allOwnedStereotypes = new HashSet<Stereotype>();
        for (Profile asProfile : asProfiles) {
            Set<Stereotype> ownedStereotypes = this.profile2ownedStereotypes.get(asProfile);
            if (ownedStereotypes == null) continue;
            allOwnedStereotypes.addAll(ownedStereotypes);
        }
        return allOwnedStereotypes;
    }

    @Nullable
    private Set<Type> getSubMetatypeClosure(@NonNull Type metatype) {
        return this.metatype2subMetatypeClosure.get(metatype);
    }
}

