/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.es2as;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Profile;
import org.eclipse.ocl.pivot.ProfileApplication;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Slot;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.StereotypeExtender;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.External2AS;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class UML2ASReferenceSwitch
extends UMLSwitch<Object> {
    private static final Logger logger = Logger.getLogger(UML2ASReferenceSwitch.class);
    @NonNull
    protected final UML2AS converter;
    @NonNull
    protected final EnvironmentFactoryInternal environmentFactory;
    @NonNull
    protected final StandardLibraryInternal standardLibrary;
    private Set<EClass> doneWarnings = null;

    public UML2ASReferenceSwitch(@NonNull UML2AS converter) {
        this.converter = converter;
        this.environmentFactory = converter.getEnvironmentFactory();
        this.standardLibrary = converter.getStandardLibrary();
    }

    public Object caseAssociation(Association umlAssociation) {
        assert (umlAssociation != null);
        EList memberEnds = umlAssociation.getMemberEnds();
        if (memberEnds.size() == 2) {
            org.eclipse.uml2.uml.Property firstEnd = (org.eclipse.uml2.uml.Property)memberEnds.get(0);
            org.eclipse.uml2.uml.Property secondEnd = (org.eclipse.uml2.uml.Property)memberEnds.get(1);
            if (firstEnd != null && secondEnd != null) {
                Property firstProperty = (Property)this.converter.getCreated(Property.class, (EObject)firstEnd);
                Property secondProperty = (Property)this.converter.getCreated(Property.class, (EObject)secondEnd);
                if (firstProperty != null && secondProperty != null) {
                    firstProperty.setOpposite(secondProperty);
                    secondProperty.setOpposite(firstProperty);
                }
            }
        }
        return this;
    }

    public Class caseClass(org.eclipse.uml2.uml.Class umlClass) {
        assert (umlClass != null);
        Class pivotElement = (Class)this.converter.getCreated(Class.class, (EObject)umlClass);
        if (pivotElement != null) {
            this.doSwitchAll(Class.class, pivotElement.getSuperClasses(), (List<? extends EObject>)umlClass.getSuperClasses());
            if (pivotElement.getSuperClasses().isEmpty()) {
                Class oclElementType = this.standardLibrary.getOclElementType();
                pivotElement.getSuperClasses().add(oclElementType);
            }
        }
        return pivotElement;
    }

    public Object caseDataType(org.eclipse.uml2.uml.DataType umlDataType) {
        assert (umlDataType != null);
        DataType pivotElement = (DataType)this.converter.getCreated(DataType.class, (EObject)umlDataType);
        ArrayList<Class> asSuperClasses = new ArrayList<Class>();
        if (pivotElement != null) {
            for (Generalization umlGeneralization : umlDataType.getGeneralizations()) {
                Class asGeneral;
                Classifier umlGeneral = umlGeneralization.getGeneral();
                if (umlGeneral == null || (asGeneral = (Class)this.converter.getCreated(Class.class, (EObject)umlGeneral)) == null || asSuperClasses.contains(asGeneral)) continue;
                asSuperClasses.add(asGeneral);
            }
            if (asSuperClasses.isEmpty()) {
                Class oclElementType = this.standardLibrary.getOclElementType();
                asSuperClasses.add(oclElementType);
            }
            this.converter.refreshList(pivotElement.getSuperClasses(), asSuperClasses);
        }
        return pivotElement;
    }

    public Object caseExtension(Extension umlExtension) {
        this.caseAssociation((Association)umlExtension);
        assert (umlExtension != null);
        StereotypeExtender asTypeExtension = (StereotypeExtender)this.converter.getCreated(StereotypeExtender.class, (EObject)umlExtension);
        if (asTypeExtension != null) {
            org.eclipse.uml2.uml.Class umlMetaclass = umlExtension.getMetaclass();
            org.eclipse.uml2.uml.Stereotype umlStereotype = umlExtension.getStereotype();
            if (umlMetaclass != null && umlStereotype != null) {
                Class asMetaclass = (Class)this.converter.getCreated(Class.class, (EObject)umlMetaclass);
                Stereotype asStereotype = (Stereotype)this.converter.getCreated(Stereotype.class, (EObject)umlStereotype);
                if (asMetaclass != null && asStereotype != null) {
                    asTypeExtension.setOwningStereotype(asStereotype);
                    asTypeExtension.setClass(asMetaclass);
                    if (UML2AS.ADD_TYPE_EXTENSION.isActive()) {
                        UML2AS.ADD_TYPE_EXTENSION.println(asTypeExtension.toString());
                    }
                    this.converter.addTypeExtension(asTypeExtension);
                }
            }
        }
        return this;
    }

    public Object caseProfileApplication(org.eclipse.uml2.uml.ProfileApplication umlProfileApplication) {
        org.eclipse.uml2.uml.Profile umlProfile;
        assert (umlProfileApplication != null);
        ProfileApplication asProfileApplication = (ProfileApplication)this.converter.getCreated(ProfileApplication.class, (EObject)umlProfileApplication);
        if (asProfileApplication != null && (umlProfile = umlProfileApplication.getAppliedProfile()) != null) {
            Profile asProfile = (Profile)this.converter.getCreated(Profile.class, (EObject)umlProfile);
            asProfileApplication.setAppliedProfile(asProfile);
            this.converter.addProfileApplication(asProfileApplication);
        }
        return this;
    }

    public Object caseProperty(org.eclipse.uml2.uml.Property umlProperty) {
        assert (umlProperty != null);
        this.caseTypedElement((org.eclipse.uml2.uml.TypedElement)umlProperty);
        Property asProperty = (Property)this.converter.getCreated(Property.class, (EObject)umlProperty);
        if (asProperty != null) {
            EObject eContainer;
            Type asTargetType;
            org.eclipse.uml2.uml.Type umlTargetType;
            if (asProperty.getName() == null && (umlTargetType = umlProperty.getType()) != null && (asTargetType = (Type)this.converter.getCreated(Type.class, (EObject)umlTargetType)) != null) {
                asProperty.setName(asTargetType.getName());
            }
            Class pivotType = null;
            Association umlAssociation = umlProperty.getAssociation();
            if (umlAssociation != null) {
                org.eclipse.uml2.uml.Type oppositeType;
                org.eclipse.uml2.uml.Property opposite;
                if (umlProperty.getOwningAssociation() != null) {
                    asProperty.setIsImplicit(true);
                }
                if ((opposite = this.getOtherEnd(umlProperty)) != null && (oppositeType = opposite.getType()) != null) {
                    pivotType = (Class)this.converter.getCreated(Class.class, (EObject)oppositeType);
                }
            }
            if (pivotType == null && (eContainer = umlProperty.eContainer()) != null) {
                pivotType = (Class)this.converter.getCreated(Class.class, eContainer);
            }
            if (pivotType != null) {
                this.converter.addProperty(pivotType, asProperty);
            }
        }
        return asProperty;
    }

    public Object caseSlot(org.eclipse.uml2.uml.Slot umlSlot) {
        assert (umlSlot != null);
        Slot asSlot = (Slot)this.converter.getCreated(Slot.class, (EObject)umlSlot);
        if (asSlot != null) {
            StructuralFeature umlDefiningFeature = umlSlot.getDefiningFeature();
            Property asProperty = umlDefiningFeature != null ? (Property)this.converter.getCreated(Property.class, (EObject)umlDefiningFeature) : null;
            asSlot.setDefiningProperty(asProperty);
        }
        return this;
    }

    public Object caseStereotype(org.eclipse.uml2.uml.Stereotype umlStereotype) {
        assert (umlStereotype != null);
        this.caseClass((org.eclipse.uml2.uml.Class)umlStereotype);
        Stereotype asStereotype = (Stereotype)this.converter.getCreated(Stereotype.class, (EObject)umlStereotype);
        if (asStereotype != null) {
            this.converter.addStereotype(asStereotype);
        }
        return asStereotype;
    }

    public EObject caseTypedElement(org.eclipse.uml2.uml.TypedElement umlTypedElement) {
        assert (umlTypedElement != null);
        TypedElement pivotElement = (TypedElement)this.converter.getCreated(TypedElement.class, (EObject)umlTypedElement);
        if (pivotElement != null) {
            this.converter.resolveMultiplicity(pivotElement, umlTypedElement);
        }
        return pivotElement;
    }

    public Object doInPackageSwitch(EObject eObject) {
        int classifierID = eObject.eClass().getClassifierID();
        return this.doSwitch(classifierID, eObject);
    }

    public <T extends Element> void doSwitchAll(@NonNull java.lang.Class<T> pivotClass, Collection<T> pivotElements, List<? extends EObject> eObjects) {
        assert (pivotElements != null);
        assert (eObjects != null);
        for (EObject eObject : eObjects) {
            EClass eClass;
            External2AS adapter;
            Resource eResource;
            if (eObject == null) continue;
            Element pivotElement = this.converter.getCreated(pivotClass, eObject);
            if (pivotElement == null && (eResource = eObject.eResource()) != null && (adapter = UML2AS.findAdapter((Resource)eResource, (EnvironmentFactoryInternal)this.environmentFactory)) != null) {
                pivotElement = adapter.getCreated(pivotClass, eObject);
            }
            if (pivotElement == null) {
                Element doSwitchResult;
                if (!(eObject instanceof Constraint)) {
                    System.out.println("Reference switching " + eObject);
                }
                pivotElement = doSwitchResult = (Element)this.doSwitch(eObject);
            }
            if (pivotElement != null) {
                pivotElements.add(pivotElement);
                continue;
            }
            if (this.doneWarnings == null) {
                this.doneWarnings = new HashSet<EClass>();
            }
            if (!this.doneWarnings.add(eClass = eObject.eClass())) continue;
            logger.warn((Object)("Failed to create a pivot representation of a UML '" + eClass.getName() + "'"));
        }
    }

    protected org.eclipse.uml2.uml.Property getOtherEnd(@NonNull org.eclipse.uml2.uml.Property umlProperty) {
        org.eclipse.uml2.uml.Property otherEnd = umlProperty.getOtherEnd();
        if (otherEnd != null) {
            return otherEnd;
        }
        Association association = umlProperty.getAssociation();
        if (association != null) {
            ArrayList memberEnds = new ArrayList(association.getMemberEnds());
            memberEnds.remove(umlProperty);
            for (org.eclipse.uml2.uml.Property aProperty : memberEnds) {
                if (aProperty.getName().equals(umlProperty)) continue;
                return aProperty;
            }
        }
        return otherEnd;
    }

    @Nullable
    public org.eclipse.uml2.uml.Property getOtherEnd(@NonNull List<org.eclipse.uml2.uml.Property> umlMemberEnds, @NonNull org.eclipse.uml2.uml.Property umlProperty) {
        for (org.eclipse.uml2.uml.Property umlMemberEnd : umlMemberEnds) {
            if (umlMemberEnd == umlProperty) continue;
            return umlMemberEnd;
        }
        return null;
    }
}

