/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.es2as;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class UML2ASUtil {
    @NonNull
    public static Map<EObject, List<Element>> computeAppliedStereotypes(@NonNull Iterable<EObject> umlStereotypeApplications) {
        HashMap<EObject, List<Element>> umlStereotypeApplication2umlStereotypedElements = new HashMap<EObject, List<Element>>();
        for (EObject umlStereotypeApplication : umlStereotypeApplications) {
            List<Element> umlStereotypedElements = UML2ASUtil.resolveStereotypedElements(umlStereotypeApplication);
            umlStereotypeApplication2umlStereotypedElements.put(umlStereotypeApplication, umlStereotypedElements);
        }
        if (UML2AS.ADD_STEREOTYPE_APPLICATION.isActive()) {
            HashMap umlStereotypeEClass2umlStereotypedElements = new HashMap();
            for (EObject umlStereotypeApplication : umlStereotypeApplications) {
                List umlStereotypedElements = (List)umlStereotypeApplication2umlStereotypedElements.get(umlStereotypeApplication);
                HashSet perEClassUMLStereotypedElements = (HashSet)umlStereotypeEClass2umlStereotypedElements.get(umlStereotypeApplication.eClass());
                if (perEClassUMLStereotypedElements == null) {
                    perEClassUMLStereotypedElements = new HashSet();
                    umlStereotypeEClass2umlStereotypedElements.put(umlStereotypeApplication.eClass(), perEClassUMLStereotypedElements);
                }
                perEClassUMLStereotypedElements.addAll(umlStereotypedElements);
            }
            StringBuffer s = new StringBuffer();
            for (EClass umlStereotypeEClass : umlStereotypeEClass2umlStereotypedElements.keySet()) {
                s.append("\n\t" + NameUtil.qualifiedNameFor((Object)umlStereotypeEClass));
                for (Element umlStereotypedElement : (Set)umlStereotypeEClass2umlStereotypedElements.get(umlStereotypeEClass)) {
                    if (umlStereotypedElement == null) continue;
                    s.append("\n\t\t" + NameUtil.qualifiedNameFor((Object)umlStereotypedElement));
                }
            }
            UML2AS.ADD_STEREOTYPE_APPLICATION.println("Applications per Stereotype" + s.toString());
        }
        return umlStereotypeApplication2umlStereotypedElements;
    }

    @Nullable
    public static Class getMetaType(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Element umlElement) {
        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        EClass umlEClass = umlElement.eClass();
        for (Stereotype umlStereotype : umlElement.getApplicableStereotypes()) {
            for (org.eclipse.uml2.uml.Class umlMetaclass : umlStereotype.getAllExtendedMetaclasses()) {
                Package umlPackage = umlMetaclass.getPackage();
                Type umlType = umlPackage.getOwnedType(umlEClass.getName());
                if (umlType == null) continue;
                try {
                    Class umlAStype = (Class)metamodelManager.getASOf(Class.class, (EObject)umlType);
                    if (umlAStype == null) continue;
                    return umlAStype;
                }
                catch (ParserException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @NonNull
    public static List<Element> resolveStereotypedElements(@NonNull EObject umlStereotypeApplication) {
        EClass eClass = umlStereotypeApplication.eClass();
        ArrayList<Element> umlStereotypedElements = new ArrayList<Element>();
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            Object umlStereotypedElement;
            String featureName = eStructuralFeature.getName();
            if (featureName == null || !featureName.startsWith("base_") || !(eStructuralFeature instanceof EReference) || !umlStereotypeApplication.eIsSet(eStructuralFeature) || !((umlStereotypedElement = umlStereotypeApplication.eGet(eStructuralFeature)) instanceof Element)) continue;
            umlStereotypedElements.add((Element)umlStereotypedElement);
        }
        return umlStereotypedElements;
    }
}

