/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.library;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.evaluation.OCLEvaluationVisitor;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.library.AbstractProperty;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.ValueSpecification;

public class InstanceSlotNavigationProperty
extends AbstractProperty {
    @NonNull
    protected final Property property;
    @Nullable
    protected final CollectionTypeId collectionTypeId;

    public InstanceSlotNavigationProperty(@NonNull Property property, @Nullable CollectionTypeId collectionTypeId) {
        this.property = property;
        this.collectionTypeId = collectionTypeId;
    }

    @Nullable
    public Object evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        if (sourceValue != null) {
            InstanceSpecification instanceSpecification = (InstanceSpecification)sourceValue;
            for (Slot slot : instanceSpecification.getSlots()) {
                if (slot.getDefiningFeature() != this.property) continue;
                EList values = slot.getValues();
                CollectionTypeId collectionTypeId2 = this.collectionTypeId;
                int size = values.size();
                if (collectionTypeId2 != null) {
                    ArrayList<Object> unboxedValues = new ArrayList<Object>(size);
                    for (ValueSpecification value : values) {
                        unboxedValues.add(this.valueOf(evaluator, value));
                    }
                    IdResolver idResolver = evaluator.getIdResolver();
                    return idResolver.createCollectionOfAll(collectionTypeId2, unboxedValues);
                }
                if (size >= 1) {
                    ValueSpecification valueSpecification = (ValueSpecification)values.get(0);
                    if (valueSpecification instanceof OpaqueExpression) {
                        try {
                            PivotMetamodelManager metamodelManager = ((OCLEvaluationVisitor)evaluator).getMetamodelManager();
                            ExpressionInOCL specification = (ExpressionInOCL)metamodelManager.getASOf(ExpressionInOCL.class, (EObject)valueSpecification);
                            if (specification == null) {
                                throw new InvalidValueException("Missing spec for " + specification, new Object[0]);
                            }
                            ExpressionInOCL query = metamodelManager.parseSpecification((LanguageExpression)specification);
                            OCLExpression bodyExpression = query.getOwnedBody();
                            assert (bodyExpression != null);
                            Object umlValue = evaluator.evaluate(bodyExpression);
                            return metamodelManager.getEnvironmentFactory().getIdResolver().boxedValueOf(umlValue);
                        }
                        catch (ParserException e) {
                            throw new InvalidValueException((Exception)((Object)e), "Parse fail for " + valueSpecification);
                        }
                    }
                    return this.valueOf(evaluator, valueSpecification);
                }
                throw new InvalidValueException("no ValueSpecification in Slot", new Object[0]);
            }
        }
        return null;
    }

    @Nullable
    private Object valueOf(@NonNull Evaluator evaluator, @Nullable ValueSpecification valueSpecification) {
        if (valueSpecification == null) {
            throw new InvalidValueException("null ValueSpecification in Slot", new Object[0]);
        }
        if (valueSpecification instanceof LiteralBoolean) {
            return ((LiteralBoolean)valueSpecification).booleanValue();
        }
        if (valueSpecification instanceof LiteralInteger) {
            return ValueUtil.integerValueOf((int)((LiteralInteger)valueSpecification).getValue());
        }
        if (valueSpecification instanceof LiteralNull) {
            return null;
        }
        if (valueSpecification instanceof LiteralReal) {
            return ValueUtil.realValueOf((double)((LiteralReal)valueSpecification).getValue());
        }
        if (valueSpecification instanceof LiteralString) {
            return ((LiteralString)valueSpecification).getValue();
        }
        if (valueSpecification instanceof LiteralUnlimitedNatural) {
            int unlimitedValue = ((LiteralUnlimitedNatural)valueSpecification).unlimitedValue();
            return unlimitedValue < 0 ? ValueUtil.UNLIMITED_VALUE : ValueUtil.integerValueOf((int)unlimitedValue);
        }
        if (valueSpecification instanceof InstanceValue) {
            InstanceSpecification ecoreInstance = ((InstanceValue)valueSpecification).getInstance();
            return ecoreInstance != null ? evaluator.getIdResolver().boxedValueOf((Object)ecoreInstance) : null;
        }
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".valueOf " + valueSpecification.eClass().getName());
    }
}

