/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.utilities;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.DynamicElement;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Profile;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.RootPackageId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.AbstractTechnology;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.library.LibraryProperty;
import org.eclipse.ocl.pivot.uml.internal.library.InstanceSlotNavigationProperty;
import org.eclipse.ocl.pivot.uml.internal.library.UMLBaseProperty;
import org.eclipse.ocl.pivot.uml.internal.library.UMLExtensionProperty;
import org.eclipse.ocl.pivot.uml.internal.library.UMLStereotypeProperty;
import org.eclipse.ocl.pivot.uml.internal.utilities.UMLIdResolver;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.uml2.types.TypesPackage;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLEcoreTechnology
extends AbstractTechnology {
    @NonNull
    public static final UMLEcoreTechnology INSTANCE = new UMLEcoreTechnology();

    protected UMLEcoreTechnology() {
    }

    @NonNull
    public UMLIdResolver createIdResolver(@NonNull EnvironmentFactoryInternal environmentFactory) {
        return new UMLIdResolver(environmentFactory);
    }

    @NonNull
    public LibraryProperty createBasePropertyImplementation(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Property property) {
        return new UMLBaseProperty(property);
    }

    @NonNull
    public LibraryProperty createExplicitNavigationPropertyImplementation(@NonNull EnvironmentFactoryInternal environmentFactory, @Nullable Element asNavigationExp, @Nullable Object sourceValue, @NonNull Property property) {
        EObject eTarget;
        Package owningPackage;
        if (sourceValue instanceof InstanceSpecification && !((owningPackage = PivotUtil.getContainingPackage((EObject)asNavigationExp)) instanceof Profile) && (eTarget = property.getESObject()) instanceof org.eclipse.uml2.uml.Property) {
            TypeId typeId = property.getTypeId();
            CollectionTypeId collectionTypeId = typeId instanceof CollectionTypeId ? (CollectionTypeId)typeId : null;
            return new InstanceSlotNavigationProperty((org.eclipse.uml2.uml.Property)eTarget, collectionTypeId);
        }
        return super.createExplicitNavigationPropertyImplementation(environmentFactory, asNavigationExp, sourceValue, property);
    }

    @NonNull
    public LibraryProperty createExtensionPropertyImplementation(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Property property) {
        return new UMLExtensionProperty(property);
    }

    @NonNull
    public LibraryProperty createStereotypePropertyImplementation(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Property property) {
        return new UMLStereotypeProperty(property);
    }

    public String getExtensionName(@NonNull Element asStereotypedElement) {
        EObject eObject;
        String name = "????";
        if (asStereotypedElement instanceof NamedElement) {
            name = ((NamedElement)asStereotypedElement).getName();
        } else if (asStereotypedElement instanceof DynamicElement && (eObject = ((DynamicElement)asStereotypedElement).getESObject()) instanceof org.eclipse.uml2.uml.NamedElement) {
            name = ((org.eclipse.uml2.uml.NamedElement)eObject).getName();
        }
        return name;
    }

    public RootPackageId getMetamodelId(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull EPackage eObject2) {
        RootPackageId metamodel = null;
        if (ClassUtil.basicGetMetamodelAnnotation((EPackage)eObject2) != null) {
            metamodel = IdManager.METAMODEL;
        } else if (eObject2 instanceof UMLPackage) {
            String nsUri = "http://www.eclipse.org/uml2/5.0.0/UML";
            environmentFactory.getMetamodelManager().getCompleteModel().addPackageURI2completeURI(nsUri, "$uml$");
            metamodel = IdManager.getRootPackageId((String)"$uml$");
        } else if (eObject2 instanceof TypesPackage) {
            String nsUri = "http://www.eclipse.org/uml2/5.0.0/Types";
            environmentFactory.getMetamodelManager().getCompleteModel().addPackageURI2completeURI(nsUri, "$types$");
            metamodel = IdManager.getRootPackageId((String)"$types$");
        } else {
            String nsURI = eObject2.getNsURI();
            String sharedNsURI = environmentFactory.getMetamodelManager().getCompleteModel().getCompleteURI(nsURI);
            if (sharedNsURI != null && !sharedNsURI.equals(nsURI)) {
                metamodel = IdManager.getRootPackageId((String)sharedNsURI);
            }
        }
        return metamodel;
    }

    @NonNull
    public PackageId getMetapackageId(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Package asPackage) {
        EClass eClass;
        EObject eTarget;
        if (asPackage instanceof PivotObjectImpl && (eTarget = ((PivotObjectImpl)asPackage).getESObject()) != null && (eClass = eTarget.eClass()) != null) {
            EPackage ePackage = eClass.getEPackage();
            if (ePackage instanceof UMLPackage) {
                return IdManager.getRootPackageId((String)"$uml$");
            }
            if (ePackage instanceof TypesPackage) {
                return IdManager.getRootPackageId((String)"$types$");
            }
        }
        return IdManager.METAMODEL;
    }

    @Nullable
    public String getOriginalName(@NonNull ENamedElement eNamedElement) {
        EAnnotation eAnnotation = eNamedElement.getEAnnotation("redefines");
        if (eAnnotation != null) {
            EObject eContainer = eNamedElement.eContainer();
            if (eContainer instanceof EAnnotation) {
                EObject eObject;
                EList eReferences = eAnnotation.getReferences();
                if (eReferences != null && eReferences.size() > 0 && (eObject = (EObject)eReferences.get(0)) instanceof ENamedElement) {
                    String originalName = this.getOriginalName((ENamedElement)eObject);
                    return originalName;
                }
            } else if (eContainer instanceof EClassifier) {
                String prefix = String.valueOf(((EClassifier)eContainer).getName()) + "_";
                String originalName = NameUtil.getOriginalName((ENamedElement)eNamedElement);
                if (originalName.startsWith(prefix)) {
                    originalName = originalName.substring(prefix.length());
                }
                return originalName;
            }
        }
        String originalName = NameUtil.getOriginalName((ENamedElement)eNamedElement);
        return originalName;
    }

    @Nullable
    public Element getParseableElement(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull EObject eObject) throws ParserException {
        if (eObject instanceof Element) {
            return (Element)eObject;
        }
        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        Element pivotElement = metamodelManager.getASOf(Element.class, eObject);
        if (eObject instanceof org.eclipse.uml2.uml.Constraint && pivotElement instanceof Constraint && pivotElement.eContainer() == null) {
            pivotElement = metamodelManager.getASOf(Element.class, (EObject)((org.eclipse.uml2.uml.Constraint)eObject).getSpecification());
        }
        return pivotElement;
    }

    public boolean isStereotype(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull EClass eClass) {
        for (EStructuralFeature eFeature : eClass.getEAllStructuralFeatures()) {
            String name;
            EPackage ePackage;
            EClassifier eType = eFeature.getEType();
            if (eType == null || (ePackage = eType.getEPackage()) != UMLPackage.eINSTANCE || (name = eFeature.getName()) == null || !name.startsWith("base_")) continue;
            return true;
        }
        return false;
    }

    public boolean isValidatable(@NonNull EClass eClass) {
        EObject eContainerContainer;
        EObject eContainer;
        EPackage ePackage = eClass.getEPackage();
        return ePackage == null || !((eContainer = ePackage.eContainer()) instanceof EAnnotation) || !((eContainerContainer = eContainer.eContainer()) instanceof Profile);
    }
}

