/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.validation;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.AbstractConstraintDescriptor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.uml.internal.validation.LoadableConstraintProvider;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.uml2.uml.Stereotype;

public abstract class LoadableConstraintDescriptor<T>
extends AbstractConstraintDescriptor
implements IModelConstraint {
    private static final Logger logger = Logger.getLogger(LoadableConstraintDescriptor.class);
    @NonNull
    private final Constraint constraint;
    @NonNull
    protected final T targetType;
    @NonNull
    private final String id;
    @NonNull
    private final String name;
    private final int code;
    private ExpressionInOCL query = null;

    public LoadableConstraintDescriptor(@NonNull T targetType, @NonNull Constraint constraint, String targetNamespace, String targetName, int code) {
        this.constraint = constraint;
        this.targetType = targetType;
        String name = constraint.getName();
        if (name == null) {
            name = Long.toHexString(System.identityHashCode(constraint));
        }
        this.id = "'" + targetNamespace + "'::" + targetName + "::" + name;
        this.name = String.valueOf(targetName) + "::" + name;
        this.code = code;
    }

    final Constraint getConstraint() {
        return this.constraint;
    }

    public String getBody() {
        return PrettyPrinter.print((Element)this.constraint);
    }

    public String getDescription() {
        return this.getBody();
    }

    public EvaluationMode<?> getEvaluationMode() {
        return EvaluationMode.BATCH;
    }

    public String getId() {
        return this.id;
    }

    public String getMessagePattern() {
        return String.format("Constraint %s violated on {0}", this.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getPluginId() {
        return "org.eclipse.ocl.pivot";
    }

    public ConstraintSeverity getSeverity() {
        return ConstraintSeverity.WARNING;
    }

    public int getStatusCode() {
        return this.code;
    }

    public boolean targetsEvent(Notification notification) {
        return false;
    }

    public IStatus validate(IValidationContext ctx) {
        Object result;
        EObject target = ctx.getTarget();
        if (target == null) {
            return ctx.createFailureStatus(new Object[]{target});
        }
        OCL ocl = LoadableConstraintProvider.getOCL();
        ExpressionInOCL query2 = this.query;
        if (query2 == null) {
            MetamodelManager metamodelManager = ocl.getMetamodelManager();
            EClass eClass = target.eClass();
            NamedElement contextElement = null;
            try {
                contextElement = (NamedElement)metamodelManager.getASOf(NamedElement.class, (EObject)eClass);
            }
            catch (ParserException e) {
                logger.error((Object)("Failed to convert " + eClass), (Throwable)e);
            }
            if (contextElement == null) {
                return ctx.createFailureStatus(new Object[]{target});
            }
            LanguageExpression specification = this.constraint.getOwnedSpecification();
            if (specification == null) {
                return ctx.createFailureStatus(new Object[]{target});
            }
            try {
                this.query = query2 = metamodelManager.parseSpecification(specification);
            }
            catch (ParserException e) {
                return ctx.createFailureStatus(new Object[]{e.getLocalizedMessage()});
            }
        }
        if ((result = ocl.evaluate((Object)target, query2)) != Boolean.TRUE) {
            return ctx.createFailureStatus(new Object[]{target});
        }
        return ctx.createSuccessStatus();
    }

    public static class Ecore
    extends LoadableConstraintDescriptor<EClassifier> {
        public Ecore(@NonNull EClassifier targetType, @NonNull Constraint constraint, int code) {
            super(targetType, constraint, targetType.getEPackage().getNsURI(), targetType.getName(), code);
        }

        public boolean targetsTypeOf(EObject eObject) {
            return ((EClassifier)this.targetType).isInstance((Object)eObject);
        }
    }

    public static class UML
    extends LoadableConstraintDescriptor<Stereotype> {
        public UML(@NonNull Stereotype targetType, @NonNull Constraint constraint, int code) {
            super(targetType, constraint, targetType.getNearestPackage().getURI(), targetType.getName(), code);
        }

        protected boolean isKindOf(@NonNull String nsURI, @NonNull String name, EClass eClass) {
            EPackage ePackage;
            if (name.equals(eClass.getName()) && nsURI.equals((ePackage = eClass.getEPackage()).getNsURI())) {
                return true;
            }
            for (EClass eSuperClass : eClass.getESuperTypes()) {
                if (!this.isKindOf(nsURI, name, eSuperClass)) continue;
                return true;
            }
            return false;
        }

        public boolean targetsTypeOf(EObject eObject) {
            EClass eClass = eObject.eClass();
            String nsURI = ((Stereotype)this.targetType).getProfile().getURI();
            if (nsURI == null) {
                return false;
            }
            String name = ((Stereotype)this.targetType).getName();
            if (name == null) {
                return false;
            }
            return this.isKindOf(nsURI, name, eClass);
        }
    }
}

