/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.standalone.validity;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.ConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.ResultSet;
import org.eclipse.ocl.examples.emf.validation.validity.ResultValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.locator.ConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.locator.EClassConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.locator.EClassifierConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.locator.EValidatorConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.validity.locator.CompleteOCLCSConstraintLocator;
import org.eclipse.ocl.examples.validity.locator.PivotConstraintLocator;
import org.eclipse.ocl.examples.validity.locator.UMLConstraintLocator;

public class StandaloneValidityManager
extends ValidityManager {
    @NonNull
    private IsActivePredicate isActivePredicate = new IsActivePredicate();

    @NonNull
    private static List<ConstrainingNode> getConstrainingNodeAncestors(@NonNull ConstrainingNode constraining) {
        ConstrainingNode ancestor = constraining.getParent();
        ArrayList<ConstrainingNode> ancestors = new ArrayList<ConstrainingNode>();
        while (ancestor != null) {
            ancestors.add(ancestor);
            ancestor = ancestor.getParent();
        }
        return ancestors;
    }

    @NonNull
    public Iterable<ConstraintLocator> getActiveConstraintLocators(@NonNull String nsURI) {
        return Iterables.filter((Iterable)super.getActiveConstraintLocators(nsURI), (Predicate)this.isActivePredicate);
    }

    public void runValidation() {
        ResultSet resultSet = this.createResultSet((IProgressMonitor)new NullProgressMonitor());
        List results = this.installResultSet(resultSet, (IProgressMonitor)new NullProgressMonitor());
        for (Result result : results) {
            try {
                ValidatableNode validatable = result.getValidatableNode();
                ValidatableNode validatableParent = validatable.getParent();
                LeafConstrainingNode constraint = result.getLeafConstrainingNode();
                if (constraint != null) {
                    List<ConstrainingNode> constrainingAncestors = StandaloneValidityManager.getConstrainingNodeAncestors((ConstrainingNode)constraint);
                    boolean isConstrainingNodeEnabled = true;
                    for (ConstrainingNode constrainingAncestor : constrainingAncestors) {
                        if (constrainingAncestor.isEnabled()) continue;
                        isConstrainingNodeEnabled = false;
                        break;
                    }
                    boolean isEnabledForValidation = false;
                    if (isConstrainingNodeEnabled) {
                        if (validatable instanceof ResultValidatableNode) {
                            if (validatableParent != null && validatableParent.isEnabled()) {
                                isEnabledForValidation = true;
                            }
                        } else {
                            isEnabledForValidation = true;
                        }
                    }
                    if (isEnabledForValidation) {
                        ConstraintLocator constraintLocator = constraint.getConstraintLocator();
                        constraintLocator.validate(result, (ValidityManager)this, null);
                        continue;
                    }
                    result.setSeverity(Severity.UNKNOWN);
                    continue;
                }
                result.setSeverity(Severity.UNKNOWN);
            }
            catch (Exception e) {
                result.setException((Throwable)e);
                result.setSeverity(Severity.FATAL);
            }
        }
    }

    public void setRunJavaConstraints(boolean runJavaConstraints) {
        this.isActivePredicate.runJavaConstraints = runJavaConstraints;
    }

    public void setRunOCLConstraints(boolean runOCLConstraints) {
        this.isActivePredicate.runOCLConstraints = runOCLConstraints;
    }

    public void setRunUMLConstraints(boolean runUMLConstraints) {
        this.isActivePredicate.runUMLConstraints = runUMLConstraints;
    }

    private static class IsActivePredicate
    implements Predicate<ConstraintLocator> {
        private boolean runOCLConstraints = false;
        private boolean runJavaConstraints = false;
        private boolean runUMLConstraints = false;

        private IsActivePredicate() {
        }

        public boolean apply(ConstraintLocator constraintLocator) {
            if (this.runOCLConstraints) {
                if (constraintLocator instanceof CompleteOCLCSConstraintLocator) {
                    return true;
                }
                if (constraintLocator instanceof PivotConstraintLocator) {
                    return true;
                }
            }
            if (this.runJavaConstraints) {
                if (constraintLocator instanceof EClassConstraintLocator) {
                    return true;
                }
                if (constraintLocator instanceof EClassifierConstraintLocator) {
                    return true;
                }
                if (constraintLocator instanceof EValidatorConstraintLocator) {
                    return true;
                }
            }
            return this.runUMLConstraints && constraintLocator instanceof UMLConstraintLocator;
        }
    }
}

