/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.oclinecore.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.xtext.base.ui.wizards.AbstractFileDialog;
import org.eclipse.ocl.xtext.base.ui.wizards.AbstractFileNewWizardPage;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.oclinecore.ui.messages.OCLinEcoreUIMessages;
import org.eclipse.ocl.xtext.oclinecore.ui.wizards.AbstractOCLinEcoreFileNewWizard;
import org.eclipse.ocl.xtext.oclinecore.ui.wizards.EcoreWithOCLFileDialog;

public class EcoreWithOCLFileNewWizard
extends AbstractOCLinEcoreFileNewWizard {
    private static final Logger logger = Logger.getLogger(EcoreWithOCLFileNewWizard.class);

    @NonNull
    protected EcoreWithOCLFileDialog createDialog(@NonNull AbstractFileNewWizardPage wizardPage, @Nullable IResource initialSelection) {
        return new EcoreWithOCLFileDialog(this, wizardPage, initialSelection);
    }

    @Override
    @NonNull
    public String getInitialContentsAsString(@NonNull IFile newFile, @NonNull AbstractFileDialog dialog) {
        URI ecoreURI = URI.createPlatformResourceURI((String)newFile.getFullPath().toString(), (boolean)true);
        URI oclInEcoreURI = ecoreURI.trimFileExtension().appendFileExtension("oclinecore");
        String initialContentsAsString = super.getInitialContentsAsString(newFile, dialog);
        OCL ocl = OCL.newInstance((EPackage.Registry)EPackage.Registry.INSTANCE);
        ResourceSet resourceSet2 = ocl.getResourceSet();
        BaseCSResource csResource = (BaseCSResource)ClassUtil.nonNullState((Object)((BaseCSResource)resourceSet2.createResource(oclInEcoreURI)));
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(initialContentsAsString.getBytes());
            csResource.load((InputStream)inputStream, null);
            ASResource asResource = ocl.cs2as((CSResource)csResource);
            Resource eResource = ocl.as2ecore((Resource)asResource, ecoreURI);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            eResource.save((OutputStream)outputStream, null);
            String string = outputStream.toString();
            return string;
        }
        catch (IOException e) {
            logger.error((Object)("Failed to create " + ecoreURI), (Throwable)e);
            return initialContentsAsString;
        }
    }

    @NonNull
    public String getNewFileExtension() {
        return "ecore";
    }

    @NonNull
    public String getNewFileLabel() {
        return OCLinEcoreUIMessages.Ecore_NewWizardPage_fileNameLabel;
    }

    @NonNull
    public String getPageDescription() {
        return OCLinEcoreUIMessages.Ecore_NewWizardPage_pageDescription;
    }

    @NonNull
    public String getPageSummary() {
        return OCLinEcoreUIMessages.Ecore_NewWizardPage_pageSummary;
    }

    @NonNull
    public String getPageTitle() {
        return OCLinEcoreUIMessages.Ecore_NewWizardPage_pageTitle;
    }
}

