/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.oclinecore.ui.wizards;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.xtext.base.ui.wizards.AbstractFileDialog;
import org.eclipse.ocl.xtext.base.ui.wizards.AbstractFileNewWizardPage;
import org.eclipse.ocl.xtext.oclinecore.ui.messages.OCLinEcoreUIMessages;
import org.eclipse.ocl.xtext.oclinecore.ui.wizards.AbstractOCLinEcoreFileNewWizard;
import org.eclipse.ocl.xtext.oclinecore.ui.wizards.OCLinEcoreFileDialog;

public class OCLinEcoreFileNewWizard
extends AbstractOCLinEcoreFileNewWizard {
    @Override
    protected void appendImports(StringBuilder s, AbstractFileDialog dialog, IFile newFile) {
        List uris = dialog.getURIs();
        if (uris.size() > 0) {
            URI newURI = URI.createPlatformResourceURI((String)newFile.getFullPath().toString(), (boolean)true);
            for (URI uri : uris) {
                URI deresolvedURI = uri.deresolve(newURI);
                s.append("import '" + ValueUtil.oclToString((Object)deresolvedURI) + "';\n");
            }
            s.append("\n");
        }
    }

    @NonNull
    protected OCLinEcoreFileDialog createDialog(@NonNull AbstractFileNewWizardPage wizardPage, @Nullable IResource initialSelection) {
        return new OCLinEcoreFileDialog(this, wizardPage, initialSelection);
    }

    @NonNull
    public String getNewFileExtension() {
        return "oclinecore";
    }

    @NonNull
    public String getNewFileLabel() {
        return OCLinEcoreUIMessages.NewWizardPage_fileNameLabel;
    }

    @NonNull
    public String getPageDescription() {
        return OCLinEcoreUIMessages.NewWizardPage_pageDescription;
    }

    @NonNull
    public String getPageSummary() {
        return OCLinEcoreUIMessages.NewWizardPage_pageSummary;
    }

    @NonNull
    public String getPageTitle() {
        return OCLinEcoreUIMessages.NewWizardPage_pageTitle;
    }
}

