/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.internal.registry.CompleteOCLRegistry;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.xtext.base.ui.utilities.PDEUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DebugDialog
extends Dialog {
    @NonNull
    protected final CompleteOCLRegistry completeOCLRegistry;
    @NonNull
    protected final EObject selectedObject;
    @Nullable
    protected Constraint selectedConstraint;
    private Text elementName;
    private Text elementNsURI;
    private Text elementClass;
    private Text constraintText;
    private Combo constraintsCombo;
    private Combo constraintCombo;
    @NonNull
    private final Map<String, URI> constraintsText2resourceURI = new HashMap<String, URI>();
    @NonNull
    private final Map<String, Constraint> constraintText2constraint = new HashMap<String, Constraint>();

    public DebugDialog(Shell parentShell, @NonNull EObject selectedObject) {
        super(parentShell);
        this.setShellStyle(3312);
        this.completeOCLRegistry = PDEUtils.createCompleteOCLRegistry();
        this.selectedObject = selectedObject;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.numColumns = 2;
        Label elementLabel = new Label(container, 0);
        elementLabel.setSize(43, 15);
        elementLabel.setText("Element");
        this.elementName = new Text(container, 2048);
        this.elementName.setEditable(false);
        this.elementName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.elementName.setText("");
        Label eClassLabel = new Label(container, 0);
        eClassLabel.setBounds(0, 0, 55, 15);
        eClassLabel.setText("EClass");
        this.elementClass = new Text(container, 2048);
        this.elementClass.setEditable(false);
        this.elementClass.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.elementClass.setBounds(0, 0, 76, 21);
        Label nsURILabel = new Label(container, 0);
        nsURILabel.setLayoutData((Object)new GridData(16384, 1024, false, false, 1, 1));
        nsURILabel.setBounds(0, 0, 55, 15);
        nsURILabel.setText("Ns URI");
        this.elementNsURI = new Text(container, 2048);
        this.elementNsURI.setEditable(false);
        this.elementNsURI.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.elementNsURI.setBounds(0, 0, 76, 21);
        Label constraintsLabel = new Label(container, 0);
        constraintsLabel.setBounds(0, 0, 55, 15);
        constraintsLabel.setText("Constraints");
        this.constraintsCombo = new Combo(container, 0);
        this.constraintsCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.constraintsCombo.setBounds(0, 0, 91, 23);
        Label constraintLabel = new Label(container, 0);
        constraintLabel.setBounds(0, 0, 55, 15);
        constraintLabel.setText("Constraint");
        this.constraintCombo = new Combo(container, 0);
        this.constraintCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.constraintText = new Text(container, 2818);
        this.constraintText.setEditable(false);
        GridData gd_constraintText = new GridData(4, 4, true, true, 2, 1);
        gd_constraintText.minimumHeight = 30;
        this.constraintText.setLayoutData((Object)gd_constraintText);
        this.constraintsCombo.addModifyListener((ModifyListener)new ConstraintsModifyListener());
        this.constraintCombo.addModifyListener((ModifyListener)new ConstraintModifyListener());
        this.setSelection(this.selectedObject);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public void setSelection(@NonNull EObject eObject) {
        this.elementName.setText(NameUtil.qualifiedNameFor((Object)eObject));
        EClass eClass = eObject.eClass();
        this.elementClass.setText(NameUtil.qualifiedNameFor((Object)eClass));
        EPackage ePackage = eClass != null ? eClass.getEPackage() : null;
        String nsURI = ePackage != null ? ePackage.getNsURI() : null;
        this.elementNsURI.setText(String.valueOf(nsURI));
        List<String> elementNsURIs = Collections.singletonList(nsURI);
        Set resourceURIs = this.completeOCLRegistry.getResourceURIs(elementNsURIs);
        ArrayList<String> constraintNsURIs = new ArrayList<String>();
        this.constraintsText2resourceURI.clear();
        for (URI resourceURI : resourceURIs) {
            URI leadingSegments = resourceURI.trimSegments(1);
            String lastSegment = resourceURI.lastSegment();
            String constraintsText = String.valueOf(lastSegment) + " - " + leadingSegments.toString();
            constraintNsURIs.add(constraintsText);
            this.constraintsText2resourceURI.put(constraintsText, resourceURI);
        }
        Collections.sort(constraintNsURIs);
        this.constraintsCombo.setItems(constraintNsURIs.toArray(new String[constraintNsURIs.size()]));
        this.constraintsCombo.select(0);
    }

    @NonNull
    public EObject getContext() {
        return this.selectedObject;
    }

    @Nullable
    public Constraint getConstraint() {
        return this.selectedConstraint;
    }

    protected class ConstraintModifyListener
    implements ModifyListener {
        protected ConstraintModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Constraint selectedConstraint2 = null;
            String text = null;
            int selectedIndex = DebugDialog.this.constraintCombo.getSelectionIndex();
            if (selectedIndex >= 0) {
                String selectedText = DebugDialog.this.constraintCombo.getItem(selectedIndex);
                selectedConstraint2 = (Constraint)DebugDialog.this.constraintText2constraint.get(selectedText);
                if (selectedConstraint2 != null) {
                    text = PrettyPrinter.print((Element)selectedConstraint2);
                }
            }
            DebugDialog.this.selectedConstraint = selectedConstraint2;
            DebugDialog.this.constraintText.setText(text != null ? text : "<no-constraint-text>");
        }
    }

    protected class ConstraintsModifyListener
    implements ModifyListener {
        protected ConstraintsModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            DebugDialog.this.constraintText2constraint.clear();
            ArrayList<String> constraints = new ArrayList<String>();
            int selectedIndex = DebugDialog.this.constraintsCombo.getSelectionIndex();
            if (selectedIndex >= 0) {
                Resource eResource;
                String selectedText = DebugDialog.this.constraintsCombo.getItem(selectedIndex);
                URI selectedURI = (URI)DebugDialog.this.constraintsText2resourceURI.get(selectedText);
                if (selectedURI != null && (eResource = DebugDialog.this.selectedObject.eResource()) != null) {
                    EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.getEnvironmentFactory((Resource)eResource);
                    PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
                    Element resource = null;
                    try {
                        resource = metamodelManager.loadResource(selectedURI, null, null);
                    }
                    catch (ParserException e1) {
                        e1.printStackTrace();
                    }
                    if (resource != null) {
                        TreeIterator tit = resource.eAllContents();
                        while (tit.hasNext()) {
                            EObject eObject = (EObject)tit.next();
                            if (!(eObject instanceof Constraint)) continue;
                            String constraintText = eObject.toString();
                            constraints.add(constraintText);
                            DebugDialog.this.constraintText2constraint.put(constraintText, (Constraint)eObject);
                        }
                        Collections.sort(constraints);
                    }
                }
            }
            DebugDialog.this.constraintCombo.setItems(constraints.toArray(new String[constraints.size()]));
            if (constraints.size() > 0) {
                DebugDialog.this.constraintCombo.select(0);
            }
        }
    }
}

