/*
 * Decompiled with CFR 0.152.
 */
package noreflectioncompany.util;

import java.util.Map;
import noreflectioncompany.Company;
import noreflectioncompany.CompanySizeKind;
import noreflectioncompany.Employee;
import noreflectioncompany.NoreflectioncompanyPackage;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class NoreflectioncompanyValidator
extends EObjectValidator {
    public static final NoreflectioncompanyValidator INSTANCE = new NoreflectioncompanyValidator();
    public static final String DIAGNOSTIC_SOURCE = "noreflectioncompany";
    public static final int COMPANY__DUMMY_INVARIANT = 1;
    public static final int EMPLOYEE__NO_MANAGER_IMPLIES_DIRECT_REPORTS = 2;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 2;
    protected static final int DIAGNOSTIC_CODE_COUNT = 2;
    protected static final String EMPLOYEE__MUST_HAVE_NAME__EEXPRESSION = "Tuple {\n\tmessage : String = 'Employee must have a name',\n\tstatus : Boolean = not name.oclIsUndefined() and hasNameAsAttribute and hasNameAsOperation()\n}.status";
    protected static final String EMPLOYEE__MUST_HAVE_NON_EMPTY_NAME__EEXPRESSION = "name->notEmpty() implies name.size() > 0";

    public static boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context, String validationDelegate, EOperation invariant, String expression, int severity, String source, int code) {
        return EObjectValidator.validate((EClass)eClass, (EObject)eObject, (DiagnosticChain)diagnostics, context, (String)validationDelegate, (EOperation)invariant, (String)expression, (int)severity, (String)source, (int)code);
    }

    protected EPackage getEPackage() {
        return NoreflectioncompanyPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateCompany((Company)value, diagnostics, context);
            }
            case 1: {
                return this.validateEmployee((Employee)value, diagnostics, context);
            }
            case 2: {
                return this.validateCompanySizeKind((CompanySizeKind)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateCompany(Company company, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(company, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(company, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCompany_dummyInvariant(company, diagnostics, context);
        }
        return result;
    }

    public boolean validateCompany_dummyInvariant(Company company, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return company.dummyInvariant(diagnostics, context);
    }

    public boolean validateEmployee(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(employee, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(employee, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_mustHaveName(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_mustHaveNonEmptyName(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_noManagerImpliesDirectReports(employee, diagnostics, context);
        }
        return result;
    }

    public boolean validateEmployee_mustHaveName(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(NoreflectioncompanyPackage.Literals.EMPLOYEE, (EObject)employee, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "mustHaveName", EMPLOYEE__MUST_HAVE_NAME__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateEmployee_mustHaveNonEmptyName(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(NoreflectioncompanyPackage.Literals.EMPLOYEE, (EObject)employee, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "mustHaveNonEmptyName", EMPLOYEE__MUST_HAVE_NON_EMPTY_NAME__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateEmployee_noManagerImpliesDirectReports(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return employee.noManagerImpliesDirectReports(diagnostics, context);
    }

    public boolean validateCompanySizeKind(CompanySizeKind companySizeKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

