/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.values.BigIntegerValueImpl;
import org.eclipse.ocl.pivot.internal.values.IntIntegerValueImpl;
import org.eclipse.ocl.pivot.internal.values.LongIntegerValueImpl;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EvaluateNumericOperationsTest4
extends PivotTestSuite {
    protected double doubleEpsilon = Math.pow(0.5, 52.0);

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public EvaluateNumericOperationsTest4(boolean useCodeGen) {
        super(useCodeGen);
    }

    @Override
    @NonNull
    protected TestOCL createOCL() {
        return new TestOCL(this.getTestPackageName(), this.getName(), (ProjectManager)(useCodeGen ? EvaluateNumericOperationsTest4.getProjectMap() : OCL.NO_PROJECTS));
    }

    @Override
    @NonNull
    protected String getTestPackageName() {
        return "EvaluateNumericOperations";
    }

    @BeforeClass
    public static void resetCounter() throws Exception {
        PivotTestSuite.resetCounter();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testIntValue() {
        TestOCL ocl = this.createOCL();
        assert (ValueUtil.integerValueOf((int)Integer.MAX_VALUE) instanceof IntIntegerValueImpl);
        assert (ValueUtil.integerValueOf((long)Integer.MAX_VALUE) instanceof IntIntegerValueImpl);
        assert (ValueUtil.integerValueOf((BigInteger)BigInteger.valueOf(Integer.MAX_VALUE)) instanceof IntIntegerValueImpl);
        assert (ValueUtil.integerValueOf((BigInteger)BigInteger.valueOf(0x80000000L)) instanceof LongIntegerValueImpl);
        assert (ValueUtil.integerValueOf((long)Long.MAX_VALUE) instanceof LongIntegerValueImpl);
        assert (ValueUtil.integerValueOf((BigInteger)BigInteger.valueOf(Long.MAX_VALUE)) instanceof LongIntegerValueImpl);
        assert (ValueUtil.integerValueOf((BigInteger)BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE)) instanceof BigIntegerValueImpl);
        assert (ValueUtil.integerValueOf((int)Integer.MIN_VALUE) instanceof IntIntegerValueImpl);
        assert (ValueUtil.integerValueOf((long)Integer.MIN_VALUE) instanceof IntIntegerValueImpl);
        assert (ValueUtil.integerValueOf((BigInteger)BigInteger.valueOf(Integer.MIN_VALUE)) instanceof IntIntegerValueImpl);
        assert (ValueUtil.integerValueOf((BigInteger)BigInteger.valueOf(-2147483649L)) instanceof LongIntegerValueImpl);
        assert (ValueUtil.integerValueOf((long)Long.MIN_VALUE) instanceof LongIntegerValueImpl);
        assert (ValueUtil.integerValueOf((BigInteger)BigInteger.valueOf(Long.MIN_VALUE)) instanceof LongIntegerValueImpl);
        assert (ValueUtil.integerValueOf((BigInteger)BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.ONE)) instanceof BigIntegerValueImpl);
        ocl.dispose();
    }

    @Test
    public void testIntPlus() {
    }

    @Test
    public void testIntMinus() {
    }

    @Test
    public void testNumber() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, 0, "0");
        ocl.assertQueryEquals(null, 3, "3");
        ocl.assertQueryEquals(null, 3.1, "3.1");
        ocl.assertQueryEquals(null, 31.0, "3.1e1");
        ocl.assertQueryEquals(null, 31.0, "3.1e+1");
        ocl.assertQueryEquals(null, 0.31, "3.1e-1");
        ocl.assertQueryEquals(null, 30.0, "3e1");
        ocl.assertQueryEquals(null, 30.0, "3e+1");
        ocl.assertQueryEquals(null, 0.3, "3e-1");
        ocl.assertQueryEquals(null, 3, "(3)");
        ocl.assertQueryEquals(null, 3.1, "(3.1)");
        ocl.assertQueryEquals(null, 31.0, "(3.1e1)");
        ocl.assertQueryEquals(null, 31.0, "(3.1e+1)");
        ocl.assertQueryEquals(null, 0.31, "(3.1e-1)");
        ocl.assertQueryEquals(null, 30.0, "(3e1)");
        ocl.assertQueryEquals(null, 30.0, "(3e+1)");
        ocl.assertQueryEquals(null, 0.3, "(3e-1)");
        ocl.assertQueryEquals(null, 3, "( 3)");
        ocl.assertQueryEquals(null, 3.1, "( 3.1 )");
        ocl.assertQueryEquals(null, 31.0, "( 3.1e1 )");
        ocl.assertQueryEquals(null, 31.0, "( 3.1e+1 )");
        ocl.assertQueryEquals(null, 0.31, "( 3.1e-1 )");
        ocl.assertQueryEquals(null, 30.0, "( 3e1 )");
        ocl.assertQueryEquals(null, 30.0, "( 3e+1 )");
        ocl.assertQueryEquals(null, 0.3, "( 3e-1 )");
        ocl.assertSemanticErrorQuery(null, "3 .1", "bad navigation argument", new Object[0]);
        ocl.assertSemanticErrorQuery(null, "3. 1", "bad navigation argument", new Object[0]);
        ocl.assertSemanticErrorQuery(null, "3.1 e1", "extraneous input ''{0}'' expecting EOF", "e1");
        ocl.assertSemanticErrorQuery(null, "3.1e 1", "no viable alternative at ''{0}''", "e");
        ocl.assertSemanticErrorQuery(null, "3.1e+ 1", "no viable alternative at ''{0}''", "e");
        ocl.dispose();
    }

    @Test
    public void testNumberAbs() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, 3, "3.abs()");
        ocl.assertQueryEquals(null, 3, "(-3).abs()");
        ocl.assertQueryEquals(null, Integer.MAX_VALUE, "2147483647.abs()");
        ocl.assertQueryEquals(null, 0x80000000L, "2147483648.abs()");
        ocl.assertQueryEquals(null, 0x80000001L, "(-2147483649).abs()");
        ocl.assertQueryEquals(null, 0x80000000L, "(-2147483648).abs()");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63).subtract(BigInteger.ONE), "9223372036854775807.abs()");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63), "9223372036854775808.abs()");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63).add(BigInteger.ONE), "(-9223372036854775809).abs()");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63), "(-9223372036854775808).abs()");
        ocl.assertQueryEquals(null, 3.0, "(3.0).abs()", 0.0);
        ocl.assertQueryEquals(null, 3.0, "(-3.0).abs()", 0.0);
        ocl.assertQueryEquals(null, 3.1758, "(3.1758).abs()", 0.0);
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i.abs()");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in r.abs()");
        ocl.assertQueryInvalid(null, "let i : Integer = null in i.abs()");
        ocl.assertQueryInvalid(null, "let r : Real = null in r.abs()");
        ocl.dispose();
    }

    @Test
    public void testNumberDiv() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, 1, "3.div(2)");
        ocl.assertQueryEquals(null, -1, "(-3).div(2)");
        ocl.assertQueryEquals(null, -1, "3.div(-2)");
        ocl.assertQueryEquals(null, 1, "(-3).div(-2)");
        ocl.assertQueryInvalid(null, "1.div(0)");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in 1.div(i)");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i.div(1)");
        ocl.assertQueryInvalid(null, "let i1 : Integer = invalid, i2 : Integer = invalid in i1.div(i2)");
        ocl.assertQueryInvalid(null, "let i : Integer = null in 1.div(i)");
        ocl.assertQueryInvalid(null, "let i : Integer = null in i.div(1)");
        ocl.assertQueryInvalid(null, "let i1 : Integer = null, i2 : Integer = null in i1.div(i2)");
        ocl.dispose();
    }

    @Test
    public void testNumberDivide() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, 1.0, "1 / 1", 0.0);
        ocl.assertQueryEquals(null, -0.25, "1 / -4", 0.0);
        ocl.assertQueryEquals(null, 1.0, "1 / 1.0", 0.0);
        ocl.assertQueryEquals(null, -0.25, "1 / -4.0", 0.0);
        ocl.assertQueryEquals(null, 1.0, "1.0 / 1", 0.0);
        ocl.assertQueryEquals(null, -0.25, "1.0 / -4", 0.0);
        ocl.assertQueryEquals(null, 1.0, "1.0 / 1.0", 0.0);
        ocl.assertQueryEquals(null, 0.9910714285714286, "1.11 / 1.12", 1.0 * this.doubleEpsilon);
        ocl.assertQueryInvalid(null, "1 / 0");
        ocl.assertQueryInvalid(null, "1.0 / 0");
        ocl.assertQueryInvalid(null, "1 / 0.0");
        ocl.assertQueryInvalid(null, "1.0 / 0.0");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in 1 / i");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i / 1");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in 1 / r");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in r / 1");
        ocl.assertQueryInvalid(null, "let i1 : Integer = invalid, i2 : Integer = invalid in i1 / i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = invalid, r2 : Real = invalid in r1 / r2");
        ocl.assertQueryInvalid(null, "let i : Integer = null in 1 / i");
        ocl.assertQueryInvalid(null, "let i : Integer = null in i / 1");
        ocl.assertQueryInvalid(null, "let r : Real = null in 1 / r");
        ocl.assertQueryInvalid(null, "let r : Real = null in r / 1");
        ocl.assertQueryInvalid(null, "let i1 : Integer = null, i2 : Integer = null in i1 / i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = null, r2 : Real = null in r1 / r2");
        ocl.dispose();
    }

    @Test
    public void testNumberEqual() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryFalse(null, "4 = 5");
        ocl.assertQueryFalse(null, "1 = 4.0");
        ocl.assertQueryFalse(null, "1.0 = 4");
        ocl.assertQueryFalse(null, "1.0 = 4.0");
        ocl.assertQueryFalse(null, "1.0 = 1.0000000000000001");
        ocl.assertQueryTrue(null, "4 = 4");
        ocl.assertQueryTrue(null, "1 = 1.0");
        ocl.assertQueryTrue(null, "1.0 = 1");
        ocl.assertQueryTrue(null, "1.0 = 1.0");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i = 0");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in -1 = i");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in r = 0.0");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in -1.0 = r");
        ocl.assertQueryInvalid(null, "let i1 : Integer = invalid, i2 : Integer = invalid in i1 = i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = invalid, r2 : Real = invalid in r1 = r2");
        ocl.assertQueryFalse(null, "let i : Integer = null in i = 0");
        ocl.assertQueryFalse(null, "let i : Integer = null in -1 = i");
        ocl.assertQueryFalse(null, "let r : Real = null in r = 0.0");
        ocl.assertQueryFalse(null, "let r : Real = null in -1.0 = r");
        ocl.assertQueryTrue(null, "let i1 : Integer = null, i2 : Integer = null in i1 = i2");
        ocl.assertQueryTrue(null, "let r1 : Real = null, r2 : Real = null in r1 = r2");
        ocl.dispose();
    }

    @Test
    public void testNumberFloor() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, 3, "3.floor()");
        ocl.assertQueryEquals(null, -3, "(-3).floor()");
        ocl.assertQueryEquals(null, -2, "(-1.5).floor()");
        ocl.assertQueryEquals(null, 1, "(1.01).floor()");
        ocl.assertQueryEquals(null, 3, "(3.999).floor()");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i.floor()");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in r.floor()");
        ocl.assertQueryInvalid(null, "let i : Integer = null in i.floor()");
        ocl.assertQueryInvalid(null, "let r : Real = null in r.floor()");
        ocl.dispose();
    }

    @Test
    public void testNumberGreaterThan() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryTrue(null, "3 > 2");
        ocl.assertQueryFalse(null, "-3 > 2");
        ocl.assertQueryTrue(null, "3 > -2");
        ocl.assertQueryFalse(null, "-3 > -2");
        ocl.assertQueryTrue(null, "2147483648 > 2147483647");
        ocl.assertQueryFalse(null, "2147483647 > 2147483648");
        ocl.assertQueryFalse(null, "-2147483649 > -2147483648");
        ocl.assertQueryTrue(null, "-2147483648 > -2147483649");
        ocl.assertQueryTrue(null, "9223372036854775808 > 9223372036854775807");
        ocl.assertQueryFalse(null, "9223372036854775807 > 9223372036854775808");
        ocl.assertQueryFalse(null, "-9223372036854775809 > -9223372036854775808");
        ocl.assertQueryTrue(null, "-9223372036854775808 > -9223372036854775809");
        ocl.assertQueryTrue(null, "3.0 > 2.0");
        ocl.assertQueryFalse(null, "-3.0 > 2.0");
        ocl.assertQueryTrue(null, "3.0 > -2.0");
        ocl.assertQueryFalse(null, "-3.0 > -2.0");
        ocl.assertQueryFalse(null, "3.0 > 3");
        ocl.assertQueryFalse(null, "-3.0 > 3");
        ocl.assertQueryTrue(null, "3.0 > -3");
        ocl.assertQueryFalse(null, "-3.0 > -3");
        ocl.assertQueryFalse(null, "3 > 3.0");
        ocl.assertQueryFalse(null, "-3 > 3.0");
        ocl.assertQueryTrue(null, "3 > -3.0");
        ocl.assertQueryFalse(null, "-3 > -3.0");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i > 0");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in 0 > i");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in r > 0");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in 0 > r");
        ocl.assertQueryInvalid(null, "let i1 : Integer = invalid, i2 : Integer = invalid in i1 > i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = invalid, r2 : Real = invalid in r1 > r2");
        ocl.assertQueryInvalid(null, "let i : Integer = null in i > 0");
        ocl.assertQueryInvalid(null, "let i : Integer = null in 0 > i");
        ocl.assertQueryInvalid(null, "let r : Real = null in r > 0");
        ocl.assertQueryInvalid(null, "let r : Real = null in 0 > r");
        ocl.assertQueryInvalid(null, "let i1 : Integer = null, i2 : Integer = null in i1 > i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = null, r2 : Real = null in r1 > r2");
        ocl.dispose();
    }

    @Test
    public void testNumberGreaterThanOrEqual() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryTrue(null, "3 >= 2");
        ocl.assertQueryFalse(null, "-3 >= 2");
        ocl.assertQueryTrue(null, "3 >= -2");
        ocl.assertQueryFalse(null, "-3 >= -2");
        ocl.assertQueryTrue(null, "2147483648 >= 2147483647");
        ocl.assertQueryFalse(null, "2147483647 >= 2147483648");
        ocl.assertQueryFalse(null, "-2147483649 >= -2147483648");
        ocl.assertQueryTrue(null, "-2147483648 >= -2147483649");
        ocl.assertQueryTrue(null, "9223372036854775808 >= 9223372036854775807");
        ocl.assertQueryFalse(null, "9223372036854775807 >= 9223372036854775808");
        ocl.assertQueryFalse(null, "-9223372036854775809 >= -9223372036854775808");
        ocl.assertQueryTrue(null, "-9223372036854775808 >= -9223372036854775809");
        ocl.assertQueryTrue(null, "3.0 >= 2.0");
        ocl.assertQueryFalse(null, "-3.0 >= 2.0");
        ocl.assertQueryTrue(null, "3.0 >= -2.0");
        ocl.assertQueryFalse(null, "-3.0 >= -2.0");
        ocl.assertQueryTrue(null, "3.0 >= 3");
        ocl.assertQueryFalse(null, "-3.0 >= 3");
        ocl.assertQueryTrue(null, "3.0 >= -3");
        ocl.assertQueryTrue(null, "-3.0 >= -3");
        ocl.assertQueryTrue(null, "3 >= 3.0");
        ocl.assertQueryFalse(null, "-3 >= 3.0");
        ocl.assertQueryTrue(null, "3 >= -3.0");
        ocl.assertQueryTrue(null, "-3 >= -3.0");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i >= 0");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in 0 >= i");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in r >= 0");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in 0 >= r");
        ocl.assertQueryInvalid(null, "let i1 : Integer = invalid, i2 : Integer = invalid in i1 >= i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = invalid, r2 : Real = invalid in r1 >= r2");
        ocl.assertQueryInvalid(null, "let i : Integer = null in i >= 0");
        ocl.assertQueryInvalid(null, "let i : Integer = null in 0 >= i");
        ocl.assertQueryInvalid(null, "let r : Real = null in r >= 0");
        ocl.assertQueryInvalid(null, "let r : Real = null in 0 >= r");
        ocl.assertQueryInvalid(null, "let i1 : Integer = null, i2 : Integer = null in i1 >= i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = null, r2 : Real = null in r1 >= r2");
        ocl.dispose();
    }

    @Test
    public void testNumberLessThan() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryFalse(null, "3 < 2");
        ocl.assertQueryTrue(null, "-3 < 2");
        ocl.assertQueryFalse(null, "3 < -2");
        ocl.assertQueryTrue(null, "-3 < -2");
        ocl.assertQueryFalse(null, "2147483648 < 2147483647");
        ocl.assertQueryTrue(null, "2147483647 < 2147483648");
        ocl.assertQueryTrue(null, "-2147483649 < -2147483648");
        ocl.assertQueryFalse(null, "-2147483648 < -2147483649");
        ocl.assertQueryFalse(null, "9223372036854775808 < 9223372036854775807");
        ocl.assertQueryTrue(null, "9223372036854775807 < 9223372036854775808");
        ocl.assertQueryTrue(null, "-9223372036854775809 < -9223372036854775808");
        ocl.assertQueryFalse(null, "-9223372036854775808 < -9223372036854775809");
        ocl.assertQueryFalse(null, "3.0 < 2.0");
        ocl.assertQueryTrue(null, "-3.0 < 2.0");
        ocl.assertQueryFalse(null, "3.0 < -2.0");
        ocl.assertQueryTrue(null, "-3.0 < -2.0");
        ocl.assertQueryFalse(null, "3.0 < 3");
        ocl.assertQueryTrue(null, "-3.0 < 3");
        ocl.assertQueryFalse(null, "3.0 < -3");
        ocl.assertQueryFalse(null, "-3.0 < -3");
        ocl.assertQueryFalse(null, "3 < 3.0");
        ocl.assertQueryTrue(null, "-3 < 3.0");
        ocl.assertQueryFalse(null, "3 < -3.0");
        ocl.assertQueryFalse(null, "-3 < -3.0");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i < 0");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in 0 < i");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in r < 0");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in 0 < r");
        ocl.assertQueryInvalid(null, "let i1 : Integer = invalid, i2 : Integer = invalid in i1 < i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = invalid, r2 : Real = invalid in r1 < r2");
        ocl.assertQueryInvalid(null, "let i : Integer = null in i < 0");
        ocl.assertQueryInvalid(null, "let i : Integer = null in 0 < i");
        ocl.assertQueryInvalid(null, "let r : Real = null in r < 0");
        ocl.assertQueryInvalid(null, "let r : Real = null in 0 < r");
        ocl.assertQueryInvalid(null, "let i1 : Integer = null, i2 : Integer = null in i1 < i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = null, r2 : Real = null in r1 < r2");
        ocl.dispose();
    }

    @Test
    public void testNumberLessThanOrEqual() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryFalse(null, "3 <= 2");
        ocl.assertQueryTrue(null, "-3 <= 2");
        ocl.assertQueryFalse(null, "3 <= -2");
        ocl.assertQueryTrue(null, "-3 <= -2");
        ocl.assertQueryFalse(null, "2147483648 <= 2147483647");
        ocl.assertQueryTrue(null, "2147483647 <= 2147483648");
        ocl.assertQueryTrue(null, "-2147483649 <= -2147483648");
        ocl.assertQueryFalse(null, "-2147483648 <= -2147483649");
        ocl.assertQueryFalse(null, "9223372036854775808 <= 9223372036854775807");
        ocl.assertQueryTrue(null, "9223372036854775807 <= 9223372036854775808");
        ocl.assertQueryTrue(null, "-9223372036854775809 <= -9223372036854775808");
        ocl.assertQueryFalse(null, "-9223372036854775808 <= -9223372036854775809");
        ocl.assertQueryFalse(null, "3.0 <= 2.0");
        ocl.assertQueryTrue(null, "-3.0 <= 2.0");
        ocl.assertQueryFalse(null, "3.0 <= -2.0");
        ocl.assertQueryTrue(null, "-3.0 <= -2.0");
        ocl.assertQueryTrue(null, "3.0 <= 3");
        ocl.assertQueryTrue(null, "-3.0 <= 3");
        ocl.assertQueryFalse(null, "3.0 <= -3");
        ocl.assertQueryTrue(null, "-3.0 <= -3");
        ocl.assertQueryTrue(null, "3 <= 3.0");
        ocl.assertQueryTrue(null, "-3 <= 3.0");
        ocl.assertQueryFalse(null, "3 <= -3.0");
        ocl.assertQueryTrue(null, "-3 <= -3.0");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i <= 0");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in 0 <= i");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in r <= 0");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in 0 <= r");
        ocl.assertQueryInvalid(null, "let i1 : Integer = invalid, i2 : Integer = invalid in i1 <= i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = invalid, r2 : Real = invalid in r1 <= r2");
        ocl.assertQueryInvalid(null, "let i : Integer = null in i <= 0");
        ocl.assertQueryInvalid(null, "let i : Integer = null in 0 <= i");
        ocl.assertQueryInvalid(null, "let r : Real = null in r <= 0");
        ocl.assertQueryInvalid(null, "let r : Real = null in 0 <= r");
        ocl.assertQueryInvalid(null, "let i1 : Integer = null, i2 : Integer = null in i1 <= i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = null, r2 : Real = null in r1 <= r2");
        ocl.dispose();
    }

    @Test
    public void testNumberMax() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, 3, "3.max(2)");
        ocl.assertQueryEquals(null, 2, "(-3).max(2)");
        ocl.assertQueryEquals(null, 3, "3.max(-2)");
        ocl.assertQueryEquals(null, -2, "(-3).max(-2)");
        ocl.assertQueryEquals(null, 0x80000000L, "2147483648.max(2147483647)");
        ocl.assertQueryEquals(null, 0x80000000L, "2147483647.max(2147483648)");
        ocl.assertQueryEquals(null, Integer.MIN_VALUE, "(-2147483649).max(-2147483648)");
        ocl.assertQueryEquals(null, Integer.MIN_VALUE, "(-2147483648).max(-2147483649)");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63), "9223372036854775808.max(9223372036854775807)");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63), "9223372036854775807.max(9223372036854775808)");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63).negate(), "(-9223372036854775809).max(-9223372036854775808)");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63).negate(), "(-9223372036854775808).max(-9223372036854775809)");
        ocl.assertQueryEquals(null, 3.0, "3.max(2.0)", 0.0);
        ocl.assertQueryEquals(null, 2.0, "(-3).max(2.0)", 0.0);
        ocl.assertQueryEquals(null, 3.0, "3.max(-2.0)", 0.0);
        ocl.assertQueryEquals(null, -2.0, "(-3).max(-2.0)", 0.0);
        ocl.assertQueryEquals(null, 3.0, "(3.0).max(2)", 0.0);
        ocl.assertQueryEquals(null, 2.0, "(-3.0).max(2)", 0.0);
        ocl.assertQueryEquals(null, 3.0, "(3.0).max(-2)", 0.0);
        ocl.assertQueryEquals(null, -2.0, "(-3.0).max(-2)", 0.0);
        ocl.assertQueryEquals(null, 3.0, "(3.0).max(2.0)", 0.0);
        ocl.assertQueryEquals(null, 2.0, "(-3.0).max(2.0)", 0.0);
        ocl.assertQueryEquals(null, 3.0, "(3.0).max(-2.0)", 0.0);
        ocl.assertQueryEquals(null, -2.0, "(-3.0).max(-2.0)", 0.0);
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in 1.max(i)");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i.max(1)");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in 1.max(r)");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in r.max(1)");
        ocl.assertQueryInvalid(null, "let i1 : Integer = invalid, i2 : Integer = invalid in i1.max(i2)");
        ocl.assertQueryInvalid(null, "let r1 : Real = invalid, r2 : Real = invalid in r1.max(r2)");
        ocl.assertQueryInvalid(null, "let i : Integer = null in 1.max(i)");
        ocl.assertQueryInvalid(null, "let i : Integer = null in i.max(1)");
        ocl.assertQueryInvalid(null, "let r : Real = null in 1.max(r)");
        ocl.assertQueryInvalid(null, "let r : Real = null in r.max(1)");
        ocl.assertQueryInvalid(null, "let i1 : Integer = null, i2 : Integer = null in i1.max(i2)");
        ocl.assertQueryInvalid(null, "let r1 : Real = null, r2 : Real = null in r1.max(r2)");
        ocl.dispose();
    }

    @Test
    public void testNumberMin() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, 2, "3.min(2)");
        ocl.assertQueryEquals(null, -3, "(-3).min(2)");
        ocl.assertQueryEquals(null, -2, "3.min(-2)");
        ocl.assertQueryEquals(null, -3, "(-3).min(-2)");
        ocl.assertQueryEquals(null, Integer.MAX_VALUE, "2147483648.min(2147483647)");
        ocl.assertQueryEquals(null, Integer.MAX_VALUE, "2147483647.min(2147483648)");
        ocl.assertQueryEquals(null, -2147483649L, "(-2147483649).min(-2147483648)");
        ocl.assertQueryEquals(null, -2147483649L, "(-2147483648).min(-2147483649)");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63).subtract(BigInteger.ONE), "9223372036854775808.min(9223372036854775807)");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63).subtract(BigInteger.ONE), "9223372036854775807.min(9223372036854775808)");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63).negate().subtract(BigInteger.ONE), "(-9223372036854775809).min(-9223372036854775808)");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63).negate().subtract(BigInteger.ONE), "(-9223372036854775808).min(-9223372036854775809)");
        ocl.assertQueryEquals(null, 2.0, "3.min(2.0)", 0.0);
        ocl.assertQueryEquals(null, -3.0, "(-3).min(2.0)", 0.0);
        ocl.assertQueryEquals(null, -2.0, "3.min(-2.0)", 0.0);
        ocl.assertQueryEquals(null, -3.0, "(-3).min(-2.0)", 0.0);
        ocl.assertQueryEquals(null, 2.0, "(3.0).min(2)", 0.0);
        ocl.assertQueryEquals(null, -3.0, "(-3.0).min(2)", 0.0);
        ocl.assertQueryEquals(null, -2.0, "(3.0).min(-2)", 0.0);
        ocl.assertQueryEquals(null, -3.0, "(-3.0).min(-2)", 0.0);
        ocl.assertQueryEquals(null, 2.0, "(3.0).min(2.0)", 0.0);
        ocl.assertQueryEquals(null, -3.0, "(-3.0).min(2.0)", 0.0);
        ocl.assertQueryEquals(null, -2.0, "(3.0).min(-2.0)", 0.0);
        ocl.assertQueryEquals(null, -3.0, "(-3.0).min(-2.0)", 0.0);
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in 1.min(i)");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i.min(1)");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in 1.min(r)");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in r.min(1)");
        ocl.assertQueryInvalid(null, "let i1 : Integer = invalid, i2 : Integer = invalid in i1.min(i2)");
        ocl.assertQueryInvalid(null, "let r1 : Real = invalid, r2 : Real = invalid in r1.min(r2)");
        ocl.assertQueryInvalid(null, "let i : Integer = null in 1.min(i)");
        ocl.assertQueryInvalid(null, "let i : Integer = null in i.min(1)");
        ocl.assertQueryInvalid(null, "let r : Real = null in 1.min(r)");
        ocl.assertQueryInvalid(null, "let r : Real = null in r.min(1)");
        ocl.assertQueryInvalid(null, "let i1 : Integer = null, i2 : Integer = null in i1.min(i2)");
        ocl.assertQueryInvalid(null, "let r1 : Real = null, r2 : Real = null in r1.min(r2)");
        ocl.dispose();
    }

    @Test
    public void testNumberMinus() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, 0, "1 - 1");
        ocl.assertQueryEquals(null, 5, "1 - -4");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(31).subtract(BigInteger.ONE), "2147483646 - -1");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(31), "2147483647 - -1");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63).subtract(BigInteger.ONE), "9223372036854775806 - -1");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63), "9223372036854775807 - -1");
        ocl.assertQueryEquals(null, BigInteger.ONE.negate().shiftLeft(31), "-2147483647 - 1");
        ocl.assertQueryEquals(null, BigInteger.ONE.negate().shiftLeft(31).subtract(BigInteger.ONE), "-2147483648 - 1");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63).negate(), "-9223372036854775807 - 1");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63).negate().subtract(BigInteger.ONE), "-9223372036854775808 - 1");
        ocl.assertQueryEquals(null, 0.0, "1 - 1.0", 2.0 * this.doubleEpsilon);
        ocl.assertQueryEquals(null, 5.0, "1 - -4.0", 5.0 * this.doubleEpsilon);
        ocl.assertQueryEquals(null, 0.0, "1.0 - 1", 2.0 * this.doubleEpsilon);
        ocl.assertQueryEquals(null, 5.0, "1.0 - -4", 5.0 * this.doubleEpsilon);
        ocl.assertQueryEquals(null, 0.0, "1.0 - 1.0", 2.0 * this.doubleEpsilon);
        ocl.assertQueryEquals(null, -0.01, "1.11 - 1.12", 3.0 * this.doubleEpsilon);
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in 1 - i");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i - 1");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in 1 - r");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in r - 1");
        ocl.assertQueryInvalid(null, "let i1 : Integer = invalid, i2 : Integer = invalid in i1 - i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = invalid, r2 : Real = invalid in r1 - r2");
        ocl.assertQueryInvalid(null, "let i : Integer = null in 1 - i");
        ocl.assertQueryInvalid(null, "let i : Integer = null in i - 1");
        ocl.assertQueryInvalid(null, "let r : Real = null in 1 - r");
        ocl.assertQueryInvalid(null, "let r : Real = null in r - 1");
        ocl.assertQueryInvalid(null, "let i1 : Integer = null, i2 : Integer = null in i1 - i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = null, r2 : Real = null in r1 - r2");
        ocl.dispose();
    }

    @Test
    public void testNumberMod() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, 1, "3.mod(2)");
        ocl.assertQueryEquals(null, -1, "(-3).mod(2)");
        ocl.assertQueryEquals(null, 1, "3.mod(-2)");
        ocl.assertQueryEquals(null, -1, "(-3).mod(-2)");
        ocl.assertQueryInvalid(null, "1.mod(0)");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in 1.mod(i)");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i.mod(1)");
        ocl.assertQueryInvalid(null, "let i1 : Integer = invalid, i2 : Integer = invalid in i1.mod(i2)");
        ocl.assertQueryInvalid(null, "let i : Integer = null in 1.mod(i)");
        ocl.assertQueryInvalid(null, "let i1 : Integer = null, i2 : Integer = null in i1.mod(i2)");
        ocl.dispose();
    }

    @Test
    public void testNumberNegate() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, -1, "-1");
        ocl.assertQueryEquals(null, -1.0, "-1.0", 0.0);
        ocl.assertQueryEquals(null, -2147483647, "-2147483647");
        ocl.assertQueryEquals(null, Integer.MIN_VALUE, "-2147483648");
        ocl.assertQueryEquals(null, -2147483649L, "-2147483649");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63).negate().add(BigInteger.ONE), "-9223372036854775807");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63).negate(), "-9223372036854775808");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63).negate().subtract(BigInteger.ONE), "-9223372036854775809");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in -i");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in -r");
        ocl.assertQueryInvalid(null, "let i : Integer = null in -i");
        ocl.assertQueryInvalid(null, "let r : Real = null in -r");
        ocl.dispose();
    }

    @Test
    public void testNumberNotEqual() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryTrue(null, "4 <> 5");
        ocl.assertQueryTrue(null, "1 <> 4.0");
        ocl.assertQueryTrue(null, "1.0 <> 4");
        ocl.assertQueryTrue(null, "1.0 <> 4.0");
        ocl.assertQueryFalse(null, "4 <> 4");
        ocl.assertQueryFalse(null, "1 <> 1.0");
        ocl.assertQueryFalse(null, "1.0 <> 1");
        ocl.assertQueryFalse(null, "1.0 <> 1.0");
        ocl.assertQueryTrue(null, "1.0 <> 1.0000000000000001");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i <> 0");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in -1 <> i");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in r <> 0.0");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in -1.0 <> r");
        ocl.assertQueryInvalid(null, "let i1 : Integer = invalid, i2 : Integer = invalid in i1 <> i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = invalid, r2 : Real = invalid in r1 <> r2");
        ocl.assertQueryTrue(null, "let i : Integer = null in i <> 0");
        ocl.assertQueryTrue(null, "let i : Integer = null in -1 <> i");
        ocl.assertQueryTrue(null, "let r : Real = null in r <> 0.0");
        ocl.assertQueryTrue(null, "let r : Real = null in -1.0 <> r");
        ocl.assertQueryFalse(null, "let i1 : Integer = null, i2 : Integer = null in i1 <> i2");
        ocl.assertQueryFalse(null, "let r1 : Real = null, r2 : Real = null in r1 <> r2");
        ocl.dispose();
    }

    @Test
    public void testNumberPlus() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, 2, "1 + 1");
        ocl.assertQueryEquals(null, -3, "1 + -4");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(31).subtract(BigInteger.ONE), "2147483646 + 1");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(31), "2147483647 + 1");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63).subtract(BigInteger.ONE), "9223372036854775806 + 1");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(63), "9223372036854775807 + 1");
        ocl.assertQueryEquals(null, BigInteger.ONE.negate().shiftLeft(31), "-2147483647 + -1");
        ocl.assertQueryEquals(null, BigInteger.ONE.negate().shiftLeft(31).subtract(BigInteger.ONE), "-2147483648 + -1");
        ocl.assertQueryEquals(null, BigInteger.ONE.negate().shiftLeft(63), "-9223372036854775807 + -1");
        ocl.assertQueryEquals(null, BigInteger.ONE.negate().shiftLeft(63).subtract(BigInteger.ONE), "-9223372036854775808 + -1");
        ocl.assertQueryEquals(null, 2.0, "1 + 1.0", 2.0 * this.doubleEpsilon);
        ocl.assertQueryEquals(null, -3.0, "1 + -4.0", 5.0 * this.doubleEpsilon);
        ocl.assertQueryEquals(null, 2.0, "1.0 + 1", 2.0 * this.doubleEpsilon);
        ocl.assertQueryEquals(null, -3.0, "1.0 + -4", 5.0 * this.doubleEpsilon);
        ocl.assertQueryEquals(null, 2.0, "1.0 + 1.0", 2.0 * this.doubleEpsilon);
        ocl.assertQueryEquals(null, 2.23, "1.11 + 1.12", 3.0 * this.doubleEpsilon);
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in 1 + i");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i + 1");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in 1 + r");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in r + 1");
        ocl.assertQueryInvalid(null, "let i1 : Integer = invalid, i2 : Integer = invalid in i1 + i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = invalid, r2 : Real = invalid in r1 + r2");
        ocl.assertQueryInvalid(null, "let i : Integer = null in 1 + i");
        ocl.assertQueryInvalid(null, "let i : Integer = null in i + 1");
        ocl.assertQueryInvalid(null, "let r : Real = null in 1 + r");
        ocl.assertQueryInvalid(null, "let r : Real = null in r + 1");
        ocl.assertQueryInvalid(null, "let i1 : Integer = null, i2 : Integer = null in i1 + i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = null, r2 : Real = null in r1 + r2");
        ocl.dispose();
    }

    @Test
    public void testNumberRound() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, 3, "3.round()");
        ocl.assertQueryEquals(null, -3, "(-3).round()");
        ocl.assertQueryEquals(null, -1, "(-1.5).round()");
        ocl.assertQueryEquals(null, 1, "(1.01).round()");
        ocl.assertQueryEquals(null, 4, "(3.999).round()");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i.round()");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in r.round()");
        ocl.assertQueryInvalid(null, "let i : Integer = null in i.round()");
        ocl.assertQueryInvalid(null, "let r : Real = null in r.round()");
        ocl.dispose();
    }

    @Test
    public void testNumberTimes() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, 1, "1 * 1");
        ocl.assertQueryEquals(null, -4, "1 * -4");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(62), "-2147483648 * -2147483648");
        ocl.assertQueryEquals(null, BigInteger.ONE.shiftLeft(126), "-9223372036854775808 * -9223372036854775808");
        ocl.assertQueryEquals(null, 1.0, "1 * 1.0", 0.0);
        ocl.assertQueryEquals(null, -4.0, "1 * -4.0", 0.0);
        ocl.assertQueryEquals(null, 1.0, "1.0 * 1", 0.0);
        ocl.assertQueryEquals(null, -4.0, "1.0 * -4", 0.0);
        ocl.assertQueryEquals(null, 1.0, "1.0 * 1.0", 0.0);
        BigDecimal expected = BigDecimal.valueOf(1.11).multiply(BigDecimal.valueOf(1.12));
        ocl.assertQueryEquals(null, (Number)expected, "1.11 * 1.12", 0.0);
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in 1 * i");
        ocl.assertQueryInvalid(null, "let i : Integer = invalid in i * 1");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in 1 * r");
        ocl.assertQueryInvalid(null, "let r : Real = invalid in r * 1");
        ocl.assertQueryInvalid(null, "let i1 : Integer = invalid, i2 : Integer = invalid in i1 * i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = invalid, r2 : Real = invalid in r1 * r2");
        ocl.assertQueryInvalid(null, "let i : Integer = null in 1 * i");
        ocl.assertQueryInvalid(null, "let i : Integer = null in i * 1");
        ocl.assertQueryInvalid(null, "let r : Real = null in 1 * r");
        ocl.assertQueryInvalid(null, "let r : Real = null in r * 1");
        ocl.assertQueryInvalid(null, "let i1 : Integer = null, i2 : Integer = null in i1 * i2");
        ocl.assertQueryInvalid(null, "let r1 : Real = null, r2 : Real = null in r1 * r2");
        ocl.dispose();
    }

    @Test
    public void testNumberToString() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, "1", "1.toString()");
        ocl.assertQueryEquals(null, "3.0", "3.0.toString()");
        ocl.assertQueryEquals(null, "4.0", "(1.0+3.0).toString()");
        ocl.assertQueryEquals(null, "null", "null.toString()");
        ocl.assertQueryInvalid(null, "invalid.toString()");
        ocl.assertQueryEquals(null, "*", "*.toString()");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedAbs() {
        TestOCL ocl = this.createOCL();
        ocl.assertSemanticErrorQuery(null, "*.abs()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "UnlimitedNatural", "abs");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = invalid in u.abs()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "UnlimitedNatural", "abs");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = null in u.abs()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "UnlimitedNatural", "abs");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedDivide() {
        TestOCL ocl = this.createOCL();
        ocl.assertSemanticErrorQuery(null, "1 / *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Integer", "/", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "* / 1", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "/", "Integer");
        ocl.assertSemanticErrorQuery(null, "1.0 / *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Real", "/", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "* / 1.0", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "/", "Real");
        ocl.assertSemanticErrorQuery(null, "* / *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "/", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = invalid in * / u", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "/", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = invalid in u / *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "/", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 / u2", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "/", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = null in * / u", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "/", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = null in u / *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "/", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 / u2", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "/", "UnlimitedNatural");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedEqual() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryFalse(null, "* = 1");
        ocl.assertQueryFalse(null, "1 = *");
        ocl.assertQueryFalse(null, "* = 1.0");
        ocl.assertQueryFalse(null, "1.0 = *");
        ocl.assertQueryFalse(null, "* = -1");
        ocl.assertQueryFalse(null, "-1 = *");
        ocl.assertQueryFalse(null, "* = -1.0");
        ocl.assertQueryFalse(null, "-1.0 = *");
        ocl.assertQueryTrue(null, "* = *");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = invalid in u = *");
        ocl.assertQueryInvalid(null, "let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 = u2");
        ocl.assertQueryFalse(null, "let u : UnlimitedNatural = null in u = *");
        ocl.assertQueryTrue(null, "let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 = u2");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedFloor() {
        TestOCL ocl = this.createOCL();
        ocl.assertSemanticErrorQuery(null, "*.floor()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "UnlimitedNatural", "floor");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = invalid in u.floor()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "UnlimitedNatural", "floor");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = null in u.floor()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "UnlimitedNatural", "floor");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedGreaterThan() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryFalse(null, "1 > *");
        ocl.assertQueryTrue(null, "* > 1");
        ocl.assertQueryFalse(null, "* > *");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = invalid in u > 0");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = invalid in 0 > u");
        ocl.assertQueryInvalid(null, "let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 > u2");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = null in u > 0");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = null in 0 > u");
        ocl.assertQueryInvalid(null, "let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 > u2");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedGreaterThanOrEqual() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryFalse(null, "1 >= *");
        ocl.assertQueryTrue(null, "* >= 1");
        ocl.assertQueryTrue(null, "* >= *");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = invalid in u >= 0");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = invalid in 0 >= u");
        ocl.assertQueryInvalid(null, "let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 >= u2");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = null in u >= 0");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = null in 0 >= u");
        ocl.assertQueryInvalid(null, "let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 >= u2");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedLessThan() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryTrue(null, "1 < *");
        ocl.assertQueryFalse(null, "* < 1");
        ocl.assertQueryFalse(null, "* < *");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = invalid in u < 0");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = invalid in 0 < u");
        ocl.assertQueryInvalid(null, "let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 < u2");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = null in u < 0");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = null in 0 < u");
        ocl.assertQueryInvalid(null, "let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 < u2");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedLessThanOrEqual() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryTrue(null, "1 <= *");
        ocl.assertQueryFalse(null, "* <= 1.toUnlimitedNatural()");
        ocl.assertQueryTrue(null, "* <= *");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = invalid in u <= 0.toUnlimitedNatural()");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = invalid in 0.toUnlimitedNatural() <= u");
        ocl.assertQueryInvalid(null, "let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 <= u2");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = null in u <= 0.toUnlimitedNatural()");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = null in 0.toUnlimitedNatural() <= u");
        ocl.assertQueryInvalid(null, "let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 <= u2");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedMax() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryUnlimited(null, "1.max(*)");
        ocl.assertQueryUnlimited(null, "*.max(1)");
        ocl.assertQueryUnlimited(null, "0.max(*)");
        ocl.assertQueryUnlimited(null, "*.max(0)");
        ocl.assertQueryInvalid(null, "(-1).max(*)");
        ocl.assertQueryInvalid(null, "*.max(-1)");
        ocl.assertSemanticErrorQuery(null, "(1.0).max(*)", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Real", "max", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "*.max(1.0)", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "max", "Real");
        ocl.assertQueryUnlimited(null, "*.max(*)");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = invalid in *.max(u)");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = invalid in u.max(*)");
        ocl.assertQueryInvalid(null, "let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1.max(u2)");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = null in *.max(u)");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = null in u.max(*)");
        ocl.assertQueryInvalid(null, "let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1.max(u2)");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedMin() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryEquals(null, 1, "1.min(*)");
        ocl.assertQueryEquals(null, 1, "*.min(1)");
        ocl.assertQueryEquals(null, 0, "0.min(*)");
        ocl.assertQueryEquals(null, 0, "*.min(0)");
        ocl.assertQueryInvalid(null, "(-1).min(*)");
        ocl.assertQueryInvalid(null, "*.min(-1)");
        ocl.assertSemanticErrorQuery(null, "(1.0).min(*)", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Real", "min", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "*.min(1.0)", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "min", "Real");
        ocl.assertQueryUnlimited(null, "*.min(*)");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = invalid in *.min(u)");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = invalid in u.min(*)");
        ocl.assertQueryInvalid(null, "let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1.min(u2)");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = null in *.min(u)");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = null in u.min(*)");
        ocl.assertQueryInvalid(null, "let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1.min(u2)");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedMinus() {
        TestOCL ocl = this.createOCL();
        ocl.assertSemanticErrorQuery(null, "1 - *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Integer", "-", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "* - 1", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "-", "Integer");
        ocl.assertSemanticErrorQuery(null, "1.0 - *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Real", "-", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "* - 1.0", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "-", "Real");
        ocl.assertSemanticErrorQuery(null, "* - *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "-", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = invalid in * - u", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "-", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = invalid in u - *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "-", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 - u2", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "-", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = null in * - u", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "-", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = null in u - *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "-", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 - u2", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "-", "UnlimitedNatural");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedNegate() {
        TestOCL ocl = this.createOCL();
        ocl.assertSemanticErrorQuery(null, "-*", PivotMessagesInternal.UnresolvedOperation_ERROR_, "UnlimitedNatural", "-");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = invalid in -u", PivotMessagesInternal.UnresolvedOperation_ERROR_, "UnlimitedNatural", "-");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedNotEqual() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryTrue(null, "* <> 1");
        ocl.assertQueryTrue(null, "1 <> *");
        ocl.assertQueryTrue(null, "* <> 1.0");
        ocl.assertQueryTrue(null, "1.0 <> *");
        ocl.assertQueryTrue(null, "* <> -1");
        ocl.assertQueryTrue(null, "-1 <> *");
        ocl.assertQueryTrue(null, "* <> -1.0");
        ocl.assertQueryTrue(null, "-1.0 <> *");
        ocl.assertQueryFalse(null, "* <> *");
        ocl.assertQueryInvalid(null, "let u : UnlimitedNatural = invalid in u <> *");
        ocl.assertQueryInvalid(null, "let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 <> u2");
        ocl.assertQueryTrue(null, "let u : UnlimitedNatural = null in u <> *");
        ocl.assertQueryFalse(null, "let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 <> u2");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedPlus() {
        TestOCL ocl = this.createOCL();
        ocl.assertSemanticErrorQuery(null, "1 + *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Integer", "+", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "* + 1", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "+", "Integer");
        ocl.assertSemanticErrorQuery(null, "1.0 + *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Real", "+", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "* + 1.0", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "+", "Real");
        ocl.assertSemanticErrorQuery(null, "* + *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "+", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = invalid in * + u", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "+", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = invalid in u + *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "+", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 + u2", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "+", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = null in * + u", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "+", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = null in u + *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "+", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 + u2", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "+", "UnlimitedNatural");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedRound() {
        TestOCL ocl = this.createOCL();
        ocl.assertSemanticErrorQuery(null, "*.round()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "UnlimitedNatural", "round");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = invalid in u.round()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "UnlimitedNatural", "round");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = null in u.round()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "UnlimitedNatural", "round");
        ocl.dispose();
    }

    @Test
    public void testUnlimitedTimes() {
        TestOCL ocl = this.createOCL();
        ocl.assertSemanticErrorQuery(null, "1 * *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Integer", "*", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "* * 1", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "*", "Integer");
        ocl.assertSemanticErrorQuery(null, "1.0 * *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Real", "*", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "* * 1.0", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "*", "Real");
        ocl.assertSemanticErrorQuery(null, "* * *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "*", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = invalid in * * u", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "*", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = invalid in u * *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "*", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 * u2", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "*", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = null in * * u", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "*", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u : UnlimitedNatural = null in u * *", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "*", "UnlimitedNatural");
        ocl.assertSemanticErrorQuery(null, "let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 * u2", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "UnlimitedNatural", "*", "UnlimitedNatural");
        ocl.dispose();
    }
}

