/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.ElementExtension;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Profile;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.uml.internal.library.UMLElementExtension;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.junit.After;
import org.junit.Before;

public class StereotypesTest
extends PivotTestSuite {
    @Override
    @NonNull
    protected MyOCL createOCL() throws ParserException {
        return new MyOCL(this.getTestPackageName(), this.getName());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        UMLStandaloneSetup.init();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void test_stereotypeM1Navigation() throws Exception {
        MyOCL ocl = this.createOCL();
        ocl.assertSemanticErrorQuery(ocl.mm.asEnglishClass, "self.extension_InEnglish", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Model::EnglishClass", "extension_InEnglish");
        ocl.assertValidQuery(ocl.mm.asEnglishClass, "self.oclType().extension_Internationalized");
        ocl.assertValidQuery(ocl.mm.asEnglishClass, "self.extension_Internationalized.base_Class");
        ocl.assertSemanticErrorQuery(ocl.mm.asEnglishClass, "self.extension_InGerman", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Model::EnglishClass", "extension_InGerman");
        ocl.assertSemanticErrorQuery(ocl.mm.asEnglishClass, "self.getAllAppliedStereotypes()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Model::EnglishClass", "getAllAppliedStereotypes");
        ocl.assertSemanticErrorQuery(ocl.mm.asEnglishClass, "self.getAppliedStereotypes()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Model::EnglishClass", "getAppliedStereotypes");
        ocl.dispose();
    }

    public void test_stereotypeM2Navigation() throws Exception {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryEquals(ocl.mm.umlEnglishClass, "EnglishClass", "self.NamedElement::name");
        ocl.assertQueryEquals(ocl.mm.umlEnglishClass, "EnglishClass", "self.name");
        ocl.assertSemanticErrorQuery(ocl.mm.asEnglishClass, "self.extension_InEnglish", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Model::EnglishClass", "extension_InEnglish");
        ocl.assertQueryEquals(ocl.mm.umlEnglishClass, ocl.mm.umlEnglishClassInEnglish, "self.extension_Internationalized");
        ocl.assertQueryEquals(ocl.mm.umlEnglishClass, ocl.mmm.umlFace.getOwnedLiteral("NORMAL"), "self.extension_Internationalized.face");
        ocl.assertQueryEquals(ocl.mm.umlGermanClass, ocl.mmm.umlFace.getOwnedLiteral("BOLD"), "self.extension_Internationalized.face");
        ocl.assertQueryEquals(ocl.mm.umlEnglishClassInEnglish, ocl.mm.umlEnglishClass, "self.base_Class");
        ocl.assertQueryEquals(ocl.mm.asEnglishClassInEnglish, ocl.mm.asEnglishClass, "self.base_Class");
        ocl.assertQueryEquals(ocl.mm.umlEnglishClass, "InEnglish", "self.extension_Internationalized.oclType().name");
        ocl.assertSemanticErrorQuery(ocl.mm.asEnglishClass, "self.extension_InGerman", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Model::EnglishClass", "extension_InGerman");
        ocl.assertSemanticErrorQuery(ocl.getIdResolver().getStaticTypeOf((Object)ocl.mm.umlEnglishClass), "self.extension_Internationalized.extension_InEnglish", PivotMessagesInternal.UnresolvedProperty_ERROR_, "InternationalizedProfile::Internationalized", "extension_InEnglish");
        ocl.assertSemanticErrorQuery(ocl.mm.asEnglishClass, "self.extension_Internationalized.extension_InEnglish", PivotMessagesInternal.UnresolvedProperty_ERROR_, "InternationalizedProfile::Internationalized", "extension_InEnglish");
        ocl.assertQueryEquals(ocl.mm.umlEnglishClass, ocl.mm.umlEnglishClassInEnglish, "self.extension_Internationalized");
        ocl.assertQueryEquals(ocl.mm.asEnglishClass, ocl.mm.asEnglishClassInEnglish, "self.extension_Internationalized");
        ocl.assertQueryEquals(ocl.mm.umlEnglishClass, ocl.mm.umlEnglishClass, "self.extension_Internationalized.base_Class");
        ocl.assertQueryEquals(ocl.mm.asEnglishClass, ocl.mm.asEnglishClass, "self.extension_Internationalized.base_Class");
        ocl.assertQueryEquals(ocl.mm.umlEnglishClassInEnglish, ocl.mm.umlEnglishClassInEnglish, "self.base_Class.extension_Internationalized");
        ocl.assertQueryEquals(ocl.mm.asEnglishClassInEnglish, ocl.mm.asEnglishClassInEnglish, "self.base_Class.extension_Internationalized");
        ocl.assertQueryTrue(ocl.mm.umlEnglishClass, "extension_Internationalized.base_Class = self");
        ocl.assertQueryTrue(ocl.mm.asEnglishClassInEnglish, "base_Class.extension_Internationalized = self");
        ocl.assertSemanticErrorQuery(ocl.mm.asFrenchClass, "self.text", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Model::FrenchClass", "text");
        ocl.dispose();
    }

    public void test_stereotyped_allInstances_382981() throws ParserException {
        MyOCL ocl = this.createOCL();
        IdResolver idResolver = ocl.getIdResolver();
        ocl.assertQueryEquals(ocl.m.eEnglishObject, idResolver.createSetOfEach(null, new Object[]{ocl.m.eEnglishObject}), "EnglishClass.allInstances()");
        ocl.assertQueryEquals(ocl.m.eEnglishObject, idResolver.createSetOfEach(null, new Object[]{ocl.m.eGermanObject}), "GermanClass.allInstances()");
        ocl.assertQueryEquals(ocl.mm.umlEnglishClass, idResolver.createSetOfEach(null, new Object[0]), "Model::EnglishClass.allInstances()");
        ocl.assertQueryEquals(ocl.mm.umlEnglishClass, idResolver.createSetOfEach(null, new Object[]{ocl.mm.umlPlainClass, ocl.mm.umlEnglishClass, ocl.mm.umlLanguageClass, ocl.mm.umlFrenchClass, ocl.mm.umlGermanClass}), "Class.allInstances()");
        ocl.assertQueryEquals(ocl.mm.asEnglishClass, idResolver.createSetOfEach(null, new Object[]{ocl.mm.asEnglishClassInEnglish, ocl.mm.asFrenchClassInEnglish, ocl.mm.asGermanClassInEnglish}), "ocl::ElementExtension.allInstances()");
        ocl.dispose();
    }

    public void test_MDT_UML2_operations_382978() throws ParserException {
        MyOCL ocl = this.createOCL();
        IdResolver idResolver = ocl.getIdResolver();
        ocl.assertSemanticErrorQuery(ocl.mm.asEnglishClass, "self.getAppliedStereotypes()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Model::EnglishClass", "getAppliedStereotypes");
        ocl.assertQueryEquals(ocl.mm.umlEnglishClass, idResolver.createSetOfEach(null, new Object[]{((PivotObjectImpl)ocl.mmm.asInEnglishStereotype).getESObject()}), "self.getAppliedStereotypes()");
        ocl.assertQueryEquals(ocl.mm.umlEnglishClass, ((PivotObjectImpl)ocl.mmm.asInEnglishStereotype).getESObject(), "self.getAppliedStereotype('InternationalizedProfile::InEnglish')");
        ocl.assertQueryEquals(ocl.mm.asEnglishClass, ocl.mm.asEnglishClassInEnglish, "self.extension_Internationalized");
        ocl.assertQueryEquals(ocl.mm.umlEnglishClass, ocl.mm.umlEnglishClassInEnglish, "self.extension_Internationalized");
        ocl.assertQueryEquals(ocl.mm.umlEnglishClass, ocl.mm.umlEnglishClassInEnglish, "self.extension_Internationalized.oclAsType(InternationalizedProfile::InEnglish)");
        ocl.assertQueryInvalid(ocl.mm.umlEnglishClass, "self.extension_Internationalized.oclAsType(InternationalizedProfile::InGerman)", StringUtil.bind((String)PivotMessages.IncompatibleOclAsTypeSourceType, (Object[])new Object[]{ocl.mmm.asInEnglishStereotype, "InternationalizedProfile::InGerman"}), InvalidValueException.class);
        ocl.dispose();
    }

    public void test_uml_enums_412685() throws Exception {
        MyOCL ocl = this.createOCL();
        org.eclipse.ocl.pivot.EnumerationLiteral asBold = ocl.mmm.asFace.getEnumerationLiteral("BOLD");
        EnumerationLiteral umlBold = ocl.mmm.umlFace.getOwnedLiteral("BOLD");
        ocl.assertQueryEquals(ocl.mm.asGermanClass, asBold, "InternationalizedProfile::Face::BOLD");
        ocl.assertQueryEquals(ocl.mm.umlGermanClass, umlBold, "InternationalizedProfile::Face::BOLD");
        ocl.assertQueryEquals(ocl.mm.asGermanClass, asBold, "self.extension_Internationalized.face");
        ocl.assertQueryEquals(ocl.mm.umlGermanClass, umlBold, "self.extension_Internationalized.face");
        ocl.assertQueryTrue(ocl.mm.asFrenchClass, "self.extension_Internationalized.isFace(InternationalizedProfile::Face::ITALIC)");
        ocl.assertQueryTrue(ocl.mm.umlFrenchClass, "self.extension_Internationalized.isFace(InternationalizedProfile::Face::ITALIC)");
        ocl.assertQueryTrue(ocl.mm.asEnglishClass, "self.extension_Internationalized.face() = InternationalizedProfile::Face::NORMAL");
        ocl.assertQueryTrue(ocl.mm.umlEnglishClass, "self.extension_Internationalized.face() = InternationalizedProfile::Face::NORMAL");
        ocl.assertQueryTrue(ocl.mm.asEnglishClass, "self.extension_Internationalized.isFace(InternationalizedProfile::Face::NORMAL)");
        ocl.assertQueryTrue(ocl.mm.umlEnglishClass, "self.extension_Internationalized.isFace(InternationalizedProfile::Face::NORMAL)");
        ocl.assertQueryFalse(ocl.mm.asEnglishClass, "self.extension_Internationalized.isFace(InternationalizedProfile::Face::BOLD)");
        ocl.assertQueryFalse(ocl.mm.umlEnglishClass, "self.extension_Internationalized.isFace(InternationalizedProfile::Face::BOLD)");
        ocl.assertQueryTrue(ocl.mm.asEnglishClass, "self.extension_Internationalized.face = InternationalizedProfile::Face::NORMAL");
        ocl.assertQueryTrue(ocl.mm.umlEnglishClass, "self.extension_Internationalized.face = InternationalizedProfile::Face::NORMAL");
        ocl.assertQueryFalse(ocl.mm.asFrenchClass, "self.extension_Internationalized.isFace(InternationalizedProfile::Face::BOLD)");
        ocl.assertQueryFalse(ocl.mm.umlFrenchClass, "self.extension_Internationalized.isFace(InternationalizedProfile::Face::BOLD)");
        ocl.assertQueryEquals(ocl.mm.asGermanClass, asBold, "self.extension_Internationalized.face");
        ocl.assertQueryEquals(ocl.mm.umlGermanClass, umlBold, "self.extension_Internationalized.face");
        ocl.assertQueryEquals(ocl.mm.asGermanClass, asBold, "self.extension_Internationalized.face()");
        ocl.assertQueryEquals(ocl.mm.umlGermanClass, umlBold, "self.extension_Internationalized.face()");
        ocl.dispose();
    }

    public class InternationalizedMetamodel {
        Package umlPackage;
        Type umlEnglishClass;
        Type umlFrenchClass;
        Type umlGermanClass;
        Type umlLanguageClass;
        Type umlPlainClass;
        Type umlString;
        UMLElementExtension umlEnglishClassInEnglish;
        Class asEnglishClass;
        Class asFrenchClass;
        Class asGermanClass;
        ElementExtension asEnglishClassInEnglish;
        ElementExtension asFrenchClassInEnglish;
        ElementExtension asGermanClassInEnglish;

        public InternationalizedMetamodel(@NonNull OCL ocl, InternationalizedProfile mmm, Package umlPackage) throws ParserException {
            MetamodelManager metamodelManager = ocl.getMetamodelManager();
            this.umlPackage = umlPackage;
            this.umlEnglishClass = umlPackage.getOwnedType("EnglishClass");
            this.umlFrenchClass = umlPackage.getOwnedType("FrenchClass");
            this.umlGermanClass = umlPackage.getOwnedType("GermanClass");
            this.umlLanguageClass = umlPackage.getOwnedType("LanguageClass");
            this.umlPlainClass = umlPackage.getOwnedType("PlainClass");
            this.umlString = umlPackage.getOwnedType("String");
            this.asEnglishClass = (Class)metamodelManager.getASOf(Class.class, (EObject)this.umlEnglishClass);
            this.asFrenchClass = (Class)metamodelManager.getASOf(Class.class, (EObject)this.umlFrenchClass);
            this.asGermanClass = (Class)metamodelManager.getASOf(Class.class, (EObject)this.umlGermanClass);
            this.umlEnglishClassInEnglish = (UMLElementExtension)UMLElementExtension.getUMLElementExtension((Stereotype)mmm.asInEnglishStereotype, (Element)this.umlEnglishClass);
            this.asEnglishClassInEnglish = (ElementExtension)NameUtil.getNameable((Iterable)this.asEnglishClass.getOwnedExtensions(), (String)"EnglishClass$InEnglish");
            this.asFrenchClassInEnglish = (ElementExtension)NameUtil.getNameable((Iterable)this.asFrenchClass.getOwnedExtensions(), (String)"FrenchClass$InFrench");
            this.asGermanClassInEnglish = (ElementExtension)NameUtil.getNameable((Iterable)this.asGermanClass.getOwnedExtensions(), (String)"GermanClass$InGerman");
        }
    }

    public class InternationalizedModel {
        EClass eEnglishClass;
        EClass eFrenchClass;
        EClass eGermanClass;
        EObject eEnglishObject;
        EObject eFrenchObject;
        EObject eGermanObject;

        public InternationalizedModel(InternationalizedMetamodel mm, Resource ecoreModel, Resource model) throws ParserException {
            Collection ecorePackages = UMLUtil.convertToEcore((Package)mm.umlPackage, null);
            ecoreModel.getContents().addAll(ecorePackages);
            for (EPackage ePackage : ecorePackages) {
                for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                    String name = eClassifier.getName();
                    if ("EnglishClass".equals(name)) {
                        this.eEnglishClass = (EClass)eClassifier;
                        continue;
                    }
                    if ("FrenchClass".equals(name)) {
                        this.eFrenchClass = (EClass)eClassifier;
                        continue;
                    }
                    if (!"GermanClass".equals(name)) continue;
                    this.eGermanClass = (EClass)eClassifier;
                }
            }
            EFactory eFactoryInstance = this.eEnglishClass.getEPackage().getEFactoryInstance();
            this.eEnglishObject = eFactoryInstance.create(this.eEnglishClass);
            model.getContents().add((Object)this.eEnglishObject);
            this.eFrenchObject = eFactoryInstance.create(this.eFrenchClass);
            model.getContents().add((Object)this.eFrenchObject);
            this.eGermanObject = eFactoryInstance.create(this.eGermanClass);
            model.getContents().add((Object)this.eGermanObject);
        }
    }

    public class InternationalizedProfile {
        org.eclipse.uml2.uml.Profile umlProfile;
        org.eclipse.uml2.uml.Stereotype umlInEnglishStereotype;
        org.eclipse.uml2.uml.Stereotype umlInFrenchStereotype;
        org.eclipse.uml2.uml.Stereotype umlInGermanStereotype;
        org.eclipse.uml2.uml.Enumeration umlFace;
        Profile asProfile;
        Stereotype asInEnglishStereotype;
        Stereotype asInFrenchStereotype;
        Stereotype asInGermanStereotype;
        Enumeration asFace;

        public InternationalizedProfile(OCL ocl, org.eclipse.uml2.uml.Profile umlProfile) throws ParserException {
            this.umlProfile = umlProfile;
            this.umlInEnglishStereotype = umlProfile.getOwnedStereotype("InEnglish");
            this.umlInFrenchStereotype = umlProfile.getOwnedStereotype("InFrench");
            this.umlInGermanStereotype = umlProfile.getOwnedStereotype("InGerman");
            this.umlFace = (org.eclipse.uml2.uml.Enumeration)umlProfile.getOwnedType("Face");
            MetamodelManager metamodelManager = ocl.getMetamodelManager();
            this.asProfile = (Profile)metamodelManager.getASOf(Profile.class, (EObject)umlProfile);
            this.asInEnglishStereotype = (Stereotype)metamodelManager.getASOf(Stereotype.class, (EObject)this.umlInEnglishStereotype);
            this.asInFrenchStereotype = (Stereotype)metamodelManager.getASOf(Stereotype.class, (EObject)this.umlInFrenchStereotype);
            this.asInGermanStereotype = (Stereotype)metamodelManager.getASOf(Stereotype.class, (EObject)this.umlInGermanStereotype);
            this.asFace = (Enumeration)metamodelManager.getASOf(Enumeration.class, (EObject)this.umlFace);
        }
    }

    public class MyOCL
    extends TestOCL {
        InternationalizedProfile mmm;
        InternationalizedMetamodel mm;
        InternationalizedModel m;

        public MyOCL(@NonNull String testPackageName, String name) throws ParserException {
            super(testPackageName, name, OCL.NO_PROJECTS);
            this.mmm = null;
            this.mm = null;
            this.m = null;
            ResourceSet resourceSet = this.getResourceSet();
            ProjectMap.getAdapter((ResourceSet)resourceSet);
            String problem = UML2AS.initialize((ResourceSet)resourceSet);
            StereotypesTest.assertNull((Object)problem);
            URI testModelURI = StereotypesTest.this.getTestModelURI("model/InternationalizedClasses.uml");
            Resource umlResource = resourceSet.getResource(testModelURI, true);
            Package umlPackage = (Package)umlResource.getContents().get(0);
            URI testProfileURI = StereotypesTest.this.getTestModelURI("model/Internationalized.profile.uml");
            org.eclipse.uml2.uml.Profile umlProfile = (org.eclipse.uml2.uml.Profile)resourceSet.getResource(testProfileURI, true).getContents().get(0);
            this.uml2as(umlResource);
            this.mmm = new InternationalizedProfile((OCL)this, umlProfile);
            this.mm = new InternationalizedMetamodel((OCL)this, this.mmm, umlPackage);
            URI ecoreURI = StereotypesTest.this.getTestModelURI("Languages.ecore");
            URI modelURI = StereotypesTest.this.getTestModelURI("Languages.xmi");
            Resource ecoreModel = resourceSet.createResource(ecoreURI);
            Resource model = resourceSet.createResource(modelURI);
            this.m = new InternationalizedModel(this.mm, ecoreModel, model);
        }

        @NonNull
        public ASResource uml2as(@NonNull Resource umlResource) throws ParserException {
            assert (this.environmentFactory != null);
            UML2AS uml2as = UML2AS.getAdapter((Resource)umlResource, (EnvironmentFactoryInternal)this.environmentFactory);
            Model pivotModel = uml2as.getASModel();
            ASResource asResource = (ASResource)pivotModel.eResource();
            return (ASResource)ClassUtil.nonNullModel((Object)asResource);
        }
    }
}

