/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.standalone;

import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporter;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCase;
import org.eclipse.ocl.examples.xtext.tests.TestCaseAppender;

public class StandaloneTestCase
extends PivotTestCase {
    @NonNull
    protected final String inputModelName = this.getProjectFileName("models/EcoreTestFile.ecore");
    @NonNull
    protected final String inputOCLFileName = this.getProjectFileName("models/eclipse_ocl_rule.ocl");
    @NonNull
    protected final String inputOCLFileName2 = this.getProjectFileName("models/eclipse_ocl_rule_2.ocl");
    @NonNull
    protected final String textInputOCLFileName = this.getProjectFileName("models/ocl_rules.txt");

    @NonNull
    protected String getProjectFileName(String referenceName) {
        String projectName = ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/');
        URL projectURL = this.getTestResource(projectName);
        StandaloneTestCase.assertNotNull((Object)projectURL);
        URI uri = URI.createURI((String)projectURL.toString());
        String projectPath = uri.isFile() ? uri.toFileString() : uri.toString();
        projectPath = projectPath.replace("\\", "/");
        if (!projectPath.endsWith("/")) {
            projectPath = String.valueOf(projectPath) + "/";
        }
        return String.valueOf(projectPath) + referenceName;
    }

    @NonNull
    protected String getHTMLLogFileName() {
        return this.getProjectFileName("models/log_" + this.getName() + ".html");
    }

    @NonNull
    protected String getTextLogFileName() {
        return this.getProjectFileName("models/log_" + this.getName() + ".txt");
    }

    @NonNull
    protected String getLogFileName(@NonNull IValidityExporter exporter) {
        return this.getProjectFileName("models/log_" + this.getName() + "." + exporter.getPreferredExtension());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestCaseAppender.INSTANCE.uninstall();
    }
}

