/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCase;
import org.eclipse.ocl.examples.xtext.console.ColorManager;
import org.eclipse.ocl.examples.xtext.console.OCLConsole;
import org.eclipse.ocl.examples.xtext.console.OCLConsolePage;
import org.eclipse.ocl.examples.xtext.tests.TestUIUtil;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.xtext.base.ui.model.BaseDocument;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageBookViewPage;

public abstract class AbstractConsoleTests
extends PivotTestCase {
    public TestConsolePage consolePage;

    public static void assertConsoleResult(TestConsolePage consolePage, EObject contextObject, String testExpression, String expectedResult) {
        consolePage.resetDocument();
        TestUIUtil.flushEvents();
        consolePage.refreshSelection(contextObject);
        TestUIUtil.flushEvents();
        BaseDocument editorDocument = consolePage.getEditorDocument();
        editorDocument.set(testExpression);
        TestUIUtil.flushEvents();
        consolePage.evaluate(testExpression);
        TestUIUtil.flushEvents();
        String string = consolePage.get();
        AbstractConsoleTests.assertEquals((String)("<b>Evaluating:\n</b>" + testExpression + "\n<b>Results:\n</b>" + expectedResult), (String)string);
    }

    protected void doDelete(@NonNull String testProjectName) throws Exception {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            TestUIUtil.suppressGitPrefixPopUp();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(testProjectName);
            project.delete(true, true, null);
        }
    }

    @NonNull
    protected TestConsolePage openConsole() {
        TestUIUtil.closeIntro();
        TestUIUtil.flushEvents();
        TestConsole console = TestConsole.getInstance();
        IConsoleManager mgr = ConsolePlugin.getDefault().getConsoleManager();
        mgr.showConsoleView((IConsole)console);
        TestUIUtil.flushEvents();
        TestConsolePage consolePage = console.getPage();
        int i = 0;
        while (consolePage == null && i < 100000) {
            TestUIUtil.flushEvents();
            consolePage = console.getPage();
            ++i;
        }
        assert (consolePage != null);
        return consolePage;
    }

    @Override
    protected void setUp() throws Exception {
        TestUIUtil.suppressGitPrefixPopUp();
        super.setUp();
        OCLstdlib.install();
        this.consolePage = this.openConsole();
    }

    @Override
    protected void tearDown() throws Exception {
        TestUIUtil.cancelAndWaitForValidationJob();
        TestConsole.getInstance().close();
        this.consolePage = null;
        super.tearDown();
    }

    public static class TestConsole
    extends OCLConsole {
        private static TestConsole instance;
        private TestConsolePage page;

        public static TestConsole getInstance() {
            if (instance == null) {
                instance = new TestConsole();
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{instance});
            }
            return instance;
        }

        public void close() {
            super.close();
            TestUIUtil.flushEvents();
            instance = null;
        }

        public IPageBookViewPage createPage(IConsoleView view) {
            this.page = new TestConsolePage(this);
            return this.page;
        }

        public final TestConsolePage getPage() {
            return this.page;
        }

        public static /* bridge */ /* synthetic */ OCLConsole getInstance() {
            return TestConsole.getInstance();
        }
    }

    public static class TestConsolePage
    extends OCLConsolePage {
        private StringBuilder s = new StringBuilder();

        public TestConsolePage(TestConsole testConsole) {
            super((OCLConsole)testConsole);
        }

        protected void append(String text, RGB rgb, boolean bold) {
            super.append(text, rgb, bold);
            String boldTag = bold ? "b" : null;
            Object rgbTag = rgb == ColorManager.DEFAULT ? null : (rgb == ColorManager.OUTPUT_ERROR ? "error" : (rgb == ColorManager.OUTPUT_RESULTS ? null : "?"));
            if (boldTag != null) {
                this.s.append("<" + boldTag + ">");
            }
            if (rgbTag != null) {
                this.s.append("<" + (String)rgbTag + ">");
            }
            this.s.append(String.valueOf(text) + "\n");
            if (rgbTag != null) {
                this.s.append("</" + (String)rgbTag + ">");
            }
            if (boldTag != null) {
                this.s.append("</" + boldTag + ">");
            }
        }

        public boolean evaluate(String expression) {
            return super.evaluate(expression);
        }

        public String get() {
            return this.s.toString();
        }

        public ILaunch launchDebugger() {
            return this.internalLaunchDebugger();
        }

        public void refreshSelection(Object selected) {
            super.refreshSelection(selected);
        }

        public void resetDocument() {
            super.resetDocument();
            this.s = new StringBuilder();
        }
    }
}

