/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.essentialocl.scoping;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.scoping.Attribution;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.xtext.base.attributes.ImportCSAttribution;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.basecs.BaseCSPackage;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.ocl.xtext.basecs.ImportCS;
import org.eclipse.ocl.xtext.basecs.ModelElementRefCS;
import org.eclipse.ocl.xtext.basecs.PathElementCS;
import org.eclipse.ocl.xtext.basecs.PathNameCS;
import org.eclipse.ocl.xtext.basecs.SpecificationCS;
import org.eclipse.ocl.xtext.basecs.TypedTypeRefCS;
import org.eclipse.ocl.xtext.essentialocl.attributes.LetExpCSAttribution;
import org.eclipse.ocl.xtext.essentialocl.attributes.LetVariableCSAttribution;
import org.eclipse.ocl.xtext.essentialocl.attributes.NavigatingArgCSAttribution;
import org.eclipse.ocl.xtext.essentialocl.attributes.NavigationOperatorCSAttribution;
import org.eclipse.ocl.xtext.essentialocl.attributes.NavigationUtil;
import org.eclipse.ocl.xtext.essentialocl.attributes.ShadowPartCSAttribution;
import org.eclipse.ocl.xtext.essentialoclcs.EssentialOCLCSPackage;
import org.eclipse.ocl.xtext.essentialoclcs.ExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.InfixExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NameExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NavigatingArgCS;
import org.eclipse.ocl.xtext.essentialoclcs.NavigationRole;
import org.eclipse.ocl.xtext.essentialoclcs.NestedExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.OperatorExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.PrefixExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.RoundBracketedClauseCS;
import org.eclipse.ocl.xtext.essentialoclcs.TypeNameExpCS;

public class EssentialOCLScoping {
    public static void init() {
        Map registry = Attribution.REGISTRY;
        registry.put(EssentialOCLCSPackage.Literals.LET_EXP_CS, LetExpCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSPackage.Literals.LET_VARIABLE_CS, LetVariableCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSPackage.Literals.NAVIGATING_ARG_CS, NavigatingArgCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSPackage.Literals.INFIX_EXP_CS, NavigationOperatorCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSPackage.Literals.SHADOW_PART_CS, ShadowPartCSAttribution.INSTANCE);
        CS2AS.addUnresolvedProxyMessageProvider((CS2AS.UnresolvedProxyMessageProvider)new PathElementCSUnresolvedProxyMessageProvider());
    }

    private static final class PathElementCSUnresolvedProxyMessageProvider
    extends CS2AS.AbstractUnresolvedProxyMessageProvider {
        private PathElementCSUnresolvedProxyMessageProvider() {
            super(BaseCSPackage.Literals.PATH_ELEMENT_CS__REFERRED_ELEMENT);
        }

        public String getMessage(@NonNull EObject eObject, @NonNull String linkText) {
            ExpCS csSource;
            String messageTemplate;
            PathElementCS csPathElement = (PathElementCS)eObject;
            PathNameCS pathName = csPathElement.getOwningPathName();
            EList path = pathName.getOwnedPathElements();
            int index = path.indexOf(csPathElement);
            int i = 0;
            while (i < index) {
                PathElementCS csElement = (PathElementCS)path.get(i);
                Element element = csElement.basicGetReferredElement();
                if (element == null || element.eIsProxy()) {
                    return null;
                }
                ++i;
            }
            ElementCS csContext = pathName.getContext();
            if (csContext == null) {
                csContext = (ElementCS)pathName.eContainer();
            }
            assert (csContext != null);
            String argumentText = null;
            ExpCS navigationArgument = null;
            Type sourceType = null;
            if (index + 1 < path.size()) {
                messageTemplate = PivotMessagesInternal.UnresolvedNamespace_ERROR_;
            } else if (csContext instanceof NameExpCS) {
                NameExpCS csNameExp = (NameExpCS)csContext;
                navigationArgument = csNameExp;
                RoundBracketedClauseCS csRoundBracketedClause = csNameExp.getOwnedRoundBracketedClause();
                if (csRoundBracketedClause != null) {
                    argumentText = this.getOperationArguments(csRoundBracketedClause);
                    EList<NavigatingArgCS> arguments = csRoundBracketedClause.getOwnedArguments();
                    messageTemplate = arguments.size() > 0 && ((NavigatingArgCS)arguments.get(0)).getRole() == NavigationRole.ITERATOR ? PivotMessagesInternal.UnresolvedIterationCall_ERROR_ : (csNameExp.getSourceTypeValue() != null ? PivotMessagesInternal.UnresolvedStaticOperationCall_ERROR_ : PivotMessagesInternal.UnresolvedOperationCall_ERROR_);
                } else {
                    String string = messageTemplate = csNameExp.getSourceTypeValue() != null ? PivotMessagesInternal.UnresolvedStaticProperty_ERROR_ : PivotMessagesInternal.UnresolvedProperty_ERROR_;
                }
                if (csNameExp.getSourceTypeValue() != null) {
                    sourceType = csNameExp.getSourceTypeValue();
                }
            } else if (csContext instanceof TypeNameExpCS) {
                messageTemplate = PivotMessagesInternal.UnresolvedType_ERROR_;
            } else if (csContext instanceof TypedTypeRefCS) {
                messageTemplate = PivotMessagesInternal.UnresolvedType_ERROR_;
            } else if (csContext instanceof ExpCS) {
                navigationArgument = (ExpCS)csContext;
                messageTemplate = PivotMessagesInternal.UnresolvedProperty_ERROR_;
            } else {
                if (csContext instanceof ImportCS) {
                    return ImportCSAttribution.INSTANCE.getMessage((EObject)csContext, linkText);
                }
                messageTemplate = csContext instanceof ModelElementRefCS ? "Unresolved ModelElement ''{0}''" : "Unresolved ''{0}'' ''{1}''";
            }
            assert (messageTemplate != null);
            TypedElement source = null;
            ExpCS aSource = csSource = navigationArgument;
            while (aSource != null) {
                OperatorExpCS csOperator = aSource.getLocalParent();
                if (csOperator != null && csOperator.getSource() != aSource) {
                    csSource = csOperator.getSource();
                    break;
                }
                EObject eContainer = aSource.eContainer();
                if (eContainer instanceof NavigatingArgCS) {
                    aSource = ((NavigatingArgCS)eContainer).getOwningRoundBracketedClause().getOwningNameExp();
                    continue;
                }
                if (eContainer instanceof InfixExpCS) {
                    aSource = (InfixExpCS)eContainer;
                    continue;
                }
                if (eContainer instanceof PrefixExpCS) {
                    aSource = (PrefixExpCS)eContainer;
                    continue;
                }
                if (eContainer instanceof NestedExpCS) {
                    aSource = (NestedExpCS)eContainer;
                    continue;
                }
                if (!(eContainer instanceof SpecificationCS)) break;
                ExpressionInOCL expression = PivotUtil.getContainingExpressionInOCL((Element)((SpecificationCS)eContainer).getPivot());
                source = expression != null ? expression.getOwnedContext() : null;
                break;
            }
            if (source == null && csSource != null && csSource != navigationArgument) {
                source = (TypedElement)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csSource);
            }
            String typeText = "";
            if (source != null) {
                typeText = "unknown-type";
                if (sourceType == null) {
                    sourceType = source.getType();
                }
                if (sourceType != null) {
                    OperatorExpCS csParent = navigationArgument != null ? navigationArgument.getLocalParent() : null;
                    typeText = !PivotUtil.isAggregate((Type)sourceType) && NavigationUtil.isNavigationInfixExp((EObject)csParent) && csParent != null && PivotUtil.isAggregateNavigationOperator((String)((InfixExpCS)csParent).getName()) ? "Set(" + sourceType.toString() + ")" : sourceType.toString();
                }
            }
            CS2AS.MessageBinder messageBinder = CS2AS.getMessageBinder();
            String messageText = argumentText == null ? messageBinder.bind((EObject)csContext, messageTemplate, new Object[]{typeText, linkText}) : messageBinder.bind((EObject)csContext, messageTemplate, new Object[]{typeText, linkText, argumentText});
            return messageText;
        }

        public String getOperationArguments(@NonNull RoundBracketedClauseCS csRoundBracketedClause) {
            EList<NavigatingArgCS> arguments = csRoundBracketedClause.getOwnedArguments();
            StringBuilder s = new StringBuilder();
            for (NavigatingArgCS csArgument : arguments) {
                TypedElement pivot = (TypedElement)PivotUtil.getPivot(TypedElement.class, (Pivotable)csArgument);
                if (pivot != null && !pivot.eIsProxy()) {
                    if (s.length() > 0) {
                        s.append(", ");
                    }
                    Type type = pivot.getType();
                    s.append(String.valueOf(type));
                    continue;
                }
                s.append(csArgument.toString());
            }
            return s.toString();
        }
    }
}

