/*******************************************************************************
 * Copyright (c) 2011, 2015 Willink Transformations and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   E.D.Willink - Initial API and implementation
 *******************************************************************************/
package org.eclipse.ocl.pivot.evaluation;

import java.util.regex.Pattern;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.ids.IdResolver;

public interface Evaluator
{
	@NonNull Evaluator createNestedEvaluator();
	void dispose();
	@Nullable Object evaluate(@NonNull OCLExpression body);
	@NonNull CompleteEnvironment getCompleteEnvironment();

	/**
	 * Return the org.eclipse.emf.common.util.Diagnostic severity to be reported for a non-true
	 * validation resultValue given a severityPreference defined by a StatusCodes value.
	 */
	int getDiagnosticSeverity(int severityPreference, @Nullable Object resultValue);
	
	@NonNull EvaluationEnvironment getEvaluationEnvironment();
	@NonNull IdResolver getIdResolver();

	/**
	 * Return the logger handling oclLog() invocations or null for none.
	 */
	@Nullable EvaluationLogger getLogger();
	
	/**
	 * Return the manager of all model instances for use by allInstances() and hidden opposite support.
	 */
	@NonNull ModelManager getModelManager();

	/**
	 * Return a cached matcher for a give regular expression.
	 */
	@NonNull Pattern getRegexPattern(@NonNull String regex);

	/**
	 * Return the StatusCodes severity with which the validation identified by validationKey is reported.
	 * The validationKey is typically a string such as "ClassName::ConstraintName" for which static literals are
	 * available in an autogenerated *Table file as STR_Classname_c_c_ConstraintName.
	 * <p>
	 * StatusCodes.OK severity suppresses the validation altogether.
	 * <br>
	 * StatusCodes.Warning is returned for any null or unknown key.
	 */
	int getSeverity(@Nullable Object validationKey);

	@NonNull StandardLibrary getStandardLibrary();

	@NonNull org.eclipse.ocl.pivot.Class getStaticTypeOf(@Nullable Object value);
	@NonNull org.eclipse.ocl.pivot.Class getStaticTypeOf(@Nullable Object value, @NonNull Object... values);
	@NonNull org.eclipse.ocl.pivot.Class getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values);
	
	/**
	 * Return true if the evaluation has been canceled.
	 */
	boolean isCanceled();
	
	/**
	 * Request cancelation of the current the evaluation, or reset the request for a new evaluation.
	 * Cancelation occurs by throwing an {@link EvaluationHaltedException} when an expression,
	 * operation or iteration is next invoked. 
	 */
	void setCanceled(boolean isCanceled);

	/**
	 * Specify the logger to handle oclLog() invocations or null for none.
	 */
	void setLogger(@Nullable EvaluationLogger loger);
}
