/*
 * Decompiled with CFR 0.152.
 */
package dataaccess.query.util;

import dataaccess.query.FromClause;
import dataaccess.query.OqlQuery;
import dataaccess.query.QueryPackage;
import dataaccess.query.Selection;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryValidator
extends EObjectValidator {
    public static final QueryValidator INSTANCE = new QueryValidator();
    public static final String DIAGNOSTIC_SOURCE = "dataaccess.query";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String SELECTION__CONDITION_MUST_BE_SIDE_EFFECT_FREE__EEXPRESSION = "self.selectionExpr.isSideEffectFree()";
    protected static final String SELECTION__CONDITION_MUST_BE_BOOLEAN_OR_NUMERIC__EEXPRESSION = "self.selectionExpr.getType().oclIsKindOf(data::classes::ClassTypeDefinition) and\r\n (\r\n    (\r\n      self.selectionExpr.getType().oclAsType(data::classes::ClassTypeDefinition).clazz.name = 'Boolean' and\r\n      self.selectionExpr.getType().upperMultiplicity = 1\r\n    )\r\n    or\r\n    (\r\n      self.selectionExpr.getType().oclAsType(data::classes::ClassTypeDefinition).clazz.name = 'Number' \r\n      and \r\n      self.object.getType().ordered\r\n    )\r\n  )";
    protected static final String OQL_QUERY__CONDITION_MUST_BE_BOOLEAN__EEXPRESSION = "self.condition->notEmpty() implies\r\n    (self.condition.getType().oclIsKindOf(data::classes::ClassTypeDefinition) and\r\n     self.condition.getType().oclAsType(data::classes::ClassTypeDefinition).clazz.name='Boolean')";
    protected static final String OQL_QUERY__WHERE_CLAUSE_MUST_BE_SIDE_EFFECT_FREE__EEXPRESSION = "self.condition->forAll(c | c.isSideEffectFree())";
    protected static final String OQL_QUERY__HAS_VALUE_TYPE__EEXPRESSION = "self.getType().oclIsKindOf(data::classes::ClassTypeDefinition) and self.getType().oclAsType(data::classes::ClassTypeDefinition).clazz.valueType";
    protected static final String OQL_QUERY__SELECTED_ITERATORS_MUST_HAVE_CLASS_TYPE_DEFINITION_AS_TYPE__EEXPRESSION = "self.selected->forAll(i | i.getType().oclIsKindOf(data::classes::ClassTypeDefinition))";
    protected static final String FROM_CLAUSE__FROM_CLAUSES_MUST_BE_SIDE_EFFECT_FREE__EEXPRESSION = "self.fromExpression.isSideEffectFree()";

    protected EPackage getEPackage() {
        return QueryPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateSelection((Selection)value, diagnostics, context);
            }
            case 1: {
                return this.validateOqlQuery((OqlQuery)value, diagnostics, context);
            }
            case 2: {
                return this.validateFromClause((FromClause)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateSelection(Selection selection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(selection, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(selection, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(selection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(selection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(selection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(selection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(selection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(selection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(selection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSelection_ConditionMustBeSideEffectFree(selection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSelection_ConditionMustBeBooleanOrNumeric(selection, diagnostics, context);
        }
        return result;
    }

    public boolean validateSelection_ConditionMustBeSideEffectFree(Selection selection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(QueryPackage.Literals.SELECTION, selection, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ConditionMustBeSideEffectFree", SELECTION__CONDITION_MUST_BE_SIDE_EFFECT_FREE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateSelection_ConditionMustBeBooleanOrNumeric(Selection selection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(QueryPackage.Literals.SELECTION, selection, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ConditionMustBeBooleanOrNumeric", SELECTION__CONDITION_MUST_BE_BOOLEAN_OR_NUMERIC__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateOqlQuery(OqlQuery oqlQuery, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(oqlQuery, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(oqlQuery, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(oqlQuery, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(oqlQuery, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(oqlQuery, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(oqlQuery, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(oqlQuery, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(oqlQuery, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(oqlQuery, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOqlQuery_ConditionMustBeBoolean(oqlQuery, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOqlQuery_WhereClauseMustBeSideEffectFree(oqlQuery, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOqlQuery_HasValueType(oqlQuery, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOqlQuery_SelectedIteratorsMustHaveClassTypeDefinitionAsType(oqlQuery, diagnostics, context);
        }
        return result;
    }

    public boolean validateOqlQuery_ConditionMustBeBoolean(OqlQuery oqlQuery, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(QueryPackage.Literals.OQL_QUERY, oqlQuery, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ConditionMustBeBoolean", OQL_QUERY__CONDITION_MUST_BE_BOOLEAN__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateOqlQuery_WhereClauseMustBeSideEffectFree(OqlQuery oqlQuery, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(QueryPackage.Literals.OQL_QUERY, oqlQuery, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "WhereClauseMustBeSideEffectFree", OQL_QUERY__WHERE_CLAUSE_MUST_BE_SIDE_EFFECT_FREE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateOqlQuery_HasValueType(OqlQuery oqlQuery, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(QueryPackage.Literals.OQL_QUERY, oqlQuery, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "HasValueType", OQL_QUERY__HAS_VALUE_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateOqlQuery_SelectedIteratorsMustHaveClassTypeDefinitionAsType(OqlQuery oqlQuery, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(QueryPackage.Literals.OQL_QUERY, oqlQuery, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "SelectedIteratorsMustHaveClassTypeDefinitionAsType", OQL_QUERY__SELECTED_ITERATORS_MUST_HAVE_CLASS_TYPE_DEFINITION_AS_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFromClause(FromClause fromClause, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(fromClause, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(fromClause, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(fromClause, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(fromClause, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(fromClause, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(fromClause, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(fromClause, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(fromClause, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(fromClause, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFromClause_FromClausesMustBeSideEffectFree(fromClause, diagnostics, context);
        }
        return result;
    }

    public boolean validateFromClause_FromClausesMustBeSideEffectFree(FromClause fromClause, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(QueryPackage.Literals.FROM_CLAUSE, fromClause, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "FromClausesMustBeSideEffectFree", FROM_CLAUSE__FROM_CLAUSES_MUST_BE_SIDE_EFFECT_FREE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

