/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.tests;

import junit.framework.TestCase;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.eventmanager.EventManager;
import org.eclipse.ocl.examples.eventmanager.EventManagerFactory;
import org.eclipse.ocl.examples.eventmanager.tests.EventManagerTest;

public class LogicalFilterTest
extends TestCase {
    private EventManager fixture;
    private EventManagerTest.Application app;
    private EClass eClass1;
    private EventFilter featureFilterRef;
    private DynamicEObjectImpl eObjectCls1;
    private EClass eClass2;
    private DynamicEObjectImpl eObjectCls2;
    private EClass eClass3;
    private DynamicEObjectImpl eObjectCls3;
    private EClass eClass4;
    private DynamicEObjectImpl eObjectCls4;
    private EReference ref;
    private EventFilter typeFilterAdd;
    private EventFilter classFilterCls1;
    private EventFilter oldValueFilterCls2;
    private EventFilter newValueFilterCls2;
    private EventFilter newValueFilterCls3;
    private EventFilter newValueFilterWithSubclassesCls3;
    private EventFilter newValueFilterWithSubclassesCls4;

    public void setUp() throws Exception {
        this.fixture = EventManagerFactory.eINSTANCE.createEventManager();
        this.app = new EventManagerTest.Application();
        this.eClass1 = EcoreFactory.eINSTANCE.createEClass();
        this.eClass1.setName("c1");
        this.eObjectCls1 = new DynamicEObjectImpl(this.eClass1);
        this.eClass2 = EcoreFactory.eINSTANCE.createEClass();
        this.eClass2.setName("c2");
        this.eObjectCls2 = new DynamicEObjectImpl(this.eClass2);
        this.eClass3 = EcoreFactory.eINSTANCE.createEClass();
        this.eClass3.setName("c3");
        this.eObjectCls3 = new DynamicEObjectImpl(this.eClass3);
        this.eClass4 = EcoreFactory.eINSTANCE.createEClass();
        this.eClass4.setName("c4");
        this.eClass4.getESuperTypes().add((Object)this.eClass3);
        this.eObjectCls4 = new DynamicEObjectImpl(this.eClass4);
        this.ref = EcoreFactory.eINSTANCE.createEReference();
        this.typeFilterAdd = EventManagerFactory.eINSTANCE.createEventTypeFilter(3);
        this.classFilterCls1 = EventManagerFactory.eINSTANCE.createClassFilter(this.eClass1);
        this.oldValueFilterCls2 = EventManagerFactory.eINSTANCE.createOldValueClassFilter(this.eClass2);
        this.newValueFilterCls2 = EventManagerFactory.eINSTANCE.createNewValueClassFilter(this.eClass2);
        this.newValueFilterCls3 = EventManagerFactory.eINSTANCE.createNewValueClassFilter(this.eClass3);
        this.newValueFilterWithSubclassesCls3 = EventManagerFactory.eINSTANCE.createNewValueClassFilterIncludingSubclasses(this.eClass3);
        this.newValueFilterWithSubclassesCls4 = EventManagerFactory.eINSTANCE.createNewValueClassFilterIncludingSubclasses(this.eClass4);
        this.featureFilterRef = EventManagerFactory.eINSTANCE.createStructuralFeatureFilter((EStructuralFeature)this.ref);
    }

    public void tearDown() throws Exception {
        this.fixture.unsubscribe((Adapter)this.app);
        this.fixture = null;
        this.app = null;
    }

    public void testMatchingAndWithSameFilterTypeOnSameElementOfMultiNewValue() {
        BasicEList newValue = new BasicEList();
        newValue.add((Object)this.eObjectCls3);
        newValue.add((Object)this.eObjectCls4);
        ENotificationImpl n = new ENotificationImpl((InternalEObject)this.eObjectCls1, 5, (EStructuralFeature)this.ref, null, (Object)newValue);
        EventFilter f = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.newValueFilterWithSubclassesCls3, this.newValueFilterWithSubclassesCls4});
        LogicalFilterTest.assertTrue((boolean)f.matchesFor((Notification)n));
        this.fixture.subscribe(f, (Adapter)this.app);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
    }

    public void testMatchingAndWithSameFilterTypeOnDifferentElementsOfMultiNewValue() {
        BasicEList newValue = new BasicEList();
        newValue.add((Object)this.eObjectCls2);
        newValue.add((Object)this.eObjectCls3);
        ENotificationImpl n = new ENotificationImpl((InternalEObject)this.eObjectCls1, 5, (EStructuralFeature)this.ref, null, (Object)newValue);
        EventFilter f = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.newValueFilterCls2, this.newValueFilterCls3});
        LogicalFilterTest.assertTrue((boolean)f.matchesFor((Notification)n));
        this.fixture.subscribe(f, (Adapter)this.app);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
    }

    public void testSimpleAndFilter1Stage() {
        ENotificationImpl n = new ENotificationImpl((InternalEObject)this.eObjectCls1, 3, (EStructuralFeature)this.ref, (Object)this.eObjectCls2, (Object)this.eObjectCls3);
        EventFilter f = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.typeFilterAdd, this.classFilterCls1, this.oldValueFilterCls2, this.newValueFilterCls3, this.featureFilterRef});
        this.fixture.subscribe(f, (Adapter)this.app);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
    }

    public void testSimpleAndFilter3Stage() {
        ENotificationImpl n = new ENotificationImpl((InternalEObject)this.eObjectCls1, 3, (EStructuralFeature)this.ref, (Object)this.eObjectCls2, (Object)this.eObjectCls3);
        EventFilter f7 = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.typeFilterAdd, this.classFilterCls1}), EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.oldValueFilterCls2, EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.newValueFilterCls3, this.featureFilterRef})})});
        this.fixture.subscribe(f7, (Adapter)this.app);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
    }

    public void testSimpleOrFilter1Stage1() {
        ENotificationImpl n = new ENotificationImpl((InternalEObject)this.eObjectCls1, 0, null, null, null);
        EventFilter f = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.typeFilterAdd, this.classFilterCls1, this.oldValueFilterCls2, this.newValueFilterCls3, this.featureFilterRef});
        this.fixture.subscribe(f, (Adapter)this.app);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
    }

    public void testSimpleOrFilter1Stage2() {
        ENotificationImpl n = new ENotificationImpl(null, 3, null, null, null);
        EventFilter f = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.typeFilterAdd, this.classFilterCls1, this.oldValueFilterCls2, this.newValueFilterCls3, this.featureFilterRef});
        this.fixture.subscribe(f, (Adapter)this.app);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
    }

    public void testSimpleOrFilter1Stage3() {
        ENotificationImpl n = new ENotificationImpl(null, 0, null, (Object)this.eObjectCls2, null);
        EventFilter f = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.typeFilterAdd, this.classFilterCls1, this.oldValueFilterCls2, this.newValueFilterCls3, this.featureFilterRef});
        this.fixture.subscribe(f, (Adapter)this.app);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
    }

    public void testSimpleOrFilter1Stage4() {
        ENotificationImpl n = new ENotificationImpl(null, 0, null, null, (Object)this.eObjectCls3);
        EventFilter f = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.typeFilterAdd, this.classFilterCls1, this.oldValueFilterCls2, this.newValueFilterCls3, this.featureFilterRef});
        this.fixture.subscribe(f, (Adapter)this.app);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
    }

    public void testSimpleOrFilter1Stage5() {
        ENotificationImpl n = new ENotificationImpl(null, 0, null, null, null);
        EventFilter f = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.typeFilterAdd, this.classFilterCls1, this.oldValueFilterCls2, this.newValueFilterCls3, this.featureFilterRef});
        this.fixture.subscribe(f, (Adapter)this.app);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertFalse((String)"Get notified", (boolean)this.app.isNotified());
    }

    public void testSimpleOrFilter2Stage1() {
        ENotificationImpl n = new ENotificationImpl(null, 0, null, null, (Object)this.eObjectCls3);
        EventFilter f = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.typeFilterAdd, this.classFilterCls1}), EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.oldValueFilterCls2, this.newValueFilterCls3}), this.featureFilterRef})});
        this.fixture.subscribe(f, (Adapter)this.app);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
    }

    public void testSimpleOrFilter2Stage2() {
        ENotificationImpl n = new ENotificationImpl(null, 0, null, null, null);
        EventFilter f = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.typeFilterAdd, this.classFilterCls1}), EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.oldValueFilterCls2, this.newValueFilterCls3}), this.featureFilterRef})});
        this.fixture.subscribe(f, (Adapter)this.app);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertFalse((String)"Get notified", (boolean)this.app.isNotified());
    }

    public void testSimpleOrFilter2StageAndNot1() {
        ENotificationImpl n = new ENotificationImpl(null, 0, null, null, (Object)this.eObjectCls3);
        EventFilter f = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.typeFilterAdd, this.classFilterCls1}), EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.oldValueFilterCls2, EventManagerFactory.eINSTANCE.createNotFilter(this.newValueFilterCls3)}), this.featureFilterRef})});
        this.fixture.subscribe(f, (Adapter)this.app);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertFalse((String)"Get notified", (boolean)this.app.isNotified());
    }

    public void testSimpleOrFilter2StageAndNot2() {
        ENotificationImpl n = new ENotificationImpl(null, 0, null, null, (Object)this.eObjectCls3);
        EventFilter f = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.typeFilterAdd, this.classFilterCls1}), EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.oldValueFilterCls2, EventManagerFactory.eINSTANCE.createNotFilter(this.newValueFilterCls3)}), this.featureFilterRef})});
        f = EventManagerFactory.eINSTANCE.createNotFilter(f);
        this.fixture.subscribe(f, (Adapter)this.app);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertTrue((String)"Get not  notified", (boolean)this.app.isNotified());
    }

    public void testSimpleOrFilter2StageDoubleNot() {
        ENotificationImpl n = new ENotificationImpl(null, 0, null, null, (Object)this.eObjectCls3);
        EventFilter f = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.typeFilterAdd, this.classFilterCls1}), EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.oldValueFilterCls2, EventManagerFactory.eINSTANCE.createNotFilter(this.newValueFilterCls3)}), this.featureFilterRef})});
        f = EventManagerFactory.eINSTANCE.createNotFilter(f);
        f = EventManagerFactory.eINSTANCE.createNotFilter(f);
        this.fixture.subscribe(f, (Adapter)this.app);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertFalse((String)"Get notified", (boolean)this.app.isNotified());
    }

    public void testDeMorgan1() {
        EventFilter f = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createNotFilter(EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.newValueFilterCls3, this.oldValueFilterCls2})), EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createNotFilter(this.newValueFilterCls3), EventManagerFactory.eINSTANCE.createNotFilter(this.oldValueFilterCls2)})});
        f = EventManagerFactory.eINSTANCE.createNotFilter(f);
        this.fixture.subscribe(f, (Adapter)this.app);
        ENotificationImpl n = new ENotificationImpl(null, 0, null, null, (Object)this.eObjectCls3);
        this.fixture.handleEMFEvent((Notification)n);
        ENotificationImpl n3 = new ENotificationImpl(null, 0, null, (Object)this.eObjectCls2, null);
        this.fixture.handleEMFEvent((Notification)n3);
        LogicalFilterTest.assertFalse((String)"Get notified", (boolean)this.app.isNotified());
        ENotificationImpl n4 = new ENotificationImpl(null, 0, null, (Object)this.eObjectCls2, (Object)this.eObjectCls3);
        this.fixture.handleEMFEvent((Notification)n4);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
    }

    public void testDeMorgan2() {
        EventFilter f = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createNotFilter(EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.newValueFilterCls3, this.oldValueFilterCls2})), EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createNotFilter(this.newValueFilterCls3), EventManagerFactory.eINSTANCE.createNotFilter(this.oldValueFilterCls2)})});
        this.fixture.subscribe(f, (Adapter)this.app);
        ENotificationImpl n = new ENotificationImpl(null, 0, null, null, (Object)this.eObjectCls3);
        this.fixture.handleEMFEvent((Notification)n);
        ENotificationImpl n3 = new ENotificationImpl(null, 0, null, (Object)this.eObjectCls2, null);
        this.fixture.handleEMFEvent((Notification)n3);
        ENotificationImpl n4 = new ENotificationImpl(null, 0, null, (Object)this.eObjectCls2, (Object)this.eObjectCls3);
        this.fixture.handleEMFEvent((Notification)n4);
        LogicalFilterTest.assertFalse((String)"Get notified", (boolean)this.app.isNotified());
        ENotificationImpl n5 = new ENotificationImpl(null, 0, null, null, null);
        this.fixture.handleEMFEvent((Notification)n5);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
    }

    public void testDeMorganTautology() {
        EventFilter f = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.newValueFilterCls3, this.oldValueFilterCls2}), EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createNotFilter(this.newValueFilterCls3), EventManagerFactory.eINSTANCE.createNotFilter(this.oldValueFilterCls2)})});
        this.fixture.subscribe(f, (Adapter)this.app);
        ENotificationImpl n = new ENotificationImpl(null, 0, null, null, (Object)this.eObjectCls3);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
        this.app.reset();
        ENotificationImpl n3 = new ENotificationImpl(null, 0, null, (Object)this.eObjectCls2, null);
        this.fixture.handleEMFEvent((Notification)n3);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
        this.app.reset();
        ENotificationImpl n4 = new ENotificationImpl(null, 0, null, (Object)this.eObjectCls2, (Object)this.eObjectCls3);
        this.fixture.handleEMFEvent((Notification)n4);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
        this.app.reset();
        ENotificationImpl n5 = new ENotificationImpl(null, 0, null, null, null);
        this.fixture.handleEMFEvent((Notification)n5);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
    }

    public void testPriorityOfNegatedFilters() {
        EventFilter f = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.classFilterCls1, EventManagerFactory.eINSTANCE.createNotFilter(this.newValueFilterCls3)});
        this.fixture.subscribe(f, (Adapter)this.app);
        ENotificationImpl n = new ENotificationImpl(null, 0, null, null, (Object)this.eObjectCls3);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertFalse((String)"Erroneously got notified", (boolean)this.app.isNotified());
        this.app.reset();
        ENotificationImpl n2 = new ENotificationImpl((InternalEObject)this.eObjectCls1, 0, null, null, (Object)this.eObjectCls2);
        this.fixture.handleEMFEvent((Notification)n2);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
        this.app.reset();
        ENotificationImpl n3 = new ENotificationImpl((InternalEObject)this.eObjectCls1, 0, null, null, (Object)this.eObjectCls3);
        this.fixture.handleEMFEvent((Notification)n3);
        LogicalFilterTest.assertFalse((String)"Erroneously got notified", (boolean)this.app.isNotified());
        this.app.reset();
        ENotificationImpl n4 = new ENotificationImpl(null, 0, null, null, null);
        this.fixture.handleEMFEvent((Notification)n4);
        LogicalFilterTest.assertFalse((String)"Erroneously got notified", (boolean)this.app.isNotified());
    }

    public void testPriorityOfNegatedFiltersReversed() {
        EventFilter f = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createNotFilter(this.classFilterCls1), this.newValueFilterCls3});
        this.fixture.subscribe(f, (Adapter)this.app);
        ENotificationImpl n = new ENotificationImpl(null, 0, null, null, (Object)this.eObjectCls3);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertTrue((String)"Did not get notified", (boolean)this.app.isNotified());
        this.app.reset();
        ENotificationImpl n2 = new ENotificationImpl((InternalEObject)this.eObjectCls1, 0, null, null, (Object)this.eObjectCls2);
        this.fixture.handleEMFEvent((Notification)n2);
        LogicalFilterTest.assertFalse((String)"Erroneously got notified", (boolean)this.app.isNotified());
        this.app.reset();
        ENotificationImpl n3 = new ENotificationImpl((InternalEObject)this.eObjectCls1, 0, null, null, (Object)this.eObjectCls3);
        this.fixture.handleEMFEvent((Notification)n3);
        LogicalFilterTest.assertFalse((String)"Erroneously got notified", (boolean)this.app.isNotified());
        this.app.reset();
        ENotificationImpl n4 = new ENotificationImpl(null, 0, null, null, null);
        this.fixture.handleEMFEvent((Notification)n4);
        LogicalFilterTest.assertFalse((String)"Erroneously got notified", (boolean)this.app.isNotified());
    }

    public void testAndForSameFilterType() {
        EventFilter f = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createClassFilter(this.eClass1), EventManagerFactory.eINSTANCE.createClassFilter(this.eClass2)});
        this.fixture.subscribe(f, (Adapter)this.app);
        ENotificationImpl n = new ENotificationImpl((InternalEObject)this.eObjectCls1, 0, null, null, null);
        this.fixture.handleEMFEvent((Notification)n);
        LogicalFilterTest.assertFalse((String)"Erroneously got notified", (boolean)this.app.isNotified());
        this.app.reset();
        ENotificationImpl n3 = new ENotificationImpl((InternalEObject)this.eObjectCls2, 0, null, null, null);
        this.fixture.handleEMFEvent((Notification)n3);
        LogicalFilterTest.assertFalse((String)"Erroneously got notified", (boolean)this.app.isNotified());
        this.app.reset();
        ENotificationImpl n6 = new ENotificationImpl(null, 0, null, null, null);
        this.fixture.handleEMFEvent((Notification)n6);
        LogicalFilterTest.assertFalse((String)"Erroneously got notified", (boolean)this.app.isNotified());
    }

    public void testSimpleContradiction() {
        EventFilter f = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.newValueFilterCls3, EventManagerFactory.eINSTANCE.createNotFilter(this.newValueFilterCls3)});
        this.fixture.subscribe(f, (Adapter)this.app);
        ENotificationImpl n3 = new ENotificationImpl(null, 0, null, null, (Object)this.eObjectCls2);
        this.fixture.handleEMFEvent((Notification)n3);
        LogicalFilterTest.assertFalse((String)"Erroneously got notified", (boolean)this.app.isNotified());
        this.app.reset();
        ENotificationImpl n6 = new ENotificationImpl(null, 0, null, null, (Object)this.eObjectCls3);
        this.fixture.handleEMFEvent((Notification)n6);
        LogicalFilterTest.assertFalse((String)"Erroneously got notified", (boolean)this.app.isNotified());
    }

    public void testDeMorganContradiction() {
        EventFilter f = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.newValueFilterCls3, this.oldValueFilterCls2}), EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createNotFilter(this.newValueFilterCls3), EventManagerFactory.eINSTANCE.createNotFilter(this.oldValueFilterCls2)})});
        this.fixture.subscribe(f, (Adapter)this.app);
        ENotificationImpl n3 = new ENotificationImpl(null, 0, null, (Object)this.eObjectCls2, null);
        this.fixture.handleEMFEvent((Notification)n3);
        LogicalFilterTest.assertFalse((String)"Erroneously got notified", (boolean)this.app.isNotified());
        this.app.reset();
        ENotificationImpl n4 = new ENotificationImpl(null, 0, null, (Object)this.eObjectCls2, (Object)this.eObjectCls3);
        this.fixture.handleEMFEvent((Notification)n4);
        LogicalFilterTest.assertFalse((String)"Erroneously got notified", (boolean)this.app.isNotified());
        this.app.reset();
        ENotificationImpl n5 = new ENotificationImpl(null, 0, null, (Object)this.eObjectCls3, (Object)this.eObjectCls2);
        this.fixture.handleEMFEvent((Notification)n5);
        LogicalFilterTest.assertFalse((String)"Erroneously got notified", (boolean)this.app.isNotified());
        this.app.reset();
        ENotificationImpl n6 = new ENotificationImpl(null, 0, null, null, null);
        this.fixture.handleEMFEvent((Notification)n6);
        LogicalFilterTest.assertFalse((String)"Erroneously got notified", (boolean)this.app.isNotified());
    }

    public void testDisjunctiveConversion() {
        EventFilter f = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createNotFilter(EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{this.newValueFilterCls3, this.oldValueFilterCls2})), this.newValueFilterCls3});
        this.fixture.subscribe(f, (Adapter)this.app);
        boolean notNotfied = false;
        ENotificationImpl n = new ENotificationImpl(null, 0, null, null, (Object)this.eObjectCls3);
        this.fixture.handleEMFEvent((Notification)n);
        notNotfied = notNotfied || !this.app.isNotified();
        ENotificationImpl n3 = new ENotificationImpl(null, 0, null, (Object)this.eObjectCls2, null);
        this.fixture.handleEMFEvent((Notification)n3);
        notNotfied = notNotfied || !this.app.isNotified();
        ENotificationImpl n4 = new ENotificationImpl(null, 0, null, null, null);
        this.fixture.handleEMFEvent((Notification)n4);
        notNotfied = notNotfied || !this.app.isNotified();
        LogicalFilterTest.assertFalse((String)"Did not get notified", (boolean)notNotfied);
    }
}

