/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.EValidatorRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCase;
import org.eclipse.ocl.examples.xtext.tests.TestCaseAppender;
import org.eclipse.ocl.pivot.internal.utilities.GlobalEnvironmentFactory;
import org.eclipse.ocl.pivot.internal.utilities.PivotDiagnostician;
import org.eclipse.ocl.pivot.internal.values.BagImpl;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.internal.validation.UMLOCLEValidator;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.values.Bag;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class AbstractValidateTests
extends PivotTestCase {
    @NonNull
    public static final String VIOLATED_TEMPLATE = "The ''{0}'' constraint is violated on ''{1}''";

    @NonNull
    public static List<Diagnostic> assertUMLOCLValidationDiagnostics(@Nullable OCL ocl, @NonNull String prefix, @NonNull Resource resource, String ... messages) {
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        if (ocl != null) {
            PivotDiagnostician.setOCL((Map)validationContext, (OCL)ocl);
        }
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (EObject eObject : resource.getContents()) {
            EValidatorRegistryImpl registry = new EValidatorRegistryImpl();
            registry.put((Object)UMLPackage.eINSTANCE, (Object)UMLOCLEValidator.INSTANCE);
            Diagnostician dignostician = new Diagnostician((EValidator.Registry)registry);
            Diagnostic diagnostic = dignostician.validate(eObject, validationContext);
            diagnostics.addAll(diagnostic.getChildren());
        }
        return AbstractValidateTests.assertDiagnostics(prefix, diagnostics, messages);
    }

    public static void checkValidationDiagnostics(EObject testInstance, int severity, String ... expectedMessage) {
        BagImpl expectedMessages = new BagImpl();
        String[] stringArray = expectedMessage;
        int n = expectedMessage.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            expectedMessages.add((Object)message);
            ++n2;
        }
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        Diagnostic diagnostics = Diagnostician.INSTANCE.validate(testInstance, validationContext);
        BagImpl actualMessages = new BagImpl();
        for (Diagnostic diagnostic : diagnostics.getChildren()) {
            AbstractValidateTests.assertEquals((int)severity, (int)diagnostic.getSeverity());
            actualMessages.add((Object)diagnostic.getMessage());
        }
        String s = AbstractValidateTests.formatMessageDifferences((Bag<String>)expectedMessages, (Bag<String>)actualMessages);
        if (s != null) {
            AbstractValidateTests.fail((String)("Inconsistent validation: (expected/actual) message" + s));
        }
    }

    @NonNull
    protected OCL createOCL() {
        OCL ocl = OCL.newInstance((ProjectManager)OCL.NO_PROJECTS);
        return ocl;
    }

    public Resource doLoadOCLinEcore(OCL ocl, String stem) throws IOException {
        String inputName = String.valueOf(stem) + ".oclinecore";
        String ecoreName = String.valueOf(stem) + ".ecore";
        URI inputURI = this.getProjectFileURI(inputName);
        URI ecoreURI = this.getProjectFileURI(ecoreName);
        CSResource xtextResource = ocl.getCSResource(inputURI);
        AbstractValidateTests.assertNoResourceErrors("Load failed", (Resource)xtextResource);
        ASResource asResource = ocl.cs2as(xtextResource);
        AbstractValidateTests.assertNoUnresolvedProxies("Unresolved proxies", (Resource)xtextResource);
        AbstractValidateTests.assertNoValidationErrors("Pivot validation errors", (EObject)asResource.getModel());
        Resource ecoreResource = AbstractValidateTests.as2ecore(ocl, (Resource)asResource, ecoreURI, true);
        return ecoreResource;
    }

    public Resource doLoadUML(OCL ocl, String stem) throws IOException {
        String umlName = String.valueOf(stem) + ".uml";
        URI umlURI = this.getProjectFileURI(umlName);
        return ocl.getResourceSet().getResource(umlURI, true);
    }

    @NonNull
    public List<Diagnostic> doValidateOCLinEcore(OCL ocl, String stem, String ... validationDiagnostics) throws IOException {
        String inputName = String.valueOf(stem) + ".oclinecore";
        URI inputURI = this.getProjectFileURI(inputName);
        BaseCSResource xtextResource = (BaseCSResource)ocl.getResourceSet().createResource(inputURI);
        assert (xtextResource != null);
        ocl.getEnvironmentFactory().adapt((Notifier)xtextResource);
        xtextResource.load(null);
        AbstractValidateTests.assertNoResourceErrors("Load failed", (Resource)xtextResource);
        ASResource asResource = ocl.cs2as((CSResource)xtextResource);
        AbstractValidateTests.assertNoUnresolvedProxies("Unresolved proxies", (Resource)xtextResource);
        return AbstractValidateTests.assertValidationDiagnostics("Pivot validation errors", (Resource)asResource, validationDiagnostics);
    }

    protected EObject eCreate(EPackage ePackage, String className) {
        EClass eClass = (EClass)ePackage.getEClassifier(className);
        EFactory eFactoryInstance = ePackage.getEFactoryInstance();
        return eFactoryInstance.create(eClass);
    }

    protected void eSet(EObject eObject, String eFeatureName, Object value) {
        EClass eClass = eObject.eClass();
        EStructuralFeature eFeature = eClass.getEStructuralFeature(eFeatureName);
        assert (eFeature != null);
        eObject.eSet(eFeature, value);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestCaseAppender.INSTANCE.install();
        AbstractValidateTests.doCompleteOCLSetup();
        AbstractValidateTests.doOCLinEcoreSetup();
        AbstractValidateTests.doOCLstdlibSetup();
    }

    @Override
    protected void tearDown() throws Exception {
        GlobalEnvironmentFactory.disposeInstance();
        super.tearDown();
    }
}

