/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EvaluateUMLTest4
extends PivotTestSuite {
    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false}};
        return Arrays.asList(data);
    }

    public EvaluateUMLTest4(boolean useCodeGen) {
        super(useCodeGen);
    }

    @Override
    @NonNull
    protected MyOCL createOCL() {
        return new MyOCL(this.getTestPackageName(), this.getName());
    }

    @Override
    @NonNull
    protected String getTestPackageName() {
        return "EvaluateUML";
    }

    @BeforeClass
    public static void resetCounter() throws Exception {
        PivotTestSuite.resetCounter();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void test_oclIsInState() throws InvocationTargetException, ParserException {
        UMLStandaloneSetup.init();
        MyOCL ocl = this.createOCL();
        ocl.initStateMachinePackage(this.getTestModelURI("model/StateMachines.uml"));
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        EObject context = ocl.statefulEFactory.create(ocl.c1Class);
        Class contextType = (Class)metamodelManager.getASOfEcore(Class.class, (EObject)ocl.c1Class);
        assert (contextType != null);
        ocl.assertSemanticErrorQuery(contextType, "self.oclIsInState(S2b)", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Model::C1", "S2b");
        ocl.assertQueryInvalid(context, "self.oclIsInState(S1a)", StringUtil.bind((String)PivotMessagesInternal.FailedToEvaluate_ERROR_, (Object[])new Object[]{"OclAny::oclIsInState(OclState[?]) : Boolean[1]", "C1", "self.oclIsInState(null)"}), UnsupportedOperationException.class);
        ocl.dispose();
    }

    public EObject doLoadUML(OCL ocl, String stem, String fragment) throws IOException {
        String umlName = String.valueOf(stem) + ".uml";
        URI umlURI = this.getProjectFileURI(umlName).appendFragment(fragment);
        return ocl.getResourceSet().getEObject(umlURI, true);
    }

    @Test
    public void test_stereotypes_Bug431638() throws Exception {
        MyOCL ocl = this.createOCL();
        IdResolver idResolver = ocl.getIdResolver();
        EObject context = this.doLoadUML((OCL)ocl, "Bug431638", "Bug431638Model.Class1.Attribute1");
        EvaluateUMLTest4.assertNotNull((Object)context);
        Class contextType = idResolver.getStaticTypeOf((Object)context);
        Package contextPackage = contextType.getOwningPackage();
        EvaluateUMLTest4.assertEquals((String)"$uml$", (String)contextPackage.getPackageId().getDisplayName());
        ocl.assertValidQuery(contextType, "self.extension_vStereotype1");
        ocl.assertSemanticErrorQuery(contextType, "self.extension_Stereotype1", PivotMessagesInternal.UnresolvedProperty_ERROR_, "UML::Property", "extension_Stereotype1");
        ocl.assertValidQuery(contextType, "self.extension_vStereotype1.base_NamedElement");
        ocl.assertSemanticErrorQuery(contextType, "self.extension_vStereotype1.base_Class", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Bug431638Profile::vStereotype1", "base_Class");
        ocl.assertSemanticErrorQuery(contextType, "self.extension_vStereotype1.string", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Bug431638Profile::vStereotype1", "string");
        ocl.assertValidQuery(contextType, "self.extension_vStereotype1.oclAsType(Bug431638Profile::Stereotype1).string");
        ocl.assertQueryEquals(context, "overrideValue", "self.extension_vStereotype1.oclAsType(Bug431638Profile::Stereotype1).string");
        ocl.assertSemanticErrorQuery(contextType, "self.extension_vStereotype1.base_Class = self.oclType()", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Bug431638Profile::vStereotype1", "base_Class");
        ocl.dispose();
    }

    @Test
    public void test_enumerations_Bug455394() throws Exception {
        UMLStandaloneSetup.init();
        MyOCL ocl = this.createOCL();
        IdResolver idResolver = ocl.getIdResolver();
        EObject context = this.doLoadUML((OCL)ocl, "Bug455394", "Model.Class1.class2");
        EvaluateUMLTest4.assertNotNull((Object)context);
        Class contextType = idResolver.getStaticTypeOf((Object)context);
        ocl.assertQueryTrue(context, "self.aggregation=UML::AggregationKind::composite");
        ocl.assertQueryResults(context, "UML::AggregationKind::composite", "self.aggregation");
        EObject associationContext = this.doLoadUML((OCL)ocl, "Bug455394", "Model.A_class2_class1");
        CollectionTypeId collectionTypeId = TypeId.ORDERED_SET.getSpecializedId(new ElementId[]{contextType.getTypeId()});
        ocl.assertQueryEquals(associationContext, idResolver.createOrderedSetOfEach(collectionTypeId, new Object[]{context}), "self.memberEnd?->select(e|e.aggregation=AggregationKind::composite)");
        ocl.dispose();
    }

    public static class MyOCL
    extends TestOCL {
        EPackage statefulEPackage;
        EFactory statefulEFactory;
        EClass c1Class;

        public MyOCL(@NonNull String testPackageName, @NonNull String name) {
            super(testPackageName, name, (ProjectManager)(useCodeGen ? EvaluateUMLTest4.getProjectMap() : OCL.NO_PROJECTS));
            MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
            Package asMetamodel = metamodelManager.getASmetamodel();
            if (asMetamodel != null) {
                metamodelManager.addGlobalNamespace("ocl", (Namespace)asMetamodel);
            }
        }

        protected Resource getPivotFromUML(@NonNull MetamodelManagerInternal metamodelManager, Resource umlResource) throws ParserException {
            UML2AS uml2as = UML2AS.getAdapter((Resource)umlResource, (EnvironmentFactoryInternal)metamodelManager.getEnvironmentFactory());
            Model pivotModel = uml2as.getASModel();
            Resource asResource = pivotModel.eResource();
            EvaluateUMLTest4.assertNoResourceErrors("Normalisation failed", asResource);
            EvaluateUMLTest4.assertNoValidationErrors("Normalisation invalid", asResource);
            return asResource;
        }

        protected Resource initStateMachinePackage(URI uri) throws ParserException {
            UMLStandaloneSetup.init();
            MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
            ResourceSet resourceSet2 = this.getResourceSet();
            assert (resourceSet2 != null);
            UML2AS.initialize((ResourceSet)resourceSet2);
            Resource umlResource = resourceSet2.getResource(uri, true);
            EList contents = umlResource.getContents();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ECORE_TAGGED_VALUES", "PROCESS");
            options.put("REDEFINING_OPERATIONS", "PROCESS");
            options.put("REDEFINING_PROPERTIES", "PROCESS");
            options.put("SUBSETTING_PROPERTIES", "PROCESS");
            options.put("UNION_PROPERTIES", "PROCESS");
            options.put("DERIVED_FEATURES", "PROCESS");
            options.put("DUPLICATE_OPERATIONS", "PROCESS");
            options.put("DUPLICATE_OPERATION_INHERITANCE", "PROCESS");
            options.put("DUPLICATE_FEATURES", "PROCESS");
            options.put("DUPLICATE_FEATURE_INHERITANCE", "PROCESS");
            options.put("SUPER_CLASS_ORDER", "PROCESS");
            options.put("ANNOTATION_DETAILS", "PROCESS");
            options.put("INVARIANT_CONSTRAINTS", "PROCESS");
            options.put("OPERATION_BODIES", "PROCESS");
            options.put("COMMENTS", "PROCESS");
            UMLUtil.UML2EcoreConverter uml2EcoreConverter = new UMLUtil.UML2EcoreConverter();
            Collection ecoreContents = uml2EcoreConverter.convert((Collection)contents, options, null, null);
            Resource ecoreResource = resourceSet2.createResource(URI.createURI((String)"StateMachines.ecore"));
            ecoreResource.getContents().addAll(ecoreContents);
            this.statefulEPackage = (EPackage)ecoreResource.getContents().get(0);
            this.statefulEFactory = this.statefulEPackage.getEFactoryInstance();
            this.c1Class = (EClass)this.statefulEPackage.getEClassifier("C1");
            Resource asResource = this.getPivotFromUML(metamodelManager, umlResource);
            return asResource;
        }
    }
}

