/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.internal.delegate.OCLValidationDelegateMapping;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.internal.delegate.ValidationDelegate;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.GlobalEnvironmentFactory;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.PivotStandaloneSetup;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.Bag;
import org.eclipse.ocl.pivot.values.Value;
import org.eclipse.ocl.xtext.base.BaseStandaloneSetup;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.completeocl.CompleteOCLRuntimeModule;
import org.eclipse.ocl.xtext.completeocl.CompleteOCLStandaloneSetup;
import org.eclipse.ocl.xtext.essentialocl.EssentialOCLRuntimeModule;
import org.eclipse.ocl.xtext.essentialocl.EssentialOCLStandaloneSetup;
import org.eclipse.ocl.xtext.essentialocl.utilities.EssentialOCLCSResource;
import org.eclipse.ocl.xtext.markup.MarkupStandaloneSetup;
import org.eclipse.ocl.xtext.oclinecore.OCLinEcoreRuntimeModule;
import org.eclipse.ocl.xtext.oclinecore.OCLinEcoreStandaloneSetup;
import org.eclipse.ocl.xtext.oclstdlib.OCLstdlibRuntimeModule;
import org.eclipse.ocl.xtext.oclstdlib.OCLstdlibStandaloneSetup;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.junit.Rule;
import org.junit.rules.TestName;

public class PivotTestCase
extends TestCase {
    @NonNull
    public static final String PLUGIN_ID = "org.eclipse.ocl.examples.xtext.tests";
    private static Writer testLog = null;
    public static boolean DEBUG_GC = false;
    public static boolean DEBUG_ID = false;
    @Rule
    public TestName testName = new TestName();
    private GlobalStateMemento makeCopyOfGlobalState = null;

    public static void appendLog(String name, Object context, String testExpression, String parseVerdict, String evaluationVerdict, String evaluationTolerance) {
        if (testLog != null) {
            try {
                testLog.append("\"" + name.replace("\"", "\"\"") + "\"");
                testLog.append(";");
                try {
                    URI contextURI;
                    if (context instanceof EObject && (contextURI = EcoreUtil.getURI((EObject)((EObject)context))) != null) {
                        testLog.append("\"" + contextURI.toString().replace("\"", "\"\"") + "\"");
                    }
                }
                catch (Throwable e) {
                    testLog.append("\"null\"");
                }
                testLog.append(";");
                if (testExpression != null) {
                    testLog.append("\"" + StringUtil.convertToOCLString((String)testExpression) + "\"");
                }
                testLog.append(";");
                if (parseVerdict != null) {
                    testLog.append("\"" + StringUtil.convertToOCLString((String)parseVerdict) + "\"");
                }
                testLog.append(";");
                if (evaluationVerdict != null) {
                    testLog.append("\"" + StringUtil.convertToOCLString((String)evaluationVerdict) + "\"");
                }
                testLog.append(";");
                if (evaluationTolerance != null) {
                    testLog.append("\"" + evaluationTolerance.replace("\"", "\"\"") + "\"");
                }
                testLog.append("\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @NonNull
    public static XtextResource as2cs(@NonNull OCL ocl, @NonNull ResourceSet resourceSet, @NonNull ASResource asResource, @NonNull URI outputURI) throws IOException {
        XtextResource xtextResource = (XtextResource)ClassUtil.nonNullState((Object)((XtextResource)resourceSet.createResource(outputURI, "org.eclipse.ocl.xtext.oclinecore")));
        ocl.as2cs(asResource, (CSResource)xtextResource);
        PivotTestCase.assertNoResourceErrors("Conversion failed", (Resource)xtextResource);
        URI savedURI = (URI)ClassUtil.nonNullState((Object)asResource.getURI());
        asResource.setURI(outputURI.trimFileExtension().trimFileExtension().appendFileExtension("oclas"));
        asResource.save(null);
        asResource.setURI(savedURI);
        PivotTestCase.assertNoDiagnosticErrors("Concrete Syntax validation failed", xtextResource);
        try {
            xtextResource.save(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            URI xmiURI = outputURI.appendFileExtension(".xmi");
            Resource xmiResource = resourceSet.createResource(xmiURI);
            xmiResource.getContents().addAll((Collection)xtextResource.getContents());
            xmiResource.save(null);
            PivotTestCase.fail((String)e.toString());
        }
        return xtextResource;
    }

    @NonNull
    public static Resource as2ecore(@NonNull OCL ocl, @NonNull Resource asResource, @Nullable URI ecoreURI, boolean validateSaved) throws IOException {
        Resource ecoreResource = ocl.as2ecore(asResource, ecoreURI != null ? ecoreURI : (URI)ClassUtil.nonNullEMF((Object)URI.createURI((String)"test.ecore")));
        if (ecoreURI != null) {
            ecoreResource.save(null);
        }
        if (validateSaved) {
            PivotTestCase.assertNoValidationErrors("AS2Ecore invalid", ecoreResource);
        }
        return ecoreResource;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    @NonNull
    public static List<Diagnostic> assertDiagnostics(@NonNull String prefix, @NonNull List<Diagnostic> diagnostics, String ... messages) {
        Integer count;
        HashMap<String, Integer> expected = new HashMap<String, Integer>();
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            count = (Integer)expected.get(message);
            count = count == null ? 1 : count + 1;
            expected.put(message, count);
            ++n2;
        }
        StringBuilder s1 = null;
        for (Diagnostic diagnostic : diagnostics) {
            String actual = diagnostic.getMessage();
            Integer expectedCount = (Integer)expected.get(actual);
            if (expectedCount == null || expectedCount <= 0) {
                if (s1 == null) {
                    s1 = new StringBuilder();
                    s1.append("\nUnexpected errors");
                }
                s1.append("\n");
                s1.append(actual);
                continue;
            }
            expected.put(actual, expectedCount - 1);
        }
        StringBuilder s2 = null;
        for (String key : expected.keySet()) {
            Integer n3;
            count = (Integer)expected.get(key);
            if (true) {
                n3 = count;
                count = n3 - 1;
                if (n3 <= 0) continue;
            }
            do {
                if (s2 == null) {
                    s2 = new StringBuilder();
                    s2.append("\nMissing errors");
                }
                s2.append("\n");
                s2.append(key);
                n3 = count;
                count = n3 - 1;
            } while (n3 > 0);
        }
        if (s1 == null) {
            if (s2 == null) return diagnostics;
            PivotTestCase.fail((String)s2.toString());
            return diagnostics;
        }
        if (s2 == null) {
            PivotTestCase.fail((String)s1.toString());
            return diagnostics;
        }
        PivotTestCase.fail((String)(String.valueOf(s1.toString()) + s2.toString()));
        return diagnostics;
    }

    public static void assertNoDiagnosticErrors(@NonNull String message, @NonNull XtextResource xtextResource) {
        List diagnostics = xtextResource.validateConcreteSyntax();
        if (diagnostics.size() > 0) {
            StringBuilder s = new StringBuilder();
            s.append(message);
            for (Diagnostic diagnostic : diagnostics) {
                s.append("\n");
                s.append(diagnostic.toString());
            }
            PivotTestCase.fail((String)s.toString());
        }
    }

    public static void assertNoResourceErrors(@NonNull String prefix, @NonNull Resource resource) {
        String message = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)resource.getErrors())), (String)prefix, (String)"\n\t");
        if (message != null) {
            PivotTestCase.fail((String)message);
        }
    }

    public static void assertNoResourceErrorsOrWarnings(@NonNull String prefix, @NonNull Resource resource) {
        String message = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)resource.getErrors())), (String)prefix, (String)"\n\t");
        if (message != null) {
            PivotTestCase.fail((String)message);
        }
        if ((message = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)resource.getWarnings())), (String)prefix, (String)"\n\t")) != null) {
            PivotTestCase.fail((String)message);
        }
    }

    public static void assertNoUnresolvedProxies(@NonNull String message, @NonNull Resource resource) {
        Map unresolvedProxies = EcoreUtil.UnresolvedProxyCrossReferencer.find((Resource)resource);
        if (unresolvedProxies.size() > 0) {
            StringBuilder s = new StringBuilder();
            s.append(unresolvedProxies.size());
            s.append(" unresolved proxies in ");
            s.append(message);
            for (Map.Entry unresolvedProxy : unresolvedProxies.entrySet()) {
                s.append("\n");
                BasicEObjectImpl key = (BasicEObjectImpl)unresolvedProxy.getKey();
                s.append(key.eProxyURI());
                for (EStructuralFeature.Setting setting : (Collection)unresolvedProxy.getValue()) {
                    s.append("\n\t");
                    EObject eObject = setting.getEObject();
                    s.append(eObject.toString());
                }
            }
            PivotTestCase.fail((String)s.toString());
        }
    }

    public static void assertNoValidationErrors(@NonNull String string, @NonNull Resource resource) {
        for (EObject eObject : resource.getContents()) {
            PivotTestCase.assertNoValidationErrors(string, (EObject)ClassUtil.nonNullEMF((Object)eObject));
        }
    }

    public static void assertNoValidationErrors(@NonNull String string, @NonNull EObject eObject) {
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject, validationContext);
        List children = diagnostic.getChildren();
        if (children.size() <= 0) {
            return;
        }
        StringBuilder s = new StringBuilder();
        s.append(String.valueOf(children.size()) + " validation errors");
        for (Diagnostic child : children) {
            s.append("\n\t");
            s.append(child.getMessage());
        }
        PivotTestCase.fail((String)s.toString());
    }

    public static void assertResourceErrors(@NonNull String prefix, @NonNull Resource resource, String ... messages) {
        PivotTestCase.assertResourceDiagnostics(prefix, (List)ClassUtil.nonNullEMF((Object)resource.getErrors()), messages);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static void assertResourceDiagnostics(@NonNull String prefix, @NonNull List<Resource.Diagnostic> resourceDiagnostics, String ... messages) {
        Integer count;
        HashMap<String, Integer> expected = new HashMap<String, Integer>();
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            count = (Integer)expected.get(message);
            count = count == null ? 1 : count + 1;
            expected.put(message, count);
            ++n2;
        }
        StringBuilder s1 = null;
        for (Resource.Diagnostic error : resourceDiagnostics) {
            String actual = error.getMessage();
            Integer expectedCount = (Integer)expected.get(actual);
            if (expectedCount == null || expectedCount <= 0) {
                if (s1 == null) {
                    s1 = new StringBuilder();
                    s1.append("\nUnexpected errors");
                }
                s1.append("\n");
                s1.append(actual);
                continue;
            }
            expected.put(actual, expectedCount - 1);
        }
        StringBuilder s2 = null;
        for (String key : expected.keySet()) {
            Integer n3;
            count = (Integer)expected.get(key);
            if (true) {
                n3 = count;
                count = n3 - 1;
                if (n3 <= 0) continue;
            }
            do {
                if (s2 == null) {
                    s2 = new StringBuilder();
                    s2.append("\nMissing errors");
                }
                s2.append("\n");
                s2.append(key);
                n3 = count;
                count = n3 - 1;
            } while (n3 > 0);
        }
        if (s1 == null) {
            if (s2 == null) {
                return;
            }
            PivotTestCase.fail((String)s2.toString());
            return;
        }
        if (s2 == null) {
            PivotTestCase.fail((String)s1.toString());
            return;
        }
        PivotTestCase.fail((String)(String.valueOf(s1.toString()) + s2.toString()));
    }

    @NonNull
    public static List<Diagnostic> assertValidationDiagnostics(@NonNull String prefix, @NonNull Resource resource, String ... messages) {
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        return PivotTestCase.assertValidationDiagnostics(prefix, resource, validationContext, messages);
    }

    @NonNull
    public static List<Diagnostic> assertValidationDiagnostics(@NonNull String prefix, @NonNull Resource resource, Map<Object, Object> validationContext, String ... messages) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (EObject eObject : resource.getContents()) {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject, validationContext);
            diagnostics.addAll(diagnostic.getChildren());
        }
        return PivotTestCase.assertDiagnostics(prefix, diagnostics, messages);
    }

    @Nullable
    public static StandaloneProjectMap basicGetProjectMap() {
        GlobalEnvironmentFactory globalEnvironmentFactory = GlobalEnvironmentFactory.basicGetInstance();
        return globalEnvironmentFactory != null ? (StandaloneProjectMap)globalEnvironmentFactory.getProjectManager() : null;
    }

    public static void closeTestLog() {
        if (testLog != null) {
            try {
                testLog.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void configurePlatformResources() {
        if (!PivotTestCase.eclipseIsRunning()) {
            File[] files;
            String urlString = System.getProperty("WORKSPACE_LOC");
            File workspaceLoc = urlString != null ? new File(urlString) : new File(System.getProperty("user.dir")).getParentFile();
            File[] fileArray = files = workspaceLoc.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    String name = file.getName();
                    EcorePlugin.getPlatformResourceMap().put(name, URI.createFileURI((String)(String.valueOf(file.toString()) + "/")));
                }
                ++n2;
            }
        }
    }

    public static void createTestLog(File file) {
        try {
            Writer writer = testLog = file != null ? new FileWriter(file) : null;
            if (testLog != null) {
                try {
                    testLog.append("Test Group");
                    testLog.append(";");
                    testLog.append("Context Object");
                    testLog.append(";");
                    testLog.append("Test Expression");
                    testLog.append(";");
                    testLog.append("Parser Result");
                    testLog.append(";");
                    testLog.append("Evaluation Result");
                    testLog.append(";");
                    testLog.append("Result Tolerance");
                    testLog.append("\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NonNull
    public static Resource cs2ecore(@NonNull OCL ocl, @NonNull String testDocument, @Nullable URI ecoreURI) throws IOException {
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(testDocument, "UTF-8");
        URI xtextURI = URI.createURI((String)"test.oclinecore");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EssentialOCLCSResource xtextResource = (EssentialOCLCSResource)ClassUtil.nonNullState((Object)((EssentialOCLCSResource)resourceSet.createResource(xtextURI, null)));
        ocl.getEnvironmentFactory().adapt((Notifier)xtextResource);
        xtextResource.load((InputStream)inputStream, null);
        PivotTestCase.assertNoResourceErrors("Loading Xtext", (Resource)xtextResource);
        Resource asResource = PivotTestCase.cs2as(ocl, (CSResource)xtextResource, null);
        Resource ecoreResource = PivotTestCase.as2ecore(ocl, asResource, ecoreURI, true);
        return ecoreResource;
    }

    @NonNull
    public static Resource cs2as(@NonNull OCL ocl, @NonNull String testDocument) throws IOException {
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(testDocument, "UTF-8");
        URI xtextURI = URI.createURI((String)"test.oclinecore");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EssentialOCLCSResource xtextResource = (EssentialOCLCSResource)ClassUtil.nonNullState((Object)((EssentialOCLCSResource)resourceSet.createResource(xtextURI, null)));
        ocl.getEnvironmentFactory().adapt((Notifier)xtextResource);
        xtextResource.load((InputStream)inputStream, null);
        PivotTestCase.assertNoResourceErrors("Loading Xtext", (Resource)xtextResource);
        Resource asResource = PivotTestCase.cs2as(ocl, (CSResource)xtextResource, null);
        return asResource;
    }

    @NonNull
    public static Resource cs2as(@NonNull OCL ocl, @NonNull CSResource xtextResource, @Nullable URI pivotURI) throws IOException {
        ASResource asResource = ocl.cs2as(xtextResource);
        PivotTestCase.assertNoUnresolvedProxies("Unresolved proxies", (Resource)asResource);
        if (pivotURI != null) {
            asResource.setURI(pivotURI);
            asResource.save(null);
        }
        return asResource;
    }

    public static void disposeResourceSet(@NonNull ResourceSet resourceSet) {
        for (Resource next : resourceSet.getResources()) {
            next.unload();
            next.eAdapters().clear();
        }
        resourceSet.getResources().clear();
        resourceSet.eAdapters().clear();
    }

    public static void doCompleteOCLSetup() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            CompleteOCLStandaloneSetup.doSetup();
        } else {
            Guice.createInjector((Module[])new Module[]{new CompleteOCLRuntimeModule()});
        }
    }

    public static void doEssentialOCLSetup() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            EssentialOCLStandaloneSetup.doSetup();
        } else {
            Guice.createInjector((Module[])new Module[]{new EssentialOCLRuntimeModule()});
        }
    }

    public static void doOCLinEcoreSetup() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            OCLinEcoreStandaloneSetup.doSetup();
        } else {
            Guice.createInjector((Module[])new Module[]{new OCLinEcoreRuntimeModule()});
        }
    }

    public static void doOCLstdlibSetup() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            OCLstdlibStandaloneSetup.doSetup();
        } else {
            Guice.createInjector((Module[])new Module[]{new OCLstdlibRuntimeModule()});
        }
    }

    public static boolean eclipseIsRunning() {
        try {
            Class<?> platformClass = Class.forName("org.eclipse.core.runtime.Platform");
            Method isRunningMethod = platformClass.getDeclaredMethod("isRunning", new Class[0]);
            return Boolean.TRUE.equals(isRunningMethod.invoke(null, new Object[0]));
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static Value failOn(@NonNull String expression, @Nullable Throwable e) {
        if (e instanceof EvaluationException) {
            Throwable eCause = e.getCause();
            if (eCause != null) {
                return PivotTestCase.failOn(expression, eCause);
            }
            throw new Error(StringUtil.bind((String)PivotMessagesInternal.FailedToEvaluate_ERROR_, (Object[])new Object[]{expression}), e);
        }
        if (e instanceof EvaluationException) {
            throw new Error("Failed to parse or evaluate \"" + expression + "\"", e);
        }
        throw new Error("Failure for \"" + expression + "\"", e);
    }

    public static String formatMessageDifferences(Bag<String> expectedMessages, Bag<String> actualMessages) {
        HashSet<String> allMessages = new HashSet<String>((Collection<String>)expectedMessages);
        allMessages.addAll((Collection<String>)actualMessages);
        StringBuilder s = null;
        for (String message : allMessages) {
            int expectedCount;
            int actualCount = actualMessages.count((Object)message);
            if (actualCount == (expectedCount = expectedMessages.count((Object)message))) continue;
            if (s == null) {
                s = new StringBuilder();
            }
            s.append("\n  (" + expectedCount + "/" + actualCount + ") " + message);
        }
        return s != null ? s.toString() : null;
    }

    @NonNull
    public static StandaloneProjectMap getProjectMap() {
        return (StandaloneProjectMap)ProjectManager.CLASS_PATH;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    public static void unloadResourceSet(@NonNull ResourceSet resourceSet) {
        EnvironmentFactoryAdapter environmentFactoryAdapter;
        StandaloneProjectMap projectMap = StandaloneProjectMap.findAdapter((ResourceSet)resourceSet);
        if (projectMap != null) {
            projectMap.unload(resourceSet);
        }
        if ((environmentFactoryAdapter = EnvironmentFactoryAdapter.find((Notifier)resourceSet)) != null) {
            EnvironmentFactoryInternal environmentFactory = environmentFactoryAdapter.getMetamodelManager().getEnvironmentFactory();
            ProjectManager projectManager = environmentFactory.getProjectManager();
            projectManager.unload(resourceSet);
        }
        for (Resource resource : resourceSet.getResources()) {
            resource.unload();
        }
        resourceSet.eAdapters().clear();
    }

    @NonNull
    public URI createEcoreFile(@NonNull OCL ocl, @NonNull String fileName, @NonNull String fileContent) throws IOException {
        return this.createEcoreFile(ocl, fileName, fileContent, false);
    }

    @NonNull
    public URI createEcoreFile(@NonNull OCL ocl, @NonNull String fileName, @NonNull String fileContent, boolean assignIds) throws IOException {
        String inputName = String.valueOf(fileName) + ".oclinecore";
        this.createOCLinEcoreFile(inputName, fileContent);
        URI inputURI = this.getProjectFileURI(inputName);
        URI ecoreURI = this.getProjectFileURI(String.valueOf(fileName) + ".ecore");
        ResourceSet resourceSet2 = ocl.getResourceSet();
        BaseCSResource xtextResource = (BaseCSResource)ClassUtil.nonNullState((Object)((BaseCSResource)resourceSet2.getResource(inputURI, true)));
        PivotTestCase.assertNoResourceErrors("Load failed", (Resource)xtextResource);
        CS2AS cs2as = xtextResource.getCS2AS();
        ASResource asResource = cs2as.getASResource();
        PivotTestCase.assertNoUnresolvedProxies("Unresolved proxies", (Resource)xtextResource);
        PivotTestCase.assertNoValidationErrors("Pivot validation errors", (EObject)ClassUtil.nonNullState((Object)((EObject)asResource.getContents().get(0))));
        XMLResource ecoreResource = AS2Ecore.createResource((EnvironmentFactoryInternal)((EnvironmentFactoryInternal)ocl.getEnvironmentFactory()), (Resource)asResource, (URI)ecoreURI, null);
        PivotTestCase.assertNoResourceErrors("To Ecore errors", (Resource)ecoreResource);
        if (assignIds) {
            TreeIterator tit = ecoreResource.getAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                ecoreResource.setID(eObject, EcoreUtil.generateUUID());
            }
        }
        ecoreResource.save(null);
        return ecoreURI;
    }

    public void createOCLinEcoreFile(String fileName, String fileContent) throws IOException {
        File file = new File(this.getProjectFile(), fileName);
        FileWriter writer = new FileWriter(file);
        ((Writer)writer).append(fileContent);
        ((Writer)writer).close();
    }

    @NonNull
    protected File getProjectFile() {
        String projectName = this.getProjectName();
        URL projectURL = this.getTestResource(projectName);
        PivotTestCase.assertNotNull((Object)projectURL);
        return new File(projectURL.getFile());
    }

    @NonNull
    protected URI getProjectFileURI(String referenceName) {
        File projectFile = this.getProjectFile();
        return (URI)ClassUtil.nonNullState((Object)URI.createFileURI((String)(String.valueOf(projectFile.toString()) + "/" + referenceName)));
    }

    @NonNull
    protected String getProjectName() {
        return String.valueOf(((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/')) + "/models";
    }

    @NonNull
    public String getName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        String methodName = this.testName.getMethodName();
        return methodName != null ? methodName : "<unnamed>";
    }

    @NonNull
    public URI getTestModelURI(@NonNull String localFileName) {
        StandaloneProjectMap projectMap = PivotTestCase.getProjectMap();
        URI location = projectMap.getLocation(PLUGIN_ID);
        TestCase.assertNotNull((Object)location);
        String urlString = location.toString();
        return (URI)ClassUtil.nonNullEMF((Object)URI.createURI((String)(String.valueOf(urlString) + localFileName)));
    }

    @NonNull
    protected URL getTestResource(@NonNull String resourceName) {
        URL projectURL;
        block5: {
            projectURL = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName);
            try {
                if (projectURL == null || !Platform.isRunning()) break block5;
                try {
                    projectURL = FileLocator.resolve((URL)projectURL);
                }
                catch (IOException e) {
                    TestCase.fail((String)e.getMessage());
                    assert (false);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return (URL)ClassUtil.nonNullState((Object)projectURL);
    }

    public void resetRegistries() {
        Object object = ValidationDelegate.Factory.Registry.INSTANCE.get((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL");
        if (object instanceof OCLValidationDelegateMapping) {
            ((OCLValidationDelegateMapping)object).reset();
        }
    }

    protected void setUp() throws Exception {
        PivotUtilInternal.debugReset();
        GlobalEnvironmentFactory.resetSafeNavigationValidations();
        if (DEBUG_GC) {
            XMLNamespacePackage.eINSTANCE.getClass();
            this.makeCopyOfGlobalState = new GlobalStateMemento();
        }
        super.setUp();
        if (DEBUG_ID) {
            PivotUtilInternal.debugPrintln((Object)("-----Starting " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.getName() + "-----"));
        }
        EcorePackage.eINSTANCE.getClass();
    }

    protected void tearDown() throws Exception {
        if (DEBUG_GC) {
            this.uninstall();
            this.makeCopyOfGlobalState.restoreGlobalState();
            this.makeCopyOfGlobalState = null;
            System.gc();
            System.runFinalization();
        }
        if (DEBUG_ID) {
            PivotUtilInternal.debugPrintln((Object)("==> Finish " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.getName()));
        }
        TreeIterator tit = OCLstdlib.getDefault().getAllContents();
        while (tit.hasNext()) {
            PivotObjectImpl asObject;
            EObject eTarget;
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof PivotObjectImpl) || (eTarget = (asObject = (PivotObjectImpl)eObject).getESObject()) == null || !eTarget.eIsProxy()) continue;
            asObject.setESObject(null);
        }
        super.tearDown();
    }

    protected void uninstall() {
        PivotStandaloneSetup.doTearDown();
        BaseStandaloneSetup.doTearDown();
        CompleteOCLStandaloneSetup.doTearDown();
        EssentialOCLStandaloneSetup.doTearDown();
        MarkupStandaloneSetup.doTearDown();
        OCLinEcoreStandaloneSetup.doTearDown();
        OCLstdlibStandaloneSetup.doTearDown();
        GlobalEnvironmentFactory.disposeInstance();
    }

    public static class GlobalStateMemento {
        @NonNull
        private HashMap<EPackage, Object> validatorReg = new HashMap(EValidator.Registry.INSTANCE);
        @NonNull
        private HashMap<String, Object> epackageReg = new HashMap(EPackage.Registry.INSTANCE);
        @NonNull
        private HashMap<String, Object> protocolToFactoryMap = new HashMap(Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap());
        @NonNull
        private HashMap<String, Object> extensionToFactoryMap = new HashMap(Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap());
        @NonNull
        private HashMap<String, Object> contentTypeIdentifierToFactoryMap = new HashMap(Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap());
        @NonNull
        private HashMap<String, Object> protocolToServiceProviderMap = new HashMap(IResourceServiceProvider.Registry.INSTANCE.getProtocolToFactoryMap());
        @NonNull
        private HashMap<String, Object> extensionToServiceProviderMap = new HashMap(IResourceServiceProvider.Registry.INSTANCE.getExtensionToFactoryMap());
        @NonNull
        private HashMap<String, Object> contentTypeIdentifierToServiceProviderMap = new HashMap(IResourceServiceProvider.Registry.INSTANCE.getContentTypeToFactoryMap());

        public void restoreGlobalState() {
            GlobalStateMemento.clearGlobalRegistries();
            EValidator.Registry.INSTANCE.putAll(this.validatorReg);
            EPackage.Registry.INSTANCE.putAll(this.epackageReg);
            Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap().putAll(this.protocolToFactoryMap);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().putAll(this.extensionToFactoryMap);
            Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap().putAll(this.contentTypeIdentifierToFactoryMap);
            IResourceServiceProvider.Registry.INSTANCE.getProtocolToFactoryMap().putAll(this.protocolToServiceProviderMap);
            IResourceServiceProvider.Registry.INSTANCE.getExtensionToFactoryMap().putAll(this.extensionToServiceProviderMap);
            IResourceServiceProvider.Registry.INSTANCE.getContentTypeToFactoryMap().putAll(this.contentTypeIdentifierToServiceProviderMap);
        }

        public static void clearGlobalRegistries() {
            EValidator.Registry.INSTANCE.clear();
            EPackage.Registry.INSTANCE.clear();
            Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap().clear();
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().clear();
            Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap().clear();
            IResourceServiceProvider.Registry.INSTANCE.getProtocolToFactoryMap().clear();
            IResourceServiceProvider.Registry.INSTANCE.getExtensionToFactoryMap().clear();
            IResourceServiceProvider.Registry.INSTANCE.getContentTypeToFactoryMap().clear();
            GlobalStateMemento.initializeDefaults();
        }

        public static void initializeDefaults() {
            if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("ecore")) {
                Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
            }
            if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("xmi")) {
                Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
            }
            if (!EPackage.Registry.INSTANCE.containsKey((Object)"http://www.eclipse.org/emf/2002/Ecore")) {
                EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
            }
            if (!EPackage.Registry.INSTANCE.containsKey((Object)"http://www.eclipse.org/2008/Xtext")) {
                EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/2008/Xtext", (Object)XtextPackage.eINSTANCE);
            }
        }
    }
}

