/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCase;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;

public abstract class PivotTestCaseWithAutoTearDown
extends PivotTestCase {
    protected void autoTearDown() throws Exception {
        Class<?> aClass = ((Object)((Object)this)).getClass();
        while (PivotTestCaseWithAutoTearDown.class.isAssignableFrom(aClass)) {
            Field[] fieldArray = aClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                int modifiers = field.getModifiers();
                if (!Modifier.isFinal(modifiers)) {
                    if (!Modifier.isStatic(modifiers)) {
                        Class<?> fieldType = field.getType();
                        if (Object.class.isAssignableFrom(fieldType)) {
                            String fieldName = field.getName();
                            try {
                                String tearDownName = "tearDown_" + fieldName;
                                Method method = aClass.getDeclaredMethod(tearDownName, new Class[0]);
                                try {
                                    this.tearDownUsing(method);
                                }
                                catch (Exception e) {
                                    PivotTestCaseWithAutoTearDown.fail((String)("Failed to invoke " + ((Object)((Object)this)).getClass().getSimpleName() + "." + tearDownName + " : " + e));
                                }
                            }
                            catch (NoSuchMethodException e) {
                                try {
                                    this.tearDownField(field);
                                }
                                catch (Exception e1) {
                                    PivotTestCaseWithAutoTearDown.fail((String)("Failed to set " + ((Object)((Object)this)).getClass().getSimpleName() + "." + fieldName + " to null : " + e1));
                                }
                            }
                        }
                    } else {
                        this.tearDownStatic(aClass, field);
                    }
                }
                ++n2;
            }
            aClass = aClass.getSuperclass();
        }
    }

    protected void tearDownField(@NonNull Field field) throws IllegalAccessException {
        field.set((Object)this, null);
    }

    protected void tearDownStatic(@NonNull Class<?> aClass, @NonNull Field field) {
        if (aClass != PivotTestSuite.class) {
            PivotTestCaseWithAutoTearDown.fail((String)("static test variable:" + field));
        }
    }

    protected void tearDownUsing(@NonNull Method method) throws IllegalAccessException, InvocationTargetException {
        method.invoke((Object)this, new Object[0]);
    }
}

