/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.ListIterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCaseWithAutoTearDown;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.examples.xtext.tests.TestCaseAppender;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;

public abstract class PivotTestSuite
extends PivotTestCaseWithAutoTearDown {
    private static boolean DISPOSE_RESOURCE_SET = false;
    @NonNull
    public static final String ORG_ECLIPSE_OCL_EXAMPLES_XTEXT_TESTRESULTS = "org.eclipse.ocl.examples.xtext.tests";
    protected static boolean noDebug = false;
    protected static ResourceSet resourceSet;
    private static ArrayList<Resource> standardResources;
    protected static int testCounter;
    private static boolean initialized;
    protected static boolean useCodeGen;

    static {
        testCounter = 0;
        initialized = false;
    }

    public static void debugPrintln(String string) {
        if (!noDebug) {
            System.out.println(string);
        }
    }

    public static boolean eclipseIsRunning() {
        try {
            java.lang.Class<?> platformClass = java.lang.Class.forName("org.eclipse.core.runtime.Platform");
            Method isRunningMethod = platformClass.getDeclaredMethod("isRunning", new java.lang.Class[0]);
            return Boolean.TRUE.equals(isRunningMethod.invoke(null, new Object[0]));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void initializeStandalone() {
        if (initialized) {
            return;
        }
        initialized = true;
    }

    protected PivotTestSuite() {
        useCodeGen = false;
    }

    protected PivotTestSuite(boolean useCodeGen) {
        PivotTestSuite.useCodeGen = useCodeGen;
    }

    protected void assertValidToString(@NonNull Visitable node) {
        try {
            String toString = node.toString();
            PivotTestSuite.assertNotNull((String)"ToStringVisitorImpl returned null", (Object)toString);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            PivotTestSuite.fail((String)("ToStringVisitorImpl threw an exception: " + e.getLocalizedMessage()));
        }
    }

    protected void checkForUTF8Encoding() {
        String testCharacter = "\u00b4";
        int length = testCharacter.length();
        if (length != 1 || testCharacter.charAt(0) != '\u00b4') {
            StringBuilder s = new StringBuilder();
            s.append("The Resource text file encoding should be set to UTF-8: test character was");
            int i = 0;
            while (i < length) {
                s.append(" ");
                s.append(Integer.toHexString(testCharacter.charAt(i)));
                ++i;
            }
            s.append(" rather than B4");
            PivotTestSuite.fail((String)s.toString());
        }
    }

    @NonNull
    protected TestOCL createOCL() throws ParserException {
        return new TestOCL(this.getTestPackageName(), this.getName(), (ProjectManager)(useCodeGen ? PivotTestSuite.getProjectMap() : OCL.NO_PROJECTS));
    }

    @NonNull
    public ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)PivotPackage.eINSTANCE.getNsURI(), (Object)PivotPackage.eINSTANCE);
        return resourceSet;
    }

    protected void disposeResourceSet() {
        ResourceSet resourceSet2 = resourceSet;
        if (resourceSet2 != null) {
            StandaloneProjectMap projectMap = PivotTestSuite.basicGetProjectMap();
            if (projectMap != null) {
                projectMap.unload(resourceSet2);
            }
            for (Resource res : resourceSet2.getResources()) {
                res.unload();
                res.eAdapters().clear();
            }
            resourceSet2.getResources().clear();
            resourceSet2.eAdapters().clear();
            resourceSet = null;
        }
        standardResources = null;
    }

    protected Property getAttribute(@NonNull Class classifier, @NonNull String name, @NonNull Type type) {
        Property feature = (Property)NameUtil.getNameable((Iterable)classifier.getOwnedProperties(), (String)name);
        if (feature == null) {
            return null;
        }
        return feature;
    }

    @NonNull
    protected String getTestPackageName() {
        return "test_package";
    }

    protected void initializeResourceSet() {
        resourceSet = this.createResourceSet();
        standardResources = new ArrayList(resourceSet.getResources());
    }

    public static void resetCounter() throws Exception {
        testCounter = 0;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestCaseAppender.INSTANCE.install();
        OCLstdlib.install();
        PivotTestSuite.doEssentialOCLSetup();
        if (resourceSet != null && DISPOSE_RESOURCE_SET) {
            this.disposeResourceSet();
        }
        if (!initialized) {
            boolean bl = noDebug = System.getProperty("org.eclipse.ocl.examples.xtext.tests.nodebug") != null;
            if (!PivotTestSuite.eclipseIsRunning()) {
                PivotTestSuite.initializeStandalone();
            }
        }
        if (resourceSet == null) {
            this.initializeResourceSet();
        }
    }

    @Override
    protected void tearDown() throws Exception {
        ListIterator i = resourceSet.getResources().listIterator();
        while (i.hasNext()) {
            Resource res = (Resource)i.next();
            if (standardResources.contains(res)) continue;
            i.remove();
            res.unload();
            res.eAdapters().clear();
        }
        this.autoTearDown();
        this.disposeResourceSet();
        super.tearDown();
    }

    public static final class CheckedTestSuite
    extends TestSuite {
        public CheckedTestSuite(String name) {
            super(name);
        }

        public void createTestSuite(java.lang.Class<? extends PivotTestSuite> testClass, String testName) {
            this.addTest((Test)new TestSuite(testClass, testName));
        }

        public void addTestSuite(CheckedTestSuite suite) {
            this.addTest((Test)suite);
        }
    }
}

