/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.internal.options.CommonOptions;
import org.eclipse.ocl.common.internal.preferences.CommonPreferenceInitializer;
import org.eclipse.ocl.ecore.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.tests.AbstractValidateTests;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.GlobalEnvironmentFactory;
import org.eclipse.ocl.pivot.internal.values.IntIntegerValueImpl;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.xtext.completeocl.utilities.CompleteOCLLoader;
import org.eclipse.ocl.xtext.oclinecore.validation.OCLinEcoreEObjectValidator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;
import org.junit.After;
import org.junit.Before;

public class UMLValidateTest
extends AbstractValidateTests {
    @Nullable
    public EObject getStereotypeApplication(@NonNull Element umlElement, @NonNull Stereotype umlStereotype) {
        for (EObject eObject : umlElement.eResource().getContents()) {
            if (!ClassUtil.safeEquals((Object)eObject.eClass().getName(), (Object)umlStereotype.getName())) continue;
            for (EStructuralFeature eFeature : eObject.eClass().getEAllStructuralFeatures()) {
                Object object;
                if (!(eFeature instanceof EReference) || eFeature.isMany() || (object = eObject.eGet(eFeature)) != umlElement) continue;
                return eObject;
            }
        }
        return null;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            UMLStandaloneSetup.init();
        }
        EValidator.Registry.INSTANCE.put(null, (Object)new OCLinEcoreEObjectValidator());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        EValidator.Registry.INSTANCE.remove(null);
        GlobalEnvironmentFactory.disposeInstance();
        super.tearDown();
    }

    public void testValidate_Bug417062_uml() throws IOException, InterruptedException, ParserException {
        OCL ocl = OCL.newInstance();
        Resource umlResource = this.doLoadUML(ocl, "Bug417062");
        Model model = (Model)umlResource.getContents().get(0);
        Class book = (Class)model.getOwnedType("Book");
        Constraint constraint = (Constraint)book.getOwnedRules().get(0);
        InstanceSpecification invalidBook = (InstanceSpecification)model.getOwnedMember("2) Invalid book");
        InstanceSpecification partialBook = (InstanceSpecification)model.getOwnedMember("3) Book with undefined price");
        UMLValidateTest.assertUMLOCLValidationDiagnostics(ocl, "UML Load", umlResource, StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{String.valueOf(book.getName()) + "::" + constraint.getName(), LabelUtil.getLabel((Object)invalidBook)}), StringUtil.bind((String)PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{book.getName(), constraint.getName(), LabelUtil.getLabel((Object)partialBook), StringUtil.bind((String)PivotMessages.UnsupportedCompareTo, (Object[])new Object[]{"null", IntIntegerValueImpl.class.getName()})}));
        ocl = null;
    }

    public void test_tutorial_umlValidation_with_lpg_408990() {
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/LPG");
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            UMLValidateTest.assertNull((Object)UML2AS.initialize((ResourceSet)resourceSet));
        }
        URI uri = this.getProjectFileURI("Bug408990.uml");
        Resource umlResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(uri, true));
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        String label = NameUtil.qualifiedNameFor((Object)umlResource.getContents().get(1));
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"Stereotype1::IntegerConstraint", label}));
        ocl.dispose();
    }

    public void test_tutorial_umlValidation_with_pivot_408990() {
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initialize((ResourceSet)resourceSet, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            UMLValidateTest.assertNull((Object)UML2AS.initialize((ResourceSet)resourceSet));
        }
        URI uri = this.getProjectFileURI("Bug408990.uml");
        Resource umlResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(uri, true));
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        Model umlModel = (Model)umlResource.getContents().get(0);
        Class umlClass1 = (Class)umlModel.getOwnedType("Class1");
        Profile umlProfile = ((ProfileApplication)umlModel.getProfileApplications().get(0)).getAppliedProfile();
        Stereotype umlStereotype1 = (Stereotype)umlProfile.getOwnedType("Stereotype1");
        assert (umlClass1 != null && umlStereotype1 != null);
        String label = NameUtil.qualifiedNameFor((Object)this.getStereotypeApplication((Element)umlClass1, umlStereotype1));
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"Stereotype1::IntegerConstraint", label}));
        ocl.dispose();
    }

    public void test_tutorial_umlValidation_436903() {
        OCL ocl = OCL.newInstance((ProjectManager)UMLValidateTest.getProjectMap());
        ResourceSet resourceSet = ocl.getResourceSet();
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            UMLValidateTest.assertNull((Object)UML2AS.initialize((ResourceSet)resourceSet));
        } else {
            UMLResourcesUtil.init((ResourceSet)resourceSet);
        }
        URI uri = this.getProjectFileURI("PapyrusTestFile.uml");
        Resource umlResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(uri, true));
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, new String[0]);
        URI oclURI = this.getProjectFileURI("ExtraUMLValidation.ocl");
        CompleteOCLLoader helper = new CompleteOCLLoader(ocl.getEnvironmentFactory()){

            protected boolean error(@NonNull String primaryMessage, @Nullable String detailMessage) {
                return false;
            }
        };
        EnvironmentFactory environmentFactory = helper.getEnvironmentFactory();
        ProjectManager projectMap = environmentFactory.getProjectManager();
        projectMap.configure(environmentFactory.getResourceSet(), StandaloneProjectMap.LoadGeneratedPackageStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
        Resource oclResource = helper.loadResource(oclURI);
        if (!helper.loadMetamodels()) {
            UMLValidateTest.fail((String)"Failed to loadMetamodels");
        }
        if (!helper.loadDocument(oclURI)) {
            UMLValidateTest.fail((String)"Failed to loadDocument");
        }
        helper.installPackages();
        Model umlModel = (Model)umlResource.getContents().get(0);
        Class umlClass1 = (Class)umlModel.getOwnedType("lowercase");
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)umlClass1, validationContext);
        diagnostics.addAll(diagnostic.getChildren());
        UMLValidateTest.assertDiagnostics("Loading", diagnostics, StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Class::CamelCaseName", NameUtil.qualifiedNameFor((Object)umlClass1)}));
        helper.dispose();
        ocl.dispose();
    }

    public void test_umlValidation_404882() {
        OCL ocl = OCL.newInstance((ProjectManager)UMLValidateTest.getProjectMap());
        ResourceSet resourceSet = ocl.getResourceSet();
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            UMLValidateTest.assertNull((Object)UML2AS.initialize((ResourceSet)resourceSet));
        } else {
            UMLResourcesUtil.init((ResourceSet)resourceSet);
        }
        URI uri = this.getProjectFileURI("Bug404882.uml");
        Resource umlResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(uri, true));
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, new String[0]);
        URI oclURI = this.getProjectFileURI("Bug404882.ocl");
        LoaderWithLog helper = new LoaderWithLog(ocl.getEnvironmentFactory());
        EnvironmentFactory environmentFactory = helper.getEnvironmentFactory();
        ProjectManager projectMap = environmentFactory.getProjectManager();
        projectMap.configure(environmentFactory.getResourceSet(), StandaloneProjectMap.LoadGeneratedPackageStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
        Resource oclResource = helper.loadResource(oclURI);
        if (!helper.loadMetamodels()) {
            UMLValidateTest.fail((String)("Failed to loadMetamodels :\n" + helper.toString()));
        }
        if (!helper.loadDocument(oclURI)) {
            UMLValidateTest.fail((String)("Failed to loadDocument '" + oclURI + "'"));
        }
        helper.installPackages();
        helper.dispose();
        ocl.dispose();
    }

    public void test_umlValidation_432920() {
        this.resetRegistries();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initialize((ResourceSet)resourceSet, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            UMLValidateTest.assertNull((Object)UML2AS.initialize((ResourceSet)resourceSet));
        }
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet((ResourceSet)resourceSet);
        URI uri = this.getProjectFileURI("bug432920.uml");
        Resource umlResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(uri, true));
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)validationContext);
        Model umlModel = (Model)umlResource.getContents().get(0);
        Class umlClass1 = (Class)umlModel.getOwnedType("Class1");
        Property umlAttribute1 = umlClass1.getOwnedAttribute("Attribute1", null);
        ValueSpecification lowerValue = umlAttribute1.getLowerValue();
        ValueSpecification upperValue = umlAttribute1.getUpperValue();
        Profile umlProfile = ((ProfileApplication)umlModel.getProfileApplications().get(0)).getAppliedProfile();
        Stereotype umlMyClassExtension = (Stereotype)umlProfile.getOwnedType("MyClassExtension");
        Stereotype umlMyPropertyExtension = (Stereotype)umlProfile.getOwnedType("MyPropertyExtension");
        assert (lowerValue != null && upperValue != null && umlMyClassExtension != null && umlMyPropertyExtension != null);
        String string1 = NameUtil.qualifiedNameFor((Object)this.getStereotypeApplication((Element)upperValue, umlMyClassExtension));
        String string2 = NameUtil.qualifiedNameFor((Object)this.getStereotypeApplication((Element)upperValue, umlMyPropertyExtension));
        String string3 = NameUtil.qualifiedNameFor((Object)this.getStereotypeApplication((Element)lowerValue, umlMyClassExtension));
        String string4 = NameUtil.qualifiedNameFor((Object)this.getStereotypeApplication((Element)lowerValue, umlMyPropertyExtension));
        String string5 = NameUtil.qualifiedNameFor((Object)this.getStereotypeApplication((Element)umlAttribute1, umlMyPropertyExtension));
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, validationContext, StringUtil.bind((String)PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{"MyClassExtension", "ClassConstraint1", string1, StringUtil.bind((String)PivotMessages.IncompatibleOclAsTypeSourceType, (Object[])new Object[]{"UML::LiteralUnlimitedNatural", "UML::Class"})}), StringUtil.bind((String)PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{"MyPropertyExtension", "Constraint1", string2, StringUtil.bind((String)PivotMessages.IncompatibleOclAsTypeSourceType, (Object[])new Object[]{"UML::LiteralUnlimitedNatural", "UML::Property"})}), StringUtil.bind((String)PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{"MyClassExtension", "ClassConstraint1", string3, StringUtil.bind((String)PivotMessages.IncompatibleOclAsTypeSourceType, (Object[])new Object[]{"UML::LiteralInteger", "UML::Class"})}), StringUtil.bind((String)PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{"MyPropertyExtension", "Constraint1", string4, StringUtil.bind((String)PivotMessages.IncompatibleOclAsTypeSourceType, (Object[])new Object[]{"UML::LiteralInteger", "UML::Property"})}), StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"MyPropertyExtension::Constraint1", string5}), StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"MyPropertyExtension::Constraint2", string2}), StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"MyPropertyExtension::Constraint2", string4}));
        ocl.dispose();
    }

    public void test_umlValidation_434433() {
        this.resetRegistries();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initialize((ResourceSet)resourceSet, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            UMLValidateTest.assertNull((Object)UML2AS.initialize((ResourceSet)resourceSet));
        }
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet((ResourceSet)resourceSet);
        URI uri = this.getProjectFileURI("Bug434433.uml");
        Resource umlResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(uri, true));
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)validationContext);
        Model umlModel = (Model)umlResource.getContents().get(0);
        Class umlClass1 = (Class)umlModel.getOwnedType("Class1");
        Profile umlProfile = ((ProfileApplication)umlModel.getProfileApplications().get(0)).getAppliedProfile();
        Stereotype umlStereotype1 = (Stereotype)umlProfile.getOwnedType("Stereotype1");
        assert (umlClass1 != null && umlStereotype1 != null);
        String label = NameUtil.qualifiedNameFor((Object)this.getStereotypeApplication((Element)umlClass1, umlStereotype1));
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, validationContext, StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Stereotype1::Constraint3", label}));
        ocl.dispose();
    }

    public void test_umlValidation_Bug434356() {
        this.resetRegistries();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initialize((ResourceSet)resourceSet, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            UMLValidateTest.assertNull((Object)UML2AS.initialize((ResourceSet)resourceSet));
        }
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet((ResourceSet)resourceSet);
        URI uri = this.getProjectFileURI("Bug434356.uml");
        Resource umlResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(uri, true));
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)validationContext);
        Model umlModel = (Model)umlResource.getContents().get(0);
        Realization umlRealization1 = (Realization)umlModel.getPackagedElement("Realization1");
        Profile umlProfile = ((ProfileApplication)umlModel.getProfileApplications().get(0)).getAppliedProfile();
        Stereotype umlStereotype1 = (Stereotype)umlProfile.getOwnedType("ParentRealization");
        assert (umlRealization1 != null && umlStereotype1 != null);
        String label = NameUtil.qualifiedNameFor((Object)this.getStereotypeApplication((Element)umlRealization1, umlStereotype1));
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, validationContext, StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"ParentRealization::In case of a ParentRealization relationship, the supplier should be a child of the client", label}));
        ocl.dispose();
    }

    public void test_umlValidation_Bug436945() throws IOException {
        OCL ocl = this.createOCL();
        Resource umlResource = this.doLoadUML(ocl, "Bug436945");
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)validationContext);
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, validationContext, new String[0]);
        UMLValidateTest.assertUMLOCLValidationDiagnostics(ocl, "UML Load", umlResource, new String[0]);
        ocl.dispose();
        ocl = null;
    }

    public void test_umlValidation_446007() {
        OCL ocl = OCL.newInstance((ProjectManager)UMLValidateTest.getProjectMap());
        ResourceSet resourceSet = ocl.getResourceSet();
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            UMLValidateTest.assertNull((Object)UML2AS.initialize((ResourceSet)resourceSet));
        } else {
            UMLResourcesUtil.init((ResourceSet)resourceSet);
        }
        URI uri = this.getProjectFileURI("Bug446007.uml");
        Resource umlResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(uri, true));
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, new String[0]);
        URI oclURI = this.getProjectFileURI("Bug446007.ocl");
        LoaderWithLog helper = new LoaderWithLog(ocl.getEnvironmentFactory());
        EnvironmentFactory environmentFactory = helper.getEnvironmentFactory();
        ProjectManager projectMap = environmentFactory.getProjectManager();
        projectMap.configure(environmentFactory.getResourceSet(), StandaloneProjectMap.LoadGeneratedPackageStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
        Resource oclResource = helper.loadResource(oclURI);
        if (!helper.loadMetamodels()) {
            UMLValidateTest.fail((String)("Failed to loadMetamodels :\n" + helper.toString()));
        }
        if (!helper.loadDocument(oclURI)) {
            UMLValidateTest.fail((String)("Failed to loadDocument '" + oclURI + "'"));
        }
        helper.installPackages();
        Model umlModel = (Model)umlResource.getContents().get(0);
        Class umlClass1 = (Class)umlModel.getOwnedType("Class1");
        Stereotype appliedStereotype = umlClass1.getAppliedStereotype("Profile1::St1");
        EObject stereotypeApplication = umlClass1.getStereotypeApplication(appliedStereotype);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)umlModel, validationContext);
        diagnostics.addAll(diagnostic.getChildren());
        UMLValidateTest.assertDiagnostics("Loading", diagnostics, new String[0]);
        UMLValidateTest.assertUMLOCLValidationDiagnostics(ocl, "UML Load", umlResource, StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"St1::ff", NameUtil.qualifiedNameFor((Object)stereotypeApplication)}));
        helper.dispose();
        ocl.dispose();
    }

    public void test_umlValidation_Bug448470() throws IOException {
        this.resetRegistries();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            new CommonPreferenceInitializer().initializeDefaultPreferences();
        }
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet((ResourceSet)resourceSet);
        Resource umlResource = this.doLoadUML(ocl, "Bug448470");
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)validationContext);
        Model model = (Model)umlResource.getContents().get(0);
        Enumeration xx = (Enumeration)model.getOwnedType("Xx");
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, validationContext, StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"MyEnum::Constraint1", "\u00abMyEnum\u00bb" + LabelUtil.getLabel((Object)xx)}), StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"MyEnum::Constraint2", "\u00abMyEnum\u00bb" + LabelUtil.getLabel((Object)xx)}));
        UMLValidateTest.assertUMLOCLValidationDiagnostics(ocl, "UML Load", umlResource, StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"MyEnum::Constraint1", "\u00abMyEnum\u00bb" + LabelUtil.getLabel((Object)xx)}), StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"MyEnum::Constraint2", "\u00abMyEnum\u00bb" + LabelUtil.getLabel((Object)xx)}), EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"Constraint1", "\u00abMyEnum\u00bb" + LabelUtil.getLabel((Object)xx)}), EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"Constraint2", "\u00abMyEnum\u00bb" + LabelUtil.getLabel((Object)xx)}));
        ocl.dispose();
    }

    public void test_umlValidation_Bug452621() throws IOException {
        this.resetRegistries();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            new CommonPreferenceInitializer().initializeDefaultPreferences();
        }
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet((ResourceSet)resourceSet);
        Resource umlResource = this.doLoadUML(ocl, "Bug452621");
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)validationContext);
        Model model = (Model)umlResource.getContents().get(0);
        Type xx = model.getOwnedType("Class1");
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, validationContext, StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Stereotype1::unique_default_values", "\u00abStereotype1\u00bb" + LabelUtil.getLabel((Object)xx)}));
        UMLValidateTest.assertUMLOCLValidationDiagnostics(ocl, "UML Load", umlResource, StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Stereotype1::unique_default_values", "\u00abStereotype1\u00bb" + LabelUtil.getLabel((Object)xx)}), EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"unique_default_values", "\u00abStereotype1\u00bb" + LabelUtil.getLabel((Object)xx)}));
        ocl.dispose();
    }

    public void test_umlValidation_Bug458326() throws IOException {
        this.resetRegistries();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            new CommonPreferenceInitializer().initializeDefaultPreferences();
        }
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet((ResourceSet)resourceSet);
        Resource umlResource = this.doLoadUML(ocl, "Bug458326");
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)validationContext);
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, validationContext, new String[0]);
        UMLValidateTest.assertUMLOCLValidationDiagnostics(ocl, "UML Load", umlResource, new String[0]);
        ocl.dispose();
    }

    public void test_umlValidation_Bug458470() throws IOException {
        this.resetRegistries();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            new CommonPreferenceInitializer().initializeDefaultPreferences();
        }
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet((ResourceSet)resourceSet);
        Resource umlResource = this.doLoadUML(ocl, "Bug458470");
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)validationContext);
        Model model = (Model)umlResource.getContents().get(0);
        Package pack = model.getNestedPackage("Package2");
        Type xx = pack.getOwnedType("ClassWith");
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, validationContext, new String[0]);
        UMLValidateTest.assertUMLOCLValidationDiagnostics(ocl, "UML Load", umlResource, StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Stereotype1::Constraint1", "\u00abStereotype1\u00bb" + LabelUtil.getLabel((Object)xx)}), StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Stereotype2::Constraint2", "\u00abStereotype2\u00bb" + LabelUtil.getLabel((Object)xx)}));
        ocl.dispose();
    }

    public void test_umlValidation_Bug464808() throws IOException {
        this.resetRegistries();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            new CommonPreferenceInitializer().initializeDefaultPreferences();
        }
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet((ResourceSet)resourceSet);
        Resource umlResource = this.doLoadUML(ocl, "Bug464808");
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)validationContext);
        Model model = (Model)umlResource.getContents().get(0);
        Type xx = model.getOwnedType("Class1");
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, validationContext, StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Stereotype1::Constraint1", "\u00abStereotype1\u00bb" + LabelUtil.getLabel((Object)xx)}));
        UMLValidateTest.assertUMLOCLValidationDiagnostics(ocl, "UML Load", umlResource, StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Stereotype1::Constraint1", "\u00abStereotype1\u00bb" + LabelUtil.getLabel((Object)xx)}), EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"Constraint1", "\u00abStereotype1\u00bb" + LabelUtil.getLabel((Object)xx)}));
        ocl.dispose();
    }

    public void test_umlValidation_Bug467192() throws IOException {
        this.resetRegistries();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            new CommonPreferenceInitializer().initializeDefaultPreferences();
        }
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet((ResourceSet)resourceSet);
        Resource umlResource = this.doLoadUML(ocl, "Bug467192");
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)validationContext);
        Model model = (Model)umlResource.getContents().get(0);
        NamedElement xx = model.getOwnedMember("InstanceSpecification1");
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, validationContext, new String[0]);
        UMLValidateTest.assertUMLOCLValidationDiagnostics(ocl, "UML Load", umlResource, StringUtil.bind((String)PivotMessagesInternal.ParsingError, (Object[])new Object[]{"CustomPrimitiveTypes::Class1::SimpleDataTypeArithmetic::self.simpleDataTypeAttribute + self.simpleDataTypeAttribute <> self.simpleDataTypeAttribute ", "The 'Class1::SimpleDataTypeArithmetic' constraint is invalid: 'self.simpleDataTypeAttribute + self.simpleDataTypeAttribute <> self.simpleDataTypeAttribute'\n1: Unresolved Operation 'CustomPrimitiveTypes::SimpleDataType::+(CustomPrimitiveTypes::SimpleDataType)'"}), StringUtil.bind((String)PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{"Class1", "SimpleDataTypeArithmetic", LabelUtil.getLabel((Object)xx), StringUtil.bind((String)PivotMessagesInternal.FailedToEvaluate_ERROR_, (Object[])new Object[]{"OclInvalid::oclBadOperation() : OclInvalid[1]", "6.0", "self.simpleDataTypeAttribute.oclBadOperation(self.simpleDataTypeAttribute)"})}));
        ocl.dispose();
    }

    public void test_umlValidation_Bug472461() throws IOException {
        this.resetRegistries();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            new CommonPreferenceInitializer().initializeDefaultPreferences();
        }
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet((ResourceSet)resourceSet);
        Resource umlResource = this.doLoadUML(ocl, "Bug472461");
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)validationContext);
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, validationContext, new String[0]);
        UMLValidateTest.assertUMLOCLValidationDiagnostics(ocl, "UML Load", umlResource, new String[0]);
        ocl.dispose();
    }

    public void test_umlValidation_Bug472469() throws IOException {
        this.resetRegistries();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            new CommonPreferenceInitializer().initializeDefaultPreferences();
        }
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet((ResourceSet)resourceSet);
        Resource umlResource = this.doLoadUML(ocl, "Bug472469");
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)validationContext);
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, validationContext, new String[0]);
        UMLValidateTest.assertUMLOCLValidationDiagnostics(ocl, "UML Load", umlResource, new String[0]);
        ocl.dispose();
    }

    public void test_umlValidation_Bug476662() throws IOException {
        this.resetRegistries();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            new CommonPreferenceInitializer().initializeDefaultPreferences();
        }
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet((ResourceSet)resourceSet);
        Resource umlResource = this.doLoadUML(ocl, "Bug476662");
        UMLValidateTest.assertNoResourceErrors("Loading", umlResource);
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)validationContext);
        UMLValidateTest.assertValidationDiagnostics("Loading", umlResource, validationContext, new String[0]);
        UMLValidateTest.assertUMLOCLValidationDiagnostics(ocl, "UML Load", umlResource, new String[0]);
        ocl.dispose();
    }

    public static final class LoaderWithLog
    extends CompleteOCLLoader {
        StringBuilder s = new StringBuilder();

        public LoaderWithLog(@NonNull EnvironmentFactory environmentFactory) {
            super(environmentFactory);
        }

        protected boolean error(@NonNull String primaryMessage, @Nullable String detailMessage) {
            this.s.append("\n");
            this.s.append(primaryMessage);
            this.s.append("\n");
            this.s.append(detailMessage);
            return false;
        }

        public String toString() {
            return this.s.toString();
        }
    }
}

