/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.generic;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public abstract class GenericKeywordsTest
extends PivotTestSuite {
    @Override
    @NonNull
    protected MyOCL createOCL() {
        return new MyOCL(this.getTestPackageName(), this.getName());
    }

    public void test_isUnique_162300() {
        MyOCL ocl = this.createOCL();
        ocl.assertInvariant(ocl.property, "self.isUnique implies self.upper > 1");
        ocl.assertInvariant(ocl.property, "isUnique implies self.upper > 1");
        ocl.dispose();
    }

    public void test_package_162300() {
        MyOCL ocl = this.createOCL();
        ocl.assertInvariant(ocl.clazz, "self._package.oclIsUndefined() implies Set{VisibilityKind::protected, VisibilityKind::_package}->excludes(self.visibility)");
        ocl.assertInvariant(ocl.clazz, "_package.oclIsUndefined() implies Set{VisibilityKind::protected, VisibilityKind::_package}->excludes(self.visibility)");
        ocl.assertInvariant(ocl.clazz, "_'package'.oclIsUndefined() implies Set{VisibilityKind::protected, VisibilityKind::_package}->excludes(self.visibility)");
        ocl.dispose();
    }

    public void test_context_162300() {
        MyOCL ocl = this.createOCL();
        ocl.assertInvariant(ocl.constraint, "self._context <> null implies _context.oclIsKindOf(Class)");
        ocl.assertInvariant(ocl.constraint, "_context <> null implies self._context.oclIsKindOf(Class)");
        ocl.assertInvariant(ocl.constraint, "_'con''te' 'x'\n't' <> null implies self._context.oclIsKindOf(Class)");
        ocl.dispose();
    }

    public void test_contextOperation_162300() {
        MyOCL ocl = this.createOCL();
        ocl.assertInvariant(ocl.block, "self._context(self).name = 'Block'");
        ocl.assertInvariant(ocl.block, "_context(self).name = 'Block'");
        ocl.assertInvariant(ocl.block, "_'context'(self).name = 'Block'");
        ocl.dispose();
    }

    public void test_reservedPackageName_183362() {
        MyOCL ocl = this.createOCL();
        ocl.assertInvariant(ocl.block, "Smalltalk::runtime::_context::language.allInstances()->notEmpty()");
        ocl.dispose();
    }

    public void test_reservedPackageName_packageContext_183362() {
        MyOCL ocl = this.createOCL();
        ocl.createDocument("package Smalltalk::runtime::_context context language inv: true endpackage");
        ocl.dispose();
    }

    public void test_reservedClassName_183362() {
        MyOCL ocl = this.createOCL();
        ocl.assertInvariant(ocl.elseClass, "let e : _else = self in _else.allInstances()->forAll(oclIsKindOf(_else))");
        ocl.assertInvariant(ocl.elseClass, "self.oclIsKindOf(_context::_else)");
        ocl.dispose();
    }

    public void test_reservedClassName_operationContext_183362() {
        MyOCL ocl = this.createOCL();
        ocl.createDocument("package Smalltalk context runtime::_context::_else::doIt() : pre: true endpackage");
        ocl.createDocument("package Smalltalk::runtime::_context context _else::doIt() : pre: true endpackage");
        ocl.dispose();
    }

    public void test_unexpectedCharacter_283509() {
        MyOCL ocl = this.createOCL();
        try {
            ocl.createInvariant((EObject)ocl.property, "self = #self");
            GenericKeywordsTest.fail((String)"Missing exception");
        }
        catch (Exception e) {
            GenericKeywordsTest.assertEquals((String)"2:6 \"#\" unexpected character ignored", (String)e.getLocalizedMessage());
        }
        ocl.dispose();
    }

    public static class MyOCL
    extends TestOCL {
        Package smalltalk;
        Class collection;
        Class block;
        protected Class elseClass;
        Class clazz;
        Class property;
        Class constraint;

        public MyOCL(@NonNull String testPackageName, @NonNull String name) {
            super(testPackageName, name, OCL.NO_PROJECTS);
            MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
            StandardLibrary standardLibrary = metamodelManager.getStandardLibrary();
            this.smalltalk = PivotUtil.createPackage(Package.class, (EClass)((EClass)ClassUtil.nonNullEMF((Object)PivotPackage.Literals.PACKAGE)), (String)"Smalltalk", null, null);
            this.registerPackage(this.smalltalk, "st", "foo://smalltalk");
            Class object = this.createOwnedClass(this.smalltalk, "Object", false);
            this.collection = this.createOwnedClass(this.smalltalk, "Collection", false);
            this.block = this.createOwnedClass(this.smalltalk, "Block", false);
            this.clazz = this.createOwnedClass(this.smalltalk, "Class", false);
            this.property = this.createOwnedClass(this.smalltalk, "Property", false);
            this.constraint = this.createOwnedClass(this.smalltalk, "Constraint", false);
            this.addSupertype(this.constraint, object);
            this.addSupertype(this.property, object);
            this.addSupertype(this.clazz, object);
            this.addSupertype(this.block, object);
            this.addSupertype(this.collection, object);
            Enumeration visibilityKind = this.createOwnedEnumeration(this.smalltalk, "VisibilityKind");
            this.createOwnedLiteral(visibilityKind, "public");
            this.createOwnedLiteral(visibilityKind, "protected");
            this.createOwnedLiteral(visibilityKind, "package");
            this.createOwnedLiteral(visibilityKind, "private");
            this.createOwnedAttribute(this.clazz, "name", (Type)standardLibrary.getStringType());
            this.createOwnedAttribute(this.clazz, "visibility", (Type)visibilityKind);
            this.createOwnedReference(this.clazz, "package", object);
            this.createOwnedAttribute(this.property, "isUnique", (Type)standardLibrary.getBooleanType());
            this.createOwnedAttribute(this.property, "upper", (Type)standardLibrary.getIntegerType());
            this.createOwnedReference(this.constraint, "context", this.clazz);
            BasicEList names = new BasicEList(1);
            BasicEList types = new BasicEList(1);
            names.add((Object)"object");
            types.add((Object)object);
            this.createOwnedOperation(this.block, "context", (List<String>)names, (List<Type>)types, (Type)this.clazz, true);
            names.set(0, (Object)"block");
            types.set(0, (Object)this.block);
            this.createOwnedOperation(this.collection, "isUnique", (List<String>)names, (List<Type>)types, (Type)standardLibrary.getBooleanType(), true);
            this.createOwnedOperation(this.collection, "select", (List<String>)names, (List<Type>)types, (Type)this.collection, true);
            names.clear();
            types.clear();
            this.createOwnedOperation(this.collection, "isEmpty", (List<String>)names, (List<Type>)types, (Type)standardLibrary.getBooleanType(), true);
            Package nested = PivotUtil.createOwnedPackage((Package)this.smalltalk, (String)"runtime");
            Package contextPackage = PivotUtil.createOwnedPackage((Package)nested, (String)"context");
            this.createOwnedClass(contextPackage, "language", false);
            this.elseClass = this.createOwnedClass(contextPackage, "else", false);
            this.createOwnedOperation(this.elseClass, "doIt", null, null, null, false);
        }
    }
}

