/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.File;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IURIEditorInput;

public class EMFURIEditorInput
implements IURIEditorInput {
    private final URI emfURI;

    public EMFURIEditorInput(URI emfURI) {
        this.emfURI = emfURI;
    }

    public int hashCode() {
        return this.emfURI.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof EMFURIEditorInput && this.emfURI.equals(((EMFURIEditorInput)o).emfURI);
    }

    public URI getEMFURI() {
        return this.emfURI;
    }

    public java.net.URI getURI() {
        try {
            return new java.net.URI(this.emfURI.toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean exists() {
        if (this.emfURI.isFile()) {
            return new File(this.emfURI.toFileString()).exists();
        }
        if (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
            return EclipseUtil.exists(this.emfURI);
        }
        return false;
    }

    public String getName() {
        return URI.decode((String)(this.emfURI.isHierarchical() && this.emfURI.lastSegment() != null ? this.emfURI.lastSegment() : this.emfURI.toString()));
    }

    public String getToolTipText() {
        return this.emfURI.toString();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        Object result;
        if (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE && (result = EclipseUtil.getAdatper(adapter, this.emfURI)) != null) {
            return result;
        }
        return null;
    }

    protected String getBundleSymbolicName() {
        return CommonUIPlugin.getPlugin().getSymbolicName();
    }

    protected static class EclipseUtil {
        protected EclipseUtil() {
        }

        public static Object getAdatper(Class<?> adapter, URI uri) {
            if ((adapter == IFile.class || adapter == IResource.class) && uri.isPlatformResource()) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
            }
            return null;
        }

        public static boolean exists(URI uri) {
            if (uri.isPlatformResource()) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))).exists();
            }
            return false;
        }
    }
}

