/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.common.internal.options.CommonOptions;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCase;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.GlobalEnvironmentFactory;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.util.PivotValidator;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.Query;
import org.eclipse.ocl.pivot.utilities.ValueUtil;

public class OCLinEcoreTutorialExamples
extends PivotTestCase {
    private ResourceSet resourceSet;

    public void testOCLinEcoreTutorialUsingLPGForLPG() throws Exception {
        GlobalEnvironmentFactory.disposeInstance();
        org.eclipse.ocl.ecore.OCL.initialize((ResourceSet)this.resourceSet);
        OCLDelegateDomain.initialize((ResourceSet)this.resourceSet);
        this.doTestOCLinEcoreTutorialUsingLPG(this.getTestModelURI("model/OCLinEcoreTutorialForLPG.xmi"), true);
        GlobalEnvironmentFactory.disposeInstance();
    }

    public void testOCLinEcoreTutorialUsingLPGForPivot() throws Exception {
        GlobalEnvironmentFactory.disposeInstance();
        GlobalEnvironmentFactory.getInstance().setSafeNavigationValidationSeverity(StatusCodes.Severity.IGNORE);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initialize((ResourceSet)this.resourceSet, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        this.doTestOCLinEcoreTutorialUsingLPG(this.getTestModelURI("model/OCLinEcoreTutorialForPivot.xmi"), true);
        GlobalEnvironmentFactory.disposeInstance();
    }

    public void testOCLinEcoreTutorialUsingPivotForLPG() throws Exception {
        GlobalEnvironmentFactory.disposeInstance();
        OCLDelegateDomain.initialize((ResourceSet)this.resourceSet);
        this.doTestOCLinEcoreTutorialUsingPivot(this.getTestModelURI("model/OCLinEcoreTutorialForLPG.xmi"));
        GlobalEnvironmentFactory.disposeInstance();
    }

    public void testOCLinEcoreTutorialUsingPivotForPivot() throws Exception {
        GlobalEnvironmentFactory.disposeInstance();
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initialize((ResourceSet)this.resourceSet, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        this.doTestOCLinEcoreTutorialUsingPivot(this.getTestModelURI("model/OCLinEcoreTutorialForPivot.xmi"));
        GlobalEnvironmentFactory.disposeInstance();
    }

    public void testOCLinEcoreTutorialUsingLPGForDefault() throws Exception {
        GlobalEnvironmentFactory.disposeInstance();
        GlobalEnvironmentFactory.getInstance().setSafeNavigationValidationSeverity(StatusCodes.Severity.IGNORE);
        OCLDelegateDomain.initialize((ResourceSet)this.resourceSet);
        this.doTestOCLinEcoreTutorialUsingLPG(this.getTestModelURI("model/OCLinEcoreTutorial.xmi"), true);
        GlobalEnvironmentFactory.disposeInstance();
    }

    public void testOCLinEcoreTutorialUsingPivotForDefault() throws Exception {
        GlobalEnvironmentFactory.disposeInstance();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        OCLDelegateDomain.initialize((ResourceSet)this.resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initialize((ResourceSet)this.resourceSet, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        this.doTestOCLinEcoreTutorialUsingPivot(this.getTestModelURI("model/OCLinEcoreTutorial.xmi"));
        GlobalEnvironmentFactory.disposeInstance();
    }

    protected void doTestOCLinEcoreTutorialUsingLPG(URI testModelURI, boolean isLPG) throws Exception {
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new EcoreResourceFactoryImpl());
        URIConverter.URI_MAP.put(URI.createURI((String)"http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore"), URI.createPlatformPluginURI((String)"/org.eclipse.ocl.ecore/model/oclstdlib.ecore", (boolean)true));
        Resource xmiResource = this.resourceSet.getResource(testModelURI, true);
        EObject xmiLibrary = (EObject)xmiResource.getContents().get(0);
        EClass ecoreLibrary = xmiLibrary.eClass();
        if (isLPG) {
            this.removeSafeNavigationOperatorsForLPG(ecoreLibrary.eResource());
        }
        EStructuralFeature ecoreBooks = ecoreLibrary.getEStructuralFeature("books");
        EClass ecoreBook = (EClass)ecoreBooks.getEType();
        EStructuralFeature bookName = ecoreBook.getEStructuralFeature("name");
        EStructuralFeature bookCopies = ecoreBook.getEStructuralFeature("copies");
        EStructuralFeature bookLoans = ecoreBook.getEStructuralFeature("loans");
        EOperation bookIsAvailable = (EOperation)NameUtil.getENamedElement((Iterable)ecoreBook.getEOperations(), (String)"isAvailable");
        List xmiBooks = (List)xmiLibrary.eGet(ecoreBooks);
        EObject b2Book = null;
        for (EObject xmiBook : xmiBooks) {
            if (!xmiBook.eGet(bookName).equals("b2")) continue;
            b2Book = xmiBook;
        }
        if (b2Book == null) {
            OCLinEcoreTutorialExamples.fail();
            return;
        }
        EcoreEnvironmentFactory environmentFactory = new EcoreEnvironmentFactory(this.resourceSet.getPackageRegistry());
        org.eclipse.ocl.ecore.OCL ocl = org.eclipse.ocl.ecore.OCL.newInstance((EnvironmentFactory)environmentFactory);
        OCL.Helper helper = ocl.createOCLHelper();
        Object b2Copies = b2Book.eGet(bookCopies);
        OCLinEcoreTutorialExamples.assertEquals((int)2, (int)((Number)b2Copies).intValue());
        Object b2Loans = b2Book.eGet(bookLoans);
        OCLinEcoreTutorialExamples.assertEquals((int)3, (int)((List)b2Loans).size());
        Object b2IsAvailable = b2Book.eInvoke(bookIsAvailable, (EList)new BasicEList());
        OCLinEcoreTutorialExamples.assertEquals((boolean)false, (boolean)((Boolean)b2IsAvailable));
        helper.setContext((Object)b2Book.eClass());
        org.eclipse.ocl.ecore.OCLExpression query = helper.createQuery("isAvailable()");
        OCL.Query queryEval = ocl.createQuery((OCLExpression)query);
        Object b2Available = queryEval.evaluate((Object)b2Book);
        OCLinEcoreTutorialExamples.assertFalse((boolean)((Boolean)b2Available));
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        Diagnostic diagnostics = Diagnostician.INSTANCE.validate(xmiLibrary, validationContext);
        OCLinEcoreTutorialExamples.assertEquals((int)3, (int)diagnostics.getChildren().size());
        b2Book.eSet(bookCopies, (Object)BigInteger.valueOf(4L));
        b2Available = queryEval.evaluate((Object)b2Book);
        OCLinEcoreTutorialExamples.assertTrue((boolean)((Boolean)b2Available));
        diagnostics = Diagnostician.INSTANCE.validate(xmiLibrary, validationContext);
        OCLinEcoreTutorialExamples.assertEquals((int)2, (int)diagnostics.getChildren().size());
        b2Book.eSet(bookCopies, (Object)BigInteger.valueOf(3L));
        b2Available = queryEval.evaluate((Object)b2Book);
        OCLinEcoreTutorialExamples.assertFalse((boolean)((Boolean)b2Available));
        List b2loans = (List)b2Book.eGet(bookLoans);
        OCLinEcoreTutorialExamples.assertEquals((int)3, (int)b2loans.size());
        OCLinEcoreTutorialExamples.assertTrue((boolean)(b2loans.get(1) instanceof EObject));
        ocl.dispose();
    }

    protected void doTestOCLinEcoreTutorialUsingPivot(URI testModelURI) throws Exception {
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new EcoreResourceFactoryImpl());
        Resource xmiResource = this.resourceSet.getResource(testModelURI, true);
        EObject xmiLibrary = (EObject)xmiResource.getContents().get(0);
        EClass ecoreLibrary = xmiLibrary.eClass();
        EStructuralFeature ecoreBooks = ecoreLibrary.getEStructuralFeature("books");
        EClass ecoreBook = (EClass)ecoreBooks.getEType();
        EStructuralFeature bookName = ecoreBook.getEStructuralFeature("name");
        EStructuralFeature bookCopies = ecoreBook.getEStructuralFeature("copies");
        EStructuralFeature bookLoans = ecoreBook.getEStructuralFeature("loans");
        EOperation bookIsAvailable = (EOperation)NameUtil.getENamedElement((Iterable)ecoreBook.getEOperations(), (String)"isAvailable");
        List xmiBooks = (List)xmiLibrary.eGet(ecoreBooks);
        EObject b2Book = null;
        for (EObject xmiBook : xmiBooks) {
            if (!xmiBook.eGet(bookName).equals("b2")) continue;
            b2Book = xmiBook;
        }
        if (b2Book == null) {
            OCLinEcoreTutorialExamples.fail();
            return;
        }
        OCL ocl = OCL.newInstance((EPackage.Registry)this.resourceSet.getPackageRegistry());
        try {
            Ecore2AS ecore2as = Ecore2AS.getAdapter((Resource)b2Book.eClass().eResource(), (EnvironmentFactoryInternal)((EnvironmentFactoryInternal)ocl.getEnvironmentFactory()));
            Class bookType = (Class)ecore2as.getCreated(Class.class, (EObject)b2Book.eClass());
            Object b2Copies = b2Book.eGet(bookCopies);
            OCLinEcoreTutorialExamples.assertEquals((int)2, (int)((Number)b2Copies).intValue());
            Object b2Loans = b2Book.eGet(bookLoans);
            OCLinEcoreTutorialExamples.assertEquals((int)3, (int)((List)b2Loans).size());
            Object b2IsAvailable = b2Book.eInvoke(bookIsAvailable, (EList)new BasicEList());
            OCLinEcoreTutorialExamples.assertEquals((boolean)false, (boolean)((Boolean)b2IsAvailable));
            ExpressionInOCL query = ocl.createQuery((EObject)bookType, "isAvailable()");
            Query queryEval = ocl.createQuery(query);
            Object b2Available = queryEval.evaluateEcore((Object)b2Book);
            OCLinEcoreTutorialExamples.assertFalse((boolean)ValueUtil.asBoolean((Object)b2Available));
            Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
            Diagnostic diagnostics = Diagnostician.INSTANCE.validate(xmiLibrary, validationContext);
            OCLinEcoreTutorialExamples.assertEquals((int)3, (int)diagnostics.getChildren().size());
            b2Book.eSet(bookCopies, (Object)BigInteger.valueOf(4L));
            b2Available = queryEval.evaluateEcore((Object)b2Book);
            OCLinEcoreTutorialExamples.assertTrue((boolean)ValueUtil.asBoolean((Object)b2Available));
            diagnostics = Diagnostician.INSTANCE.validate(xmiLibrary, validationContext);
            OCLinEcoreTutorialExamples.assertEquals((int)2, (int)diagnostics.getChildren().size());
            b2Book.eSet(bookCopies, (Object)BigInteger.valueOf(3L));
            b2Available = queryEval.evaluateEcore((Object)b2Book);
            OCLinEcoreTutorialExamples.assertFalse((boolean)ValueUtil.asBoolean((Object)b2Available));
            List b2loans = (List)b2Book.eGet(bookLoans);
            OCLinEcoreTutorialExamples.assertEquals((int)3, (int)b2loans.size());
            OCLinEcoreTutorialExamples.assertTrue((boolean)(b2loans.get(1) instanceof EObject));
        }
        finally {
            ocl.dispose();
        }
    }

    protected void removeSafeNavigationOperatorsForLPG(@NonNull Resource eResource) {
        TreeIterator tit = eResource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof EAnnotation)) continue;
            EAnnotation eAnnotation = (EAnnotation)eObject;
            if (OCLCommon.isDelegateURI((String)eAnnotation.getSource())) {
                EMap details = eAnnotation.getDetails();
                for (String key : details.keySet()) {
                    String value = (String)details.get((Object)key);
                    String unsafeValue = value.replace("?.", ".").replace("?->", "->");
                    if (ClassUtil.safeEquals((Object)unsafeValue, (Object)value)) continue;
                    details.put((Object)key, (Object)unsafeValue);
                }
            }
            tit.prune();
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.resetRegistries();
        OCLstdlib.install();
        OCLinEcoreTutorialExamples.doEssentialOCLSetup();
        this.resourceSet = new ResourceSetImpl();
    }

    @Override
    protected void tearDown() throws Exception {
        OCLinEcoreTutorialExamples.unloadResourceSet(this.resourceSet);
        this.resourceSet = null;
        EValidator.Registry.INSTANCE.put((Object)PivotPackage.eINSTANCE, (Object)PivotValidator.INSTANCE);
        super.tearDown();
    }
}

