/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.basecs.RootPackageCS;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtext.resource.XtextResource;

public class SerializeTests
extends XtextTestCase {
    protected Map<Object, Object> createLoadedEcoreOptions() {
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put(ResourceSetInitializer.class, new ResourceSetInitializer(){

            @Override
            public void initializeResourceSet(@NonNull ResourceSet resourceSet) {
                URI ecoreURI;
                ProjectManager.IPackageDescriptor packageDescriptor;
                ProjectManager.IProjectDescriptor projectDescriptor = SerializeTests.getProjectMap().getProjectDescriptor("org.eclipse.emf.ecore");
                if (projectDescriptor != null && (packageDescriptor = projectDescriptor.getPackageDescriptor(ecoreURI = URI.createURI((String)"http://www.eclipse.org/emf/2002/Ecore"))) != null) {
                    packageDescriptor.configure(resourceSet, StandaloneProjectMap.LoadGeneratedPackageStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
                }
            }
        });
        return options;
    }

    public XtextResource doSerialize(@NonNull OCL ocl, @NonNull String stem) throws Exception {
        return this.doSerialize(ocl, stem, stem, null, true, true);
    }

    public XtextResource doSerialize(@NonNull OCL ocl, @NonNull String stem, @NonNull String referenceStem, @Nullable Map<Object, Object> options, boolean doCompare, boolean validateSaved) throws Exception {
        String inputName = String.valueOf(stem) + ".ecore";
        URI inputURI = this.getProjectFileURI(inputName);
        String referenceName = String.valueOf(referenceStem) + ".ecore";
        URI referenceURI = this.getProjectFileURI(referenceName);
        return this.doSerialize(ocl, inputURI, stem, referenceURI, options, doCompare, validateSaved);
    }

    public XtextResource doSerialize(@NonNull OCL ocl, @NonNull URI inputURI, @NonNull String stem, @NonNull URI referenceURI, @Nullable Map<Object, Object> options, boolean doCompare, boolean validateSaved) throws Exception {
        ResourceSetInitializer resourceSetInitializer = options != null ? (ResourceSetInitializer)options.get(ResourceSetInitializer.class) : null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        SerializeTests.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
        String outputName = String.valueOf(stem) + ".serialized.oclinecore";
        URI outputURI = this.getProjectFileURI(outputName);
        Resource ecoreResource = this.loadEcore(inputURI);
        OCL ocl1 = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        XtextResource xtextResource1 = null;
        try {
            if (resourceSetInitializer != null) {
                resourceSetInitializer.initializeResourceSet(ocl1.getResourceSet());
            }
            ASResource asResource = ocl1.ecore2as(ecoreResource);
            SerializeTests.assertNoResourceErrors("Normalisation failed", (Resource)asResource);
            SerializeTests.assertNoValidationErrors("Normalisation invalid", (Resource)asResource);
            xtextResource1 = SerializeTests.as2cs(ocl1, (ResourceSet)resourceSet, asResource, outputURI);
            resourceSet.getResources().clear();
        }
        finally {
            ocl1.dispose();
            ocl1 = null;
        }
        OCL ocl2 = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        try {
            Object cs2asErrors;
            if (resourceSetInitializer != null) {
                resourceSetInitializer.initializeResourceSet(ocl2.getResourceSet());
            }
            BaseCSResource xtextResource2 = (BaseCSResource)resourceSet.createResource(outputURI);
            ocl2.getEnvironmentFactory().adapt((Notifier)xtextResource2);
            xtextResource2.load(null);
            Object object = cs2asErrors = options != null ? options.get("cs2asErrors") : null;
            if (cs2asErrors != null) {
                SerializeTests.assertResourceErrors("Reload failed", (Resource)xtextResource2, cs2asErrors.toString());
            } else {
                SerializeTests.assertNoResourceErrors("Reload failed", (Resource)xtextResource2);
                SerializeTests.assertNoUnresolvedProxies("unresolved reload proxies", (Resource)xtextResource2);
            }
            String pivotName2 = String.valueOf(stem) + "2.ecore.oclas";
            URI pivotURI2 = this.getProjectFileURI(pivotName2);
            Resource pivotResource2 = SerializeTests.cs2as(ocl2, (CSResource)xtextResource2, pivotURI2);
            String inputName2 = String.valueOf(stem) + "2.ecore";
            URI ecoreURI2 = this.getProjectFileURI(inputName2);
            Resource ecoreResource2 = SerializeTests.as2ecore(ocl2, pivotResource2, ecoreURI2, validateSaved);
            Resource referenceResource = this.loadEcore(referenceURI);
            if (doCompare) {
                TestUtil.assertSameModel(referenceResource, ecoreResource2);
            }
            XtextResource xtextResource = xtextResource1;
            return xtextResource;
        }
        finally {
            ocl2.dispose();
            ocl2 = null;
        }
    }

    public XtextResource doSerializeUML(@NonNull OCL ocl, @NonNull String stem) throws Exception {
        UMLPackage.eINSTANCE.getClass();
        String inputName = String.valueOf(stem) + ".uml";
        URI inputURI = this.getProjectFileURI(inputName);
        Resource umlResource = this.loadUML(ocl, inputURI);
        OCLInternal ocl1 = OCLInternal.newInstance((ProjectManager)SerializeTests.getProjectMap(), null);
        UML2AS.initialize((ResourceSet)ocl1.getResourceSet());
        XtextResource xtextResource = null;
        try {
            MetamodelManagerInternal metamodelManager1 = ocl1.getMetamodelManager();
            Resource resource = this.getPivotFromUML(metamodelManager1, umlResource);
        }
        finally {
            ocl1.dispose();
            ocl1 = null;
        }
        return xtextResource;
    }

    protected Resource getPivotFromUML(MetamodelManagerInternal metamodelManager, @NonNull Resource umlResource) throws ParserException {
        UML2AS uml2as = UML2AS.getAdapter((Resource)umlResource, (EnvironmentFactoryInternal)metamodelManager.getEnvironmentFactory());
        Model pivotModel = uml2as.getASModel();
        Resource asResource = (Resource)ClassUtil.nonNullState((Object)pivotModel.eResource());
        SerializeTests.assertNoResourceErrors("Normalisation failed", asResource);
        SerializeTests.assertNoValidationErrors("Normalisation invalid", asResource);
        return asResource;
    }

    @NonNull
    protected Resource loadUML(@NonNull OCL ocl, @NonNull URI inputURI) {
        Resource umlResource = ocl.getResourceSet().getResource(inputURI, true);
        this.mapOwnURI(umlResource);
        SerializeTests.assertNoResourceErrors("Load failed", umlResource);
        return umlResource;
    }

    public void testSerialize_Bug320689() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        this.doSerialize(ocl, "Bug320689");
        ocl.dispose();
    }

    public void testSerialize_Bug323741() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        this.doSerialize(ocl, "Bug323741");
        ocl.dispose();
    }

    public void testSerialize_Bug354336() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        this.doSerialize(ocl, "Bug354336", "Bug354336", null, false, true);
        ocl.dispose();
    }

    public void testSerialize_Bug362620() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        this.doSerialize(ocl, "Bug362620");
        ocl.dispose();
    }

    public void testSerialize_Bug376488() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        this.doSerialize(ocl, "Bug376488", "Bug376488", null, true, false);
        ocl.dispose();
    }

    public void testSerialize_Bug388282() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"rootPackage\" nsURI=\"http://www.example.com/rootPackage/1.0\"\n    nsPrefix=\"rootPackage\">\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"Element\" abstract=\"true\">\n    <eStructuralFeatures xsi:type=\"ecore:EAttribute\" name=\"name\" lowerBound=\"1\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EString\"\n        defaultValueLiteral=\"\"/>\n  </eClassifiers>\n  <eSubpackages name=\"subPackage\" nsURI=\"http://www.example.com/subPackage/1.0\" nsPrefix=\"subPackage\">\n    <eClassifiers xsi:type=\"ecore:EClass\" name=\"Element\" abstract=\"true\" eSuperTypes=\"#//Element\"/>\n  </eSubpackages>\n</ecore:EPackage>\n\n";
        this.createOCLinEcoreFile("Bug388282.ecore", testFile);
        this.doSerialize(ocl, "Bug388282");
        ocl.dispose();
    }

    public void testSerialize_Bug397917() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n   xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"test1\" nsURI=\"http://test1/1.0\" nsPrefix=\"test1\">\n <eClassifiers xsi:type=\"ecore:EClass\" name=\"Model\">\n   <eStructuralFeatures xsi:type=\"ecore:EReference\" name=\"node\" upperBound=\"-1\" eType=\"#//Node\" containment=\"true\"/>\n   <eStructuralFeatures xsi:type=\"ecore:EReference\" name=\"link\" upperBound=\"-1\" eType=\"#//Link\" containment=\"true\"/>\n </eClassifiers>\n <eClassifiers xsi:type=\"ecore:EClass\" name=\"Node\">\n   <eStructuralFeatures xsi:type=\"ecore:EAttribute\" name=\"uuid\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EString\" iD=\"true\"/>\n   <eStructuralFeatures xsi:type=\"ecore:EReference\" name=\"outgoing\" eType=\"#//Link\" eOpposite=\"#//Link/from\" eKeys=\"#//Link/uuid\"/>\n   <eStructuralFeatures xsi:type=\"ecore:EReference\" name=\"incoming\" eType=\"#//Link\" eOpposite=\"#//Link/to\" eKeys=\"#//Link/uuid\"/>\n </eClassifiers>\n <eClassifiers xsi:type=\"ecore:EClass\" name=\"Link\">\n   <eStructuralFeatures xsi:type=\"ecore:EAttribute\" name=\"uuid\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EString\" defaultValueLiteral=\"\" iD=\"true\"/>\n   <eStructuralFeatures xsi:type=\"ecore:EReference\" name=\"from\" lowerBound=\"1\" eType=\"#//Node\" eOpposite=\"#//Node/outgoing\" eKeys=\"#//Node/uuid\"/>\n   <eStructuralFeatures xsi:type=\"ecore:EReference\" name=\"to\" lowerBound=\"1\" eType=\"#//Node\" eOpposite=\"#//Node/incoming\" eKeys=\"#//Node/uuid\"/>\n </eClassifiers>\n</ecore:EPackage>";
        this.createOCLinEcoreFile("Bug397917.ecore", testFile);
        this.doSerialize(ocl, "Bug397917");
        ocl.dispose();
    }

    public void testSerialize_Bug404493() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"company\" nsURI=\"http://www.eclipse.org/ocl/test/Pivot/Company.ecore\"\n    nsPrefix=\"co\">\n  <eAnnotations source=\"http://www.eclipse.org/emf/2002/Ecore\">\n    <details key=\"invocationDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n    <details key=\"settingDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n    <details key=\"validationDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n  </eAnnotations>\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"Employee\">\n    <eStructuralFeatures xsi:type=\"ecore:EAttribute\" name=\"name\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EString\"/>\n    <eStructuralFeatures xsi:type=\"ecore:EAttribute\" name=\"hasNameAsAttribute\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EBoolean\"\n        changeable=\"false\" volatile=\"true\" transient=\"true\" derived=\"true\">\n      <eAnnotations source=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\">\n        <details key=\"derivation\" value=\"name &lt;> null -- trailing comment\"/>\n      </eAnnotations>\n    </eStructuralFeatures>\n  </eClassifiers>\n</ecore:EPackage>\n";
        this.createOCLinEcoreFile("Bug404493.ecore", testFile);
        this.doSerialize(ocl, "Bug404493", "Bug404493", null, false, true);
        ocl.dispose();
    }

    public void testSerialize_Bug425506() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"p\" nsURI=\"p\" nsPrefix=\"p\">\n  <eAnnotations source=\"http://www.eclipse.org/emf/2002/Ecore\">\n    <details key=\"invocationDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n    <details key=\"settingDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n    <details key=\"validationDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n  </eAnnotations>\n  <eAnnotations source=\"http://www.eclipse.org/OCL/Import\">\n    <details key=\"ecore\" value=\"http://www.eclipse.org/emf/2002/Ecore\"/>\n  </eAnnotations>\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"A\">\n    <eAnnotations source=\"http://www.eclipse.org/emf/2002/Ecore\">\n      <details key=\"constraints\" value=\"inv2\"/>\n    </eAnnotations>\n    <eAnnotations source=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\">\n      <details key=\"inv2\" value=\"true\"/>\n    </eAnnotations>\n    <eOperations name=\"f\">\n      <eAnnotations source=\"http://www.eclipse.org/emf/2002/GenModel\">\n        <details key=\"documentation\" value=\"function doc\"/>\n        <details key=\"body\" value=\"return 1;\"/>\n      </eAnnotations>\n    </eOperations>\n    <eOperations name=\"inv\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EBoolean\">\n      <eAnnotations source=\"http://www.eclipse.org/emf/2002/GenModel\">\n        <details key=\"documentation\" value=\"invariant doc\"/>\n        <details key=\"body\" value=\"return 1;\"/>\n      </eAnnotations>\n      <eParameters name=\"diagnostics\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EDiagnosticChain\"/>\n      <eParameters name=\"context\">\n        <eGenericType eClassifier=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EMap\">\n          <eTypeArguments eClassifier=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EJavaObject\"/>\n          <eTypeArguments eClassifier=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EJavaObject\"/>\n        </eGenericType>\n      </eParameters>\n    </eOperations>\n  </eClassifiers>\n</ecore:EPackage>\n";
        this.createOCLinEcoreFile("Bug425506.ecore", testFile);
        this.doSerialize(ocl, "Bug425506", "Bug425506", null, true, true);
        ocl.dispose();
    }

    public void testSerialize_Bug457043() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\"\n    name=\"bug457043\" nsURI=\"http://bug/457043\" nsPrefix=\"bug\">\n  <eAnnotations source=\"http://www.eclipse.org/emf/2002/GenModel\">\n    <details key=\"documentation\"/>\n  </eAnnotations>\n</ecore:EPackage>\n";
        this.createOCLinEcoreFile("Bug457043.ecore", testFile);
        this.doSerialize(ocl, "Bug457043", "Bug457043", null, true, true);
        ocl.dispose();
    }

    public void testSerialize_Bug463877() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"my\" nsURI=\"http://my\" nsPrefix=\"my\">\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"Node\">\n    <eStructuralFeatures xsi:type=\"ecore:EReference\"/>\n  </eClassifiers>\n</ecore:EPackage>\n";
        this.createOCLinEcoreFile("Bug463877.ecore", testFile);
        this.doSerialize(ocl, "Bug463877", "Bug463877", null, false, false);
        ocl.dispose();
    }

    public void testSerialize_Bug464062() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"env\" nsURI=\"http://cs2as/tests/example2/env/1.0\" nsPrefix=\"env\">\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"Environment\">\n    <eOperations name=\"addElements\" eType=\"#//Environment\">\n      <eTypeParameters name=\"E\">\n        <eBounds eClassifier=\"#//Element\"/>\n      </eTypeParameters>\n      <eParameters name=\"elements\" upperBound=\"-1\">\n        <eGenericType eTypeParameter=\"#//Environment/addElements/E\"/>\n      </eParameters>\n    </eOperations>\n  </eClassifiers>\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"Element\" abstract=\"true\"/>\n</ecore:EPackage>\n";
        this.createOCLinEcoreFile("Bug464062.ecore", testFile);
        this.doSerialize(ocl, "Bug464062");
        ocl.dispose();
    }

    public void testSerialize_Company() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        this.doSerialize(ocl, "Company", "Company.reference", null, true, true);
        ocl.dispose();
    }

    public void testSerialize_ConstraintMessages() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        this.doSerialize(ocl, "ConstraintMessages", "ConstraintMessages.reference", null, true, true);
        ocl.dispose();
    }

    public void testSerialize_Ecore() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        this.doSerialize(ocl, "Ecore");
        ocl.dispose();
    }

    public void testSerialize_Imports() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        XtextResource xtextResource = this.doSerialize(ocl, "Imports");
        RootPackageCS documentCS = (RootPackageCS)xtextResource.getContents().get(0);
        EList imports = documentCS.getOwnedImports();
        SerializeTests.assertEquals((String)"One import", (int)1, (int)imports.size());
        ocl.dispose();
    }

    public void testSerialize_Keys() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        this.doSerialize(ocl, "Keys");
        ocl.dispose();
    }

    public void testSerialize_Names() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        this.doSerialize(ocl, "Names");
        ocl.dispose();
    }

    public void testSerialize_BaseCST() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        URI uri = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.xtext.base/model/BaseCS.ecore", (boolean)true);
        String stem = uri.trimFileExtension().lastSegment();
        this.doSerialize(ocl, uri, stem, uri, null, false, true);
        ocl.dispose();
    }

    public void testSerialize_EssentialOCLCST() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        URI uri = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.xtext.essentialocl/model/EssentialOCLCS.ecore", (boolean)true);
        String stem = uri.trimFileExtension().lastSegment();
        Map<Object, Object> options = this.createLoadedEcoreOptions();
        this.doSerialize(ocl, uri, stem, uri, options, false, true);
    }

    public void testSerialize_OCLinEcoreCST() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        URI uri = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.xtext.oclinecore/model/OCLinEcoreCS.ecore", (boolean)true);
        String stem = uri.trimFileExtension().lastSegment();
        Map<Object, Object> options = this.createLoadedEcoreOptions();
        this.doSerialize(ocl, uri, stem, uri, options, false, true);
        ocl.dispose();
    }

    public void testSerialize_OCLstdlib() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        this.doSerialize(ocl, "OCLstdlib");
        ocl.dispose();
    }

    public void testSerialize_OCLCST() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        this.doSerialize(ocl, "OCLCST");
        ocl.dispose();
    }

    public void testSerialize_RoyalAndLoyal_ecore() throws Exception {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
            URI inputURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.project.royalandloyal/oclsrc/RoyalAndLoyal/RoyalAndLoyal.ecore", (boolean)true);
            this.doSerialize(ocl, inputURI, "RoyalAndLoyal", inputURI, null, true, true);
            ocl.dispose();
        }
    }

    public void testSerialize_States() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("cs2asErrors", StringUtil.bind((String)PivotMessagesInternal.UnresolvedOperationCall_ERROR_, (Object[])new Object[]{"OclInvalid", "substring", "1, 1"}));
        this.doSerialize(ocl, "States", "States", options, true, true);
        ocl.dispose();
    }

    public void testSerialize_XMLNamespace() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        this.doSerialize(ocl, "XMLNamespace");
        ocl.dispose();
    }

    public void test_StateMachines_uml_Serialize() throws Exception {
        UMLStandaloneSetup.init();
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        this.doSerializeUML(ocl, "StateMachines");
        ocl.dispose();
    }

    protected static interface ResourceSetInitializer {
        public void initializeResourceSet(@NonNull ResourceSet var1);
    }
}

