/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.tests;

import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class TestCaseLogger
extends ConsoleAppender {
    @NonNull
    public static final TestCaseLogger INSTANCE = new TestCaseLogger();
    private static Logger rootLogger = Logger.getRootLogger();
    private boolean installed = false;
    @NonNull
    private StringBuilder s = new StringBuilder();

    private TestCaseLogger() {
        super((Layout)new SimpleLayout(), "System.out");
        this.setName("TestCaseLogger");
    }

    public void append(LoggingEvent event) {
        if (event.getLevel().isGreaterOrEqual((Priority)Level.INFO)) {
            String renderedMessage = event.getRenderedMessage();
            this.s.append(renderedMessage);
        }
    }

    public void clear() {
        this.s.setLength(0);
    }

    public String get() {
        return this.s.toString();
    }

    @Nullable
    public Iterable<Appender> install() {
        ArrayList<Appender> removedAppenders = null;
        if (!this.installed) {
            Enumeration allAppenders = rootLogger.getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                Object element = allAppenders.nextElement();
                if (!(element instanceof Appender)) continue;
                Appender appender = (Appender)element;
                if (removedAppenders == null) {
                    removedAppenders = new ArrayList<Appender>();
                }
                removedAppenders.add(appender);
            }
            if (removedAppenders != null) {
                for (Appender appender : removedAppenders) {
                    rootLogger.removeAppender(appender);
                }
            }
            rootLogger.addAppender((Appender)this);
            this.installed = true;
        }
        this.clear();
        return removedAppenders;
    }

    public void uninstall(@Nullable Iterable<Appender> removedAppenders) {
        rootLogger.removeAppender((Appender)this);
        if (removedAppenders != null) {
            for (Appender appender : removedAppenders) {
                rootLogger.addAppender(appender);
            }
        }
        this.installed = false;
    }
}

