/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.tests;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.osgi.framework.Bundle;

public class TestUIUtil {
    private static boolean testedEgitUiBundle = false;

    public static void closeIntro() {
        IIntroManager introManager = PlatformUI.getWorkbench().getIntroManager();
        introManager.closeIntro(introManager.getIntro());
    }

    public static void cancelAndWaitForValidationJob() throws InterruptedException {
        IJobManager jobManager = Job.getJobManager();
        Job[] jobArray = jobManager.find(null);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (job instanceof ValidationJob && !job.cancel()) {
                int i = 0;
                while (job.getState() == 4 && i++ < 10) {
                    TestUIUtil.flushEvents();
                    Thread.sleep(100L);
                }
            }
            ++n2;
        }
    }

    @NonNull
    public static IFile copyIFile(IFile outFile, @NonNull URI uri, String encoding) throws CoreException, FileNotFoundException {
        String string = uri.isFile() ? uri.toFileString() : uri.toString();
        BufferedReader reader = new BufferedReader(new FileReader(string));
        if (encoding == null) {
            encoding = URIConverter.ReadableInputStream.getEncoding((Reader)reader);
        }
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream((Reader)reader, encoding);
        outFile.create((InputStream)inputStream, true, null);
        return outFile;
    }

    @NonNull
    public static FileEditorInput createFileEditorInput(@NonNull IContainer container, @NonNull String fileName, @NonNull InputStream inputStream) throws CoreException {
        IFile file1 = container.getFile((IPath)new Path(fileName));
        file1.create(inputStream, true, null);
        return new FileEditorInput(file1){};
    }

    @NonNull
    public static IProject createIProject(String projectName) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            project.create(null);
        }
        project.open(null);
        return project;
    }

    public static void deleteIProject(@NonNull String testProjectName) throws Exception {
        TestUIUtil.suppressGitPrefixPopUp();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(testProjectName);
        project.delete(true, true, null);
    }

    public static void enableSwitchToDebugPerspectivePreference() {
        DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.switch_to_perspective", "always");
    }

    public static void flushEvents() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        int i = 0;
        while (i < 10) {
            while (workbench.getDisplay().readAndDispatch()) {
            }
            ++i;
        }
    }

    public static void removeTerminatedLaunches(ILaunch[] elements) {
        ArrayList<ILaunch> removed = new ArrayList<ILaunch>();
        int i = 0;
        while (i < elements.length) {
            ILaunch launch = elements[i];
            if (launch.isTerminated()) {
                removed.add(launch);
            }
            ++i;
        }
        if (!removed.isEmpty()) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            manager.removeLaunches(removed.toArray(new ILaunch[removed.size()]));
        }
    }

    public static void suppressGitPrefixPopUp() {
        if (!testedEgitUiBundle) {
            testedEgitUiBundle = true;
            Bundle egitUiBundle = Platform.getBundle((String)"org.eclipse.egit.ui");
            if (egitUiBundle != null) {
                try {
                    Class activatorClass = egitUiBundle.loadClass("org.eclipse.egit.ui.Activator");
                    Class preferencesClass = egitUiBundle.loadClass("org.eclipse.egit.ui.UIPreferences");
                    Method getDefaultMethod = activatorClass.getMethod("getDefault", new Class[0]);
                    AbstractUIPlugin activator = (AbstractUIPlugin)getDefaultMethod.invoke(null, new Object[0]);
                    IPreferenceStore store = activator.getPreferenceStore();
                    Field field = preferencesClass.getField("SHOW_GIT_PREFIX_WARNING");
                    String name = (String)field.get(null);
                    store.setValue(name, false);
                    field = preferencesClass.getField("SHOW_HOME_DIR_WARNING");
                    name = (String)field.get(null);
                    store.setValue(name, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void wait(int delayTimeInMilliseconds) {
        int i = 0;
        while (i < delayTimeInMilliseconds) {
            TestUIUtil.flushEvents();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            i += 100;
        }
    }

    public static void waitForLaunchToTerminate(@NonNull ILaunch launch) throws InterruptedException, DebugException {
        boolean allDead;
        do {
            int i = 0;
            while (i < 10) {
                TestUIUtil.flushEvents();
                Thread.sleep(100L);
                ++i;
            }
            allDead = true;
            IDebugTarget[] iDebugTargetArray = launch.getDebugTargets();
            int n = iDebugTargetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugTarget debugTarget = iDebugTargetArray[n2];
                IProcess process = debugTarget.getProcess();
                if (!process.isTerminated()) {
                    allDead = false;
                }
                IThread[] iThreadArray = debugTarget.getThreads();
                int n3 = iThreadArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IThread debugThread = iThreadArray[n4];
                    if (!debugThread.isTerminated()) {
                        allDead = false;
                    }
                    ++n4;
                }
                ++n2;
            }
        } while (!allDead);
    }

    public static void waitForSuspended(@NonNull IThread vmThread) throws InterruptedException, DebugException {
        int i = 0;
        while (i < 10) {
            TestUIUtil.flushEvents();
            Thread.sleep(100L);
            if (vmThread.isSuspended()) {
                return;
            }
            ++i;
        }
        TestCase.fail((String)"Failed to suspend");
    }

    public static void waitForTerminated(@NonNull IThread vmThread) throws InterruptedException, DebugException {
        int i = 0;
        while (i < 10) {
            TestUIUtil.flushEvents();
            Thread.sleep(100L);
            if (vmThread.isTerminated()) {
                return;
            }
            ++i;
        }
        TestCase.fail((String)"Failed to terminate");
    }
}

