/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.tests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.xtext.util.EmfFormatter;

public class TestUtil {
    public static void assertSameModel(@NonNull Resource expectedResource, @NonNull Resource actualResource) throws IOException, InterruptedException {
        List<XtextTestCase.Normalizer> expectedNormalizations = TestUtil.normalize(expectedResource);
        List<XtextTestCase.Normalizer> actualNormalizations = TestUtil.normalize(actualResource);
        String expected = EmfFormatter.listToStr((List)expectedResource.getContents());
        String actual = EmfFormatter.listToStr((List)actualResource.getContents());
        TestCase.assertEquals((String)expected, (String)actual);
        for (XtextTestCase.Normalizer normalizer : expectedNormalizations) {
            normalizer.denormalize();
        }
        for (XtextTestCase.Normalizer normalizer : actualNormalizations) {
            normalizer.denormalize();
        }
    }

    @NonNull
    public static IFile copyIFile(@NonNull OCL ocl, @NonNull URI sourceURI, IProject project, String projectPath) throws CoreException, IOException {
        URIHandler uriHandler = ocl.getResourceSet().getURIConverter().getURIHandler(sourceURI);
        InputStream inputStream = uriHandler.createInputStream(sourceURI, new HashMap());
        IFile outFile = project.getFile(projectPath);
        TestUtil.mkdirs(outFile.getParent());
        outFile.create(inputStream, true, null);
        return outFile;
    }

    public static void createClassPath(@NonNull IProject project, @Nullable String[] srcPaths) throws IOException, CoreException {
        StringBuilder s = new StringBuilder();
        s.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        s.append("<classpath>\n");
        s.append("\t<classpathentry kind=\"con\" path=\"org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.7\"/>\n");
        s.append("\t<classpathentry kind=\"con\" path=\"org.eclipse.pde.core.requiredPlugins\"/>\n");
        if (srcPaths != null) {
            String[] stringArray = srcPaths;
            int n = srcPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String srcPath = stringArray[n2];
                s.append("\t<classpathentry kind=\"src\" path=\"" + srcPath + "\"/>\n");
                ++n2;
            }
        }
        s.append("\t<classpathentry kind=\"output\" path=\"bin\"/>\n");
        s.append("</classpath>\n");
        String string = s.toString();
        TestUtil.createIFile((IContainer)project, ".classpath", string);
    }

    public static void createFile(@NonNull File file, @NonNull String fileContent) throws IOException {
        FileWriter writer = new FileWriter(file);
        ((Writer)writer).append(fileContent);
        ((Writer)writer).close();
    }

    @NonNull
    public static IFile createIFile(@NonNull IContainer container, @NonNull String fileName, @NonNull String fileContents) throws IOException, CoreException {
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(fileContents, "UTF-8");
        IFile iFile = container.getFile((IPath)new Path(fileName));
        if (iFile.exists()) {
            iFile.delete(true, null);
        }
        iFile.create((InputStream)inputStream, true, null);
        return iFile;
    }

    @NonNull
    public static IFolder createFolder(@NonNull IContainer container, @NonNull String folderName) throws CoreException {
        IFolder folder = container.getFolder((IPath)new Path(folderName));
        if (!folder.exists()) {
            folder.create(true, false, null);
        }
        return folder;
    }

    @NonNull
    public static IProject createJavaProject(@NonNull String projectName) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            project.create(null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        IProjectDescription description = project.getDescription();
        ICommand command1 = description.newCommand();
        command1.setBuilderName("org.eclipse.jdt.core.javabuilder");
        ICommand command2 = description.newCommand();
        command2.setBuilderName("org.eclipse.pde.ManifestBuilder");
        ICommand command3 = description.newCommand();
        command3.setBuilderName("org.eclipse.pde.SchemaBuilder");
        description.setBuildSpec(new ICommand[]{command1, command2, command3});
        description.setNatureIds(new String[]{"org.eclipse.pde.PluginNature", "org.eclipse.jdt.core.javanature"});
        project.setDescription(description, null);
        return project;
    }

    public static void createManifest(@NonNull IProject project, @NonNull String projectName, @Nullable String[] requireBundles, @Nullable String[] additionalBundles, @Nullable String[] exportPackages) throws CoreException {
        int n;
        int n2;
        String[] stringArray;
        String prefix;
        IFolder folder = project.getFolder("META-INF");
        folder.create(true, false, null);
        IFile file = folder.getFile("MANIFEST.MF");
        StringBuilder s = new StringBuilder();
        s.append("Manifest-Version: 1.0\n");
        s.append("Bundle-ManifestVersion: 2\n");
        s.append("Bundle-Name: " + projectName + "\n");
        s.append("Bundle-SymbolicName: " + projectName + ";singleton:=true\n");
        s.append("Bundle-Version: 0.0.0.qualifier\n");
        s.append("Bundle-Localization: plugin\n");
        if (requireBundles != null) {
            s.append("Require-Bundle:");
            prefix = " ";
            stringArray = requireBundles;
            n2 = requireBundles.length;
            n = 0;
            while (n < n2) {
                String requireBundle = stringArray[n];
                s.append(prefix);
                s.append(requireBundle);
                prefix = ",\n ";
                ++n;
            }
            s.append("\n");
        }
        if (exportPackages != null) {
            s.append("Export-Package:");
            prefix = " ";
            stringArray = exportPackages;
            n2 = exportPackages.length;
            n = 0;
            while (n < n2) {
                String exportPackage = stringArray[n];
                s.append(prefix);
                s.append(exportPackage);
                prefix = ",\n ";
                ++n;
            }
            s.append("\n");
        }
        String manifestContents = s.toString();
        file.create((InputStream)new ByteArrayInputStream(manifestContents.getBytes()), true, null);
        if (additionalBundles != null) {
            file = project.getFile("build.properties");
            s = new StringBuilder();
            s.append("additional.bundles =");
            String prefix2 = " ";
            String[] stringArray2 = additionalBundles;
            int n3 = additionalBundles.length;
            n2 = 0;
            while (n2 < n3) {
                String additionalBundle = stringArray2[n2];
                s.append(prefix2);
                s.append(additionalBundle);
                prefix2 = ",\\\n\t";
                ++n2;
            }
            s.append("\n");
            String buildPropertiesContents = s.toString();
            file.create((InputStream)new ByteArrayInputStream(buildPropertiesContents.getBytes()), true, null);
        }
    }

    public static void deleteDirectory(@NonNull File dir) throws Exception {
        File[] listFiles;
        File[] fileArray = listFiles = dir.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                TestUtil.deleteDirectory(file);
            }
            ++n2;
        }
        dir.delete();
    }

    public static void mkdirs(IContainer parent) throws CoreException {
        IFolder iFolder;
        if (parent instanceof IProject) {
            IProject iProject = (IProject)parent;
            if (!iProject.exists()) {
                iProject.create(null);
            }
        } else if (parent instanceof IFolder && !(iFolder = (IFolder)parent).exists()) {
            TestUtil.mkdirs(iFolder.getParent());
            iFolder.create(true, false, null);
        }
    }

    public static List<XtextTestCase.Normalizer> normalize(Resource resource) {
        ArrayList<XtextTestCase.Normalizer> normalizers = new ArrayList<XtextTestCase.Normalizer>();
        TreeIterator tit = resource.getAllContents();
        while (tit.hasNext()) {
            EModelElement eModelElement;
            EClass eClass;
            ETypedElement eTypedElement;
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof ETypedElement && (eTypedElement = (ETypedElement)eObject).getUpperBound() == 1) {
                EClassifier eType;
                if (!eTypedElement.isOrdered() || !eTypedElement.isUnique()) {
                    normalizers.add(new XtextTestCase.ETypedElementNormalizer(eTypedElement));
                } else if (eTypedElement.getLowerBound() == 0 && (eType = eTypedElement.getEType()) instanceof EDataType && ElementUtil.isPrimitiveInstanceClass((EDataType)((EDataType)eType))) {
                    normalizers.add(new XtextTestCase.ETypedElementNormalizer(eTypedElement));
                }
            }
            if (eObject instanceof EClass && (eClass = (EClass)eObject).getEOperations().size() >= 2) {
                normalizers.add(new XtextTestCase.EOperationsNormalizer(eClass));
            }
            if (eObject instanceof EModelElement && (eModelElement = (EModelElement)eObject).getEAnnotations().size() >= 2) {
                normalizers.add(new XtextTestCase.EAnnotationsNormalizer(eModelElement));
            }
            if (!(eObject instanceof EAnnotation)) continue;
            EAnnotation eAnnotation = (EAnnotation)eObject;
            EMap eDetails = eAnnotation.getDetails();
            if (eDetails.size() > 1) {
                normalizers.add(new XtextTestCase.EDetailsNormalizer(eAnnotation));
            }
            if (!"http://www.eclipse.org/emf/2002/Ecore".equals(eAnnotation.getSource()) || !eDetails.containsKey((Object)"constraints")) continue;
            normalizers.add(new XtextTestCase.EAnnotationConstraintsNormalizer(eAnnotation));
        }
        for (XtextTestCase.Normalizer normalizer : normalizers) {
            normalizer.normalize();
        }
        return normalizers;
    }
}

