/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.internal.elements.AbstractExecutorElement;
import org.eclipse.ocl.pivot.internal.executor.ExecutorCollectionType;
import org.eclipse.ocl.pivot.internal.executor.ExecutorMapType;
import org.eclipse.ocl.pivot.internal.executor.ExecutorTupleType;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibTables;
import org.eclipse.ocl.pivot.options.EnumeratedOption;
import org.eclipse.ocl.pivot.options.PivotValidationOptions;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TypeUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionTypeParameters;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.MapTypeParameters;
import org.eclipse.ocl.pivot.values.TemplateParameterSubstitutions;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public abstract class ExecutableStandardLibrary
extends AbstractExecutorElement
implements CompleteEnvironment,
StandardLibrary.StandardLibraryExtension {
    private @NonNull Map<Type, Map<CollectionTypeParameters<Type>, WeakReference<ExecutorCollectionType>>> collectionSpecializations = new WeakHashMap<Type, Map<CollectionTypeParameters<Type>, WeakReference<ExecutorCollectionType>>>();
    private @NonNull Map<Type, Map<MapTypeParameters<Type, Type>, WeakReference<ExecutorMapType>>> mapSpecializations = new WeakHashMap<Type, Map<MapTypeParameters<Type, Type>, WeakReference<ExecutorMapType>>>();
    private @NonNull Map<TupleTypeId, WeakReference<TupleType>> tupleTypeMap = new WeakHashMap<TupleTypeId, WeakReference<TupleType>>();
    private Map<Object, StatusCodes.Severity> validationKey2severity = null;

    protected @NonNull HashMap<Object, StatusCodes.Severity> createValidationKey2severityMap() {
        HashMap<Object, StatusCodes.Severity> map = new HashMap<Object, StatusCodes.Severity>();
        Set<Map.Entry<String, EnumeratedOption<StatusCodes.Severity>>> entrySet = PivotValidationOptions.safeValidationName2severityOption.entrySet();
        for (Map.Entry<String, EnumeratedOption<StatusCodes.Severity>> entry : entrySet) {
            EnumeratedOption<StatusCodes.Severity> value = entry.getValue();
            if (value == null) continue;
            map.put(entry.getKey(), (StatusCodes.Severity)((Object)value.getDefaultValue()));
        }
        return map;
    }

    @Override
    public @NonNull Iterable<? extends CompletePackage> getAllCompletePackages() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Class getBagType() {
        return OCLstdlibTables.Types._Bag;
    }

    @Override
    public @NonNull CollectionType getBagType(@NonNull Type elementType, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return this.getCollectionType(this.getBagType(), elementType, false, lower, upper);
    }

    @Override
    public @NonNull CollectionType getBagType(@NonNull Type elementType, boolean isNullFree, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return this.getCollectionType(this.getBagType(), elementType, isNullFree, lower, upper);
    }

    @Override
    public @NonNull Class getBooleanType() {
        return OCLstdlibTables.Types._Boolean;
    }

    @Override
    public @NonNull Class getCollectionType() {
        return OCLstdlibTables.Types._Collection;
    }

    @Override
    public @NonNull CollectionType getCollectionType(@NonNull Class genericType, @NonNull Type elementType, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return this.getCollectionType(genericType, elementType, false, lower, upper);
    }

    @Override
    public synchronized @NonNull CollectionType getCollectionType(@NonNull Class genericType, @NonNull Type elementType, boolean isNullFree, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        IntegerValue lower2 = lower;
        UnlimitedNaturalValue upper2 = upper;
        if (lower2 == null) {
            lower2 = ValueUtil.ZERO_VALUE;
        }
        if (upper2 == null) {
            upper2 = ValueUtil.UNLIMITED_VALUE;
        }
        CollectionTypeParameters<Type> typeParameters = TypeUtil.createCollectionTypeParameters(elementType, isNullFree, lower2, upper2);
        ExecutorCollectionType specializedType = null;
        Map<CollectionTypeParameters<Type>, WeakReference<ExecutorCollectionType>> map = this.collectionSpecializations.get(genericType);
        if (map == null) {
            map = new WeakHashMap<CollectionTypeParameters<Type>, WeakReference<ExecutorCollectionType>>();
            this.collectionSpecializations.put(genericType, map);
        } else {
            specializedType = this.weakGet(map, typeParameters);
        }
        if (specializedType == null) {
            specializedType = new ExecutorCollectionType(ClassUtil.nonNullModel(genericType.getName()), genericType, elementType, isNullFree, lower, upper);
            map.put(typeParameters, new WeakReference<ExecutorCollectionType>(specializedType));
        }
        return specializedType;
    }

    @Override
    public @NonNull Class getIntegerType() {
        return OCLstdlibTables.Types._Integer;
    }

    @Override
    public @NonNull LambdaType getLambdaType(@NonNull String typeName, @NonNull Type contextType, @NonNull List<? extends Type> parameterTypes, @NonNull Type resultType, @Nullable TemplateParameterSubstitutions bindings) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Class getMapType() {
        return OCLstdlibTables.Types._Map;
    }

    @Override
    public synchronized @NonNull MapType getMapType(@NonNull Class genericType, @NonNull Type keyType, @NonNull Type valueType) {
        MapTypeParameters<Type, Type> typeParameters = TypeUtil.createMapTypeParameters(keyType, valueType);
        ExecutorMapType specializedType = null;
        Map<MapTypeParameters<Type, Type>, WeakReference<ExecutorMapType>> map = this.mapSpecializations.get(genericType);
        if (map == null) {
            map = new WeakHashMap<MapTypeParameters<Type, Type>, WeakReference<ExecutorMapType>>();
            this.mapSpecializations.put(genericType, map);
        } else {
            specializedType = this.weakGet(map, typeParameters);
        }
        if (specializedType == null) {
            specializedType = new ExecutorMapType(ClassUtil.nonNullModel(genericType.getName()), genericType, keyType, valueType);
            map.put(typeParameters, new WeakReference<ExecutorMapType>(specializedType));
        }
        return specializedType;
    }

    @Override
    public @NonNull Class getMetaclass(@NonNull Type classType) {
        Class metaType = null;
        if (classType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)classType;
            metaType = collectionType.isOrdered() ? (collectionType.isUnique() ? this.getPivotType("OrderedSetType") : this.getPivotType("SequenceType")) : (collectionType.isUnique() ? this.getPivotType("SetType") : this.getPivotType("BagType"));
        } else if (classType instanceof MapType) {
            metaType = this.getPivotType("MapType");
        }
        if (metaType != null) {
            return metaType;
        }
        return this.getClassType();
    }

    @Override
    public Type getMetaType(@NonNull Type instanceType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Package getNestedPackage(@NonNull Package parentPackage, @NonNull String name) {
        return NameUtil.getNameable(parentPackage.getOwnedPackages(), name);
    }

    @Override
    public @Nullable Class getNestedType(@NonNull Package parentPackage, @NonNull String name) {
        return NameUtil.getNameable(parentPackage.getOwnedClasses(), name);
    }

    @Override
    public @NonNull Class getOclAnyType() {
        return OCLstdlibTables.Types._OclAny;
    }

    @Override
    public @NonNull Class getOclComparableType() {
        return OCLstdlibTables.Types._OclComparable;
    }

    @Override
    public @NonNull Class getOclElementType() {
        return OCLstdlibTables.Types._OclElement;
    }

    @Override
    public @NonNull Class getOclEnumerationType() {
        return OCLstdlibTables.Types._OclEnumeration;
    }

    @Override
    public @NonNull Class getOclInvalidType() {
        return OCLstdlibTables.Types._OclInvalid;
    }

    @Override
    public @NonNull Class getOclMessageType() {
        return OCLstdlibTables.Types._OclMessage;
    }

    @Override
    public @NonNull Class getOclSelfType() {
        return OCLstdlibTables.Types._OclSelf;
    }

    @Override
    public @NonNull Class getOclStereotypeType() {
        return OCLstdlibTables.Types._OclStereotype;
    }

    @Override
    public @NonNull Class getOclSummableType() {
        return OCLstdlibTables.Types._OclSummable;
    }

    @Override
    public @NonNull Class getOclTupleType() {
        return OCLstdlibTables.Types._OclTuple;
    }

    @Override
    public @NonNull Class getOclVoidType() {
        return OCLstdlibTables.Types._OclVoid;
    }

    @Override
    public @Nullable Element getOperationTemplateParameter(@NonNull Operation anOperation, int index) {
        return anOperation.getTypeParameters().get(index);
    }

    @Override
    public @NonNull Class getOrderedCollectionType() {
        return OCLstdlibTables.Types._OrderedCollection;
    }

    @Override
    public @NonNull Class getOrderedSetType() {
        return OCLstdlibTables.Types._OrderedSet;
    }

    @Override
    public @NonNull CollectionType getOrderedSetType(@NonNull Type elementType, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return this.getCollectionType(this.getOrderedSetType(), elementType, false, lower, upper);
    }

    @Override
    public @NonNull CollectionType getOrderedSetType(@NonNull Type elementType, boolean isNullFree, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return this.getCollectionType(this.getOrderedSetType(), elementType, isNullFree, lower, upper);
    }

    @Override
    public @NonNull CompleteModel getOwnedCompleteModel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull StandardLibrary getOwnedStandardLibrary() {
        return this;
    }

    @Override
    public CompleteEnvironment getOwningCompleteEnvironment() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Package getPackage() {
        return OCLstdlibTables.PACKAGE;
    }

    public @Nullable Class getPivotType(@NonNull String className) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Type getPrimitiveType(@NonNull PrimitiveTypeId typeId) {
        return TypeUtil.getPrimitiveType(this, typeId);
    }

    @Override
    public @NonNull Class getRealType() {
        return OCLstdlibTables.Types._Real;
    }

    @Override
    public Package getRootPackage(@NonNull String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Class getSequenceType() {
        return OCLstdlibTables.Types._Sequence;
    }

    @Override
    public @NonNull CollectionType getSequenceType(@NonNull Type elementType, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return this.getCollectionType(this.getSequenceType(), elementType, false, lower, upper);
    }

    @Override
    public @NonNull CollectionType getSequenceType(@NonNull Type elementType, boolean isNullFree, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return this.getCollectionType(this.getSequenceType(), elementType, isNullFree, lower, upper);
    }

    @Override
    public @NonNull Class getSetType() {
        return OCLstdlibTables.Types._Set;
    }

    @Override
    public @NonNull CollectionType getSetType(@NonNull Type elementType, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return this.getCollectionType(this.getSetType(), elementType, false, lower, upper);
    }

    @Override
    public @NonNull CollectionType getSetType(@NonNull Type elementType, boolean isNullFree, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return this.getCollectionType(this.getSetType(), elementType, isNullFree, lower, upper);
    }

    public  @Nullable StatusCodes.Severity getSeverity(@Nullable Object validationKey) {
        Map<Object, StatusCodes.Severity> validationKey2severity2 = this.validationKey2severity;
        if (validationKey2severity2 == null) {
            this.validationKey2severity = validationKey2severity2 = this.createValidationKey2severityMap();
        }
        return validationKey2severity2.get(validationKey);
    }

    @Override
    public @NonNull Type getSpecializedType(@NonNull Type type, @Nullable TemplateParameterSubstitutions substitutions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Class getStringType() {
        return OCLstdlibTables.Types._String;
    }

    public @NonNull Element getTemplateParameter(@NonNull TemplateParameterId id, Element context) {
        throw new UnsupportedOperationException();
    }

    public synchronized @NonNull TupleType getTupleType(@NonNull TupleTypeId typeId) {
        TupleType domainTupleType;
        WeakReference<TupleType> ref = this.tupleTypeMap.get(typeId);
        if (ref != null && (domainTupleType = (TupleType)ref.get()) != null) {
            return domainTupleType;
        }
        domainTupleType = new ExecutorTupleType(typeId);
        this.tupleTypeMap.put(typeId, new WeakReference<TupleType>(domainTupleType));
        return domainTupleType;
    }

    @Override
    public @NonNull TupleType getTupleType(@NonNull String typeName, @NonNull Collection<? extends TypedElement> parts, @Nullable TemplateParameterSubstitutions bindings) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Class getUniqueCollectionType() {
        return OCLstdlibTables.Types._UniqueCollection;
    }

    @Override
    public @NonNull Class getUnlimitedNaturalType() {
        return OCLstdlibTables.Types._UnlimitedNatural;
    }

    public void resetSeverities() {
        this.validationKey2severity = null;
    }

    @Override
    public void setOwnedCompleteModel(CompleteModel value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOwnedStandardLibrary(StandardLibrary value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOwningCompleteEnvironment(CompleteEnvironment value) {
        throw new UnsupportedOperationException();
    }

    protected <K, V> @Nullable V weakGet(@NonNull Map<K, WeakReference<V>> map, @NonNull K key) {
        WeakReference<V> ref = map.get(key);
        if (ref == null) {
            return null;
        }
        @Nullable T value = ref.get();
        if (value == null) {
            map.remove(key);
        }
        return (V)value;
    }
}

