/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;

public class FinalAnalysis {
    protected final @NonNull CompleteModelInternal completeModel;
    @Deprecated
    protected final @NonNull PivotMetamodelManager metamodelManager;
    private final @NonNull Map<@NonNull CompleteClass, @NonNull Set<@NonNull CompleteClass>> superCompleteClass2subCompleteClasses = new HashMap<CompleteClass, Set<CompleteClass>>();
    private final @NonNull Map<@NonNull Operation, @Nullable Set<@NonNull Operation>> operation2overrides = new HashMap<Operation, Set<Operation>>();

    public FinalAnalysis(@NonNull CompleteModelInternal completeModel) {
        this.completeModel = completeModel;
        this.metamodelManager = completeModel.getMetamodelManager();
        for (CompletePackage completePackage : completeModel.getAllCompletePackages()) {
            for (CompleteClass subCompleteClass : ClassUtil.nullFree(completePackage.getOwnedCompleteClasses())) {
                for (CompleteClass superCompleteClass : subCompleteClass.getSuperCompleteClasses()) {
                    Set<@NonNull CompleteClass> subCompleteClasses = this.superCompleteClass2subCompleteClasses.get(superCompleteClass);
                    if (subCompleteClasses == null) {
                        subCompleteClasses = new HashSet<CompleteClass>();
                        this.superCompleteClass2subCompleteClasses.put(superCompleteClass, subCompleteClasses);
                    }
                    subCompleteClasses.add(subCompleteClass);
                }
            }
        }
        for (CompleteClass completeClass : this.superCompleteClass2subCompleteClasses.keySet()) {
            Set<@NonNull CompleteClass> subCompleteClasses = this.superCompleteClass2subCompleteClasses.get(completeClass);
            assert (subCompleteClasses != null);
            for (Operation domainOperation : completeClass.getOperations(null)) {
                String opName = domainOperation.getName();
                ParametersId parametersId = domainOperation.getParametersId();
                LibraryFeature domainImplementation = this.metamodelManager.getImplementation(domainOperation);
                Set<@NonNull Operation> overrides = this.operation2overrides.get(domainOperation);
                for (CompleteClass subCompleteClass : subCompleteClasses) {
                    if (subCompleteClass == completeClass) continue;
                    for (Operation subOperation : subCompleteClass.getOperations(null)) {
                        LibraryFeature subImplementation;
                        if (!opName.equals(subOperation.getName()) || !parametersId.equals(subOperation.getParametersId()) || domainImplementation == (subImplementation = this.metamodelManager.getImplementation(subOperation)) && domainOperation.getBodyExpression() == subOperation.getBodyExpression() && domainOperation.getTypeId() == subOperation.getTypeId()) continue;
                        if (overrides == null) {
                            overrides = new HashSet<Operation>();
                            overrides.add(domainOperation);
                        }
                        overrides.add(subOperation);
                    }
                }
                this.operation2overrides.put(domainOperation, overrides);
            }
        }
    }

    public @NonNull Iterable<@NonNull Operation> getOverrides(@NonNull Operation operation) {
        Set<@NonNull Operation> overrides = this.operation2overrides.get(operation);
        return overrides != null ? overrides : Collections.singletonList(operation);
    }

    public @NonNull Iterable<@NonNull Operation> getOverrides(@NonNull Operation operation, @NonNull CompleteClass completeClass) {
        Set<@NonNull Operation> overrides = this.operation2overrides.get(operation);
        if (overrides == null) {
            return Collections.singletonList(operation);
        }
        ArrayList<@NonNull Operation> results = new ArrayList<Operation>();
        StandardLibraryInternal standardLibrary = this.completeModel.getStandardLibrary();
        CompleteInheritance requiredInheritance = completeClass.getCompleteInheritance();
        for (Operation override : overrides) {
            CompleteInheritance overrideInheritance = override.getInheritance(standardLibrary);
            if (overrideInheritance == null || !overrideInheritance.isSuperInheritanceOf(requiredInheritance)) continue;
            results.add(override);
        }
        if (results.size() <= 0) {
            results.add(operation);
        }
        return results;
    }

    public boolean isFinal(@NonNull CompleteClass completeClass) {
        Set<@NonNull CompleteClass> subCompleteClasses = this.superCompleteClass2subCompleteClasses.get(completeClass);
        return subCompleteClasses != null && subCompleteClasses.size() <= 1;
    }

    public boolean isFinal(@NonNull Operation operation) {
        Set<@NonNull Operation> overrides = this.operation2overrides.get(operation);
        return overrides == null;
    }

    public @Nullable Operation isFinal(@NonNull Operation operation, @NonNull CompleteClass completeClass) {
        Set<@NonNull Operation> overrides = this.operation2overrides.get(operation);
        if (overrides == null) {
            return operation;
        }
        Operation candidate = null;
        StandardLibraryInternal standardLibrary = this.completeModel.getStandardLibrary();
        CompleteInheritance requiredInheritance = completeClass.getCompleteInheritance();
        for (Operation override : overrides) {
            CompleteInheritance overrideInheritance = override.getInheritance(standardLibrary);
            if (overrideInheritance == null || !overrideInheritance.isSuperInheritanceOf(requiredInheritance)) continue;
            if (candidate != null) {
                return null;
            }
            candidate = override;
        }
        return candidate;
    }

    public void print(@NonNull StringBuilder s) {
        ArrayList<@NonNull CompleteClass> completeClasses = new ArrayList<CompleteClass>(this.superCompleteClass2subCompleteClasses.keySet());
        Collections.sort(completeClasses, NameUtil.NAMEABLE_COMPARATOR);
        s.append("Final types");
        for (CompleteClass completeClass : completeClasses) {
            assert (completeClass != null);
            if (!this.isFinal(completeClass)) continue;
            s.append("\n\t");
            s.append(completeClass.getName());
        }
        s.append("\nNon-final types");
        for (CompleteClass completeClass : completeClasses) {
            assert (completeClass != null);
            if (this.isFinal(completeClass)) continue;
            s.append("\n\t");
            s.append(completeClass.getName());
        }
    }
}

