/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.prettyprint;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;

public abstract class PrettyPrintOptions {
    protected final @Nullable Namespace scope;

    public PrettyPrintOptions(@Nullable Namespace scope) {
        this.scope = scope;
    }

    public abstract void addReservedNames(@NonNull Iterable<String> var1);

    public abstract void addRestrictedNames(@NonNull Iterable<String> var1);

    public @Nullable String getAlias(@NonNull Namespace namespace) {
        return this.getGlobalOptions().getAlias(namespace);
    }

    public @Nullable URI getBaseURI() {
        return this.getGlobalOptions().getBaseURI();
    }

    public @Nullable EnvironmentFactory getEnvironmentFactory() {
        return this.getGlobalOptions().getEnvironmentFactory();
    }

    public abstract @NonNull Global getGlobalOptions();

    public @NonNull String getIndentStep() {
        return this.getGlobalOptions().getIndentStep();
    }

    public int getLinelength() {
        return this.getGlobalOptions().getLinelength();
    }

    public abstract @Nullable Set<String> getReservedNames();

    public abstract @Nullable Set<String> getRestrictedNames();

    public @Nullable Namespace getScope() {
        return this.scope;
    }

    public void setIndentStep(@NonNull String indentStep) {
        this.getGlobalOptions().setIndentStep(indentStep);
    }

    public void setLinelength(int linelength) {
        this.getGlobalOptions().setLinelength(linelength);
    }

    public static class Global
    extends PrettyPrintOptions {
        private @NonNull String indentStep = "  ";
        private int linelength = Integer.MAX_VALUE;
        private final @NonNull Set<String> reservedNames = new HashSet<String>();
        private final @NonNull Set<String> restrictedNames = new HashSet<String>();
        private @NonNull Map<Namespace, String> namespace2alias = new HashMap<Namespace, String>();
        private @Nullable URI baseURI = null;
        private @Nullable EnvironmentFactory environmentFactory = null;

        public Global(@Nullable Namespace scope) {
            super(scope);
        }

        public void addAliases(@NonNull Namespace namespace, @NonNull String alias) {
            this.namespace2alias.put(namespace, alias);
        }

        @Override
        public void addReservedNames(@NonNull Iterable<String> names) {
            for (String name : names) {
                this.reservedNames.add(name);
                this.restrictedNames.add(name);
            }
        }

        @Override
        public void addRestrictedNames(@NonNull Iterable<String> names) {
            for (String name : names) {
                this.restrictedNames.add(name);
            }
        }

        @Override
        public @Nullable String getAlias(@NonNull Namespace namespace) {
            return this.namespace2alias.get(namespace);
        }

        @Override
        public @Nullable URI getBaseURI() {
            return this.baseURI;
        }

        @Override
        public @Nullable EnvironmentFactory getEnvironmentFactory() {
            return this.environmentFactory;
        }

        @Override
        public @NonNull Global getGlobalOptions() {
            return this;
        }

        @Override
        public @NonNull String getIndentStep() {
            return this.indentStep;
        }

        @Override
        public int getLinelength() {
            return this.linelength;
        }

        public @NonNull Set<Namespace> getAliasedNamespaces() {
            return this.namespace2alias.keySet();
        }

        @Override
        public @Nullable Set<String> getReservedNames() {
            return this.reservedNames;
        }

        @Override
        public @Nullable Set<String> getRestrictedNames() {
            return this.restrictedNames;
        }

        public void setAliases(@NonNull Map<Namespace, String> namespace2alias) {
            this.namespace2alias = namespace2alias;
        }

        public void setBaseURI(@Nullable URI baseURI) {
            this.baseURI = baseURI;
        }

        public void setEnvironmentFactory(EnvironmentFactory environmentFactory) {
            this.environmentFactory = environmentFactory;
        }

        @Override
        public void setIndentStep(@NonNull String indentStep) {
            this.indentStep = indentStep;
        }

        @Override
        public void setLinelength(int linelength) {
            this.linelength = linelength;
        }
    }

    public static class Local
    extends PrettyPrintOptions {
        private @NonNull PrettyPrintOptions options;
        private @Nullable Set<String> reservedNames = null;
        private @Nullable Set<String> restrictedNames = null;

        public Local(@NonNull PrettyPrintOptions options, @Nullable Namespace scope) {
            super(scope);
            this.options = options;
        }

        @Override
        public void addReservedNames(@NonNull Iterable<String> names) {
            Set<String> reservedNames2 = this.reservedNames;
            Set<String> restrictedNames2 = this.restrictedNames;
            if (reservedNames2 == null) {
                reservedNames2 = this.reservedNames = new HashSet<String>();
            }
            if (restrictedNames2 == null) {
                restrictedNames2 = this.restrictedNames = new HashSet<String>();
            }
            for (String name : names) {
                reservedNames2.add(name);
                restrictedNames2.add(name);
            }
        }

        @Override
        public void addRestrictedNames(@NonNull Iterable<String> names) {
            Set<String> reservedNames2 = this.reservedNames;
            Set<String> restrictedNames2 = this.restrictedNames;
            if (reservedNames2 == null) {
                reservedNames2 = this.reservedNames = new HashSet<String>();
            }
            if (restrictedNames2 == null) {
                restrictedNames2 = this.restrictedNames = new HashSet<String>();
            }
            for (String name : names) {
                restrictedNames2.add(name);
            }
        }

        @Override
        public @NonNull Global getGlobalOptions() {
            return this.options.getGlobalOptions();
        }

        @Override
        public Set<String> getReservedNames() {
            return this.reservedNames != null ? this.reservedNames : this.options.getReservedNames();
        }

        @Override
        public Set<String> getRestrictedNames() {
            return this.restrictedNames != null ? this.restrictedNames : this.options.getRestrictedNames();
        }
    }
}

