/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.utilities;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EMOFResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.utilities.External2AS;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.AbstractEnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;

public class GlobalEnvironmentFactory
extends AbstractEnvironmentFactory {
    private static @Nullable GlobalEnvironmentFactory INSTANCE = null;
    private @Nullable List<Listener> listeners = null;

    public static @Nullable GlobalEnvironmentFactory basicGetInstance() {
        return INSTANCE;
    }

    private static @NonNull ResourceSet createGlobalResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        ConcurrentMap weakMap = new MapMaker().weakValues().makeMap();
        resourceSet.setURIResourceMap((Map)weakMap);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("emof", new EMOFResourceFactoryImpl());
        ASResourceFactoryRegistry.INSTANCE.configureResourceSet((ResourceSet)resourceSet);
        return resourceSet;
    }

    public static void disposeInstance() {
        GlobalEnvironmentFactory instance = INSTANCE;
        if (instance != null) {
            instance.dispose();
        }
    }

    public static @NonNull GlobalEnvironmentFactory getInstance() {
        GlobalEnvironmentFactory instance = INSTANCE;
        if (instance == null) {
            INSTANCE = instance = new GlobalEnvironmentFactory();
        }
        return instance;
    }

    public static void resetSafeNavigationValidations() {
        if (INSTANCE != null) {
            INSTANCE.resetSeverities();
        }
    }

    private GlobalEnvironmentFactory() {
        super(ProjectManager.CLASS_PATH, GlobalEnvironmentFactory.createGlobalResourceSet());
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            this.getProjectManager().initializeResourceSet(null);
        }
    }

    @Override
    public void addExternal2AS(@NonNull External2AS external2as) {
        super.addExternal2AS(external2as);
        Resource esResource = external2as.getResource();
        if (esResource != null) {
            UnloadResourceAdapter adapter = new UnloadResourceAdapter();
            esResource.eAdapters().add((Object)adapter);
            this.addListener(adapter);
        }
    }

    public void addListener(@NonNull Listener listener) {
        List<Listener> listeners2 = this.listeners;
        if (listeners2 == null) {
            this.listeners = listeners2 = new ArrayList<Listener>();
        }
        if (!listeners2.contains(listener)) {
            listeners2.add(listener);
        }
    }

    @Override
    protected void disposeInternal() {
        assert (this == INSTANCE);
        INSTANCE = null;
        if (this.listeners != null) {
            List<Listener> savedListeners = this.listeners;
            this.listeners = null;
            for (Listener listener : savedListeners) {
                listener.environmentFactoryDisposed(this);
            }
        }
        super.disposeInternal();
    }

    public void removeListener(@NonNull Listener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public static interface Listener {
        public void environmentFactoryDisposed(@NonNull EnvironmentFactory var1);
    }

    protected class UnloadResourceAdapter
    extends AdapterImpl
    implements Listener {
        protected UnloadResourceAdapter() {
        }

        @Override
        public void environmentFactoryDisposed(@NonNull EnvironmentFactory environmentFactory) {
            Notifier target2 = this.getTarget();
            if (target2 != null) {
                target2.eAdapters().remove((Object)this);
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            ResourceSet externalResourceSet2;
            assert (oldTarget instanceof Resource);
            PivotMetamodelManager metamodelManager = GlobalEnvironmentFactory.this.basicGetMetamodelManager();
            if (metamodelManager != null) {
                metamodelManager.removeExternalResource((Resource)oldTarget);
            }
            if ((externalResourceSet2 = GlobalEnvironmentFactory.this.getResourceSet()) instanceof ResourceSetImpl) {
                ArrayList<URI> deadKeys = new ArrayList<URI>();
                Map uriResourceMap = ((ResourceSetImpl)externalResourceSet2).getURIResourceMap();
                for (Map.Entry entry : uriResourceMap.entrySet()) {
                    if (entry.getValue() != oldTarget) continue;
                    deadKeys.add((URI)entry.getKey());
                }
                for (URI deadKey : deadKeys) {
                    uriResourceMap.remove(deadKey);
                }
            }
            super.unsetTarget(oldTarget);
        }
    }
}

