/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.ocl.util.Bag;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class ProfilesTest
extends AbstractTestSuite {
    private Profile testProfile;
    Stereotype testStereotype;
    Stereotype testSubStereotype;
    Property stereoEnum;
    Property stereoX;
    Property stereoTag;
    Enumeration testEnumeration;
    EnumerationLiteral maybe;
    EnumerationLiteral no;
    EnumerationLiteral yes;
    Class tag;
    EClass eTag;
    Property tagName;
    EAttribute eTagName;

    public void test_parseStereotypeConstraint() {
        this.helper.setContext((Object)this.testStereotype);
        try {
            Constraint constraint = (Constraint)this.helper.createInvariant("base_Classifier.name = 'Fruit' implies (x > 0 or yesno = YesNo::yes)");
            this.fruit.applyStereotype(this.testStereotype);
            this.fruit.setValue(this.testStereotype, this.stereoX.getName(), (Object)0);
            this.fruit.setValue(this.testStereotype, this.stereoEnum.getName(), (Object)this.no);
            this.tree.applyStereotype(this.testStereotype);
            this.tree.setValue(this.testStereotype, this.stereoX.getName(), (Object)0);
            this.tree.setValue(this.testStereotype, this.stereoEnum.getName(), (Object)this.no);
            ProfilesTest.assertFalse((boolean)this.ocl.check((Object)this.fruit, (Object)constraint));
            ProfilesTest.assertTrue((boolean)this.ocl.check((Object)this.tree, (Object)constraint));
            this.fruit.setValue(this.testStereotype, this.stereoX.getName(), (Object)1);
            ProfilesTest.assertTrue((boolean)this.ocl.check((Object)this.fruit, (Object)constraint));
            this.fruit.setValue(this.testStereotype, this.stereoX.getName(), (Object)0);
            this.fruit.setValue(this.testStereotype, this.stereoEnum.getName(), (Object)this.yes);
            ProfilesTest.assertTrue((boolean)this.ocl.check((Object)this.fruit, (Object)constraint));
        }
        catch (Exception e) {
            ProfilesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_parseStereotypeConstraint_substereotype_243098() {
        this.helper.setContext((Object)this.testStereotype);
        try {
            Constraint constraint = (Constraint)this.helper.createInvariant("base_Classifier.name = 'Fruit' implies (x > 0 or yesno = YesNo::yes)");
            this.fruit.applyStereotype(this.testSubStereotype);
            this.fruit.setValue(this.testSubStereotype, this.stereoX.getName(), (Object)0);
            this.fruit.setValue(this.testSubStereotype, this.stereoEnum.getName(), (Object)this.no);
            this.tree.applyStereotype(this.testSubStereotype);
            this.tree.setValue(this.testSubStereotype, this.stereoX.getName(), (Object)0);
            this.tree.setValue(this.testSubStereotype, this.stereoEnum.getName(), (Object)this.no);
            ProfilesTest.assertFalse((boolean)this.ocl.check((Object)this.fruit, (Object)constraint));
            ProfilesTest.assertTrue((boolean)this.ocl.check((Object)this.tree, (Object)constraint));
            this.fruit.setValue(this.testSubStereotype, this.stereoX.getName(), (Object)1);
            ProfilesTest.assertTrue((boolean)this.ocl.check((Object)this.fruit, (Object)constraint));
            this.fruit.setValue(this.testSubStereotype, this.stereoX.getName(), (Object)0);
            this.fruit.setValue(this.testSubStereotype, this.stereoEnum.getName(), (Object)this.yes);
            ProfilesTest.assertTrue((boolean)this.ocl.check((Object)this.fruit, (Object)constraint));
        }
        catch (Exception e) {
            ProfilesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_navigateToStereotypeApplication() {
        this.helper.setContext((Object)((Classifier)this.getMetametaclass("Classifier")));
        try {
            Constraint constraint = (Constraint)this.helper.createInvariant("let st : TestProfile::Stereo1 = self.extension_Stereo1 in st <> null implies st.x > 0 or st.yesno = TestProfile::YesNo::yes");
            ProfilesTest.assertTrue((boolean)this.ocl.check((Object)this.fruit, (Object)constraint));
            this.fruit.applyStereotype(this.testStereotype);
            this.fruit.setValue(this.testStereotype, this.stereoX.getName(), (Object)0);
            this.fruit.setValue(this.testStereotype, this.stereoEnum.getName(), (Object)this.no);
            ProfilesTest.assertFalse((boolean)this.ocl.check((Object)this.fruit, (Object)constraint));
            this.fruit.setValue(this.testStereotype, this.stereoX.getName(), (Object)1);
            ProfilesTest.assertTrue((boolean)this.ocl.check((Object)this.fruit, (Object)constraint));
            this.fruit.setValue(this.testStereotype, this.stereoX.getName(), (Object)0);
            this.fruit.setValue(this.testStereotype, this.stereoEnum.getName(), (Object)this.yes);
            ProfilesTest.assertTrue((boolean)this.ocl.check((Object)this.fruit, (Object)constraint));
        }
        catch (Exception e) {
            ProfilesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_allInstances_stereotype_241148() {
        this.helper.setContext((Object)this.testStereotype);
        try {
            OCLExpression expr = this.helper.createQuery("Stereo1.allInstances().base_Classifier.name");
            this.fruit.applyStereotype(this.testStereotype);
            this.tree.applyStereotype(this.testStereotype);
            Bag expectedValue = CollectionUtil.createNewBag();
            expectedValue.add((Object)"Fruit");
            expectedValue.add((Object)"Tree");
            ProfilesTest.assertEquals((Object)expectedValue, (Object)this.evaluate(expr, this.fruit));
        }
        catch (Exception e) {
            ProfilesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_allInstances_profileClass_241148() {
        this.helper.setContext((Object)this.testStereotype);
        try {
            OCLExpression expr = this.helper.createQuery("Tag.allInstances()");
            this.fruit.applyStereotype(this.testStereotype);
            EObject tag1 = EcoreUtil.create((EClass)this.eTag);
            List tags = (List)this.fruit.getValue(this.testStereotype, this.stereoTag.getName());
            tags.add(tag1);
            tag1.eSet((EStructuralFeature)this.eTagName, (Object)"myTag");
            this.tree.applyStereotype(this.testStereotype);
            EObject tag2 = EcoreUtil.create((EClass)this.eTag);
            tags = (List)this.tree.getValue(this.testStereotype, this.stereoTag.getName());
            tags.add(tag2);
            tag2.eSet((EStructuralFeature)this.eTagName, (Object)"anotherTag");
            HashSet<EObject> expectedInstances = new HashSet<EObject>();
            expectedInstances.add(tag1);
            expectedInstances.add(tag2);
            ProfilesTest.assertEquals(expectedInstances, (Object)this.evaluate(expr, this.fruit));
            expr = this.helper.createQuery("Tag.allInstances().name");
            Bag expectedValue = CollectionUtil.createNewBag();
            expectedValue.add((Object)"myTag");
            expectedValue.add((Object)"anotherTag");
            ProfilesTest.assertEquals((Object)expectedValue, (Object)this.evaluate(expr, this.fruit));
        }
        catch (Exception e) {
            ProfilesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_navigateToStereotypeApplication_247079() {
        this.helper.setContext((Object)((Classifier)this.getMetametaclass("Classifier")));
        Package nested = ((Package)this.fruitPackage).createNestedPackage("nested");
        nested.getPackagedElements().add((Object)this.fruit);
        try {
            try {
                Callable<Void> call = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Constraint constraint = (Constraint)ProfilesTest.this.helper.createInvariant("let st : TestProfile::Stereo1 = self.extension_Stereo1 in st <> null implies st.x > 0 or st.yesno = TestProfile::YesNo::yes");
                        ProfilesTest.assertTrue((boolean)ProfilesTest.this.ocl.check((Object)ProfilesTest.this.fruit, (Object)constraint));
                        ProfilesTest.this.fruit.applyStereotype(ProfilesTest.this.testStereotype);
                        ProfilesTest.this.fruit.setValue(ProfilesTest.this.testStereotype, ProfilesTest.this.stereoX.getName(), (Object)0);
                        ProfilesTest.this.fruit.setValue(ProfilesTest.this.testStereotype, ProfilesTest.this.stereoEnum.getName(), (Object)ProfilesTest.this.no);
                        ProfilesTest.assertFalse((boolean)ProfilesTest.this.ocl.check((Object)ProfilesTest.this.fruit, (Object)constraint));
                        ProfilesTest.this.fruit.setValue(ProfilesTest.this.testStereotype, ProfilesTest.this.stereoX.getName(), (Object)1);
                        ProfilesTest.assertTrue((boolean)ProfilesTest.this.ocl.check((Object)ProfilesTest.this.fruit, (Object)constraint));
                        ProfilesTest.this.fruit.setValue(ProfilesTest.this.testStereotype, ProfilesTest.this.stereoX.getName(), (Object)0);
                        ProfilesTest.this.fruit.setValue(ProfilesTest.this.testStereotype, ProfilesTest.this.stereoEnum.getName(), (Object)ProfilesTest.this.yes);
                        ProfilesTest.assertTrue((boolean)ProfilesTest.this.ocl.check((Object)ProfilesTest.this.fruit, (Object)constraint));
                        return null;
                    }
                };
                exec.submit(call).get(60L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                ProfilesTest.fail((String)"Timed out waiting for evaluation");
                ((Package)this.fruitPackage).getPackagedElements().add((Object)this.fruit);
                nested.destroy();
            }
            catch (Exception e) {
                ProfilesTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
                ((Package)this.fruitPackage).getPackagedElements().add((Object)this.fruit);
                nested.destroy();
            }
        }
        finally {
            ((Package)this.fruitPackage).getPackagedElements().add((Object)this.fruit);
            nested.destroy();
        }
    }

    protected void setUp() {
        super.setUp();
        if (this.testProfile == null) {
            this.initTestProfile();
        }
        ((Package)this.fruitPackage).applyProfile(this.testProfile);
        this.expectModified = true;
    }

    public void tearDown_testProfile() {
        ((Package)this.fruitPackage).unapplyProfile(this.testProfile);
        this.testProfile = null;
    }

    private void initTestProfile() {
        Resource res = ((Package)this.fruitPackage).eResource();
        URI uri = res.getURI().trimSegments(1).appendSegment("OCLTest.profile.uml");
        res = resourceSet.getResource(uri, true);
        this.testProfile = (Profile)res.getContents().get(0);
        this.testStereotype = this.testProfile.getOwnedStereotype("Stereo1");
        ProfilesTest.assertNotNull((Object)this.testStereotype);
        this.stereoEnum = this.testStereotype.getOwnedAttribute("yesno", null);
        ProfilesTest.assertNotNull((Object)this.stereoEnum);
        this.stereoX = this.testStereotype.getOwnedAttribute("x", null);
        ProfilesTest.assertNotNull((Object)this.stereoX);
        this.stereoTag = this.testStereotype.getOwnedAttribute("tag", null);
        ProfilesTest.assertNotNull((Object)this.stereoTag);
        this.testSubStereotype = this.testProfile.getOwnedStereotype("SubStereo1");
        ProfilesTest.assertNotNull((Object)this.testSubStereotype);
        this.testEnumeration = (Enumeration)this.testProfile.getOwnedType("YesNo");
        ProfilesTest.assertNotNull((Object)this.testEnumeration);
        this.maybe = this.testEnumeration.getOwnedLiteral("maybe");
        ProfilesTest.assertNotNull((Object)this.maybe);
        this.no = this.testEnumeration.getOwnedLiteral("no");
        ProfilesTest.assertNotNull((Object)this.no);
        this.yes = this.testEnumeration.getOwnedLiteral("yes");
        ProfilesTest.assertNotNull((Object)this.yes);
        this.tag = (Class)this.testProfile.getOwnedType("Tag");
        ProfilesTest.assertNotNull((Object)this.tag);
        this.eTag = (EClass)this.testProfile.getDefinition((NamedElement)this.tag);
        ProfilesTest.assertNotNull((Object)this.eTag);
        this.tagName = this.tag.getOwnedAttribute("name", null);
        ProfilesTest.assertNotNull((Object)this.tagName);
        this.eTagName = (EAttribute)this.eTag.getEStructuralFeature(this.tagName.getName());
        ProfilesTest.assertNotNull((Object)this.eTagName);
    }
}

