/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.tests;

import java.math.BigInteger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.tests.GenericEvaluationTestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericEvaluationNumberOperationTest<E extends EObject, PK extends E, T extends E, C extends T, CLS extends C, DT extends C, PT extends C, ET extends DT, O extends E, PM extends E, P extends E, PA extends P, PR extends P, EL, S, COA, SSA, CT>
extends GenericEvaluationTestSuite<E, PK, T, C, CLS, DT, PT, ET, O, PM, P, PA, PR, EL, S, COA, SSA, CT> {
    public void testNumberAbs() {
        this.assertResult(3, "3.abs()");
        this.assertResult(3, "(-3).abs()");
        this.assertResult(Integer.MAX_VALUE, "2147483647.abs()");
        this.assertParserError("2147483648.abs()", "For input string: \"{0}\"", "2147483648");
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)true);
        this.assertResult(0x80000000L, "2147483648.abs()");
        this.assertResult(0x80000001L, "(-2147483649).abs()");
        this.assertResult(0x80000000L, "(-2147483648).abs()");
        this.assertResult(3.0, "(3.0).abs()");
        this.assertResult(3.0, "(-3.0).abs()");
        this.assertResult(3.1758, "(3.1758).abs()");
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)false);
    }

    public void testNumberAbsInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in i.abs()");
        this.assertResultInvalid("let r : Real = invalid in r.abs()");
    }

    public void testNumberAbsNull() {
        this.assertResultInvalid("let i : Integer = null in i.abs()");
        this.assertResultInvalid("let r : Real = null in r.abs()");
    }

    public void testNumberDiv() {
        this.assertResult(1, "3.div(2)");
        this.assertResult(-1, "(-3).div(2)");
        this.assertResult(-1, "3.div(-2)");
        this.assertResult(1, "(-3).div(-2)");
    }

    public void testNumberDivByZero() {
        this.assertResultInvalid("1.div(0)");
    }

    public void testNumberDivide() {
        this.assertResult(1.0, "1 / 1");
        this.assertResult(-0.25, "1 / -4");
        this.assertResult(1.0, "1 / 1.0");
        this.assertResult(-0.25, "1 / -4.0");
        this.assertResult(1.0, "1.0 / 1");
        this.assertResult(-0.25, "1.0 / -4");
        this.assertResult(1.0, "1.0 / 1.0");
        this.assertResult(0.9910714285714286, "1.11 / 1.12");
    }

    public void testNumberDivideByZero() {
        this.assertResultInvalid("1 / 0");
        this.assertResultInvalid("1.0 / 0");
        this.assertResultInvalid("1 / 0.0");
        this.assertResultInvalid("1.0 / 0.0");
    }

    public void testNumberDivideInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in 1 / i");
        this.assertResultInvalid("let i : Integer = invalid in i / 1");
        this.assertResultInvalid("let r : Real = invalid in 1 / r");
        this.assertResultInvalid("let r : Real = invalid in r / 1");
        this.assertResultInvalid("let i1 : Integer = invalid, i2 : Integer = invalid in i1 / i2");
        this.assertResultInvalid("let r1 : Real = invalid, r2 : Real = invalid in r1 / r2");
    }

    public void testNumberDivideNull() {
        this.assertResultInvalid("let i : Integer = null in 1 / i");
        this.assertResultInvalid("let i : Integer = null in i / 1");
        this.assertResultInvalid("let r : Real = null in 1 / r");
        this.assertResultInvalid("let r : Real = null in r / 1");
        this.assertResultInvalid("let i1 : Integer = null, i2 : Integer = null in i1 / i2");
        this.assertResultInvalid("let r1 : Real = null, r2 : Real = null in r1 / r2");
    }

    public void testNumberDivInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in 1.div(i)");
        this.assertResultInvalid("let i : Integer = invalid in i.div(1)");
        this.assertResultInvalid("let i1 : Integer = invalid, i2 : Integer = invalid in i1.div(i2)");
    }

    public void testNumberDivNull() {
        this.assertResultInvalid("let i : Integer = null in 1.div(i)");
        this.assertResultInvalid("let i : Integer = null in i.div(1)");
        this.assertResultInvalid("let i1 : Integer = null, i2 : Integer = null in i1.div(i2)");
    }

    public void testNumberEqual() {
        this.assertResultFalse("4 = 5");
        this.assertResultFalse("1 = 4.0");
        this.assertResultFalse("1.0 = 4");
        this.assertResultFalse("1.0 = 4.0");
        this.assertResultTrue("4 = 4");
        this.assertResultTrue("1 = 1.0");
        this.assertResultTrue("1.0 = 1");
        this.assertResultTrue("1.0 = 1.0");
    }

    public void testNumberEqualInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in i = 0");
        this.assertResultInvalid("let i : Integer = invalid in -1 = i");
        this.assertResultInvalid("let r : Real = invalid in r = 0.0");
        this.assertResultInvalid("let r : Real = invalid in -1.0 = r");
        this.assertResultInvalid("let i1 : Integer = invalid, i2 : Integer = invalid in i1 = i2");
        this.assertResultInvalid("let r1 : Real = invalid, r2 : Real = invalid in r1 = r2");
    }

    public void testNumberEqualNull() {
        this.assertResultFalse("let i : Integer = null in i = 0");
        this.assertResultFalse("let i : Integer = null in -1 = i");
        this.assertResultFalse("let r : Real = null in r = 0.0");
        this.assertResultFalse("let r : Real = null in -1.0 = r");
        this.assertResultTrue("let i1 : Integer = null, i2 : Integer = null in i1 = i2");
        this.assertResultTrue("let r1 : Real = null, r2 : Real = null in r1 = r2");
    }

    public void testNumberFloor() {
        this.assertResult(3, "3.floor()");
        this.assertResult(-3, "(-3).floor()");
        this.assertResult(-2, "(-1.5).floor()");
        this.assertResult(1, "(1.01).floor()");
        this.assertResult(3, "(3.999).floor()");
    }

    public void testNumberFloorInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in i.floor()");
        this.assertResultInvalid("let r : Real = invalid in r.floor()");
    }

    public void testNumberFloorNull() {
        this.assertResultInvalid("let i : Integer = null in i.floor()");
        this.assertResultInvalid("let r : Real = null in r.floor()");
    }

    public void testNumberGreaterThan() {
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)true);
        this.assertResultTrue("3 > 2");
        this.assertResultFalse("-3 > 2");
        this.assertResultTrue("3 > -2");
        this.assertResultFalse("-3 > -2");
        this.assertQueryTrue(null, "2147483648 > 2147483647");
        this.assertQueryFalse(null, "2147483647 > 2147483648");
        this.assertQueryFalse(null, "-2147483649 > -2147483648");
        this.assertQueryTrue(null, "-2147483648 > -2147483649");
        this.assertQueryTrue(null, "2147483648 >= 2147483647");
        this.assertQueryFalse(null, "2147483647 >= 2147483648");
        this.assertQueryFalse(null, "-2147483649 >= -2147483648");
        this.assertQueryTrue(null, "-2147483648 >= -2147483649");
        this.assertResultTrue("3.0 > 2.0");
        this.assertResultFalse("-3.0 > 2.0");
        this.assertResultTrue("3.0 > -2.0");
        this.assertResultFalse("-3.0 > -2.0");
        this.assertResultFalse("3.0 > 3");
        this.assertResultFalse("-3.0 > 3");
        this.assertResultTrue("3.0 > -3");
        this.assertResultFalse("-3.0 > -3");
        this.assertResultFalse("3 > 3.0");
        this.assertResultFalse("-3 > 3.0");
        this.assertResultTrue("3 > -3.0");
        this.assertResultFalse("-3 > -3.0");
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)false);
    }

    public void testNumberGreaterThanInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in i > 0");
        this.assertResultInvalid("let i : Integer = invalid in 0 > i");
        this.assertResultInvalid("let r : Real = invalid in r > 0");
        this.assertResultInvalid("let r : Real = invalid in 0 > r");
        this.assertResultInvalid("let i1 : Integer = invalid, i2 : Integer = invalid in i1 > i2");
        this.assertResultInvalid("let r1 : Real = invalid, r2 : Real = invalid in r1 > r2");
    }

    public void testNumberGreaterThanNull() {
        this.assertResultInvalid("let i : Integer = null in i > 0");
        this.assertResultInvalid("let i : Integer = null in 0 > i");
        this.assertResultInvalid("let r : Real = null in r > 0");
        this.assertResultInvalid("let r : Real = null in 0 > r");
        this.assertResultInvalid("let i1 : Integer = null, i2 : Integer = null in i1 > i2");
        this.assertResultInvalid("let r1 : Real = null, r2 : Real = null in r1 > r2");
    }

    public void testNumberGreaterThanOrEqual() {
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)true);
        this.assertResultTrue("3 >= 2");
        this.assertResultFalse("-3 >= 2");
        this.assertResultTrue("3 >= -2");
        this.assertResultFalse("-3 >= -2");
        this.assertQueryTrue(null, "2147483648 >= 2147483647");
        this.assertQueryFalse(null, "2147483647 >= 2147483648");
        this.assertQueryFalse(null, "-2147483649 >= -2147483648");
        this.assertQueryTrue(null, "-2147483648 >= -2147483649");
        this.assertResultTrue("3.0 >= 2.0");
        this.assertResultFalse("-3.0 >= 2.0");
        this.assertResultTrue("3.0 >= -2.0");
        this.assertResultFalse("-3.0 >= -2.0");
        this.assertResultTrue("3.0 >= 3");
        this.assertResultFalse("-3.0 >= 3");
        this.assertResultTrue("3.0 >= -3");
        this.assertResultTrue("-3.0 >= -3");
        this.assertResultTrue("3 >= 3.0");
        this.assertResultFalse("-3 >= 3.0");
        this.assertResultTrue("3 >= -3.0");
        this.assertResultTrue("-3 >= -3.0");
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)true);
    }

    public void testNumberGreaterThanOrEqualInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in i >= 0");
        this.assertResultInvalid("let i : Integer = invalid in 0 >= i");
        this.assertResultInvalid("let r : Real = invalid in r >= 0");
        this.assertResultInvalid("let r : Real = invalid in 0 >= r");
        this.assertResultInvalid("let i1 : Integer = invalid, i2 : Integer = invalid in i1 >= i2");
        this.assertResultInvalid("let r1 : Real = invalid, r2 : Real = invalid in r1 >= r2");
    }

    public void testNumberGreaterThanOrEqualNull() {
        this.assertResultInvalid("let i : Integer = null in i >= 0");
        this.assertResultInvalid("let i : Integer = null in 0 >= i");
        this.assertResultInvalid("let r : Real = null in r >= 0");
        this.assertResultInvalid("let r : Real = null in 0 >= r");
        this.assertResultInvalid("let i1 : Integer = null, i2 : Integer = null in i1 >= i2");
        this.assertResultInvalid("let r1 : Real = null, r2 : Real = null in r1 >= r2");
    }

    public void testNumberLessThan() {
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)true);
        this.assertResultFalse("3 < 2");
        this.assertResultTrue("-3 < 2");
        this.assertResultFalse("3 < -2");
        this.assertResultTrue("-3 < -2");
        this.assertQueryFalse(null, "2147483648 < 2147483647");
        this.assertQueryTrue(null, "2147483647 < 2147483648");
        this.assertQueryTrue(null, "-2147483649 < -2147483648");
        this.assertQueryFalse(null, "-2147483648 < -2147483649");
        this.assertResultFalse("3.0 < 2.0");
        this.assertResultTrue("-3.0 < 2.0");
        this.assertResultFalse("3.0 < -2.0");
        this.assertResultTrue("-3.0 < -2.0");
        this.assertResultFalse("3.0 < 3");
        this.assertResultTrue("-3.0 < 3");
        this.assertResultFalse("3.0 < -3");
        this.assertResultFalse("-3.0 < -3");
        this.assertResultFalse("3 < 3.0");
        this.assertResultTrue("-3 < 3.0");
        this.assertResultFalse("3 < -3.0");
        this.assertResultFalse("-3 < -3.0");
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)false);
    }

    public void testNumberLessThanInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in i < 0");
        this.assertResultInvalid("let i : Integer = invalid in 0 < i");
        this.assertResultInvalid("let r : Real = invalid in r < 0");
        this.assertResultInvalid("let r : Real = invalid in 0 < r");
        this.assertResultInvalid("let i1 : Integer = invalid, i2 : Integer = invalid in i1 < i2");
        this.assertResultInvalid("let r1 : Real = invalid, r2 : Real = invalid in r1 < r2");
    }

    public void testNumberLessThanNull() {
        this.assertResultInvalid("let i : Integer = null in i < 0");
        this.assertResultInvalid("let i : Integer = null in 0 < i");
        this.assertResultInvalid("let r : Real = null in r < 0");
        this.assertResultInvalid("let r : Real = null in 0 < r");
        this.assertResultInvalid("let i1 : Integer = null, i2 : Integer = null in i1 < i2");
        this.assertResultInvalid("let r1 : Real = null, r2 : Real = null in r1 < r2");
    }

    public void testNumberLessThanOrEqual() {
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)true);
        this.assertResultFalse("3 <= 2");
        this.assertResultTrue("-3 <= 2");
        this.assertResultFalse("3 <= -2");
        this.assertResultTrue("-3 <= -2");
        this.assertQueryFalse(null, "2147483648 <= 2147483647");
        this.assertQueryTrue(null, "2147483647 <= 2147483648");
        this.assertQueryTrue(null, "-2147483649 <= -2147483648");
        this.assertQueryFalse(null, "-2147483648 <= -2147483649");
        this.assertResultFalse("3.0 <= 2.0");
        this.assertResultTrue("-3.0 <= 2.0");
        this.assertResultFalse("3.0 <= -2.0");
        this.assertResultTrue("-3.0 <= -2.0");
        this.assertResultTrue("3.0 <= 3");
        this.assertResultTrue("-3.0 <= 3");
        this.assertResultFalse("3.0 <= -3");
        this.assertResultTrue("-3.0 <= -3");
        this.assertResultTrue("3 <= 3.0");
        this.assertResultTrue("-3 <= 3.0");
        this.assertResultFalse("3 <= -3.0");
        this.assertResultTrue("-3 <= -3.0");
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)false);
    }

    public void testNumberLessThanOrEqualInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in i <= 0");
        this.assertResultInvalid("let i : Integer = invalid in 0 <= i");
        this.assertResultInvalid("let r : Real = invalid in r <= 0");
        this.assertResultInvalid("let r : Real = invalid in 0 <= r");
        this.assertResultInvalid("let i1 : Integer = invalid, i2 : Integer = invalid in i1 <= i2");
        this.assertResultInvalid("let r1 : Real = invalid, r2 : Real = invalid in r1 <= r2");
    }

    public void testNumberLessThanOrEqualNull() {
        this.assertResultInvalid("let i : Integer = null in i <= 0");
        this.assertResultInvalid("let i : Integer = null in 0 <= i");
        this.assertResultInvalid("let r : Real = null in r <= 0");
        this.assertResultInvalid("let r : Real = null in 0 <= r");
        this.assertResultInvalid("let i1 : Integer = null, i2 : Integer = null in i1 <= i2");
        this.assertResultInvalid("let r1 : Real = null, r2 : Real = null in r1 <= r2");
    }

    public void testNumberMax() {
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)true);
        this.assertResult(3, "3.max(2)");
        this.assertResult(2, "(-3).max(2)");
        this.assertResult(3, "3.max(-2)");
        this.assertResult(-2, "(-3).max(-2)");
        this.assertResult(0x80000000L, "2147483648.max(2147483647)");
        this.assertResult(0x80000000L, "2147483647.max(2147483648)");
        this.assertResult(Integer.MIN_VALUE, "(-2147483649).max(-2147483648)");
        this.assertResult(Integer.MIN_VALUE, "(-2147483648).max(-2147483649)");
        this.assertResult(3.0, "3.max(2.0)");
        this.assertResult(2.0, "(-3).max(2.0)");
        this.assertResult(3.0, "3.max(-2.0)");
        this.assertResult(-2.0, "(-3).max(-2.0)");
        this.assertResult(3.0, "(3.0).max(2)");
        this.assertResult(2.0, "(-3.0).max(2)");
        this.assertResult(3.0, "(3.0).max(-2)");
        this.assertResult(-2.0, "(-3.0).max(-2)");
        this.assertResult(3.0, "(3.0).max(2.0)");
        this.assertResult(2.0, "(-3.0).max(2.0)");
        this.assertResult(3.0, "(3.0).max(-2.0)");
        this.assertResult(-2.0, "(-3.0).max(-2.0)");
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)false);
    }

    public void testNumberMaxInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in 1.max(i)");
        this.assertResultInvalid("let i : Integer = invalid in i.max(1)");
        this.assertResultInvalid("let r : Real = invalid in 1.max(r)");
        this.assertResultInvalid("let r : Real = invalid in r.max(1)");
        this.assertResultInvalid("let i1 : Integer = invalid, i2 : Integer = invalid in i1.max(i2)");
        this.assertResultInvalid("let r1 : Real = invalid, r2 : Real = invalid in r1.max(r2)");
    }

    public void testNumberMaxNull() {
        this.assertResultInvalid("let i : Integer = null in 1.max(i)");
        this.assertResultInvalid("let i : Integer = null in i.max(1)");
        this.assertResultInvalid("let r : Real = null in 1.max(r)");
        this.assertResultInvalid("let r : Real = null in r.max(1)");
        this.assertResultInvalid("let i1 : Integer = null, i2 : Integer = null in i1.max(i2)");
        this.assertResultInvalid("let r1 : Real = null, r2 : Real = null in r1.max(r2)");
    }

    public void testNumberMin() {
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)true);
        this.assertResult(2, "3.min(2)");
        this.assertResult(-3, "(-3).min(2)");
        this.assertResult(-2, "3.min(-2)");
        this.assertResult(-3, "(-3).min(-2)");
        this.assertResult(Integer.MAX_VALUE, "2147483648.min(2147483647)");
        this.assertResult(Integer.MAX_VALUE, "2147483647.min(2147483648)");
        this.assertResult(-2147483649L, "(-2147483649).min(-2147483648)");
        this.assertResult(-2147483649L, "(-2147483648).min(-2147483649)");
        this.assertResult(2.0, "3.min(2.0)");
        this.assertResult(-3.0, "(-3).min(2.0)");
        this.assertResult(-2.0, "3.min(-2.0)");
        this.assertResult(-3.0, "(-3).min(-2.0)");
        this.assertResult(2.0, "(3.0).min(2)");
        this.assertResult(-3.0, "(-3.0).min(2)");
        this.assertResult(-2.0, "(3.0).min(-2)");
        this.assertResult(-3.0, "(-3.0).min(-2)");
        this.assertResult(2.0, "(3.0).min(2.0)");
        this.assertResult(-3.0, "(-3.0).min(2.0)");
        this.assertResult(-2.0, "(3.0).min(-2.0)");
        this.assertResult(-3.0, "(-3.0).min(-2.0)");
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)false);
    }

    public void testNumberMinInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in 1.min(i)");
        this.assertResultInvalid("let i : Integer = invalid in i.min(1)");
        this.assertResultInvalid("let r : Real = invalid in 1.min(r)");
        this.assertResultInvalid("let r : Real = invalid in r.min(1)");
        this.assertResultInvalid("let i1 : Integer = invalid, i2 : Integer = invalid in i1.min(i2)");
        this.assertResultInvalid("let r1 : Real = invalid, r2 : Real = invalid in r1.min(r2)");
    }

    public void testNumberMinNull() {
        this.assertResultInvalid("let i : Integer = null in 1.min(i)");
        this.assertResultInvalid("let i : Integer = null in i.min(1)");
        this.assertResultInvalid("let r : Real = null in 1.min(r)");
        this.assertResultInvalid("let r : Real = null in r.min(1)");
        this.assertResultInvalid("let i1 : Integer = null, i2 : Integer = null in i1.min(i2)");
        this.assertResultInvalid("let r1 : Real = null, r2 : Real = null in r1.min(r2)");
    }

    public void testNumberMinus() {
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)true);
        this.assertResult(0, "1 - 1");
        this.assertResult(5, "1 - -4");
        this.assertResult(BigInteger.ONE.shiftLeft(31).subtract(BigInteger.ONE).intValue(), "2147483646 - -1");
        this.assertResult(BigInteger.ONE.shiftLeft(31).longValue(), "2147483647 - -1");
        this.assertResult(BigInteger.ONE.shiftLeft(63).subtract(BigInteger.ONE).longValue(), "9223372036854775806 - -1");
        this.assertResult(BigInteger.ONE.shiftLeft(63).longValue(), "9223372036854775807 - -1");
        this.assertResult(BigInteger.ONE.negate().shiftLeft(31).intValue(), "-2147483647 - 1");
        this.assertResult(BigInteger.ONE.negate().shiftLeft(31).subtract(BigInteger.ONE).longValue(), "-2147483648 - 1");
        this.assertResult(BigInteger.ONE.shiftLeft(63).negate().longValue(), "-9223372036854775807 - 1");
        this.assertResult(0.0, "1 - 1.0");
        this.assertResult(5.0, "1 - -4.0");
        this.assertResult(0.0, "1.0 - 1");
        this.assertResult(5.0, "1.0 - -4");
        this.assertResult(0.0, "1.0 - 1.0");
        this.assertResult(-0.01, "1.11 - 1.12");
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)false);
    }

    public void testNumberMinusInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in 1 - i");
        this.assertResultInvalid("let i : Integer = invalid in i - 1");
        this.assertResultInvalid("let r : Real = invalid in 1 - r");
        this.assertResultInvalid("let r : Real = invalid in r - 1");
        this.assertResultInvalid("let i1 : Integer = invalid, i2 : Integer = invalid in i1 - i2");
        this.assertResultInvalid("let r1 : Real = invalid, r2 : Real = invalid in r1 - r2");
    }

    public void testNumberMinusNull() {
        this.assertResultInvalid("let i : Integer = null in 1 - i");
        this.assertResultInvalid("let i : Integer = null in i - 1");
        this.assertResultInvalid("let r : Real = null in 1 - r");
        this.assertResultInvalid("let r : Real = null in r - 1");
        this.assertResultInvalid("let i1 : Integer = null, i2 : Integer = null in i1 - i2");
        this.assertResultInvalid("let r1 : Real = null, r2 : Real = null in r1 - r2");
    }

    public void testNumberMod() {
        this.assertResult(1, "3.mod(2)");
        this.assertResult(-1, "(-3).mod(2)");
        this.assertResult(1, "3.mod(-2)");
        this.assertResult(-1, "(-3).mod(-2)");
    }

    public void testNumberModInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in 1.mod(i)");
        this.assertResultInvalid("let i : Integer = invalid in i.mod(1)");
        this.assertResultInvalid("let i1 : Integer = invalid, i2 : Integer = invalid in i1.mod(i2)");
    }

    public void testNumberModNull() {
        this.assertResultInvalid("let i : Integer = null in 1.mod(i)");
        this.assertResultInvalid("let i : Integer = null in i.mod(1)");
        this.assertResultInvalid("let i1 : Integer = null, i2 : Integer = null in i1.mod(i2)");
    }

    public void testNumberNegate() {
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)true);
        this.assertResult(-1, "-1");
        this.assertResult(-1.0, "-1.0");
        this.assertResult(-2147483647, "-2147483647");
        this.assertResult(Integer.MIN_VALUE, "-2147483648");
        this.assertResult(0x80000000L, "-(-2147483648)");
        this.assertResult(-2147483649L, "-2147483649");
        this.assertResultInvalid("let i : Integer = invalid in -i");
        this.assertResultInvalid("let r : Real = invalid in -r");
        this.assertResultInvalid("let i : Integer = null in -i");
        this.assertResultInvalid("let r : Real = null in -r");
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)false);
    }

    public void testNumberNotEqual() {
        this.assertResultTrue("4 <> 5");
        this.assertResultTrue("1 <> 4.0");
        this.assertResultTrue("1.0 <> 4");
        this.assertResultTrue("1.0 <> 4.0");
        this.assertResultFalse("4 <> 4");
        this.assertResultFalse("1 <> 1.0");
        this.assertResultFalse("1.0 <> 1");
        this.assertResultFalse("1.0 <> 1.0");
    }

    public void testNumberNotEqualInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in i <> 0");
        this.assertResultInvalid("let i : Integer = invalid in -1 <> i");
        this.assertResultInvalid("let r : Real = invalid in r <> 0.0");
        this.assertResultInvalid("let r : Real = invalid in -1.0 <> r");
        this.assertResultInvalid("let i1 : Integer = invalid, i2 : Integer = invalid in i1 <> i2");
        this.assertResultInvalid("let r1 : Real = invalid, r2 : Real = invalid in r1 <> r2");
    }

    public void testNumberNotEqualNull() {
        this.assertResultTrue("let i : Integer = null in i <> 0");
        this.assertResultTrue("let i : Integer = null in -1 <> i");
        this.assertResultTrue("let r : Real = null in r <> 0.0");
        this.assertResultTrue("let r : Real = null in -1.0 <> r");
        this.assertResultFalse("let i1 : Integer = null, i2 : Integer = null in i1 <> i2");
        this.assertResultFalse("let r1 : Real = null, r2 : Real = null in r1 <> r2");
    }

    public void testNumberOclIsInvalid() {
        this.assertResultFalse("3.oclIsInvalid()");
        this.assertResultFalse("(3.0).oclIsInvalid()");
    }

    public void testNumberOclIsUndefined() {
        this.assertResultFalse("3.oclIsUndefined()");
        this.assertResultFalse("(3.0).oclIsUndefined()");
    }

    public void testNumberPlus() {
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)true);
        this.assertResult(2, "1 + 1");
        this.assertResult(-3, "1 + -4");
        this.assertResult(BigInteger.ONE.shiftLeft(31).subtract(BigInteger.ONE).intValue(), "2147483646 + 1");
        this.assertResult(BigInteger.ONE.shiftLeft(31).longValue(), "2147483647 + 1");
        this.assertResult(BigInteger.ONE.shiftLeft(63).subtract(BigInteger.ONE).longValue(), "9223372036854775806 + 1");
        this.assertResult(BigInteger.ONE.shiftLeft(63).longValue(), "9223372036854775807 + 1");
        this.assertResult(BigInteger.ONE.negate().shiftLeft(31).intValue(), "-2147483647 + -1");
        this.assertResult(BigInteger.ONE.negate().shiftLeft(31).subtract(BigInteger.ONE).longValue(), "-2147483648 + -1");
        this.assertResult(BigInteger.ONE.negate().shiftLeft(63).longValue(), "-9223372036854775807 + -1");
        this.assertResult(2.0, "1 + 1.0");
        this.assertResult(-3.0, "1 + -4.0");
        this.assertResult(2.0, "1.0 + 1");
        this.assertResult(-3.0, "1.0 + -4");
        this.assertResult(2.0, "1.0 + 1.0");
        this.assertResult(2.23, "1.11 + 1.12");
        ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_LONG_INTEGERS, (Object)false);
    }

    public void testNumberPlusInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in 1 + i");
        this.assertResultInvalid("let i : Integer = invalid in i + 1");
        this.assertResultInvalid("let r : Real = invalid in 1 + r");
        this.assertResultInvalid("let r : Real = invalid in r + 1");
        this.assertResultInvalid("let i1 : Integer = invalid, i2 : Integer = invalid in i1 + i2");
        this.assertResultInvalid("let r1 : Real = invalid, r2 : Real = invalid in r1 + r2");
    }

    public void testNumberPlusNull() {
        this.assertResultInvalid("let i : Integer = null in 1 + i");
        this.assertResultInvalid("let i : Integer = null in i + 1");
        this.assertResultInvalid("let r : Real = null in 1 + r");
        this.assertResultInvalid("let r : Real = null in r + 1");
        this.assertResultInvalid("let i1 : Integer = null, i2 : Integer = null in i1 + i2");
        this.assertResultInvalid("let r1 : Real = null, r2 : Real = null in r1 + r2");
    }

    public void testNumberRound() {
        this.assertResult(3, "3.round()");
        this.assertResult(-3, "(-3).round()");
        this.assertResult(-1, "(-1.5).round()");
        this.assertResult(1, "(1.01).round()");
        this.assertResult(4, "(3.999).round()");
    }

    public void testNumberRoundInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in i.round()");
        this.assertResultInvalid("let r : Real = invalid in r.round()");
    }

    public void testNumberRoundNull() {
        this.assertResultInvalid("let i : Integer = null in i.round()");
        this.assertResultInvalid("let r : Real = null in r.round()");
    }

    public void testNumberTimes() {
        this.assertResult(1, "1 * 1");
        this.assertResult(-4, "1 * -4");
        this.assertResult(1.0, "1 * 1.0");
        this.assertResult(-4.0, "1 * -4.0");
        this.assertResult(1.0, "1.0 * 1");
        this.assertResult(-4.0, "1.0 * -4");
        this.assertResult(1.0, "1.0 * 1.0");
        this.assertResult(1.2432000000000003, "1.11 * 1.12");
    }

    public void testNumberTimesInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in 1 * i");
        this.assertResultInvalid("let i : Integer = invalid in i * 1");
        this.assertResultInvalid("let r : Real = invalid in 1 * r");
        this.assertResultInvalid("let r : Real = invalid in r * 1");
        this.assertResultInvalid("let i1 : Integer = invalid, i2 : Integer = invalid in i1 * i2");
        this.assertResultInvalid("let r1 : Real = invalid, r2 : Real = invalid in r1 * r2");
    }

    public void testNumberTimesNull() {
        this.assertResultInvalid("let i : Integer = null in 1 * i");
        this.assertResultInvalid("let i : Integer = null in i * 1");
        this.assertResultInvalid("let r : Real = null in 1 * r");
        this.assertResultInvalid("let r : Real = null in r * 1");
        this.assertResultInvalid("let i1 : Integer = null, i2 : Integer = null in i1 * i2");
        this.assertResultInvalid("let r1 : Real = null, r2 : Real = null in r1 * r2");
    }

    public void testNumberToString() {
        this.assertResult("1", "1.toString()");
        this.assertResult("3.0", "3.0.toString()");
        this.assertResult("4.0", "(1.0+3.0).toString()");
        this.assertResult("null", "null.toString()");
        this.assertResult("invalid", "invalid.toString()");
        this.assertResult("*", "*.toString()");
    }

    public void testNumberUnaryMinus() {
        this.assertResult(-1, "-1");
        this.assertResult(-1.0, "-1.0");
    }

    public void testNumberUnaryMinusInvalid() {
        this.assertResultInvalid("let i : Integer = invalid in -i");
        this.assertResultInvalid("let r : Real = invalid in -r");
    }

    public void testNumberUnaryMinusNull() {
        this.assertResultInvalid("let i : Integer = null in -i");
        this.assertResultInvalid("let r : Real = null in -r");
    }

    public void testUnlimitedAbs() {
        this.assertResultInvalid("*.abs()");
    }

    public void testUnlimitedAbsInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u.abs()");
    }

    public void testUnlimitedAbsNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in u.abs()");
    }

    public void testUnlimitedDiv() {
        this.assertResultInvalid("1.div(*)");
        this.assertResultInvalid("*.div(1)");
        this.assertResultInvalid("*.div(*)");
    }

    public void testUnlimitedDivide() {
        this.assertResultInvalid("1 / *");
        this.assertResultInvalid("* / 1");
        this.assertResultInvalid("1.0 / *");
        this.assertResultInvalid("* / 1.0");
        this.assertResultInvalid("* / *");
    }

    public void testUnlimitedDivideByZero() {
        this.assertResultInvalid("* / 0");
        this.assertResultInvalid("* / 0.0");
    }

    public void testUnlimitedDivideInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in * / u");
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u / *");
        this.assertResultInvalid("let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 / u2");
    }

    public void testUnlimitedDivideNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in * / u");
        this.assertResultInvalid("let u : UnlimitedNatural = null in u / *");
        this.assertResultInvalid("let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 / u2");
    }

    public void testUnlimitedDivInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in 1.div(u)");
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u.div(1)");
    }

    public void testUnlimitedDivNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in 1.div(u)");
        this.assertResultInvalid("let u : UnlimitedNatural = null in u.div(1)");
    }

    public void testUnlimitedEqual() {
        this.assertResultFalse("* = 1");
        this.assertResultFalse("1 = *");
        this.assertResultFalse("* = 1.0");
        this.assertResultFalse("1.0 = *");
        this.assertResultTrue("* = *");
    }

    public void testUnlimitedEqualInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u = *");
        this.assertResultInvalid("let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 = u2");
    }

    public void testUnlimitedEqualNull() {
        this.assertResultFalse("let u : UnlimitedNatural = null in u = *");
        this.assertResultTrue("let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 = u2");
    }

    public void testUnlimitedFloor() {
        this.assertResultInvalid("*.floor()");
    }

    public void testUnlimitedFloorInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u.floor()");
    }

    public void testUnlimitedFloorNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in u.floor()");
    }

    public void testUnlimitedGreaterThan() {
        this.assertResultFalse("1 > *");
        this.assertResultTrue("* > 1");
        this.assertResultFalse("* > *");
    }

    public void testUnlimitedGreaterThanInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u > 0");
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in 0 > u");
        this.assertResultInvalid("let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 > u2");
    }

    public void testUnlimitedGreaterThanNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in u > 0");
        this.assertResultInvalid("let u : UnlimitedNatural = null in 0 > u");
        this.assertResultInvalid("let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 > u2");
    }

    public void testUnlimitedGreaterThanOrEqual() {
        this.assertResultFalse("1 >= *");
        this.assertResultTrue("* >= 1");
        this.assertResultTrue("* >= *");
    }

    public void testUnlimitedGreaterThanOrEqualInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u >= 0");
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in 0 >= u");
        this.assertResultInvalid("let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 >= u2");
    }

    public void testUnlimitedGreaterThanOrEqualNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in u >= 0");
        this.assertResultInvalid("let u : UnlimitedNatural = null in 0 >= u");
        this.assertResultInvalid("let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 >= u2");
    }

    public void testUnlimitedLessThan() {
        this.assertResultTrue("1 < *");
        this.assertResultFalse("* < 1");
        this.assertResultFalse("* < *");
    }

    public void testUnlimitedLessThanInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u < 0");
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in 0 < u");
        this.assertResultInvalid("let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 < u2");
    }

    public void testUnlimitedLessThanNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in u < 0");
        this.assertResultInvalid("let u : UnlimitedNatural = null in 0 < u");
        this.assertResultInvalid("let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 < u2");
    }

    public void testUnlimitedLessThanOrEqual() {
        this.assertResultTrue("1 <= *");
        this.assertResultFalse("* <= 1");
        this.assertResultTrue("* <= *");
    }

    public void testUnlimitedLessThanOrEqualInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u <= 0");
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in 0 <= u");
        this.assertResultInvalid("let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 <= u2");
    }

    public void testUnlimitedLessThanOrEqualNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in u <= 0");
        this.assertResultInvalid("let u : UnlimitedNatural = null in 0 <= u");
        this.assertResultInvalid("let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 <= u2");
    }

    public void testUnlimitedMax() {
        this.assertResultInvalid("1.max(*)");
        this.assertResultInvalid("*.max(1)");
        this.assertResultInvalid("(1.0).max(*)");
        this.assertResultInvalid("*.max(1.0)");
        this.assertResultInvalid("*.max(*)");
    }

    public void testUnlimitedMaxInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in *.max(u)");
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u.max(*)");
        this.assertResultInvalid("let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1.max(u2)");
    }

    public void testUnlimitedMaxNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in *.max(u)");
        this.assertResultInvalid("let u : UnlimitedNatural = null in u.max(*)");
        this.assertResultInvalid("let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1.max(u2)");
    }

    public void testUnlimitedMin() {
        this.assertResultInvalid("1.min(*)");
        this.assertResultInvalid("*.min(1)");
        this.assertResultInvalid("(1.0).min(*)");
        this.assertResultInvalid("*.min(1.0)");
        this.assertResultInvalid("*.min(*)");
    }

    public void testUnlimitedMinInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in *.min(u)");
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u.min(*)");
        this.assertResultInvalid("let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1.min(u2)");
    }

    public void testUnlimitedMinNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in *.min(u)");
        this.assertResultInvalid("let u : UnlimitedNatural = null in u.min(*)");
        this.assertResultInvalid("let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1.min(u2)");
    }

    public void testUnlimitedMinus() {
        this.assertResultInvalid("1 - *");
        this.assertResultInvalid("* - 1");
        this.assertResultInvalid("1.0 - *");
        this.assertResultInvalid("* - 1.0");
        this.assertResultInvalid("* - *");
    }

    public void testUnlimitedMinusInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in * - u");
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u - *");
        this.assertResultInvalid("let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 - u2");
    }

    public void testUnlimitedMinusNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in * - u");
        this.assertResultInvalid("let u : UnlimitedNatural = null in u - *");
        this.assertResultInvalid("let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 - u2");
    }

    public void testUnlimitedMod() {
        this.assertResultInvalid("1.mod(*)");
        this.assertResultInvalid("*.mod(1)");
        this.assertResultInvalid("*.mod(*)");
    }

    public void testUnlimitedModInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in 1.mod(u)");
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u.mod(1)");
    }

    public void testUnlimitedModNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in 1.mod(u)");
        this.assertResultInvalid("let u : UnlimitedNatural = null in u.mod(1)");
    }

    public void testUnlimitedNotEqual() {
        this.assertResultTrue("* <> 1");
        this.assertResultTrue("1 <> *");
        this.assertResultTrue("* <> 1.0");
        this.assertResultTrue("1.0 <> *");
        this.assertResultFalse("* <> *");
    }

    public void testUnlimitedNotEqualInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u <> *");
        this.assertResultInvalid("let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 <> u2");
    }

    public void testUnlimitedNotEqualNull() {
        this.assertResultTrue("let u : UnlimitedNatural = null in u <> *");
        this.assertResultFalse("let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 <> u2");
    }

    public void testUnlimitedOclAsType() {
        this.assertResultInvalid("*.oclAsType(Integer)");
        this.assertResultInvalid("*.oclAsType(Real)");
        this.assertResult(-1, "*.oclAsType(UnlimitedNatural)");
        this.assertResultInvalid("*.oclAsType(String)");
        this.assertResult(-1, "*.oclAsType(OclAny)");
        this.assertResultInvalid("*.oclAsType(OclVoid)");
        this.assertResultInvalid("*.oclAsType(OclInvalid)");
    }

    public void testUnlimitedOclIsInvalid() {
        this.assertResultFalse("*.oclIsInvalid()");
    }

    public void testUnlimitedOclIsTypeOf() {
        this.assertResultFalse("*.oclIsTypeOf(Integer)");
        this.assertResultFalse("*.oclIsTypeOf(Real)");
        this.assertResultTrue("*.oclIsTypeOf(UnlimitedNatural)");
        this.assertResultFalse("*.oclIsTypeOf(String)");
        this.assertResultFalse("*.oclIsTypeOf(OclAny)");
        this.assertResultFalse("*.oclIsTypeOf(OclVoid)");
        this.assertResultFalse("*.oclIsTypeOf(OclInvalid)");
    }

    public void testUnlimitedOclIsUndefined() {
        this.assertResultFalse("*.oclIsUndefined()");
    }

    public void testUnlimitedPlus() {
        this.assertResultInvalid("1 + *");
        this.assertResultInvalid("* + 1");
        this.assertResultInvalid("1.0 + *");
        this.assertResultInvalid("* + 1.0");
        this.assertResultInvalid("* + *");
    }

    public void testUnlimitedPlusInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in * + u");
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u + *");
        this.assertResultInvalid("let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 + u2");
    }

    public void testUnlimitedPlusNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in * + u");
        this.assertResultInvalid("let u : UnlimitedNatural = null in u + *");
        this.assertResultInvalid("let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 + u2");
    }

    public void testUnlimitedRound() {
        this.assertResultInvalid("*.round()");
    }

    public void testUnlimitedRoundInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u.round()");
    }

    public void testUnlimitedRoundNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in u.round()");
    }

    public void testUnlimitedTimes() {
        this.assertResultInvalid("1 * *");
        this.assertResultInvalid("* * 1");
        this.assertResultInvalid("1.0 * *");
        this.assertResultInvalid("* * 1.0");
        this.assertResultInvalid("* * *");
    }

    public void testUnlimitedTimesInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in * * u");
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in u * *");
        this.assertResultInvalid("let u1 : UnlimitedNatural = invalid, u2 : UnlimitedNatural = invalid in u1 * u2");
    }

    public void testUnlimitedTimesNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in * * u");
        this.assertResultInvalid("let u : UnlimitedNatural = null in u * *");
        this.assertResultInvalid("let u1 : UnlimitedNatural = null, u2 : UnlimitedNatural = null in u1 * u2");
    }

    public void testUnlimitedUnaryMinus() {
        this.assertResultInvalid("-*");
    }

    public void testUnlimitedUnaryMinusInvalid() {
        this.assertResultInvalid("let u : UnlimitedNatural = invalid in -u");
    }

    public void testUnlimitedUnaryMinusNull() {
        this.assertResultInvalid("let u : UnlimitedNatural = null in -u");
    }
}

