/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.standalone;

import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporter;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCase;
import org.eclipse.ocl.examples.xtext.tests.TestCaseAppender;

public class StandaloneTestCase
extends PivotTestCase {
    protected final @NonNull String inputModelName = this.getProjectFileName("models/EcoreTestFile.ecore");
    protected final @NonNull String inputOCLFileName = this.getProjectFileName("models/eclipse_ocl_rule.ocl");
    protected final @NonNull String inputOCLFileName2 = this.getProjectFileName("models/eclipse_ocl_rule_2.ocl");
    protected final @NonNull String textInputOCLFileName = this.getProjectFileName("models/ocl_rules.txt");

    protected @NonNull String getProjectFileName(String referenceName) {
        @NonNull String projectName = ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/');
        URL projectURL = this.getTestResource(projectName);
        StandaloneTestCase.assertNotNull((Object)projectURL);
        URI uri = URI.createURI((String)projectURL.toString());
        String projectPath = uri.isFile() ? uri.toFileString() : uri.toString();
        projectPath = projectPath.replace("\\", "/");
        if (!projectPath.endsWith("/")) {
            projectPath = String.valueOf(projectPath) + "/";
        }
        return String.valueOf(projectPath) + referenceName;
    }

    protected @NonNull String getHTMLLogFileName() {
        return this.getProjectFileName("models/log_" + this.getName() + ".html");
    }

    protected @NonNull String getTextLogFileName() {
        return this.getProjectFileName("models/log_" + this.getName() + ".txt");
    }

    protected @NonNull String getLogFileName(@NonNull IValidityExporter exporter) {
        return this.getProjectFileName("models/log_" + this.getName() + "." + exporter.getPreferredExtension());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestCaseAppender.INSTANCE.uninstall();
    }
}

