/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.xtext.resource.impl.BinaryGrammarResourceFactoryImpl;

public abstract class AbstractGrammarTests
extends XtextTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected void doTestGrammar(URL binaryURL, @NonNull Resource javaResource) throws IOException, InterruptedException {
        OCL ocl = OCL.newInstance((ProjectManager)OCL.CLASS_PATH);
        ResourceSet resourceSet = ocl.getResourceSet();
        File binaryFile = new File(binaryURL.getFile());
        URI binaryURI = URI.createFileURI((String)binaryFile.toString());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xtextbin", new BinaryGrammarResourceFactoryImpl());
        Resource binaryResource = resourceSet.getResource(binaryURI, true);
        assert (binaryResource != null);
        AbstractGrammarTests.assertNoResourceErrors("Load failed", binaryResource);
        AbstractGrammarTests.assertNoUnresolvedProxies("Java Model", binaryResource);
        AbstractGrammarTests.assertNoValidationErrors("File Model", binaryResource);
        AbstractGrammarTests.assertNoResourceErrors("Java Model", javaResource);
        AbstractGrammarTests.assertNoUnresolvedProxies("Java Model", javaResource);
        AbstractGrammarTests.assertNoValidationErrors("Java Model", javaResource);
        TestUtil.assertSameModel(binaryResource, javaResource);
        ocl.dispose();
    }
}

