/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ocl.examples.xtext.tests.TestUIUtil;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.xtext.oclinecore.ui.internal.OCLinEcoreActivator;
import org.eclipse.ocl.xtext.oclstdlib.scoping.JavaClassScope;
import org.eclipse.ocl.xtext.oclstdlib.ui.internal.OCLstdlibActivator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.XtextContentAssistProcessor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateProposal;

public class CompletionProposalTests
extends XtextTestCase {
    public static final @NonNull IReferenceCompletionProposal abstractKeywordProposal = new ReferenceConfigurableCompletionProposal("abstract");
    public static final @NonNull IReferenceCompletionProposal annotationTemplateProposal = new ReferenceXtextTemplateProposal("Annotation - annotation declaration");
    public static final @NonNull IReferenceCompletionProposal selfKeywordProposal = new ReferenceConfigurableCompletionProposal("self");
    public static final @NonNull IReferenceCompletionProposal sNameProposal = new ReferenceConfigurableCompletionProposal("s");
    protected XtextContentAssistProcessor contentAssistProcessor = null;
    protected XtextEditor editor = null;

    public static void assertExcludes(ICompletionProposal[] actualProposals, IReferenceCompletionProposal expectedProposal) {
        ICompletionProposal[] iCompletionProposalArray = actualProposals;
        int n = actualProposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal actualProposal = iCompletionProposalArray[n2];
            if (expectedProposal.covers(actualProposal)) {
                CompletionProposalTests.fail((String)("Unexpected completion proposal " + expectedProposal));
            }
            ++n2;
        }
    }

    public static void assertIncludes(ICompletionProposal[] actualProposals, IReferenceCompletionProposal expectedProposal) {
        ICompletionProposal[] iCompletionProposalArray = actualProposals;
        int n = actualProposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal actualProposal = iCompletionProposalArray[n2];
            if (expectedProposal.covers(actualProposal)) {
                return;
            }
            ++n2;
        }
        CompletionProposalTests.fail((String)("Missing completion proposal " + expectedProposal));
    }

    protected @NonNull FileEditorInput createEcoreFileEditorInput(@NonNull OCL ocl, @NonNull IContainer container, @NonNull String fileName, @NonNull String testDocument) throws IOException, CoreException {
        String ecoreString = this.createEcoreString(ocl, fileName, testDocument, true);
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(ecoreString, "UTF-8");
        FileEditorInput fileEditorInput = TestUIUtil.createFileEditorInput(container, fileName, (InputStream)inputStream);
        return fileEditorInput;
    }

    protected void doTearDown(XtextEditor editor) {
        TestUIUtil.flushEvents();
        editor.close(false);
        TestUIUtil.flushEvents();
    }

    public void doTestEditor(@NonNull String testContent, @NonNull IReferenceCompletionProposal @Nullable [] expectedProposals, @NonNull IReferenceCompletionProposal @Nullable [] unexpectedProposals) throws Exception {
        int n;
        int n2;
        IReferenceCompletionProposal[] iReferenceCompletionProposalArray;
        int cursorIndex = testContent.indexOf("$");
        String trueContent = testContent.replace("$", "");
        IXtextDocument document = this.editor.getDocument();
        document.set(trueContent);
        ISourceViewer viewer = this.editor.getInternalSourceViewer();
        ICompletionProposal[] actualProposals = this.contentAssistProcessor.computeCompletionProposals((ITextViewer)viewer, cursorIndex);
        if (expectedProposals != null) {
            iReferenceCompletionProposalArray = expectedProposals;
            n2 = expectedProposals.length;
            n = 0;
            while (n < n2) {
                IReferenceCompletionProposal expectedProposal = iReferenceCompletionProposalArray[n];
                CompletionProposalTests.assertIncludes(actualProposals, expectedProposal);
                ++n;
            }
        }
        if (unexpectedProposals != null) {
            iReferenceCompletionProposalArray = unexpectedProposals;
            n2 = unexpectedProposals.length;
            n = 0;
            while (n < n2) {
                IReferenceCompletionProposal unexpectedProposal = iReferenceCompletionProposalArray[n];
                CompletionProposalTests.assertExcludes(actualProposals, unexpectedProposal);
                ++n;
            }
        }
    }

    @Override
    protected void setUp() throws Exception {
        JavaClassScope.SUPPRESS_WORK_THREAD = true;
        TestUIUtil.suppressGitPrefixPopUp();
        super.setUp();
    }

    protected void doSetUp(@NonNull String editorId, Injector injector, @NonNull String fileName, @NonNull String initialContent) throws CoreException, PartInitException, IOException {
        this.contentAssistProcessor = (XtextContentAssistProcessor)injector.getInstance(XtextContentAssistProcessor.class);
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(initialContent, "UTF-8");
        IProject project = TestUtil.createJavaProject("CompletionProposalTests");
        TestUtil.createIFile((IContainer)TestUtil.createFolder((IContainer)project, "META-INF"), "MANIFEST.MF", "Manifest-Version: 1.0\nBundle-ManifestVersion: 2\nBundle-Name: CompletionProposalTests\nBundle-SymbolicName: CompletionProposalTests\nBundle-Version: 1.0.0.qualifier\nBundle-RequiredExecutionEnvironment: JavaSE-1.7\nRequire-Bundle: org.eclipse.ocl.pivot\n");
        TestUtil.createIFile((IContainer)project, ".classpath", "<classpath>\n\t\t\t<classpathentry kind=\"con\" path=\"org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.7\"/>\n\t\t\t<classpathentry kind=\"con\" path=\"org.eclipse.pde.core.requiredPlugins\"/>\n\t\t\t<classpathentry kind=\"src\" path=\"src\"/>\n\t\t\t<classpathentry kind=\"output\" path=\"bin\"/>\n\t\t</classpath>\n");
        TestUtil.createIFile((IContainer)TestUtil.createFolder((IContainer)project, "src"), "Test.java", "import org.eclipse.emf.ecore.provider.*;\npublic class Test {}\n");
        project.build(6, null);
        FileEditorInput fileEditorInput = TestUIUtil.createFileEditorInput((IContainer)project, fileName, (InputStream)inputStream);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = activeWorkbenchWindow.getActivePage();
        this.editor = (XtextEditor)IDE.openEditor((IWorkbenchPage)page, (IEditorInput)fileEditorInput, (String)editorId, (boolean)true);
    }

    public void testEditor_OCLinEcore_Completions() throws Exception {
        Injector injector = OCLinEcoreActivator.getInstance().getInjector("org.eclipse.ocl.xtext.oclinecore.OCLinEcore");
        this.doSetUp("org.eclipse.ocl.xtext.oclinecore.OCLinEcore", injector, "completion.oclinecore", "package test : test = 'test' {}");
        this.doTestEditor("package p : p = 'p' {$}", new IReferenceCompletionProposal[]{abstractKeywordProposal, annotationTemplateProposal}, null);
        this.doTestEditor("package p : p = 'p' { class C { invariant I:$}}", new IReferenceCompletionProposal[]{selfKeywordProposal}, null);
        this.doTestEditor("package p : p = 'p' { class C { property s:String; invariant I:self.$}}", new IReferenceCompletionProposal[]{sNameProposal}, null);
        this.doTearDown(this.editor);
    }

    public void testEditor_OCLstdlib_Completions() throws Exception {
        Injector injector = OCLstdlibActivator.getInstance().getInjector("org.eclipse.ocl.xtext.oclstdlib.OCLstdlib");
        this.doSetUp("org.eclipse.ocl.xtext.oclstdlib.OCLstdlib", injector, "completion.oclstdlib", "import 'http://www.eclipse.org/ocl/2015/Library';\nlibrary ocl : ocl = 'http://www.eclipse.org/ocl/2015/Library' {\n\ttype Complex : PrimitiveType {\n\t}\n}';\n");
        try {
            ReferenceConfigurableCompletionProposal proposal1a = new ReferenceConfigurableCompletionProposal("PrimitiveType");
            ReferenceConfigurableCompletionProposal proposal1b = new ReferenceConfigurableCompletionProposal("{");
            this.doTestEditor("import 'http://www.eclipse.org/ocl/2015/Library';\nlibrary ocl : ocl = 'http://www.eclipse.org/ocl/2015/Library' {\n\ttype Complex : Primitive$ {\n\t}\n}';\n", new IReferenceCompletionProposal[]{proposal1a, proposal1b}, null);
            ReferenceConfigurableCompletionProposal proposal2a = new ReferenceConfigurableCompletionProposal("org.eclipse.emf.common.util.Reflect");
            ReferenceConfigurableCompletionProposal proposal2b = new ReferenceConfigurableCompletionProposal("org.eclipse.emf.common.util.ResourceLocator");
            this.doTestEditor("import 'http://www.eclipse.org/ocl/2015/Library';\nlibrary ocl : ocl = 'http://www.eclipse.org/ocl/2015/Library' {\n\ttype Complex : PrimitiveType {\n\t\toperation testing() : String => 'org.eclipse.emf.common.util.R$';\n\t}\n}';\n", new IReferenceCompletionProposal[]{proposal2a, proposal2b}, null);
            ReferenceConfigurableCompletionProposal proposal3a = new ReferenceConfigurableCompletionProposal("org.eclipse.ocl.pivot.internal.ids.OclInvalidTypeIdImpl");
            ReferenceConfigurableCompletionProposal proposal3b = new ReferenceConfigurableCompletionProposal("org.eclipse.ocl.pivot.internal.ids.OclVoidTypeIdImpl");
            this.doTestEditor("import 'http://www.eclipse.org/ocl/2015/Library';\nlibrary ocl : ocl = 'http://www.eclipse.org/ocl/2015/Library' {\n\ttype Complex : PrimitiveType {\n\t\toperation testing() : String => 'org.eclipse.ocl.pivot.internal.ids.O$';\n\t}\n}';\n", new IReferenceCompletionProposal[]{proposal3a, proposal3b}, null);
        }
        finally {
            this.doTearDown(this.editor);
        }
    }

    public static interface IReferenceCompletionProposal {
        public boolean covers(@NonNull ICompletionProposal var1);
    }

    public static class ReferenceCompletionProposal
    implements IReferenceCompletionProposal {
        protected final @NonNull String name;

        public ReferenceCompletionProposal(@NonNull String name) {
            this.name = name;
        }

        @Override
        public boolean covers(@NonNull ICompletionProposal aProposal) {
            return this.name.equals(aProposal.getDisplayString());
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ReferenceConfigurableCompletionProposal
    extends ReferenceCompletionProposal
    implements IReferenceCompletionProposal {
        public ReferenceConfigurableCompletionProposal(@NonNull String name) {
            super(name);
        }

        @Override
        public boolean covers(@NonNull ICompletionProposal aProposal) {
            if (!(aProposal instanceof ConfigurableCompletionProposal)) {
                return false;
            }
            return super.covers(aProposal);
        }
    }

    public static class ReferenceXtextTemplateProposal
    extends ReferenceCompletionProposal {
        public ReferenceXtextTemplateProposal(@NonNull String name) {
            super(name);
        }

        @Override
        public boolean covers(@NonNull ICompletionProposal aProposal) {
            if (!(aProposal instanceof XtextTemplateProposal)) {
                return false;
            }
            return super.covers(aProposal);
        }
    }
}

