/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.cse;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cse.AbstractAnalysis;
import org.eclipse.ocl.examples.codegen.cse.CommonAnalysis;
import org.eclipse.ocl.examples.codegen.cse.SimpleAnalysis;

public class HashedAnalyses
implements Iterable<AbstractAnalysis> {
    private @NonNull Multimap<Integer, AbstractAnalysis> map;

    public static @Nullable HashedAnalyses intersection(@NonNull HashedAnalyses iHash2Analyses, @NonNull HashedAnalyses jHash2Analyses) {
        HashMultimap intersection = null;
        Iterator iterator = iHash2Analyses.map.keySet().iterator();
        while (iterator.hasNext()) {
            int hash = (Integer)iterator.next();
            Collection jAnalyses = jHash2Analyses.map.get((Object)hash);
            if (jAnalyses == null) continue;
            for (AbstractAnalysis iAnalysis : iHash2Analyses.map.get((Object)hash)) {
                for (AbstractAnalysis jAnalysis : jAnalyses) {
                    if (!iAnalysis.isStructurallyEqualTo(jAnalysis)) continue;
                    if (intersection == null) {
                        intersection = HashMultimap.create();
                    }
                    intersection.put((Object)hash, (Object)iAnalysis);
                    intersection.put((Object)hash, (Object)jAnalysis);
                }
            }
        }
        return intersection != null ? new HashedAnalyses((Multimap<Integer, AbstractAnalysis>)intersection) : null;
    }

    public static <V> void printIndented(@NonNull Appendable appendable, @NonNull Multimap<Integer, V> map, @NonNull String indentation, @NonNull String title) {
        try {
            ArrayList keys = new ArrayList(map.keySet());
            Collections.sort(keys);
            for (Integer key : keys) {
                appendable.append(String.valueOf(indentation) + title + " " + key + "\n");
                for (Object analysis : map.get((Object)key)) {
                    appendable.append(String.valueOf(indentation) + "\t" + analysis.toString() + "\n");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public HashedAnalyses() {
        this.map = HashMultimap.create();
    }

    private HashedAnalyses(@NonNull Multimap<Integer, AbstractAnalysis> map) {
        this.map = map;
    }

    public @NonNull AbstractAnalysis add(@NonNull AbstractAnalysis anAnalysis) {
        int structuralHashCode = anAnalysis.getStructuralHashCode();
        AbstractAnalysis oldAnalysis = this.get(anAnalysis);
        if (oldAnalysis == null) {
            this.map.put((Object)structuralHashCode, (Object)anAnalysis);
            return anAnalysis;
        }
        CommonAnalysis newAnalysis = oldAnalysis.addAnalysis(anAnalysis);
        if (newAnalysis != oldAnalysis) {
            this.map.remove((Object)structuralHashCode, (Object)oldAnalysis);
            this.map.put((Object)structuralHashCode, (Object)newAnalysis);
        }
        return newAnalysis;
    }

    public @NonNull AbstractAnalysis addSimpleAnalysis(@NonNull SimpleAnalysis anAnalysis) {
        int structuralHashCode = anAnalysis.getStructuralHashCode();
        AbstractAnalysis oldAnalysis = this.get(anAnalysis);
        if (oldAnalysis == null || !anAnalysis.getElement().isCommonable()) {
            this.map.put((Object)structuralHashCode, (Object)anAnalysis);
            return anAnalysis;
        }
        CommonAnalysis newAnalysis = oldAnalysis.addAnalysis(anAnalysis);
        if (newAnalysis != oldAnalysis) {
            this.map.remove((Object)structuralHashCode, (Object)oldAnalysis);
            this.map.put((Object)structuralHashCode, (Object)newAnalysis);
        }
        return newAnalysis;
    }

    public @Nullable AbstractAnalysis get(@NonNull AbstractAnalysis childAnalysis) {
        Collection theseAnalyses = this.map.get((Object)childAnalysis.getStructuralHashCode());
        if (theseAnalyses == null) {
            return null;
        }
        for (AbstractAnalysis thisAnalysis : theseAnalyses) {
            if (!thisAnalysis.isStructurallyEqualTo(childAnalysis)) continue;
            return thisAnalysis;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.map.size() <= 0;
    }

    @Override
    public @NonNull Iterator<AbstractAnalysis> iterator() {
        return this.map.values().iterator();
    }

    public @Nullable AbstractAnalysis remove(@NonNull AbstractAnalysis thatAnalysis) {
        int hash = thatAnalysis.getStructuralHashCode();
        Collection theseAnalyses = this.map.get((Object)hash);
        if (theseAnalyses != null) {
            for (AbstractAnalysis thisAnalysis : theseAnalyses) {
                if (!thisAnalysis.isStructurallyEqualTo(thatAnalysis)) continue;
                theseAnalyses.remove(thisAnalysis);
                return thisAnalysis;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        HashedAnalyses.printIndented(s, this.map, "", "");
        return ((Object)s).toString();
    }
}

