/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.cse;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cse.AbstractPlace;
import org.eclipse.ocl.examples.codegen.cse.ControlPlace;
import org.eclipse.ocl.examples.codegen.cse.GlobalPlace;
import org.eclipse.ocl.examples.codegen.cse.StackPlace;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public abstract class LocalPlace
extends AbstractPlace {
    protected final @NonNull GlobalPlace globalPlace;
    private HashSet<ControlPlace> controlPlaces = null;

    public static @NonNull AbstractPlace createLocalPlace(@NonNull Map<CGElement, AbstractPlace> element2place, @NonNull CGValuedElement cgElement) {
        boolean isGlobal = cgElement.isGlobal();
        if (isGlobal) {
            return (AbstractPlace)ClassUtil.nonNullState((Object)element2place.get(null));
        }
        return ControlPlace.createControlPlace(element2place, cgElement);
    }

    protected static @NonNull GlobalPlace getGlobalPlace(@NonNull Map<CGElement, AbstractPlace> element2place) {
        AbstractPlace abstractPlace = element2place.get(null);
        if (abstractPlace instanceof GlobalPlace) {
            return (GlobalPlace)abstractPlace;
        }
        throw new IllegalStateException("No GlobalPlace");
    }

    protected static @NonNull LocalPlace getLocalPlace(@NonNull Map<CGElement, AbstractPlace> element2place, @Nullable CGElement cgElement) {
        if (cgElement == null) {
            throw new IllegalStateException("No LocalPlace for null element");
        }
        AbstractPlace abstractPlace = element2place.get(cgElement);
        return LocalPlace.getLocalPlace(abstractPlace, cgElement);
    }

    protected static @NonNull LocalPlace getLocalPlace(@Nullable AbstractPlace abstractPlace, @NonNull CGElement cgElement) {
        if (abstractPlace instanceof LocalPlace) {
            return (LocalPlace)abstractPlace;
        }
        throw new IllegalStateException("No LocalPlace for " + cgElement);
    }

    protected LocalPlace(@NonNull GlobalPlace globalPlace) {
        this.globalPlace = globalPlace;
    }

    public void addControlPlace(@NonNull ControlPlace controlPlace) {
        if (this.controlPlaces == null) {
            this.controlPlaces = new HashSet();
        }
        this.controlPlaces.add(controlPlace);
    }

    @Override
    public @NonNull GlobalPlace getGlobalPlace() {
        return this.globalPlace;
    }

    @Override
    public abstract @NonNull StackPlace getStackPlace();

    @Override
    public void printHierarchy(@NonNull Appendable appendable, @NonNull String indentation) {
        if (this.controlPlaces != null) {
            for (ControlPlace controlPlace : this.controlPlaces) {
                controlPlace.printHierarchy(appendable, indentation);
            }
        }
    }

    public void prune() {
        if (this.controlPlaces != null) {
            for (ControlPlace controlPlace : this.controlPlaces) {
                controlPlace.prune();
            }
        }
    }

    public void pullUp() {
        if (this.controlPlaces != null) {
            for (ControlPlace controlPlace : this.controlPlaces) {
                controlPlace.pullUp();
            }
        }
    }

    public void pushUp() {
        if (this.controlPlaces != null) {
            for (ControlPlace controlPlace : this.controlPlaces) {
                controlPlace.pushUp();
            }
        }
    }

    public void rewrite() {
        if (this.controlPlaces != null) {
            for (ControlPlace controlPlace : this.controlPlaces) {
                controlPlace.rewrite();
            }
        }
    }
}

