/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.dynamic;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.dynamic.ExplicitClassLoader;
import org.eclipse.ocl.pivot.library.LibraryOperation;

public class OCL2JavaFileObject
extends SimpleJavaFileObject {
    private static @Nullable JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private String javaCode;

    @Deprecated
    public static Class<?> loadClass(@NonNull String qualifiedName, @NonNull String javaCodeSource) throws Exception {
        OCL2JavaFileObject.saveClass(qualifiedName, javaCodeSource);
        Class<?> testClass = Class.forName(qualifiedName);
        return testClass;
    }

    public static Class<?> loadExplicitClass(@NonNull File explicitClassPath, @NonNull String qualifiedClassName) throws ClassNotFoundException, IOException {
        ExplicitClassLoader classLoader = new ExplicitClassLoader(explicitClassPath, qualifiedClassName);
        return classLoader.loadClass(qualifiedClassName);
    }

    @Deprecated
    public static @Nullable LibraryOperation loadLibraryOperationClass(@NonNull String qualifiedName, @NonNull String javaCodeSource) throws Exception {
        OCL2JavaFileObject.saveClass(qualifiedName, javaCodeSource);
        Class<?> testClass = Class.forName(qualifiedName);
        return (LibraryOperation)testClass.newInstance();
    }

    @Deprecated
    public static void saveClass(@NonNull String qualifiedName, @NonNull String javaCodeSource) throws Exception {
        OCL2JavaFileObject.saveClass("bin", qualifiedName, javaCodeSource);
    }

    public static void saveClass(@NonNull String explicitClassPath, @NonNull String qualifiedName, @NonNull String javaCodeSource) throws IOException {
        JavaCompiler compiler2 = compiler;
        if (compiler2 == null) {
            throw new IllegalStateException("No JavaCompiler provided by the Java platform - you need to use a JDK rather than a JRE");
        }
        StandardJavaFileManager stdFileManager2 = compiler2.getStandardFileManager(null, Locale.getDefault(), null);
        if (stdFileManager2 == null) {
            throw new IllegalStateException("No StandardJavaFileManager provided by the Java platform");
        }
        List<OCL2JavaFileObject> compilationUnits = Collections.singletonList(new OCL2JavaFileObject(qualifiedName, javaCodeSource));
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        List<String> compilationOptions = Arrays.asList("-d", explicitClassPath, "-g");
        JavaCompiler.CompilationTask compilerTask = compiler2.getTask(null, stdFileManager2, diagnostics, compilationOptions, null, compilationUnits);
        if (!compilerTask.call().booleanValue()) {
            StringBuilder s = new StringBuilder();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                s.append("\n" + diagnostic);
            }
            if (s.length() > 0) {
                throw new IOException("Failed to compile " + qualifiedName + s.toString());
            }
            System.out.println("Compilation of " + qualifiedName + " returned false but no diagnostics");
        }
        stdFileManager2.close();
    }

    public OCL2JavaFileObject(String qualifiedName, String javaCode) {
        super(URI.create("string:///" + qualifiedName.replaceAll("\\.", "/") + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
        this.javaCode = javaCode;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return this.javaCode;
    }
}

