/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.generator;

import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenOperation;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenParameter;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.generator.GenModelException;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.examples.codegen.java.ImportUtils;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.library.AbstractBinaryOperation;
import org.eclipse.ocl.pivot.library.AbstractOperation;
import org.eclipse.ocl.pivot.library.AbstractTernaryOperation;
import org.eclipse.ocl.pivot.library.AbstractUnaryOperation;
import org.eclipse.ocl.pivot.library.LibraryBinaryOperation;
import org.eclipse.ocl.pivot.library.LibraryOperation;
import org.eclipse.ocl.pivot.library.LibraryTernaryOperation;
import org.eclipse.ocl.pivot.library.LibraryUnaryOperation;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;

public class AbstractGenModelHelper
implements GenModelHelper {
    public static final @NonNull String TABLES_CLASS_SUFFIX = "Tables";
    public static final @NonNull String TABLES_PACKAGE_NAME = "";
    protected final @NonNull PivotMetamodelManager metamodelManager;

    public static @NonNull String encodeName(@NonNull NamedElement element) {
        int arity = element instanceof Operation ? ((Operation)element).getOwnedParameters().size() : 0;
        String rawEncodeName = AbstractGenModelHelper.rawEncodeName((String)ClassUtil.nonNullModel((Object)element.getName()), arity);
        if (element instanceof Operation) {
            int sameNames = 0;
            int myIndex = 0;
            for (Operation operation : ((Operation)element).getOwningClass().getOwnedOperations()) {
                String rawName = AbstractGenModelHelper.rawEncodeName((String)ClassUtil.nonNullModel((Object)operation.getName()), (Integer)ClassUtil.nonNullModel((Object)operation.getOwnedParameters().size()));
                if (!rawName.equals(rawEncodeName)) continue;
                if (operation == element) {
                    myIndex = sameNames;
                }
                ++sameNames;
            }
            if (sameNames > 1) {
                return String.valueOf(myIndex) + "_" + rawEncodeName;
            }
        }
        return rawEncodeName;
    }

    public static @NonNull String rawEncodeName(@NonNull String name, @NonNull Integer arity) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (ch == '<') {
                s.append("_lt_");
            } else if (ch == '>') {
                s.append("_gt_");
            } else if (ch == '=') {
                s.append("_eq_");
            } else if (ch == '+') {
                s.append("_add_");
            } else if (ch == '-') {
                if (arity == 0) {
                    s.append("_neg_");
                } else {
                    s.append("_sub_");
                }
            } else if (ch == '*') {
                s.append("_mul_");
            } else if (ch == '/') {
                s.append("_div_");
            } else if (!Character.isJavaIdentifierPart(ch)) {
                s.append("_" + Integer.toString(ch) + "_");
            } else {
                s.append(ch);
            }
            ++i;
        }
        return s.toString();
    }

    public AbstractGenModelHelper(@NonNull PivotMetamodelManager metamodelManager) {
        this.metamodelManager = metamodelManager;
    }

    @Override
    public @NonNull java.lang.Class<?> getAbstractOperationClass(@NonNull List<?> parameters) {
        switch (parameters.size()) {
            case 0: {
                return AbstractUnaryOperation.class;
            }
            case 1: {
                return AbstractBinaryOperation.class;
            }
            case 2: {
                return AbstractTernaryOperation.class;
            }
        }
        return AbstractOperation.class;
    }

    @Override
    public @Nullable java.lang.Class<?> getEcoreFactoryClass(@NonNull EPackage ePackage) {
        GenPackage genPackage = this.getGenPackage(ePackage);
        if (genPackage == null) {
            return null;
        }
        String qualifiedFactoryName = genPackage.getQualifiedFactoryInterfaceName();
        try {
            Thread currentThread = Thread.currentThread();
            @NonNull ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            @NonNull java.lang.Class<?> loadedClass = contextClassLoader.loadClass(qualifiedFactoryName);
            return loadedClass;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public @NonNull java.lang.Class<?> getEcoreInterfaceClass(@NonNull Class type) throws GenModelException {
        String qualifiedInterfaceName;
        GenClassifier genClassifier = this.getGenClassifier(type);
        if (genClassifier instanceof GenDataType) {
            qualifiedInterfaceName = ((GenDataType)genClassifier).getQualifiedInstanceClassName();
            java.lang.Class<?> primitiveClass = JavaCodeGenerator.javaPrimitiveNames.get(qualifiedInterfaceName);
            if (primitiveClass != null) {
                return primitiveClass;
            }
        } else {
            qualifiedInterfaceName = ((GenClass)genClassifier).getQualifiedInterfaceName();
        }
        try {
            Thread currentThread = Thread.currentThread();
            @NonNull ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            @NonNull java.lang.Class<?> loadedClass = contextClassLoader.loadClass(qualifiedInterfaceName);
            return loadedClass;
        }
        catch (Exception e) {
            throw new GenModelException("Failed to load class for " + type);
        }
    }

    @Override
    public @Nullable String getEcoreInterfaceClassName(@NonNull EClass eClass) throws GenModelException {
        try {
            GenClass genClassifier = this.getGenClass(eClass);
            String qualifiedInterfaceName = genClassifier instanceof GenDataType ? ((GenDataType)genClassifier).getQualifiedInstanceClassName() : genClassifier.getQualifiedInterfaceName();
            return qualifiedInterfaceName;
        }
        catch (GenModelException e) {
            return null;
        }
    }

    @Override
    public @NonNull java.lang.Class<?> getEcoreInterfaceClassifier(@NonNull EClassifier eClassifier) throws GenModelException {
        String qualifiedInterfaceName;
        GenClassifier genClassifier = this.getGenClassifier(eClassifier);
        if (genClassifier instanceof GenDataType) {
            qualifiedInterfaceName = ((GenDataType)genClassifier).getQualifiedInstanceClassName();
            java.lang.Class<?> primitiveClass = JavaCodeGenerator.javaPrimitiveNames.get(qualifiedInterfaceName);
            if (primitiveClass != null) {
                return primitiveClass;
            }
        } else {
            qualifiedInterfaceName = ((GenClass)genClassifier).getQualifiedInterfaceName();
        }
        try {
            Thread currentThread = Thread.currentThread();
            @NonNull ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            @NonNull java.lang.Class<?> loadedClass = contextClassLoader.loadClass(qualifiedInterfaceName);
            return loadedClass;
        }
        catch (Exception e) {
            throw new GenModelException("Failed to load class for " + eClassifier);
        }
    }

    @Override
    public @Nullable String getEcoreInterfaceClassifierName(@NonNull EClassifier eClassifier) throws GenModelException {
        try {
            GenClassifier genClassifier = this.getGenClassifier(eClassifier);
            String qualifiedInterfaceName = genClassifier instanceof GenDataType ? ((GenDataType)genClassifier).getQualifiedInstanceClassName() : ((GenClass)genClassifier).getQualifiedInterfaceName();
            return qualifiedInterfaceName;
        }
        catch (GenModelException e) {
            return null;
        }
    }

    @Override
    public @Nullable String getEcoreInterfaceName(@NonNull Class type) {
        try {
            GenClassifier genClassifier = this.getGenClassifier(type);
            return genClassifier instanceof GenDataType ? ((GenDataType)genClassifier).getQualifiedInstanceClassName() : ((GenClass)genClassifier).getQualifiedInterfaceName();
        }
        catch (GenModelException e) {
            return null;
        }
    }

    @Override
    public @Nullable String getEcoreLiteralName(@NonNull EStructuralFeature eFeature) {
        try {
            GenFeature genFeature = this.getGenFeature(eFeature);
            return genFeature.getGenClass().getFeatureID(genFeature);
        }
        catch (GenModelException e) {
            return null;
        }
    }

    @Override
    public @Nullable String getEcoreClassName(@NonNull Class type) {
        try {
            GenClassifier genClassifier = this.getGenClassifier(type);
            return genClassifier instanceof GenDataType ? ((GenDataType)genClassifier).getQualifiedInstanceClassName() : ((GenClass)genClassifier).getQualifiedClassName();
        }
        catch (GenModelException e) {
            return null;
        }
    }

    @Override
    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.metamodelManager.getEnvironmentFactory();
    }

    protected @NonNull GenClass getGenClass(@NonNull Class type) throws GenModelException {
        GenPackage genPackage = this.getGenPackage(type);
        if (genPackage != null) {
            String name = type.getName();
            for (GenClass genClass : genPackage.getGenClasses()) {
                String clsName = genClass.getEcoreClass().getName();
                if (!name.equals(clsName)) continue;
                return genClass;
            }
        }
        throw new GenModelException("No GenClass for " + type);
    }

    protected @NonNull GenClass getGenClass(@NonNull EClass eClass) throws GenModelException {
        GenPackage genPackage = this.getGenPackage((EClassifier)eClass);
        if (genPackage != null) {
            String name = eClass.getName();
            for (GenClass genClass : genPackage.getGenClasses()) {
                String clsName = genClass.getEcoreClass().getName();
                if (!name.equals(clsName)) continue;
                return genClass;
            }
        }
        throw new GenModelException("No GenClass for " + eClass);
    }

    protected @NonNull GenClassifier getGenClassifier(@NonNull EClassifier eClassifier) throws GenModelException {
        GenPackage genPackage = this.getGenPackage(eClassifier);
        if (genPackage != null) {
            String name = eClassifier.getName();
            for (GenClassifier genClassifier : genPackage.getGenClassifiers()) {
                String clsName = genClassifier.getEcoreClassifier().getName();
                if (!name.equals(clsName)) continue;
                return genClassifier;
            }
        }
        throw new GenModelException("No GenClassifier for " + eClassifier);
    }

    @Override
    public @NonNull GenClassifier getGenClassifier(@NonNull Class type) throws GenModelException {
        GenPackage genPackage = this.getGenPackage(type);
        if (genPackage != null) {
            String name = type.getName();
            for (GenClassifier genClassifier : genPackage.getGenClassifiers()) {
                String clsName = genClassifier.getEcoreClassifier().getName();
                if (!name.equals(clsName)) continue;
                return genClassifier;
            }
        }
        for (Class partialType : this.metamodelManager.getPartialClasses((Type)type)) {
            genPackage = this.getGenPackage(partialType);
            if (genPackage == null) continue;
            String name = partialType.getName();
            for (GenClassifier genClassifier : genPackage.getGenClassifiers()) {
                String clsName = genClassifier.getEcoreClassifier().getName();
                if (!name.equals(clsName)) continue;
                return genClassifier;
            }
        }
        throw new GenModelException("No GenClassifier for " + type);
    }

    public @NonNull GenFeature getGenFeature(@NonNull Property property) throws GenModelException {
        Class owningType = property.getOwningClass();
        if (owningType != null) {
            GenClass genClass = this.getGenClass(owningType);
            String name = property.getName();
            for (GenFeature genFeature : genClass.getGenFeatures()) {
                String featureName = genFeature.getEcoreFeature().getName();
                if (!name.equals(featureName)) continue;
                return genFeature;
            }
        }
        throw new GenModelException("No GenFeature for " + property);
    }

    @Override
    public @NonNull GenFeature getGenFeature(@NonNull EStructuralFeature eStructuralFeature) throws GenModelException {
        EClass eClass = eStructuralFeature.getEContainingClass();
        if (eClass != null) {
            GenClass genClass = this.getGenClass(eClass);
            String name = eStructuralFeature.getName();
            for (GenFeature genFeature : genClass.getGenFeatures()) {
                String featureName = genFeature.getEcoreFeature().getName();
                if (!name.equals(featureName)) continue;
                return genFeature;
            }
        }
        throw new GenModelException("No GenFeature for " + eStructuralFeature);
    }

    @Override
    public @NonNull GenOperation getGenOperation(@NonNull Operation operation) throws GenModelException {
        Operation baseOperation = operation;
        while (baseOperation.getRedefinedOperations().size() > 0) {
            baseOperation = (Operation)baseOperation.getRedefinedOperations().get(0);
        }
        Class owningType = baseOperation.getOwningClass();
        if (owningType != null) {
            GenClass genClass = this.getGenClass(owningType);
            String name = operation.getName();
            for (GenOperation genOperation : genClass.getGenOperations()) {
                String operationName = genOperation.getEcoreOperation().getName();
                if (!name.equals(operationName)) continue;
                return genOperation;
            }
        }
        Operation baseOperation2 = operation;
        while (baseOperation2.getRedefinedOperations().size() > 0) {
            baseOperation2 = (Operation)baseOperation2.getRedefinedOperations().get(0);
        }
        throw new GenModelException("No GenFeature for " + baseOperation);
    }

    @Override
    public @Nullable GenPackage getGenPackage(@NonNull Package asPackage) {
        GenPackage genPackage;
        String nsURI;
        EObject eContainer = asPackage.eContainer();
        if (eContainer instanceof Model && (nsURI = ((Model)eContainer).getExternalURI()) != null && (genPackage = this.metamodelManager.getGenPackage(nsURI)) != null) {
            return genPackage;
        }
        nsURI = asPackage.getURI();
        if (nsURI == null) {
            return null;
        }
        return this.metamodelManager.getGenPackage(nsURI);
    }

    @Override
    public @Nullable GenPackage getGenPackage(@NonNull Class type) {
        Package asPackage = type.getOwningPackage();
        if (asPackage == null) {
            return null;
        }
        return this.getGenPackage(asPackage);
    }

    public @Nullable GenPackage getGenPackage(@NonNull EClassifier eClassifier) {
        EPackage ePackage = eClassifier.getEPackage();
        if (ePackage == null) {
            return null;
        }
        return this.getGenPackage(ePackage);
    }

    public @Nullable GenPackage getGenPackage(@NonNull EPackage ePackage) {
        String nsURI = ePackage.getNsURI();
        if (nsURI == null) {
            return null;
        }
        return this.metamodelManager.getGenPackage(nsURI);
    }

    @Override
    public @Nullable GenParameter getGenParameter(@NonNull Parameter parameter) throws GenModelException {
        Operation operation = parameter.getOwningOperation();
        if (operation != null) {
            int index = operation.getOwnedParameters().indexOf(parameter);
            GenOperation genOperation = this.getGenOperation(operation);
            EList genParameters = genOperation.getGenParameters();
            if (index >= 0 && index < genParameters.size()) {
                return (GenParameter)genParameters.get(index);
            }
        }
        throw new GenModelException("No GenParameter for " + parameter);
    }

    @Override
    public @NonNull String getGetAccessor(@NonNull Property aProperty) throws GenModelException {
        GenFeature genFeature = this.getGenFeature(aProperty);
        String getAccessor = genFeature.getGetAccessor();
        if (getAccessor != null) {
            return getAccessor;
        }
        throw new GenModelException("No GenFeature for " + aProperty);
    }

    @Override
    public @NonNull String getGetAccessor(@NonNull EStructuralFeature eStructuralFeature) throws GenModelException {
        GenFeature genFeature = this.getGenFeature(eStructuralFeature);
        String getAccessor = genFeature.getGetAccessor();
        if (getAccessor != null) {
            return getAccessor;
        }
        throw new GenModelException("No GenFeature for " + eStructuralFeature);
    }

    @Override
    public @Nullable String getImplementationClassName(@NonNull EClassifier eClassifier) throws GenModelException {
        try {
            GenClassifier genClassifier = this.getGenClassifier(eClassifier);
            if (genClassifier instanceof GenClass) {
                return ((GenClass)genClassifier).getClassName();
            }
            return genClassifier.getName();
        }
        catch (GenModelException e) {
            return null;
        }
    }

    @Override
    public @NonNull String getLiteralName(@NonNull EClassifier eClassifier) {
        String name = eClassifier.getName();
        return CodeGenUtil.upperName((String)(name != null ? name : TABLES_PACKAGE_NAME));
    }

    @Override
    public @NonNull PivotMetamodelManager getMetamodelManager() {
        return this.metamodelManager;
    }

    @Override
    public @NonNull String getOperationAccessor(@NonNull Operation anOperation) throws GenModelException {
        GenOperation genOperation = this.getGenOperation(anOperation);
        String operationAccessor = genOperation.getName();
        if (operationAccessor != null) {
            return operationAccessor;
        }
        throw new GenModelException("No GenOperation for " + anOperation);
    }

    @Override
    public @NonNull java.lang.Class<?> getOperationInterface(@NonNull List<? extends TypedElement> parameters) {
        switch (parameters.size()) {
            case 0: {
                return LibraryUnaryOperation.class;
            }
            case 1: {
                return LibraryBinaryOperation.class;
            }
            case 2: {
                return LibraryTernaryOperation.class;
            }
        }
        return LibraryOperation.class;
    }

    @Override
    public @NonNull String getOperationReturnType(@NonNull Operation operation) throws GenModelException {
        Class owningType = operation.getOwningClass();
        if (owningType == null) {
            throw new GenModelException("No owningType for " + operation);
        }
        GenClass genClass = this.getGenClass(owningType);
        GenOperation genOperation = this.getGenOperation(operation);
        String returnType = genOperation.getType(genClass);
        if (returnType == null) {
            throw new GenModelException("No returnType for " + operation);
        }
        return returnType;
    }

    @Override
    public @NonNull String getPropertyResultType(@NonNull Property property) throws GenModelException {
        Class owningType = property.getOwningClass();
        if (owningType == null) {
            throw new GenModelException("No owningType for " + property);
        }
        GenClass genClass = this.getGenClass(owningType);
        GenFeature genFeature = this.getGenFeature(property);
        String resultType = genFeature.getQualifiedObjectType(genClass);
        if (resultType == null) {
            throw new GenModelException("No resultType for " + property);
        }
        return resultType;
    }

    @Override
    public @Nullable String getQualifiedFactoryInterfaceName(@NonNull EPackage ePackage) {
        GenPackage genPackage = this.getGenPackage(ePackage);
        if (genPackage == null) {
            return null;
        }
        return genPackage.getQualifiedFactoryInterfaceName();
    }

    @Override
    public @Nullable String getQualifiedFactoryInterfaceName(@NonNull Class type) {
        GenPackage genPackage = this.getGenPackage(type);
        if (genPackage == null) {
            return null;
        }
        return genPackage.getQualifiedFactoryInterfaceName();
    }

    @Override
    public @Nullable String getQualifiedFactoryInstanceAccessor(@NonNull EPackage ePackage) {
        GenPackage genPackage = this.getGenPackage(ePackage);
        if (genPackage == null) {
            return null;
        }
        return genPackage.getQualifiedFactoryInstanceAccessor();
    }

    @Override
    public @Nullable String getQualifiedFactoryInstanceAccessor(@NonNull Class type) {
        GenPackage genPackage = this.getGenPackage(type);
        if (genPackage == null) {
            return null;
        }
        return genPackage.getQualifiedFactoryInstanceAccessor();
    }

    @Override
    public @Nullable String getQualifiedPackageInterfaceName(@NonNull EPackage ePackage) {
        GenPackage genPackage = this.getGenPackage(ePackage);
        if (genPackage == null) {
            return null;
        }
        return genPackage.getQualifiedPackageInterfaceName();
    }

    @Override
    public @NonNull String getQualifiedValidatorClassName(@NonNull GenPackage genPackage) {
        return (String)ClassUtil.nonNullEMF((Object)genPackage.getQualifiedValidatorClassName());
    }

    @Override
    public @NonNull String getSetAccessor(@NonNull EStructuralFeature eStructuralFeature) throws GenModelException {
        GenFeature genFeature = this.getGenFeature(eStructuralFeature);
        String setAccessor = genFeature.getAccessorName();
        if (setAccessor != null) {
            return "set" + setAccessor;
        }
        throw new GenModelException("No GenFeature for " + eStructuralFeature);
    }

    @Override
    public @NonNull String getTablesClassName(@NonNull GenPackage genPackage) {
        return ImportUtils.getAffixedName(String.valueOf(genPackage.getQualifiedPackageName()) + "." + genPackage.getPrefix() + TABLES_CLASS_SUFFIX);
    }
}

