/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBuiltInIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstraint;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElementId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorCompositionProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorNavigationProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOppositeProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOppositePropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorShadowPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLetExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterateCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGMapExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGMapPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGShadowExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGShadowPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGText;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGUnboxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.util.AbstractExtendingCGModelVisitor;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.JavaConstants;
import org.eclipse.ocl.examples.codegen.java.JavaGlobalContext;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.EnumerationLiteralId;
import org.eclipse.ocl.pivot.ids.NestedTypeId;
import org.eclipse.ocl.pivot.ids.OclVoidTypeId;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.LibraryOperation;
import org.eclipse.ocl.pivot.library.LibrarySimpleOperation;
import org.eclipse.ocl.pivot.library.LibraryUntypedOperation;
import org.eclipse.ocl.pivot.values.CollectionValue;

public class CG2JavaPreVisitor
extends AbstractExtendingCGModelVisitor<Object, JavaGlobalContext<? extends JavaCodeGenerator>> {
    protected final @NonNull JavaCodeGenerator codeGenerator;
    protected final @NonNull GenModelHelper genModelHelper;
    protected final @NonNull CodeGenAnalyzer analyzer;
    protected JavaLocalContext<?> localContext;

    public CG2JavaPreVisitor(@NonNull JavaGlobalContext<? extends JavaCodeGenerator> javaContext) {
        super(javaContext);
        this.codeGenerator = javaContext.getCodeGenerator();
        this.analyzer = this.codeGenerator.getAnalyzer();
        this.genModelHelper = this.codeGenerator.getGenModelHelper();
    }

    protected void addOwnedTypeId(@NonNull CGValuedElement cgElement, @NonNull ElementId typeId) {
        if (!(typeId instanceof OclVoidTypeId) && !(typeId instanceof PrimitiveTypeId)) {
            CGElementId elementId;
            CGElementId cgTypeId = elementId = this.analyzer.getElementId(typeId);
            CGConstantExp cgConstantExp = CGModelFactory.eINSTANCE.createCGConstantExp();
            cgConstantExp.setReferredConstant(cgTypeId);
            if (elementId instanceof CGTypeId) {
                cgConstantExp.setTypeId((CGTypeId)elementId);
            }
            cgElement.getOwns().add(cgConstantExp);
            if (typeId instanceof CollectionTypeId) {
                this.addOwnedTypeId(cgConstantExp, (ElementId)((CollectionTypeId)typeId).getElementTypeId());
            } else if (typeId instanceof TupleTypeId) {
                TuplePartId[] tuplePartIdArray = ((TupleTypeId)typeId).getPartIds();
                int n = tuplePartIdArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TuplePartId partId = tuplePartIdArray[n2];
                    this.addOwnedTypeId(cgConstantExp, (ElementId)partId);
                    ++n2;
                }
            } else if (typeId instanceof NestedTypeId) {
                this.addOwnedTypeId(cgConstantExp, (ElementId)((NestedTypeId)typeId).getParent());
            }
        }
    }

    protected void doTypedElement(@NonNull CGTypedElement cgTypedElement) {
        CGTypeId cgTypeId = cgTypedElement.getTypeId();
        if (cgTypeId != null) {
            cgTypeId.accept(this);
        }
    }

    protected void doValuedElement(@NonNull CGValuedElement cgValuedElement) {
        TypeId asTypeId;
        CGValuedElement value = cgValuedElement.getNamedValue();
        if (value.isGlobal()) {
            ((JavaGlobalContext)this.context).addGlobal(value);
        }
        if ((asTypeId = cgValuedElement.getASTypeId()) != null) {
            this.addOwnedTypeId(cgValuedElement, (ElementId)asTypeId);
        }
        if (cgValuedElement.getNamedValue() == cgValuedElement) {
            if (this.localContext != null && !cgValuedElement.isGlobal()) {
                this.localContext.getValueName(cgValuedElement);
            } else {
                ((JavaGlobalContext)this.context).getValueName(cgValuedElement);
            }
        }
    }

    public @NonNull JavaCodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    protected @Nullable CGValuedElement installEvaluatorVariable(@NonNull CGValuedElement cgValuedElement) {
        CGValuedElement evaluatorVariable = this.localContext.createEvaluatorVariable();
        if (evaluatorVariable != null) {
            cgValuedElement.getOwns().add(evaluatorVariable);
        }
        return evaluatorVariable;
    }

    protected @Nullable CGValuedElement installIdResolverVariable(@NonNull CGValuedElement cgValuedElement) {
        CGValuedElement idResolverVariable = this.localContext.createIdResolverVariable();
        cgValuedElement.getOwns().add(idResolverVariable);
        return idResolverVariable;
    }

    protected @NonNull CGText installStandardLibraryVariable(@NonNull CGValuedElement cgValuedElement) {
        CGText standardLibraryVariable = this.localContext.createStandardLibraryVariable();
        cgValuedElement.getOwns().add(standardLibraryVariable);
        this.installIdResolverVariable(standardLibraryVariable);
        return standardLibraryVariable;
    }

    @Override
    public @Nullable Object visiting(@NonNull CGElement visitable) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    @Override
    public @Nullable Object visitCGBoxExp(@NonNull CGBoxExp cgBoxExp) {
        TypeDescriptor unboxedTypeDescriptor;
        CGValuedElement unboxedValue = cgBoxExp.getSource();
        if (unboxedValue != null && (unboxedTypeDescriptor = this.codeGenerator.getTypeDescriptor(unboxedValue)).isAssignableTo(Iterable.class)) {
            this.installIdResolverVariable(cgBoxExp);
        }
        return super.visitCGBoxExp(cgBoxExp);
    }

    @Override
    public @Nullable Object visitCGBuiltInIterationCallExp(@NonNull CGBuiltInIterationCallExp cgBuiltInIterationCallExp) {
        TypeId asTypeId = cgBuiltInIterationCallExp.getASTypeId();
        if (asTypeId != null) {
            this.addOwnedTypeId(cgBuiltInIterationCallExp, (ElementId)asTypeId);
        }
        return super.visitCGBuiltInIterationCallExp(cgBuiltInIterationCallExp);
    }

    @Override
    public @Nullable Object visitCGCollectionExp(@NonNull CGCollectionExp cgCollectionExp) {
        TypeId asTypeId;
        CollectionLiteralExp collectionExp = (CollectionLiteralExp)cgCollectionExp.getAst();
        if (collectionExp != null && (asTypeId = cgCollectionExp.getASTypeId()) != null) {
            this.addOwnedTypeId(cgCollectionExp, (ElementId)asTypeId);
        }
        return super.visitCGCollectionExp(cgCollectionExp);
    }

    @Override
    public @Nullable Object visitCGCollectionPart(@NonNull CGCollectionPart cgCollectionPart) {
        boolean isRange = cgCollectionPart.isRange();
        if (cgCollectionPart.isConstant()) {
            // empty if block
        }
        return super.visitCGCollectionPart(cgCollectionPart);
    }

    @Override
    public @Nullable Object visitCGConstantExp(@NonNull CGConstantExp cgConstantExp) {
        super.visitCGConstantExp(cgConstantExp);
        CGValuedElement referredConstant = cgConstantExp.getReferredConstant();
        if (referredConstant != null) {
            referredConstant.accept(this);
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGConstraint(@NonNull CGConstraint cgConstraint) {
        this.localContext = ((JavaGlobalContext)this.context).getLocalContext(cgConstraint);
        try {
            Object r = super.visitCGConstraint(cgConstraint);
            return r;
        }
        finally {
            this.localContext = null;
        }
    }

    @Override
    public @Nullable Object visitCGEcoreExp(@NonNull CGEcoreExp cgEcoreExp) {
        TypeDescriptor boxedTypeDescriptor;
        CGValuedElement ecoreValue = cgEcoreExp.getSource();
        if (ecoreValue != null && ((boxedTypeDescriptor = this.codeGenerator.getTypeDescriptor(ecoreValue)).isAssignableTo(Iterable.class) || boxedTypeDescriptor.isAssignableTo(EnumerationLiteralId.class))) {
            this.installIdResolverVariable(cgEcoreExp);
        }
        return super.visitCGEcoreExp(cgEcoreExp);
    }

    @Override
    public @Nullable Object visitCGElement(@NonNull CGElement cgElement) {
        List<CGValuedElement> owns = cgElement instanceof CGValuedElement ? ((CGValuedElement)cgElement).getOwns() : null;
        for (CGElement cGElement : cgElement.getChildren()) {
            if (owns != null && owns.contains(cGElement)) continue;
            cGElement.accept(this);
        }
        return null;
    }

    @Override
    public @Nullable Object visitCGExecutorCompositionProperty(@NonNull CGExecutorCompositionProperty cgExecutorProperty) {
        Property asProperty = (Property)cgExecutorProperty.getAst();
        Property asOppositeProperty = asProperty.getOpposite();
        if (asOppositeProperty != null && asOppositeProperty.isIsComposite()) {
            TypeId javaPropertyTypeId = JavaConstants.UNBOXED_COMPOSITION_PROPERTY_TYPE_ID;
            cgExecutorProperty.setTypeId(this.analyzer.getTypeId(javaPropertyTypeId));
        }
        return super.visitCGExecutorCompositionProperty(cgExecutorProperty);
    }

    @Override
    public @Nullable Object visitCGExecutorNavigationProperty(@NonNull CGExecutorNavigationProperty cgExecutorProperty) {
        TypeId javaPropertyTypeId = JavaConstants.UNBOXED_EXPLICIT_NAVIGATION_PROPERTY_TYPE_ID;
        cgExecutorProperty.setTypeId(this.analyzer.getTypeId(javaPropertyTypeId));
        return super.visitCGExecutorNavigationProperty(cgExecutorProperty);
    }

    @Override
    public @Nullable Object visitCGExecutorOperation(@NonNull CGExecutorOperation cgExecutorOperation) {
        this.installIdResolverVariable(cgExecutorOperation);
        CGElementId cgOperationId = cgExecutorOperation.getUnderlyingOperationId();
        if (cgOperationId != null) {
            cgOperationId.accept(this);
        }
        return super.visitCGExecutorOperation(cgExecutorOperation);
    }

    @Override
    public @Nullable Object visitCGExecutorOperationCallExp(@NonNull CGExecutorOperationCallExp cgExecutorOperationCallExp) {
        return super.visitCGExecutorOperationCallExp(cgExecutorOperationCallExp);
    }

    @Override
    public @Nullable Object visitCGExecutorOppositeProperty(@NonNull CGExecutorOppositeProperty cgExecutorProperty) {
        TypeId javaPropertyTypeId = JavaConstants.UNBOXED_OPPOSITE_NAVIGATION_PROPERTY_TYPE_ID;
        cgExecutorProperty.setTypeId(this.analyzer.getTypeId(javaPropertyTypeId));
        return super.visitCGExecutorOppositeProperty(cgExecutorProperty);
    }

    @Override
    public @Nullable Object visitCGExecutorOppositePropertyCallExp(@NonNull CGExecutorOppositePropertyCallExp cgExecutorPropertyCallExp) {
        CGExecutorProperty cgExecutorProperty = cgExecutorPropertyCallExp.getExecutorProperty();
        if (cgExecutorProperty != null) {
            cgExecutorProperty.accept(this);
        }
        return super.visitCGExecutorOppositePropertyCallExp(cgExecutorPropertyCallExp);
    }

    @Override
    public @Nullable Object visitCGExecutorProperty(@NonNull CGExecutorProperty cgExecutorProperty) {
        CGElementId cgPropertyId = cgExecutorProperty.getUnderlyingPropertyId();
        if (cgPropertyId != null) {
            cgPropertyId.accept(this);
        }
        return super.visitCGExecutorProperty(cgExecutorProperty);
    }

    @Override
    public @Nullable Object visitCGExecutorPropertyCallExp(@NonNull CGExecutorPropertyCallExp cgExecutorPropertyCallExp) {
        CGExecutorProperty cgExecutorProperty = cgExecutorPropertyCallExp.getExecutorProperty();
        if (cgExecutorProperty != null) {
            cgExecutorProperty.accept(this);
        }
        return super.visitCGExecutorPropertyCallExp(cgExecutorPropertyCallExp);
    }

    @Override
    public @Nullable Object visitCGExecutorType(@NonNull CGExecutorType cgExecutorType) {
        this.installIdResolverVariable(cgExecutorType);
        CGTypeId cgTypeId = cgExecutorType.getUnderlyingTypeId();
        if (cgTypeId != null) {
            cgTypeId.accept(this);
        }
        cgExecutorType.setTypeId(this.analyzer.getTypeId(JavaConstants.CLASS_TYPE_ID));
        return super.visitCGExecutorType(cgExecutorType);
    }

    @Override
    public @Nullable Object visitCGIterationCallExp(@NonNull CGIterationCallExp cgIterationCallExp) {
        this.doValuedElement(cgIterationCallExp);
        this.doTypedElement(cgIterationCallExp);
        CGValuedElement cgSource = cgIterationCallExp.getSource();
        if (cgSource != null) {
            cgSource.accept(this);
        }
        for (CGIterator cgIterator : cgIterationCallExp.getIterators()) {
            CGValuedElement cgInit = cgIterator.getInit();
            if (cgInit == null) continue;
            cgInit.accept(this);
        }
        JavaLocalContext<?> savedLocalContext = this.localContext;
        this.localContext = ((JavaGlobalContext)this.context).getLocalContext(cgIterationCallExp);
        try {
            CGValuedElement cgBody = cgIterationCallExp.getBody();
            if (cgBody != null) {
                cgBody.accept(this);
            }
            for (CGIterator cgIterator : cgIterationCallExp.getIterators()) {
                cgIterator.accept(this);
            }
            return null;
        }
        finally {
            this.localContext = savedLocalContext;
        }
    }

    @Override
    public @Nullable Object visitCGLetExp(@NonNull CGLetExp cgLetExp) {
        CGValuedElement in = cgLetExp.getIn();
        return super.visitCGLetExp(cgLetExp);
    }

    @Override
    public @Nullable Object visitCGLibraryIterateCallExp(@NonNull CGLibraryIterateCallExp cgLibraryIterateCallExp) {
        this.installStandardLibraryVariable(cgLibraryIterateCallExp);
        return super.visitCGLibraryIterateCallExp(cgLibraryIterateCallExp);
    }

    @Override
    public @Nullable Object visitCGLibraryIterationCallExp(@NonNull CGLibraryIterationCallExp cgLibraryIterationCallExp) {
        this.installStandardLibraryVariable(cgLibraryIterationCallExp);
        return super.visitCGLibraryIterationCallExp(cgLibraryIterationCallExp);
    }

    @Override
    public @Nullable Object visitCGLibraryOperationCallExp(@NonNull CGLibraryOperationCallExp cgOperationCallExp) {
        LibraryOperation libraryOperation = cgOperationCallExp.getLibraryOperation();
        if (!(libraryOperation instanceof LibrarySimpleOperation)) {
            TypeId asTypeId;
            this.installEvaluatorVariable(cgOperationCallExp);
            if (!(libraryOperation instanceof LibraryUntypedOperation) && (asTypeId = cgOperationCallExp.getASTypeId()) != null) {
                this.addOwnedTypeId(cgOperationCallExp, (ElementId)asTypeId);
            }
        }
        return super.visitCGLibraryOperationCallExp(cgOperationCallExp);
    }

    @Override
    public @Nullable Object visitCGLibraryPropertyCallExp(@NonNull CGLibraryPropertyCallExp cgPropertyCallExp) {
        try {
            this.installEvaluatorVariable(cgPropertyCallExp);
            Object r = super.visitCGLibraryPropertyCallExp(cgPropertyCallExp);
            return r;
        }
        finally {
            CGTypeId cgTypeId = cgPropertyCallExp.getTypeId();
            TypeId asTypeId = cgPropertyCallExp.getASTypeId();
            if (asTypeId != null) {
                this.addOwnedTypeId(cgPropertyCallExp, (ElementId)asTypeId);
            }
        }
    }

    @Override
    public @Nullable Object visitCGMapExp(@NonNull CGMapExp cgMapExp) {
        TypeId asTypeId;
        MapLiteralExp mapExp = (MapLiteralExp)cgMapExp.getAst();
        if (mapExp != null && (asTypeId = cgMapExp.getASTypeId()) != null) {
            this.addOwnedTypeId(cgMapExp, (ElementId)asTypeId);
        }
        return super.visitCGMapExp(cgMapExp);
    }

    @Override
    public @Nullable Object visitCGMapPart(@NonNull CGMapPart cgMapPart) {
        return super.visitCGMapPart(cgMapPart);
    }

    @Override
    public @Nullable Object visitCGOperation(@NonNull CGOperation cgOperation) {
        this.localContext = ((JavaGlobalContext)this.context).getLocalContext(cgOperation);
        try {
            Object r = super.visitCGOperation(cgOperation);
            return r;
        }
        finally {
            this.localContext = null;
        }
    }

    @Override
    public @Nullable Object visitCGProperty(@NonNull CGProperty cgProperty) {
        this.localContext = ((JavaGlobalContext)this.context).getLocalContext(cgProperty);
        try {
            Object r = super.visitCGProperty(cgProperty);
            return r;
        }
        finally {
            this.localContext = null;
        }
    }

    @Override
    public @Nullable Object visitCGTypeExp(@NonNull CGTypeExp cgTypeExp) {
        CGExecutorType cgType;
        TypeId asTypeId = cgTypeExp.getASTypeId();
        if (asTypeId != null) {
            this.addOwnedTypeId(cgTypeExp, (ElementId)asTypeId);
        }
        if ((cgType = cgTypeExp.getExecutorType()) != null) {
            cgType.accept(this);
        }
        return super.visitCGTypeExp(cgTypeExp);
    }

    @Override
    public @Nullable Object visitCGShadowExp(@NonNull CGShadowExp cgShadowExp) {
        CGExecutorType cgType = cgShadowExp.getExecutorType();
        if (cgType != null) {
            cgType.accept(this);
        }
        return super.visitCGShadowExp(cgShadowExp);
    }

    @Override
    public @Nullable Object visitCGShadowPart(@NonNull CGShadowPart cgShadowPart) {
        CGExecutorShadowPart cgExecutorConstructorPart = cgShadowPart.getExecutorPart();
        cgExecutorConstructorPart.accept(this);
        TypeId javaPropertyTypeId = JavaConstants.PROPERTY_TYPE_ID;
        cgExecutorConstructorPart.setTypeId(this.analyzer.getTypeId(javaPropertyTypeId));
        this.installIdResolverVariable(cgExecutorConstructorPart);
        cgShadowPart.getOwns().add(cgExecutorConstructorPart);
        cgShadowPart.getDependsOn().add(cgExecutorConstructorPart);
        return super.visitCGShadowPart(cgShadowPart);
    }

    @Override
    public @Nullable Object visitCGTypedElement(@NonNull CGTypedElement cgTypedElement) {
        super.visitCGTypedElement(cgTypedElement);
        this.doTypedElement(cgTypedElement);
        return null;
    }

    @Override
    public @Nullable Object visitCGUnboxExp(@NonNull CGUnboxExp cgUnboxExp) {
        CGValuedElement source = this.analyzer.getExpression(cgUnboxExp.getSource());
        TypeDescriptor boxedTypeDescriptor = this.codeGenerator.getTypeDescriptor(source);
        if (boxedTypeDescriptor.isAssignableTo(CollectionValue.class) || boxedTypeDescriptor.isAssignableTo(EnumerationLiteralId.class)) {
            this.installIdResolverVariable(cgUnboxExp);
        }
        return super.visitCGUnboxExp(cgUnboxExp);
    }

    @Override
    public @Nullable Object visitCGValuedElement(@NonNull CGValuedElement cgValuedElement) {
        super.visitCGValuedElement(cgValuedElement);
        this.doValuedElement(cgValuedElement);
        return null;
    }
}

