/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.types;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGUnboxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.types.AbstractValueDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.BoxedDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.CollectionDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.EObjectsDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.EcoreDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.EcoreListDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.FutureEObjectsDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedElementsDescriptor;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;

public class BoxedValuesDescriptor
extends AbstractValueDescriptor
implements BoxedDescriptor {
    private CollectionDescriptor unboxedDescriptor;
    private CollectionDescriptor ecoreDescriptor;

    public BoxedValuesDescriptor(@NonNull CollectionTypeId elementId, @NonNull java.lang.Class<?> javaClass) {
        super((ElementId)elementId, javaClass);
    }

    @Override
    public @NonNull Boolean appendUnboxStatements(@NonNull JavaStream js, @NonNull JavaLocalContext<?> localContext, @NonNull CGUnboxExp cgUnboxExp, @NonNull CGValuedElement boxedValue) {
        js.append("final ");
        this.unboxedDescriptor.append(js, true);
        js.append(" ");
        js.appendValueName(cgUnboxExp);
        js.append(" = ");
        js.appendValueName(boxedValue);
        js.append(".asEcoreObjects(");
        js.appendReferenceTo(localContext.getIdResolverVariable(cgUnboxExp));
        js.append(", ");
        this.unboxedDescriptor.appendElement(js, true);
        js.append(".class);\n");
        js.append("assert ");
        js.appendValueName(cgUnboxExp);
        js.append(" != null;\n");
        return true;
    }

    protected EClassifier getEClassifier(@NonNull PivotMetamodelManager metamodelManager, @NonNull Type type) {
        for (Class dType : metamodelManager.getPartialClasses(type)) {
            EClassifier eClass = (EClassifier)dType.getESObject();
            if (eClass == null) continue;
            return eClass;
        }
        return null;
    }

    @Override
    public @NonNull EcoreDescriptor getEcoreDescriptor(@NonNull CodeGenerator codeGenerator, @Nullable java.lang.Class<?> instanceClass) {
        CollectionDescriptor ecoreDescriptor2 = this.ecoreDescriptor;
        if (ecoreDescriptor2 == null) {
            Class type;
            CollectionTypeId id = (CollectionTypeId)this.elementId;
            TypeId typeId = id.getElementTypeId();
            CollectionTypeId generalizedId = id.getGeneralizedId();
            EnvironmentFactoryInternal environmentFactory = codeGenerator.getEnvironmentFactory();
            IdResolver idResolver = environmentFactory.getIdResolver();
            if (generalizedId == id) {
                type = idResolver.getClass((TypeId)id, null);
            } else if (typeId instanceof TemplateParameterId) {
                CollectionType collectionType = (CollectionType)idResolver.getClass((TypeId)generalizedId, null);
                type = collectionType.getElementType();
                assert (type != null);
            } else {
                type = idResolver.getClass(typeId, null);
            }
            this.ecoreDescriptor = ecoreDescriptor2 = new EcoreListDescriptor(id, (StandardLibrary)environmentFactory.getStandardLibrary(), (Type)type);
        }
        return (EcoreDescriptor)((Object)ecoreDescriptor2);
    }

    @Override
    public @NonNull UnboxedDescriptor getUnboxedDescriptor(@NonNull CodeGenerator codeGenerator) {
        CollectionDescriptor unboxedDescriptor2 = this.unboxedDescriptor;
        if (unboxedDescriptor2 == null) {
            Class type;
            EnvironmentFactoryInternal environmentFactory;
            CollectionTypeId id;
            block8: {
                id = (CollectionTypeId)this.elementId;
                CollectionTypeId generalizedId = id.getGeneralizedId();
                environmentFactory = codeGenerator.getEnvironmentFactory();
                IdResolver idResolver = environmentFactory.getIdResolver();
                if (generalizedId == id) {
                    type = idResolver.getClass((TypeId)id, null);
                } else {
                    TypeId typeId = id.getElementTypeId();
                    type = idResolver.getClass(typeId, null);
                }
                EClassifier eClassifier = this.getEClassifier(environmentFactory.getMetamodelManager(), (Type)type);
                if (eClassifier != null) {
                    GenModelHelper genModelHelper = codeGenerator.getGenModelHelper();
                    try {
                        java.lang.Class<?> javaClass = genModelHelper.getEcoreInterfaceClassifier(eClassifier);
                        unboxedDescriptor2 = new EObjectsDescriptor(id, eClassifier, javaClass);
                    }
                    catch (Exception e) {
                        String instanceClassName = type.getInstanceClassName();
                        if (instanceClassName == null) {
                            instanceClassName = genModelHelper.getEcoreInterfaceClassifierName(eClassifier);
                        }
                        if (instanceClassName == null) break block8;
                        unboxedDescriptor2 = new FutureEObjectsDescriptor(id, eClassifier, instanceClassName);
                    }
                }
            }
            if (unboxedDescriptor2 == null) {
                unboxedDescriptor2 = new UnboxedElementsDescriptor(id, (StandardLibrary)environmentFactory.getStandardLibrary(), (Type)type);
            }
            this.unboxedDescriptor = unboxedDescriptor2;
        }
        return unboxedDescriptor2;
    }

    @Override
    public final boolean isAssignableFrom(@NonNull TypeDescriptor typeDescriptor) {
        if (!(typeDescriptor instanceof BoxedDescriptor)) {
            return false;
        }
        return this.javaClass.isAssignableFrom(typeDescriptor.getJavaClass());
    }
}

