/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.types;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.types.AbstractCollectionDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.EcoreDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedDescriptor;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;

public class EObjectsDescriptor
extends AbstractCollectionDescriptor
implements EcoreDescriptor,
UnboxedDescriptor {
    protected final @NonNull EClassifier eClassifier;
    protected final @NonNull Class<?> javaClass;
    protected final @NonNull Class<?> oldJavaClass;

    public EObjectsDescriptor(@NonNull CollectionTypeId collectionTypeId, @NonNull EClassifier eClassifier, @NonNull Class<?> javaClass) {
        super(collectionTypeId);
        this.eClassifier = eClassifier;
        this.javaClass = javaClass;
        this.oldJavaClass = EObjectsDescriptor.reClass(javaClass);
    }

    @Override
    public void append(@NonNull JavaStream javaStream, @Nullable Boolean isRequired) {
        javaStream.appendClassReference(List.class, this.javaClass != this.oldJavaClass, this.oldJavaClass);
    }

    @Override
    public void append(@NonNull JavaStream javaStream, boolean reClass) {
        javaStream.appendClassReference(List.class, this.javaClass != this.oldJavaClass, reClass ? this.javaClass : this.oldJavaClass);
    }

    @Override
    public void appendElement(@NonNull JavaStream javaStream, boolean reClass) {
        javaStream.appendClassReference(reClass ? this.javaClass : this.oldJavaClass);
    }

    @Override
    public @NonNull String getClassName() {
        return this.javaClass.getName();
    }

    @Override
    public @NonNull EcoreDescriptor getEcoreDescriptor(@NonNull CodeGenerator codeGenerator, @Nullable Class<?> instanceClass) {
        return this;
    }

    @Override
    public @NonNull Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public @NonNull UnboxedDescriptor getUnboxedDescriptor(@NonNull CodeGenerator codeGenerator) {
        return this;
    }

    @Override
    public @Nullable Class<?> hasJavaClass() {
        return this.javaClass;
    }

    @Override
    public final boolean isAssignableFrom(@NonNull TypeDescriptor typeDescriptor) {
        if (!(typeDescriptor instanceof EObjectsDescriptor)) {
            return false;
        }
        return this.javaClass.isAssignableFrom(typeDescriptor.getJavaClass());
    }
}

