/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.utilities;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.OclVoidTypeId;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;

public class CGUtil {
    public static @NonNull CGParameter createCGParameter(@NonNull String name, @NonNull CGTypeId typeId) {
        CGParameter cgParameter = CGModelFactory.eINSTANCE.createCGParameter();
        cgParameter.setName(name);
        cgParameter.setTypeId(typeId);
        return cgParameter;
    }

    public static @Nullable CGClass getContainingClass(@NonNull CGElement cgExpression) {
        CGElement cgElement = cgExpression;
        while (cgElement != null) {
            if (cgElement instanceof CGClass) {
                return (CGClass)cgElement;
            }
            cgElement = cgElement.getParent();
        }
        return null;
    }

    public static boolean isInlinedId(@NonNull ElementId elementId) {
        return elementId instanceof PrimitiveTypeId || elementId instanceof OclVoidTypeId || elementId instanceof TemplateParameterId;
    }

    public static @Nullable Boolean isKindOf(@NonNull CGValuedElement cgValue, @NonNull CGExecutorType executorType) {
        CGTypeId actualTypeId;
        CGTypeId referenceTypeId = executorType.getUnderlyingTypeId();
        return referenceTypeId == (actualTypeId = cgValue.getTypeId()) ? Boolean.TRUE : null;
    }

    public static @NonNull CGValuedElement replace(@NonNull CGValuedElement oldElement, @NonNull CGValuedElement newElement) {
        assert (!oldElement.isRequired() || !newElement.isNull());
        EObject oldContainer = oldElement.eContainer();
        EcoreUtil.replace((EObject)oldElement, (EObject)newElement);
        assert (oldElement.eContainer() == null);
        assert (newElement.eContainer() == oldContainer);
        return oldElement;
    }

    public static void wrap(@NonNull CGCallExp wrapExp, @NonNull CGValuedElement wrappedExp) {
        wrapExp.setTypeId(wrappedExp.getTypeId());
        wrapExp.setAst(wrappedExp.getAst());
        CGUtil.replace(wrappedExp, wrapExp);
        wrapExp.setSource(wrappedExp);
    }
}

